/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "ButBarr.h"
#include "ActButt.h"
#include "PicEl.h"

#include <QWidget>
#include <QRect>
#include <QPainter>
//Added by qt3to4:
#include <QResizeEvent>
#include <QPaintEvent>

#include <stdio.h>
#include <stdlib.h>

#define kNDButt 24


static const int stdBut[]={
 kABCir,
 kABLine,
 kABRect,
 kABText,
 kABMove,
 kABMoveBl,
 kABCopy,
 kABCopyBl,
 kABRot,
 kABRotBl,
 kABMir,
 kABMirBl,
 kABMoveP,
 kABEdit,
 kABDel,
 kABDelBl,
// kABAtr,
// kABEnter,

 kABLastW,
 kABFitW,
 kABVWin,
 kABMView,
 kABZoomIn,
 kABZoomOut,
 kNButt,
 -1
};

static const int SchBut[]={
 kABCir,
 kABLine,
 kABRect,
 kABText,
 kABPower,
 kABPoly,
 kABMove,
 kABMoveBl,
 kABCopy,
 kABCopyBl,
 kABRot,
 kABRotBl,
 kABMir,
 kABMirBl,
 kABMoveP,
 kABEdit,
 kABHiL,
 kABXMove,
 kABDel,
 kABDelBl,
 kABAtr,
 kABEnter,
 kABLastW,
 kABFitW,
 kABVWin,
 kABMView,
 kABZoomIn,
 kABZoomOut,
 kNButt,
 -1
};

static const int PcbBut[]={
 kABCir,
 kABLine,
 kABRect,
 kABText,
 kABPoly,
 kABAddP,
 kABMove,
 kABMoveBl,
 kABCopy,
 kABCopyBl,
 kABRot,
 kABRotBl,
 kABMir,
 kABMirBl,
 kABMoveP,
 kABEdit,
 kABHiL,
 kABR1,
 kABDel,
 kABDelBl,
 kABAtr,
 kABEnter,
 kABLastW,
 kABFitW,
 kABVWin,
 kABMView,
 kABZoomIn,
 kABZoomOut,
 kNButt,
 -1
};

static const char *sAB[] = {
 "CIRCLE",
 "LINE",
 "RECT",
 "TEXT",
 "POWER",
 "POLYGON",
 "ADD_PNT",
 "MOVE",
 "MOVE_BL",
 "COPY",
 "COPY_BL",
 "ROTATE",
 "ROT_BL",
 "MIRROR",
 "MIR_BL",
 "MOVE_P",
 "EDIT",
 "H_LIGHT",
 "NONE",
 "XMOVE",
 "DELETE",
 "DEL_BL",
 "ATR",
 "ENTER",
 "LAST_W",
 "FIT_W",
 "V_WIN",
 "M_VIEW",
 "ZOOM+",
 "ZOOM-",
 0
};


ButBarr::ButBarr(QWidget *parent)
 :  QWidget(parent)
{
 setMinimumSize(60,60);
 setMaximumSize(60,800);

 LAct=-1;
 MAct=-1;

 DbT=0;

 int i=0;

 for(i=0;i<maxH;i++){
  HistL[i]=kABNone;
  HistM[i]=kABNone;
 }

 for(i=0;i<kNButt;i++){
  AB[i]= new ActButton(this);
  AB[i]->SetType(i);
  connect(AB[i], SIGNAL(Select(int,int)), this, SLOT(ButSel(int,int)) );
 }
 Arrange();
}

void ButBarr::Arrange()
{
 int i;
 for(i=0;i<kNButt;i++){
  if (i>=kNDButt)
  AB[i]->move((((Cn(kNButt)-Cn(i))%2)*30)+1,height()-(((Cn(kNButt)-Cn(i)+1)/2)*30));
  else AB[i]->move((Cn(i)%2)*30+1,(Cn(i)/2)*30);
  if (Cn(i)<0) AB[i]->hide();
  else AB[i]->show();
 }
}

ButBarr::~ButBarr()
{
}

int ButBarr::Cn(int i)
{
 const int * BA;
 int j=0;
 if(DbT==kPicGrp) BA=stdBut;
 else if(DbT==kDbSch) BA=SchBut;
 else if(DbT==kDbPcb) BA=PcbBut;
 else if(DbT==kDbPrj) BA=stdBut;
 else BA=stdBut;
// else return i;

 while (BA[j]>=0){
  if (BA[j]==i) return j;
  j++;
 }
 return -1;
}

void ButBarr::SetDbType(int T)
{
 DbT=T;
 LAct=kABNone;
 MAct=kABNone;
 int i;
 for(i=0;i<maxH;i++){
  HistL[i]=kABNone;
  HistM[i]=kABNone;
 }
 Arrange();
 update();
}


void ButBarr::Escape()
{
 int i;
// int j=0;
// bool Done=false;

 for(i=1;i<maxH;i++){
  HistL[i-1]=HistL[i];
  HistM[i-1]=HistM[i];
 }
 HistL[maxH]=kABNone;
 HistM[maxH]=kABNone;

 LAct=HistL[0];
 LActSel(LAct);
 MAct=HistM[0];
 MActSel(MAct);

 for (i=0;i<kNButt;i++){
  if (i==LAct || i==MAct) AB[i]->setDown(true);
  else AB[i]->setDown(false);
 }

 i=kNDButt;
 while(Cn(i)<0) i--;
 i=Cn(i);

 QRect  r;
 r.setRect(0,((i/2)*30)+10,60,60);
 repaint(r);
}

void ButBarr::ButSel(int type, int butt)
{
 int i;
 for (i=0;i<kNButt;i++){
  if (i!=type && AB[i]->GetButt()==butt){
   AB[i]->setDown(false);
  }
 }

 for(i=maxH-1;i>0;i--){
  HistL[i]=HistL[i-1];
  HistM[i]=HistM[i-1];
 }

 if (butt==Qt::LeftButton){
  LAct=type;
  LActSel(type);
 }
 else{
  MAct=type;
  MActSel(type);
 }

 HistL[0]=LAct;
 HistM[0]=MAct;

 i=kNDButt;
 while(Cn(i)<0) i--;
 i=Cn(i);

 QRect  r;
 r.setRect(0,((i/2)*30)+10,60,60);
 repaint(r);
}

int StrToType(QString s)
{
  int i=0;
  while(sAB[i]){
    if(s.compare(sAB[i],Qt::CaseInsensitive)==0) return i;
    i++;
  }
  return -1;
}

void ButBarr::SetAct(QString s,int b)
{
  int i=StrToType(s);
  if(i>=0) ButSel(i,b);
}


void ButBarr::resizeEvent ( QResizeEvent * /*e*/)
{
// int i;
 Arrange();
}



void ButBarr::paintEvent( QPaintEvent * /*e*/)
{
 QPainter paint( this );

 QRect r;

 paint.setFont(QFont( "Helvetica", 9, QFont::Bold ));

 QString s;
 s="Left";
/* paint.setPen(black);
 r.setRect(0,((kNDButt/2)*30)+10,60,20);
 paint.drawText(r,AlignCenter,s);
*/
 int i=kNDButt;
 while(Cn(i)<0) i--;
 i=Cn(i);
 if (LAct>=0){
  s=sAB[LAct];
  paint.setPen(Qt::blue);
  r.setRect(0,((i/2)*30)+10,60,20);
  paint.drawText(r,Qt::AlignCenter,s);
 }
/*
 s="Middle";
 paint.setPen(black);
 r.setRect(0,((kNDButt/2+1)*30)+60,60,20);
 paint.drawText(r,AlignCenter,s);
*/
 if (MAct>=0){
  s=sAB[MAct];
  paint.setPen(Qt::red);
  r.setRect(0,((i/2)*30)+35,60,20);
  paint.drawText(r,Qt::AlignCenter,s);
 }
}

