/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "CnvAtr.h"

#include <QFile>
//Added by qt3to4:
//#include <QTextStream>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

#include "Error.h"
#include "Library.h"

extern Errors  gErr;
extern Library gLib;


CnvAtr::CnvAtr()
{
 CL=NULL;
}

CnvAtr::~CnvAtr()
{
 CnvLst * L;
 if(CL){
  L=CL;
  CL=CL->Next;
  delete L;
 }
}

void CnvAtr::SetTyp(QString t)
{
 Typ="\042"+t+"\042";
}

void CnvAtr::Sep(int &i,QString & s,QString & t)
{
 int j;
 j=s.indexOf('"',i);
 j++;
 i=s.indexOf('"',j);
 t=s.mid(j,i-j);
 i++;
}

void CnvAtr::List()
{
 CnvLst * L=CL;
 while(L){
//  printf("N:%s V:%s S:%s P:%s C:%s\n",(const char *)L->Name,(const char *)L->Val
//        ,(const char *)L->SVal,(const char *)L->Pkg,(const char *)L->Comm);
  L=L->Next;
 }
}

bool CnvAtr::Load(QString name)
{
 QFile F;
 QTextStream S;
 QString s;
 CnvLst * L;
 bool t=false;
 int i;

 gLib.SetFName(&F,name);
 if(!F.exists()){
   printf("File not found %s\n",F.fileName().toLatin1().data());
   return false;
 } 
 F.open(QIODevice::ReadOnly);

 S.setDevice(&F);

 while(!S.atEnd()){
  s=S.readLine();
  if(!s.isEmpty() && s[0]!='#'){
   if(s.indexOf("Typ:")==0){
    printf("Typ: %s, %s\n",Typ.toLatin1().data(),s.toLatin1().data());
    if(s.contains(Typ)) t=true;
    else t=false;
   }
   else if(t){
    i=0;
    L=new CnvLst;
    L->Name=name;
    if(i>=0) Sep(i,s,L->Val);
    if(i>=0) Sep(i,s,L->SVal);
    if(i>=0) Sep(i,s,L->Pkg);
    if(i>=0) Sep(i,s,L->Comm);
    if(i<0){
     printf("Error %s\n",s.toLatin1().data());
     delete L;
    }
    else{
     L->Next=CL;
     CL=L;
    }
   }
  }
 }
 F.close();
 List();
 return true;
}

bool CnvAtr::IsLoad(QString name)
{
 CnvLst * L=CL;
 while(L){
  if(L->Name==name) return true;
  L=L->Next;
 }
 return false;
}


bool CnvAtr::Eval(QString s,QString t)
{
 Atrib A;
// int i;
// int j;
 double x1;
 double x2;
 if(s.isEmpty()){
  if(t.isEmpty()) return true;
  return false;
 }
 if(s[0]=='<'){
  s=s.remove(0,1);
  if(!A.ValToNum(s.toLatin1().data(),x1))  return false;
  if(!A.ValToNum(t.toLatin1().data(),x2))  return false;
  if(x2<x1) return true;
  return false;
 }
 if(s[0]=='>'){
  s=s.remove(0,1);
  if(!A.ValToNum(s.toLatin1().data(),x1))  return false;
  if(!A.ValToNum(t.toLatin1().data(),x2))  return false;
  if(x2>x1) return true;
  return false;
 }


 if(s==t) return true;
 return false;
}

bool CnvAtr::Convert(QString comm, QString pkg, Atrib & Atr)
{
 CnvLst * L;

 if(pkg.isEmpty()) return false;

 if(!pkg.contains("@")){
  Atr.SetAtr(kAtrPkg,pkg);
  Atr.SetAtr(kAtrComm,comm);
  return true;
 }
 pkg.remove(pkg.indexOf('@'),1);
 if(!IsLoad(pkg)) Load(pkg);

 printf("##R:%s V:%s S:%s\n",Atr.GetAtr(kAtrRef)->toLatin1().data()
        ,Atr.GetAtr(kAtrVal)->toLatin1().data()
        ,Atr.GetAtr(kAtrSubV)->toLatin1().data());

 L=CL;
 while(L){
  if(L->Name==pkg){
   if(Eval(L->Val,*Atr.GetAtr(kAtrVal)) && Eval(L->SVal,*Atr.GetAtr(kAtrSubV))){
    Atr.SetAtr(kAtrPkg,L->Pkg);
    Atr.SetAtr(kAtrComm,L->Comm);
    printf("N:%s V:%s S:%s P:%s C:%s\n",L->Name.toLatin1().data(),L->Val.toLatin1().data()
         ,L->SVal.toLatin1().data(),L->Pkg.toLatin1().data(),L->Comm.toLatin1().data());
    return true;
   }
  }
  L=L->Next;
 }

 return false;
}

