/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "DbPrj.h"
#include "Layers.h"

#include <QPainter>
#include <QPen>
#include <QColor>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

#include "Error.h"

extern Errors  gErr;


DbPrj::DbPrj(Layers *L)
 :PicGrp(L)
{
 DL=NULL;
}


DbPrj::~DbPrj()
{
 DbLst * D=DL;
 while(D){
  D=DL->Next;
  delete DL;
  DL=D;
 }
}

int DbPrj::GetIden()
{
 return kDbPrj;
}


void DbPrj::AddDb(QString name,int ver)
{
 DbLst *D;
 D=new DbLst;
 D->FName=name;
 D->Ver=ver;
 D->Next=DL;
 DL=D;
}

QString DbPrj::GetDb()
{
 DbLst *X;
 if(ADL){
  X=ADL;
  ADL=ADL->Next;
  return X->FName;
 }
 QString s;
 return s;
}

void DbPrj::GetDbR()
{
 ADL=DL;
}

int DbPrj::GetVer(QString name)
{
 DbLst *X=DL;
 while(X){
//  printf("GetVer : %s==%s\n",(const char *)name,(const char *)X->FName);
  if(name==X->FName){
//   printf("GetVer : true\n");
   return X->Ver;
  }
  X=X->Next;
 }
 return 0;
}

int DbPrj::GetParam(QString name, int *x, int *y, QString* l)
{
 DbLst *X=DL;
 while(X){
//  printf("GetVer : %s==%s\n",(const char *)name,(const char *)X->FName);
  if(name==X->FName){
//   printf("GetVer : true\n");
   *x=X->XOffs;
   *y=X->YOffs;
   *l=X->PartLay;
   return 1;
  }
  X=X->Next;
 }
 return 0;
}

void DbPrj::SetVer(QString name,int ver)
{
 DbLst *X=DL;
 while(X){
//  printf("SetVer : %s==%s\n",(const char *)name,(const char *)X->FName);
  if(name==X->FName){
//   printf("SetVer : true\n");
   X->Ver=ver;
   return;
  }
  X=X->Next;
 }
}



void DbPrj::TextSave(QTextStream * S, bool sel)
{
// int i;
 DbLst * D=DL;
 PicEl::TextSave(S,sel);
 while(D){
  *S << "    {DbLst " << D->FName << " " << D->Ver <<" }\n";
  *S << "    {DbParam " << D->XOffs << " " << D->YOffs  << " " << D->PartLay <<" }\n";
  D=D->Next;
 }
 PicGrp::TextSaveNext(S,sel);
}

bool  DbPrj::TLoadNext(QTextStream * S,QString* s)
{
 DbLst * D;
 if (s->contains("DbLst")){
  D=new DbLst;
  D->Next=DL;
  DL=D;
  *S >> D->FName;
  *S >> D->Ver;
  D->XOffs=0;
  D->YOffs=0;
  D->PartLay="PINTOP";
  TextLoadSkip(S);
 }
 else if (s->contains("DbParam")){
  if(DL){
    *S >> DL->XOffs;
    *S >> DL->YOffs;
    *S >> DL->PartLay;
  }
  TextLoadSkip(S);
 }
 else  return PicGrp::TLoadNext(S,s);
 return true;
}


