/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DbSch_included
#define DbSch_included

#include "PicEl.h"
#include "PicGrp.h"
#include "PicObj.h"
#include "SComp.h"
#include "DbPcb.h"
#include "Part.h"

#include <QWidget>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

class QPainter;
class QColor;


class DbSch : public PicGrp
{

public:

  DbSch(Layers *L);
  virtual ~DbSch();

  virtual int GetIden();


  void SetType(QString Typ);

  void SetVer(int ver);
  int  GetVer();

  void UpdateAtr();

  void SelXPartL();

  void GetPart(Part * P);

  void Netlist();

  void ClrNets();

  void MkNets();

  void ListNet();

  void ToPcb(DbPcb * D);

  void UpdCGrp();

  bool CheckRef();

  bool Annotate();
  void AddRef(int n);

  void ResetSelRef();

  SComp * GetFirstComp();
  SComp * GetNextComp();


  virtual bool Select(QPoint p,int mode=0,int mir=0);

  virtual void TextSave(QTextStream * S, bool sel=false);

protected:

  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:

  int Ver;

  GrpEl * AE;
  
  QString Type;

};


//-------------------------------------------------------------------------

class PicNet : public PicGrp
{

public:

  PicNet(Layers *L);
  virtual ~PicNet();

  virtual int GetIden();

  virtual void AddTreeList(TreeListItem * LI);

  virtual void HLSel(int fl=0);
  
  virtual void GetSelORect(QRect* r);

  void AddItem(PicEl* E);


  void SetName(QString N);
  QString GetName();

//  PicGrp::GrpEl * Unconnect(unsigned int L,int tol);

//  bool IsConnect(PicEl * L,int tol,GrpEl * B=NULL);
  bool IsConnect(PicEl * L,int tol);
  bool IsConnect(QPoint p,int tol);

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);

  virtual void TextSave(QTextStream * S, bool sel=false);

protected:

  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:

  QString Name;


};



#endif
