/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef Dlg_included
#define Dlg_included

#include "Global.h"
#include "SComp.h"
#include "PComp.h"
#include "PicSComp.h"
#include "PicPin.h"
#include "PicPadS.h"
#include "DbSch.h"
#include "Table.h"

#include <QObject>
#include <QWidget>
#include <QEvent>
#include <QDialog>
#include <QLineEdit>
#include <QComboBox>
#include <QCheckBox>
#include <QPushButton>
#include <QLabel>
//Added by qt3to4:
#include <QResizeEvent>


class StrDlg : public QDialog
{
    Q_OBJECT
public:
    StrDlg( QWidget *parent);
    virtual ~StrDlg();

    bool GetStr(QString * Str,QString & text);

protected:



private:


};


//---------------------------------------------------------------------------

class SCompDlg : public QDialog
{
    Q_OBJECT
public:
    SCompDlg(SComp * C, QWidget *parent);
    virtual ~SCompDlg();

public slots:

    void OK();
    void CA();
    void SetVer(int v);

    void SetPkg(int n);
    void SetPkg0();
    void SetPkg1();
    void SetPkg2();
    void SetPkg3();

signals:
    void Change();

protected:


private:
   SComp * Co;

   QLineEdit * LE[AtrN];
   QLineEdit * LEPiP;
   QCheckBox * CBPPV;
   QComboBox * CBVer;
   int Ver;
};


//---------------------------------------------------------------------------

class PCompDlg : public QDialog
{
    Q_OBJECT
public:
    PCompDlg(PComp * C, QWidget *parent);
    virtual ~PCompDlg();

public slots:

    void OK();
    void CA();

signals:
    void Change();

protected:


private:
   PComp * Co;

   QLineEdit * LE[AtrN];
   QLineEdit * LEPiP;
   QCheckBox * CBPPV;
};

//---------------------------------------------------------------------------

class PSCompDlg : public QDialog
{
    Q_OBJECT
public:
    PSCompDlg(PicSComp * C, QWidget *parent);
    virtual ~PSCompDlg();

public slots:

    void OK();
    void CA();
    void InsT();
    void SetPPP();

protected:

    void MkPkgT();
    void MkPinT();

private:
   PicSComp * Co;
   Table * PinT;
   Table * PkgT;
   int PkgN;
   int PinN;
   int ppp;

   QLineEdit * LEPPP;
   QLineEdit * LEVal;
   QLineEdit * LERef;
};

//---------------------------------------------------------------------------

class PinDlg : public QDialog
{
    Q_OBJECT
public:
    PinDlg(PicPin * C, QWidget *parent);
    virtual ~PinDlg();

public slots:

    void OK();
    void CA();

signals:
    void Change();

protected:


private:
   PicPin * Co;

   QLineEdit * LENum;
   QComboBox * CBTyp;
};


//---------------------------------------------------------------------------

class PadSDlg : public QDialog
{
    Q_OBJECT
public:
    PadSDlg(PicPadS * C, QWidget *parent);
    virtual ~PadSDlg();

public slots:

    void OK();
    void CA();

signals:
    void Change();

protected:


private:
   PicPadS * Co;
   QLineEdit * LENum;

};

//---------------------------------------------------------------------------

class SchDlg : public QDialog
{
    Q_OBJECT

struct AtrLst {
 Atrib A;
 AtrLst * Next;
};

public:
    SchDlg(DbSch * D, QWidget *parent);
    virtual ~SchDlg();

public slots:

    void OK();
    void CA();

protected:

    void MkTable();
    void Arrange();

    void AddAtr(Atrib & A);
    void MkAL();
    void Sort();

    Atrib * FindAtr(QString Ref);

    void resizeEvent ( QResizeEvent * e);

private:
   QPushButton *ok, *cancel;

   DbSch * Db;
   Table * T;
   int   Num;
   AtrLst *AL;
   QLabel *L;
   QLineEdit * LEV;
};


#endif
