/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "KeyMap.h"
#include <stdlib.h>
#include <QTextStream>
#include <QFileDialog>
#include <QFile>
#include <QPrinter>
#include <QPainter>
#include <QEvent>
#include <QScrollArea>

#include <QHBoxLayout>
#include <QVBoxLayout>


KeyMap::KeyMap()
{
  int i,j;
  for(i=0;i<KMNUM;i++){
    Key[i]=0;
    for(j=0;j<FUNCNUM;j++){
      FnId[i][j]=0;
      Param[i][j]="";
    }
  }
  Type=0;
}

KeyMap::~KeyMap()
{
}

void KeyMap::SetKeyMapType(int n)
{
  Type=n;
}

int KeyMap::GetKeyMapType()
{
  return Type;
}

void KeyMap::ProcKey(int k)
{
  int i,j;  
  printf("Key %s\n",KeyToStr(k).toLatin1().data());
  for(i=0;i<KMNUM;i++){
    if(Key[i]==k){
      for(j=0;j<FUNCNUM;j++){
        printf("Fn %d %s\n",FnId[i][j],Param[i][j].toLatin1().data());
	if(FnId[i][j]==fnSelFnL) SetAct(Param[i][j],Qt::LeftButton);
	else if(FnId[i][j]==fnSelFnM) SetAct(Param[i][j],Qt::MidButton);
	else if(FnId[i][j]==fnActLayer) SetLy(Param[i][j]);
	else if(FnId[i][j]==fnActNextLy) SetNextLy(1);
	else if(FnId[i][j]==fnActPrevLy) SetNextLy(-1);
	else if((FnId[i][j]>=fnSetWd) && (FnId[i][j]<=fnAltGrid)){
	  SetInfo(FnId[i][j],Param[i][j]);
	}
      }
    }
  }
}


KeyMap::KeyDef KeyList[]={
 {Qt::Key_Escape,"Esc"},
 {Qt::Key_Escape,"Escape"},
 {Qt::Key_Tab,"Tab"},
 {Qt::Key_Return,"Return"},
 {Qt::Key_Enter,"Enter"},
 {Qt::Key_Insert,"Insert"},
 {Qt::Key_Insert,"Ins"},
 {Qt::Key_Delete,"Delete"},
 {Qt::Key_Delete,"Del"},
 {Qt::Key_Pause,"Pause"},
 {Qt::Key_Print,"Print"},
 {Qt::Key_SysReq,"SysReq"},
 {Qt::Key_Clear,"Clear"},
 {Qt::Key_Home,"Home"},
 {Qt::Key_End,"End"},
 {Qt::Key_Left,"Left"},
 {Qt::Key_Up,"Up"},
 {Qt::Key_Right,"Right"},
 {Qt::Key_Down,"Down"},
 {Qt::Key_PageUp,"PageUp"},
 {Qt::Key_PageDown,"PageDown"},
 {Qt::Key_Shift,"Shift"},
 {Qt::Key_Control,"Control"},
 {Qt::Key_Meta,"Meta"},
 {Qt::Key_Alt,"Alt"},
 {Qt::Key_CapsLock,"CapsLock"},
 {Qt::Key_NumLock,"NumLock"},
 {Qt::Key_ScrollLock,"ScrollLock"},
 {Qt::Key_F1,"F1"},
 {Qt::Key_F2,"F2"},
 {Qt::Key_F3,"F3"},
 {Qt::Key_F4,"F4"},
 {Qt::Key_F5,"F5"},
 {Qt::Key_F6,"F6"},
 {Qt::Key_F7,"F7"},
 {Qt::Key_F8,"F8"},
 {Qt::Key_F9,"F9"},
 {Qt::Key_F10,"F10"},
 {Qt::Key_F11,"F11"},
 {Qt::Key_F12,"F12"},
 {Qt::Key_Space,"Space"},
 {Qt::Key_Any,"Any"},
 {Qt::Key_Exclam,"Exclam"},
 {Qt::Key_QuoteDbl,"QuoteDbl"},
 {Qt::Key_NumberSign,"NumberSign"},
 {Qt::Key_Dollar,"Dollar"},
 {Qt::Key_Percent,"Percent"},
 {Qt::Key_Ampersand,"Ampersand"},
 {Qt::Key_Apostrophe,"Apostrophe"},
 {Qt::Key_ParenLeft,"ParenLeft"},
 {Qt::Key_ParenRight,"ParenRight"},
 {Qt::Key_Asterisk,"Asterisk"},
 {Qt::Key_Plus,"Plus"},
 {Qt::Key_Comma,"Comma"},
 {Qt::Key_Minus,"Minus"},
 {Qt::Key_Period,"Period"},
 {Qt::Key_Slash,"Slash"},
 {Qt::Key_0,"0"},
 {Qt::Key_1,"1"},
 {Qt::Key_2,"2"},
 {Qt::Key_3,"3"},
 {Qt::Key_4,"4"},
 {Qt::Key_5,"5"},
 {Qt::Key_6,"6"},
 {Qt::Key_7,"7"},
 {Qt::Key_8,"8"},
 {Qt::Key_9,"9"},
 {Qt::Key_Colon,"Colon"},
 {Qt::Key_Semicolon,"Semicolon"},
 {Qt::Key_Less,"Less"},
 {Qt::Key_Equal,"Equal"},
 {Qt::Key_Greater,"Greater"},
 {Qt::Key_Question,"Question"},
 {Qt::Key_At,"At"},
 {Qt::Key_A,"A"},
 {Qt::Key_B,"B"},
 {Qt::Key_C,"C"},
 {Qt::Key_D,"D"},
 {Qt::Key_E,"E"},
 {Qt::Key_F,"F"},
 {Qt::Key_G,"G"},
 {Qt::Key_H,"H"},
 {Qt::Key_I,"I"},
 {Qt::Key_J,"J"},
 {Qt::Key_K,"K"},
 {Qt::Key_L,"L"},
 {Qt::Key_M,"M"},
 {Qt::Key_N,"N"},
 {Qt::Key_O,"O"},
 {Qt::Key_P,"P"},
 {Qt::Key_Q,"Q"},
 {Qt::Key_R,"R"},
 {Qt::Key_S,"S"},
 {Qt::Key_T,"T"},
 {Qt::Key_U,"U"},
 {Qt::Key_V,"V"},
 {Qt::Key_W,"W"},
 {Qt::Key_X,"X"},
 {Qt::Key_Y,"Y"},
 {Qt::Key_Z,"Z"},
 {Qt::Key_BracketLeft,"BracketLeft"},
 {Qt::Key_Backslash,"Backslash"},
 {Qt::Key_BracketRight,"BracketRight"},
 {Qt::Key_AsciiCircum,"AsciiCircum"},
 {Qt::Key_Underscore,"Underscore"},
 {Qt::Key_QuoteLeft,"QuoteLeft"},
 {Qt::Key_BraceLeft,"BraceLeft"},
 {Qt::Key_Bar,"Bar"},
 {Qt::Key_BraceRight,"BraceRight"},
 {Qt::Key_AsciiTilde,"AsciiTilde"},

 {0,""},
};

int KeyMap::StrToKey(QString s)
{
  int i=0;
  while(KeyList[i].Num){
    if(s.compare(KeyList[i].Name,Qt::CaseInsensitive)==0) return KeyList[i].Num;
    i++;
  } 
  return 0;
}

QString KeyMap::KeyToStr(int k)
{
  int i=0;
  while(KeyList[i].Num){
    if(KeyList[i].Num==k) return KeyList[i].Name;
    i++;
  }
  return "";
}

void KeyMap::SetKey(int n,QString s)
{
  Key[n]=StrToKey(s);
  printf("Set Key %d to %d %s\n",n,StrToKey(s),s.toLatin1().data());
}

QString KeyMap::GetKey(int n)
{
  return KeyToStr(Key[n]);
}

void KeyMap::SetFn(int n,int m,int f,QString p)
{
  FnId[n][m]=f;
  Param[n][m]=p;
}

void KeyMap::GetFn(int n,int m,int & f,QString & p)
{
  f=FnId[n][m];
  p=Param[n][m];
}


void KeyMap::TextSave(QTextStream * S)
{
  int i;
  int j;
  if(Type==0) *S << "{SchKeyMapSetting\n";
  else *S << "{PcbKeyMapSetting\n";
  for(i=0;i<KMNUM;i++){
    if(Key[i]){
      *S << " {Key " << KeyToStr(Key[i]) << "\n";
      for(j=0;j<FUNCNUM;j++){
        if(FnId[i][j]){
	  *S << "  {Fn " << FnId[i][j] << " " << Param[i][j] << " }\n";
	}  
      }
      *S << " }\n";
    }
  }
  *S << "}\n";
}


void KeyMap::TextLoad(QTextStream * S)
{
  int m=0;
  int n=0;
  QString s;
  int i,j;
  
  *S >> s;
  while (!s.contains("}")){
    if(s.contains("Key")){
      *S >> s;
      Key[m]=StrToKey(s);
      n=0;
      *S >> s;
      while (!s.contains("}")){
	if (s.contains("Fn")){
	  *S >> FnId[m][n];
	  *S >> s;
	  if(!s.contains("}")) Param[m][n]=s;
	  n++;
	}
	while (!s.contains("}")) *S >> s;
	*S >> s;
      }
      for(j=n;j<FUNCNUM;j++){
	FnId[m][j]=0;
	Param[m][j]="";
      }
      m++;
    }
    while (!s.contains("}")) *S >> s;
    *S >> s;
  }
  for(i=m;i<KMNUM;i++){
    Key[i]=0;
    for(j=0;j<FUNCNUM;j++){
      FnId[i][j]=0;
      Param[i][j]="";
    }
  }
}


/**************************************************************************/

KeyMapDlg::KeyMapDlg(KeyMap * km, QWidget *parent )
        : QDialog( parent )
{
  setMinimumWidth(950);
  QVBoxLayout * MLayout;
  QHBoxLayout * BLayout;

  KM=km;

  MLayout = new QVBoxLayout(this);
  MLayout->setSpacing(6);
  MLayout->setMargin(11);


  QScrollArea * SA = new QScrollArea;
//  SA->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
  
  QWidget * Wg = new QWidget;

  QVBoxLayout * SLayout;
  SLayout = new QVBoxLayout(Wg);
  SLayout->setSpacing(6);
  SLayout->setMargin(11);

  QPushButton* Pb;
  QLabel* Lb;

  BLayout = new QHBoxLayout();
  BLayout->setSpacing(6);
  BLayout->setMargin(11);

  Lb=new QLabel("KEYMAP SETTINGS",this);
  BLayout->addWidget( Lb );

  QSpacerItem * spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding , QSizePolicy::Minimum);
  BLayout->addItem( spacer );

  MLayout->addLayout( BLayout );

  QString s;
  int i;
  int j;
  for(i=0;i<KMNUM;i++){
    BLayout = new QHBoxLayout();
    BLayout->setSpacing(2);
    BLayout->setMargin(0);

    s.sprintf("%02d. Key:",i+1);
    Lb=new QLabel(s,this);
    BLayout->addWidget( Lb );

    Key[i]=new QLineEdit(this);
    Key[i]->setMaximumWidth(40);

    BLayout->addWidget(Key[i]);

    for(j=0;j<FUNCNUM;j++){
    
      Lb=new QLabel(" Fn:",this);
      BLayout->addWidget( Lb );
      
      Fn[i][j]=new QComboBox(this);
      BLayout->addWidget(Fn[i][j]);
      Fn[i][j]->insertItem(0,"----");
      Fn[i][j]->insertItem(fnActLayer,"Act Layer");
      Fn[i][j]->insertItem(fnActNextLy,"Act Next Layer");
      Fn[i][j]->insertItem(fnActPrevLy,"Act Prev Layer");
      Fn[i][j]->insertItem(fnSelFnL,"Activate L Fnc");
      Fn[i][j]->insertItem(fnSelFnM,"Activate M Fnc");
      Fn[i][j]->insertItem(fnEsc,"Esc");
      Fn[i][j]->insertItem(fnSetWd,"Set Width");
      Fn[i][j]->insertItem(fnSetRadius,"Set Radius");
      Fn[i][j]->insertItem(fnSetFont,"Set Font");
      Fn[i][j]->insertItem(fnSetOrient,"Set Orient.");
      Fn[i][j]->insertItem(fnSetLineType,"Set Line Type");
      Fn[i][j]->insertItem(fnSetLineMode,"Set Line Mode");
      Fn[i][j]->insertItem(fnSetPwrType,"Set Pwr Type");
      Fn[i][j]->insertItem(fnSetCopyMode,"Set Copy Mode");
      Fn[i][j]->insertItem(fnSetSelMode,"Set Sel Mode");
      Fn[i][j]->insertItem(fnSetBlSelMode,"Set Blk Sel M.");
      Fn[i][j]->insertItem(fnLoad,"Open");
      Fn[i][j]->insertItem(fnSave,"Save");
      Fn[i][j]->insertItem(fnAltGrid,"Alt Grid");


      Par[i][j]=new QLineEdit(this);
      BLayout->addWidget(Par[i][j]);
      Par[i][j]->setMinimumWidth(80);
      Par[i][j]->setMaximumWidth(100);
      
      if(j==(FUNCNUM/2-1)){
        SLayout->addLayout( BLayout );
	BLayout = new QHBoxLayout();
	BLayout->setSpacing(2);
	BLayout->setContentsMargins(0,0,1,8);
	QSpacerItem * spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding , QSizePolicy::Minimum);
	BLayout->addItem( spacer );
      }
    }
    
    SLayout->addLayout( BLayout );
  }

  SA->setWidget(Wg);
  
  MLayout->addWidget(SA);
  
  BLayout = new QHBoxLayout();
  BLayout->setSpacing(6);
  BLayout->setMargin(11);

  Pb = new QPushButton( "Load", this );
  connect( Pb, SIGNAL(clicked()),this, SLOT(Load()) );
  BLayout->addWidget( Pb );

  Pb = new QPushButton( "Save", this );
  connect( Pb, SIGNAL(clicked()),this, SLOT(Save()) );
  BLayout->addWidget( Pb );

  spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding , QSizePolicy::Minimum);
  BLayout->addItem( spacer );

  Pb = new QPushButton( "Cancel", this );
  connect( Pb, SIGNAL(clicked()),this, SLOT(Cancel()) );
  BLayout->addWidget( Pb );

  Pb = new QPushButton( "Revert", this );
  connect( Pb, SIGNAL(clicked()),this, SLOT(Revert()) );
  BLayout->addWidget( Pb );

  Pb = new QPushButton( "OK", this);
  connect( Pb, SIGNAL(clicked()),this, SLOT(OK()) );
  BLayout->addWidget( Pb );

  MLayout->addLayout( BLayout );
  Revert();
}

KeyMapDlg::~KeyMapDlg()
{
}

void KeyMapDlg::Set()
{
  int i,j;
  int f;
  QString p;
  for(i=0;i<KMNUM;i++){
    KM->SetKey(i,Key[i]->text());
    for(j=0;j<FUNCNUM;j++){
      f=Fn[i][j]->currentIndex();
      p=Par[i][j]->text();
      KM->SetFn(i,j,f,p);
    }
  }
}

void KeyMapDlg::OK()
{
  Set();
  close();
}

void KeyMapDlg::Cancel()
{
  close();
}

void KeyMapDlg::Revert()
{
  int i,j;
  int f;
  QString p;
  for(i=0;i<KMNUM;i++){
    Key[i]->setText(KM->GetKey(i));
    for(j=0;j<FUNCNUM;j++){
      KM->GetFn(i,j,f,p);
      Fn[i][j]->setCurrentIndex(f);
      Par[i][j]->setText(p);
    }
  }
}

void KeyMapDlg::Save()
{
  QString s;
  s = QFileDialog::getSaveFileName(this, tr("Save File"),0,tr("*"));
  if (s.isEmpty()) return;

  Set();
  QFile F(s);
  F.open(QIODevice::WriteOnly);
  QTextStream S;
  S.setDevice(&F);
  
  KM->TextSave(&S);
  
  F.close();
}

void KeyMapDlg::Load()
{
  QString s;
  QString id="SchKeyMapSetting";
  int i;
  
  if(KM->GetKeyMapType()!=0) id="PcbKeyMapSetting";
  
  s = QFileDialog::getOpenFileName(this, tr("Open File"),0,tr("*"));
  if (s.isEmpty()) return;

  QFile F(s);
  F.open(QIODevice::ReadOnly);
  QTextStream S;
  S.setDevice(&F);
  
  S >> s;
  while(!s.isEmpty()){
    if(s.contains(id)){
      KM->TextLoad(&S);;
      break;
    }
    else{
      i=1;
      while(i){
        S >> s;
        if(s.contains("{")) i++;
        if(s.contains("}")) i--;
	if(s.isEmpty()) break;
      }
    }
    S >> s;
  }
  
  F.close();
  Revert();
}
