/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Library.h"
#include "PicPComp.h"
#include "PicPadS.h"
#include "PicPin.h"
#include "PicSComp.h"
#include "DbPcb.h"

#include <QFile>
#include <QDir>
//Added by qt3to4:
#include <QTextStream>


#include "Error.h"

extern Errors  gErr;

extern const char *sPic[];

Library::Library()
{
 DL=NULL;
 CL=NULL;
 MWheel[0]=-1;
 MWheel[1]=-1;
 MWheel[2]=-1;
 ThermalPattern[0]=-1;
 ThermalPattern[1]=-1;
 ThermalPattern[2]=-1;
 EmbedLib[0]=-1;
 EmbedLib[1]=-1;
 EmbedLib[2]=-1;
}

Library::~Library()
{
}

const char * DefDirs="../../libsch/analog/\n"
		     "../../libsch/connectors/\n"
		     "../../libsch/cpu/\n"
		     "../../libsch/discrete/\n"
		     "../../libsch/drivers/\n"
		     "../../libsch/logic/\n"
		     "../../libsch/memory/\n" 
		     "../../libsch/opto/\n" 
		     "../../libsch/periph/\n" 
		     "../../libsch/pin/\n" 
		     "../../libsch/power/\n" 
		     "../../libsch/rlc/\n"
		     "../../libpcb/connectors/\n"
		     "../../libpcb/discrete/\n"
		     "../../libpcb/ic/\n"
		     "../../libpcb/pasive/\n"
		     "../../libpcb/vias/\n"
		     "../../libpcb/special/\n"
		     "/usr/share/peda/libsch/analog/\n"
		     "/usr/share/peda/libsch/connectors/\n"
		     "/usr/share/peda/libsch/cpu/\n"
		     "/usr/share/peda/libsch/discrete/\n"
		     "/usr/share/peda/libsch/drivers/\n"
		     "/usr/share/peda/libsch/logic/\n"
		     "/usr/share/peda/libsch/memory/\n" 
		     "/usr/share/peda/libsch/opto/\n" 
		     "/usr/share/peda/libsch/periph/\n" 
		     "/usr/share/peda/libsch/pin/\n" 
		     "/usr/share/peda/libsch/power/\n" 
		     "/usr/share/peda/libsch/rlc/\n"
		     "/usr/share/peda/libpcb/connectors/\n"
		     "/usr/share/peda/libpcb/discrete/\n"
		     "/usr/share/peda/libpcb/ic/\n"
		     "/usr/share/peda/libpcb/pasive/\n"
		     "/usr/share/peda/libpcb/vias/\n"
		     "/usr/share/peda/libpcb/special/\n";


QString Library::GetDirs(int t)
{
  if(t<0) return DefDirs;
  if(t>2) return "";
  return Dirs[t];
}

void Library::SetDirs(int t,QString d)
{
  if(t<0) return ;
  if(t>2) return ;
  Dirs[t]=d;
  Dirs2DL();
}

int Library::GetMWheel(int t)
{
  if(t<0) return 0;
  if(t>2) return 0;
  return MWheel[t];
}
void Library::SetMWheel(int t,int d)
{
  if(t<0) return ;
  if(t>2) return ;
  MWheel[t]=d;
}

int Library::GetThPat(int t)
{
  if(t<0){
    int t=2;
    while(t && (ThermalPattern[t]<0)) t--;
    return ThermalPattern[t];
  }
  if(t>2) return 0;
  return ThermalPattern[t];
}

int Library::GetEmbedLib(int t)
{
  if(t<0){
    int t=2;
    while(t && (EmbedLib[t]<0)) t--;
    return EmbedLib[t];
  }
  if(t>2) return 0;
  return EmbedLib[t];
}

void Library::SetThPat(int t,int d)
{
  if(t<0) return ;
  if(t>2) return ;
  ThermalPattern[t]=d;
}

void Library::SetEmbedLib(int t,int d)
{
  if(t<0) return ;
  if(t>2) return ;
  EmbedLib[t]=d;
}

void Library::LoadSetting()
{
  QFile F;
  QTextStream S;
  QString s;
  
  F.setFileName(QDir::homePath()+"/.pedarc");
  if(F.exists()){
    if(F.open(QIODevice::ReadOnly)){
      S.setDevice(&F);
      S >> s;
      if (s.contains("Settings")) LoadSetting(&S,0);
      F.close();
    }
  }
  F.setFileName(".pedarc");
  if(F.exists()){
    if(F.open(QIODevice::ReadOnly)){
      S.setDevice(&F);
      S >> s;
      if (s.contains("Settings")) LoadSetting(&S,1);
      F.close();
    }
  }
  else{
    Dirs[1]="";
    F.setFileName(".pedarc-libs");
    if(F.open(QIODevice::ReadOnly)){
      S.setDevice(&F);
      S>>s;
      while(!S.atEnd()){
        Dirs[1]+=s;
	Dirs[1]+="\n";
	S>>s;
      }
      F.close();
    }
  }
  Dirs2DL();
}
void Library::SaveSetting()
{
  QFile F;
  QTextStream S;

  F.setFileName(QDir::homePath()+"/.pedarc");
  if(F.open(QIODevice::WriteOnly)){
    S.setDevice(&F);
    SaveSetting(&S,0);
    F.close();
  }
  else printf("Error open %s\n",F.fileName().toLatin1().data());

  F.setFileName(".pedarc");
  F.open(QIODevice::WriteOnly);
  S.setDevice(&F);
  SaveSetting(&S,1);
  F.close();
}

void Library::LoadSetting(QTextStream *S,int t)
{
  QString s;

  MWheel[t]=-1;
  Dirs[t]="";

  *S >> s;
  while (!s.contains("}") && !S->atEnd()){
    if(s.contains("Dirs")){
      *S >> s;
      while(!s.contains("}")){
        Dirs[t]+=s;
	Dirs[t]+="\n";
        *S >> s;
      }
    }
    else if(s.contains("MWheel")){
      *S >> MWheel[t];
      TextLoadSkip(S);
    }
    else if(s.contains("ThPat")){
      *S >> ThermalPattern[t];
      TextLoadSkip(S);
    }
    else if(s.contains("EmbedLib")){
      *S >> EmbedLib[t];
      TextLoadSkip(S);
    }
    else TextLoadSkip(S);

    *S >> s;
  }
  Dirs2DL();
}

void Library::SaveSetting(QTextStream *S,int t)
{
  *S << "{Settings\n";
  if(!Dirs[t].isEmpty()){
    *S << "{Dirs\n";
    *S << Dirs[t] << "\n";
    *S << "}\n";
  }
  if(MWheel[t]>=0) *S << "{MWheel " << MWheel[t] << " }\n";
  if(ThermalPattern[t]>=0) *S << "{ThPat " << ThermalPattern[t] << " }\n";
  if(EmbedLib[t]>=0) *S << "{EmbedLib " << EmbedLib[t] << " }\n";
  *S << "}\n";
}


void Library::SaveParts(QString dir)
{
  QFile F;
  QTextStream S;
  QString s;

  PCompList * T=CL;
  while (T!=NULL){
    s=dir+"/"+T->Name;
    s+=Suff(T->C->GetIden());
    F.setFileName(s);
    F.open(QIODevice::WriteOnly);
    S.setDevice(&F);
    S<<"{"<< sPic[T->C->GetIden()];
    T->C->TextSave(&S);
    F.close();
    T=T->Next;
  }
}

void Library::SaveLib(QTextStream *S,int typ)
{
  PCompList * T=CL;

  while (T!=NULL){
    if(T->C->GetIden()==typ){
      *S << "{LibPart\n";
      *S << "{ShortName " << T->Name << " }\n";
      *S << "{FullName " << T->FullName << " }\n";
      *S << "{"<< sPic[T->C->GetIden()];
      T->C->TextSave(S);
      *S << "}\n";
    }
    T=T->Next;
  }
}

void Library::LoadLib(QTextStream *S,Layers * L,Layers * Lp)
{
  QString s;
  PCompList * T;
  PicGrp * Db=NULL;
  Layers * Lx;

  T=new PCompList;

  *S >> s;
  while (!s.contains("}") && !S->atEnd()){
    if(s.contains("ShortName")){
      *S >> T->Name;
      TextLoadSkip(S);
    }
    else if(s.contains("FullName")){
      *S >> T->FullName;
      TextLoadSkip(S);
    }
    else if (s.contains(sPic[kPicPComp])){
     if (Db) delete Db;
     PicPComp * Dbb=NULL;
     Dbb=new PicPComp(Lp);
     Dbb->SetName(T->Name);
     Dbb->TextLoad(S);
     Db=Dbb;
    }
    else if (s.contains(sPic[kPicPadS])){
     if (Db) delete Db;
     PicPadS * Dbb=NULL;
     Dbb=new PicPadS(Lp);
     Dbb->SetName(T->Name);
     Dbb->TextLoad(S);
     Db=Dbb;
    }
    else if (s.contains(sPic[kPicPin])){
     if (Db) delete Db;
     PicPin * Dbb=NULL;
     Dbb=new PicPin(L);
     Dbb->SetName(T->Name);
     Dbb->TextLoad(S);
     Db=Dbb;
    }
    else if (s.contains(sPic[kPicSComp])){
     if (Db) delete Db;
     PicSComp * Dbb=NULL;
     Dbb=new PicSComp(L);
     Dbb->SetName(T->Name);
     Dbb->TextLoad(S);
     Db=Dbb;
    }
    else TextLoadSkip(S);
    *S >> s;
  }
  if(Db){
    printf("LibPart %s\n",T->Name.toLatin1().data());
    T->Next=CL;
    CL=T;
    T->C=Db;
    Db->SetLock(false);
    Db->Sort();
    Lx=Db->GetLayers();
    Lx->Store();
    Lx->SetVis(AllLy);
    Lx->DelVis(Lx->GetRts());
    Db->UpdORect();
    Lx->ReStore();
  }
  else delete T;
}

void Library::Dirs2DL()
{
  DirList * D=DL;
  QString s;
  QString s1;
  int t;
  
  while (D){
    DL=D->Next;
    delete D;
    D=DL;
  }
  t=2;
  while((t>=0) && (Dirs[t].isEmpty())) t--;
  if(t<0) s=DefDirs;
  else s=Dirs[t];
  s=s.simplified();
//  printf("Dirs: %s\n",s.ascii());
  t=0;
  s1=s.section(' ',t,t);
  while(!s1.isEmpty()){
    AddDir(s1.toLatin1().data());
    t++;
    s1=s.section(' ',t,t);
  }
}

void Library::AddDir(const char * Dir)
{
 DirList * D;
 D=new DirList;
 D->Dir=Dir;
 D->Next=DL;
 DL=D;
}

void Library::Clear()
{
 PCompList * T=CL;
 while (T!=NULL){
  CL=T->Next;
  delete T->C;
  delete T;
  T=CL;
 }
}

void Library::Clear(Layers * Ly)
{
 PCompList * T=CL;
 PCompList * T1=CL;
 while (T!=NULL){
  if (T->C->GetLayers()==Ly){
   if(T==CL){
    CL=T->Next;
    delete T->C;
    delete T;
    T=CL;
   }
   else{
    T1->Next=T->Next;
    delete T->C;
    delete T;
    T=T1->Next;
   }
  }
  else{
   T1=T;
   T=T->Next;
  }
 }
}


PicGrp * Library::GetPComp(QString name,Layers * L)
{
 return GetComp(name,L,kPicPComp);;
}


PicGrp * Library::GetComp(QString name,Layers * L,int typ,int fl)
{
 PCompList * T=CL;
 while (T!=NULL){
  if (T->Name==name &&
      T->C->GetIden()==typ &&
      T->C->GetLayers()==L) return T->C;
  T=T->Next;
 }

 DirList * D=DL;
 QFile F;
 QDir  Dir;
 QTextStream S;
 QString s;
 PicGrp * Db=NULL;

 while (D){
  s=D->Dir+name;
  s+=Suff(typ);
  F.setFileName(s);
  if (F.exists()) break;
//  s="Lib: Neni ";
//  s+=D->Dir+name;
//  s+=Suff(typ);
//  printf("%s %d\n",(const char *)s,name.length());
  D=D->Next;
 }

 if (F.exists()){
  F.open(QIODevice::ReadOnly);
  S.setDevice(&F);
  S >> s;
  while(!S.atEnd()){
   if (s.contains("Layer") && typ!=kDbPcb){
    L->TextLoad(&S);
   }
   else if (s.contains("LayerP") && typ==kDbPcb){
    L->TextLoad(&S);
   }
   else if (s.contains(sPic[kPicPComp])){
    if (Db) delete Db;
    PicPComp * Dbb=NULL;
    Dbb=new PicPComp(L);
    Dbb->SetName(name);
    Dbb->TextLoad(&S);
    Db=Dbb;
   }
   else if (s.contains(sPic[kPicPadS])){
    if (Db) delete Db;
    PicPadS * Dbb=NULL;
    Dbb=new PicPadS(L);
    Dbb->SetName(name);
    Dbb->TextLoad(&S);
    Db=Dbb;
   }
   else if (s.contains(sPic[kPicPin])){
    if (Db) delete Db;
    PicPin * Dbb=NULL;
    Dbb=new PicPin(L);
    Dbb->SetName(name);
    Dbb->TextLoad(&S);
    Db=Dbb;
   }
   else if (s.contains(sPic[kPicSComp])){
    if (Db) delete Db;
    PicSComp * Dbb=NULL;
    Dbb=new PicSComp(L);
    Dbb->SetName(name);
    Dbb->TextLoad(&S);
    Db=Dbb;
   }
   else if (s.contains(sPic[kDbPcb])){
    if (Db) delete Db;
    DbPcb * Dbb=NULL;
    Dbb=new DbPcb(L);
    Dbb->SetName(name);
    Dbb->TextLoad(&S);
    Db=Dbb;
   }
   else{
    TextLoadSkip(&S);
   }
   S >> s;
  }
  F.close();

  if (Db && Db->GetIden()==typ){
   T=new PCompList;
   T->Next=CL;
   CL=T;
   T->Name=name;
   T->C=Db;
   T->FullName=F.fileName();
   Db->SetLock(false);
   Db->Sort();
   L->Store();
   L->SetVis(AllLy);
   L->DelVis(L->GetRts());
   Db->UpdORect();
   L->ReStore();
   return Db;
  }
  else delete Db;
 }
// s="Lib: Neni ";
// s+=D->Dir+name;
// s+=Suff(typ);
// gErr.Err(s);
  if((fl==0)&&(!name.isEmpty())){
    s="ERROR "+name+" not found";
//    gErr.ToLst(s);
    gErr.Err(s);
    printf("%s\n",s.toLatin1().data());
  }
 return NULL;
}

void Library::FillTree(QTreeWidget * Tree,int type)
{
  unsigned int i;
  DirList * D=DL;
  QString s,s1;
  QDir  Dir;
  QDir  DirS;
//  Dir.setFileNameFilters(QStringList(Suff(type)));
  if (type==kPicSComp){
    Dir.setNameFilters(QStringList(QString("*.sco")));
    Tree->setHeaderLabel("Sch components");
    s=".sco";
  }  
  if (type==kPicPComp){
    Dir.setNameFilters(QStringList(QString("*.pco")));
    Tree->setHeaderLabel("Pcb components");
    s=".pco";
  }  

  QTreeWidgetItem *I;
  QTreeWidgetItem *J;
  
  printf("Library::FillTree\n");
  while (D){
    Dir.setPath(D->Dir);
    DirS.setPath(D->Dir);
    s1=DirS.dirName();
    DirS.cdUp();
    while(!DirS.cd("libsrc")){
      if(!DirS.cdUp()) break;
    }
    if (type==kPicSComp){
      s1+=".tlb";
      DirS.cd("sch");
    }
    else{
      s1+=".ppd";
      DirS.cd("pcb");
    }
    printf("  %s %d\n",D->Dir.toAscii().data(),Dir.count());
    if(Dir.count()>0){
      I=new QTreeWidgetItem((QTreeWidget*)0, QStringList(Dir.dirName()));
      Tree->addTopLevelItem(I);
      for(i=0;i<Dir.count();i++){
        J=new QTreeWidgetItem((QTreeWidget*)0, QStringList(Dir[i].remove(s)));
	J->setText(1,Dir.path()+"/"+Dir[i]);
	J->setText(2,DirS.path()+"/"+s1);
	I->addChild(J);
      }
    }
    D=D->Next;
  }
}


QString Library::Suff(int typ)
{
 if (typ==kPicPComp) return ".pco";
 if (typ==kPicPadS) return ".pad";
 if (typ==kPicPin) return ".pin";
 if (typ==kPicSComp) return ".sco";
 if (typ==kDbPcb) return ".tdb";
 return "";
}


void Library::TextLoadSkip(QTextStream * S)
{
  QString s;
  int i=1;
  do{
   *S >> s;
   i+=s.count('{');
   i-=s.count('}');
  } while (i>0);
}

bool Library::SetFName(QFile * F,QString name)
{
 DirList * D=DL;
 QString s;

 while (D){
  s=D->Dir+name;
  F->setFileName(s);
  if (F->exists()) return true;
  D=D->Next;
 }
 return false;
}
