
/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QTextStream>
#include <QDialog>
#include <QLineEdit>
#include <QComboBox>
#include <QCheckBox>
#include <QPushButton>
#include <QLabel>
#include <QPaintEvent>
#include <QPainterPath>

#include "Global.h"
#include "Layers.h"
#include "PicEl.h"
#include "PicGrp.h"
#include "DbSch.h"

#ifndef Outputs_included
#define Outputs_included

#define OUTNUM 18

class Outputs
{
public:

 struct PolyLst {
   QPainterPath P;
   PolyLst* Next;
 };

 struct Aperture{
   int t;
   int x;
   int y;
 };

  Outputs();
  virtual ~Outputs();

  void DoOutputs(PicGrp * Sch,PicGrp * Pcb, QString n,QString v);
  void PartLOutput(DbSch *D,PicGrp * Pcb,unsigned long int L,QString n);
  void BomOutput(DbSch *D,PicGrp * Pcb,unsigned long int L,QString n);
  void CplOutput(DbSch *D,PicGrp * Pcb,unsigned long int L,QString n);
  void PlaceOutput(DbSch *D,PicGrp * Pcb,unsigned long int L,QString n, int fl);
  void PdfOutput(PicGrp *D,unsigned long int L,QString n,int fl);
  void GerberOutput(PicGrp *D,unsigned long int L,QString n);
  void ExcelonOutput(PicGrp *D,unsigned long int L,QString n);
  void DescOutput(QString n,QString v);

  int GetType(int i);
  bool GetMirror(int i);
  QString GetLayers(int i);
  QString GetFName(int i);
  QString GetDesc(int i);
  QString GetOutDir();
  void GetPCB(QString & th,QString & cu,QString & mat);
  int GetFillApr();
  QString GetDescFile();
  int GetXOffs();
  int GetYOffs();
  
  void SetType(int i,int t);
  void SetOutDir(QString OD);
  void SetFName(int i,QString n);
  void SetDesc(int i,QString n);
  void SetLayers(int i,QString l);
  void SetMirror(int i,bool m);
  void SetPCB(QString th,QString cu,QString mat);
  void SetFillApr(int a);
  void SetDescFile(QString n);
  void SetOffs(int x,int y);
  
  void TextSave(QTextStream * S);
  void TextLoad(QTextStream * S);

private:

  bool XPoint(QPoint p1, QPoint p2, QPoint p3, QPoint p4, QPoint &x);
//  bool FindSubPoly(QPainterPath &Po,int &i,int &j);
//  void SplitSubPoly(QPainterPath Po,PolyLst** PLst);
  void FillPoly(QPainterPath &Po,QTextStream & S,int W,Aperture * apr,int a);
//  void ReducePoly(QPainterPath &Po, QPainterPath &SP, QPainterPath &DP);

  void AddApr(Aperture * apr,int & num,int type,int x,int y);
  int FindApr(Aperture * apr,int & num,int type,int x,int y);
  void WriteApr(Aperture * apr,int num,QTextStream & S);
  void WriteAprEx(Aperture * apr,int num,QTextStream & S);
  void SortApr(Aperture * apr,int & num);

  QString DescFile;

  QString Th;
  QString Cu;
  QString Mat;

  QString OutDir;
  QString Ly[OUTNUM];
  QString FN[OUTNUM];
  QString Desc[OUTNUM];
  bool Mirror[OUTNUM];
  int Type[OUTNUM];

  int FillApr;
  int XOffs;
  int YOffs;
  
  int MinX;
  int MaxX;
  int MinY;
  int MaxY;

};


class OutDlg : public QDialog
{
 Q_OBJECT
public:
    OutDlg(Outputs * O, QWidget *parent=0 );
    virtual ~OutDlg();

public slots:
    void Set();
    void OK();
    void Cancel();
    void Revert();
    void Save();
    void Load();

protected:

/*
    void paintEvent( QPaintEvent * e);
    void mousePressEvent ( QMouseEvent *e );
*/


private:

    Outputs * Out;
    
    QLineEdit * OutDir;
    QLineEdit * DescFile;
    QLineEdit * FillApr;
    QLineEdit * XOffs;
    QLineEdit * YOffs;

    QLineEdit * Th;
    QLineEdit * Mat;
    QLineEdit * Cu;
    
    QComboBox * CBTyp[OUTNUM];
    QLineEdit * Ly[OUTNUM];
    QLineEdit * FN[OUTNUM];
    QCheckBox * CbMir[OUTNUM];
    QLineEdit * Desc[OUTNUM];

};

#endif
