/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PComp_included
#define PComp_included

#include "PicEl.h"
#include "PicGrp.h"
#include "PicObj.h"
//#include "SComp.h"
#include "PicPComp.h"
#include "Atr.h"
#include "PinLst.h"

#include <QWidget>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

class QPainter;
class QPainterPath;
class QColor;

class PComp : public PicGrp
{

struct PinP {
  QPoint P;
  int E;
};

public:

  PComp(Layers *L);
  virtual ~PComp();

  virtual int GetIden();

  virtual void AddTreeList(TreeListItem * LI);

  PicText * AddAtr(int A);
  void UpdateAtr();

  PicPComp * GetPPComp();
  bool IsValid();
//  void DelAtr();

  void SetAtr(Atrib & A);
  Atrib & GetAtr();
  void SetPinL(PinList & P);

  QString GetAtr(int n);
  void SetAtr(int n, const char * s);
  const char * GetAtrNam(int n);

  virtual bool Select(QPoint p,int mode=0,int mir=0);
  virtual bool Select(QRect r,int mode=0,int mir=0);
  virtual bool Select(PicEl * E);
  virtual void DeSelect();

  bool LibPart(QString name);
  bool ChLibPart(QString name);

  void MkPinP();

  void GetPinR();
  bool GetPin(QString * net,int * num);
  bool GetPinP(QPoint * p,int num);
  unsigned long int GetPinL(int num);

  void GetPinPosRes();
  bool GetPinPos(QPoint & p,int & num);

  void GetCenter(QPoint & p, int & rot,int & mir,int & typ);

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);

//  void SetSC(SComp * S);
//  void SetSCG(SCGrp * S);

  virtual PicEl * GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                        int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);
  virtual PicEl * GetNextEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                            int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool & pad);


  virtual void TextSave(QTextStream * S, bool sel=false);

protected:

  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:
  QString Reff;
  Atrib  Atr;
  PinList PL;

  bool X;
  PinP * PP;

};

#endif
