/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PartDlg_included
#define PartDlg_included

#include "Part.h"

#include <QObject>
#include <QWidget>
#include <QEvent>
#include <QDialog>
#include <QLineEdit>
#include <QComboBox>
#include <QCheckBox>
#include <QPushButton>
#include <QLabel>
#include <QScrollBar>
//#include <QNameSpace>
#include <QPrinter>
#include <QPrintDialog>

//Added by qt3to4:
#include <QPaintEvent>
#include <QResizeEvent>
#include <QMouseEvent>



class PartWdg : public QWidget
{
    Q_OBJECT
public:
    PartWdg(Part * C, QWidget *parent );
    virtual ~PartWdg();

public slots:

    void MoveY(int y);
    void IncPN();
    void DecPN();

    void Print();
    void WrCsv();

    void SetHead();
    void SetTail();

    void SetFont();


protected:
    void paintEvent( QPaintEvent * e);
    void mouseMoveEvent( QMouseEvent *e );
    void mousePressEvent ( QMouseEvent *e );
    void mouseReleaseEvent ( QMouseEvent * e);
    void resizeEvent ( QResizeEvent * e);


private:
   Part * P;

   int  HOff;
   int  VOff;

   int  Zoom;

   int  PN;
   int  MaxP;

   QFont Font;


   QScrollBar * HS;
   QScrollBar * VS;

};


//-----------------------------------------------------------------------------



class PartDlg : public QDialog
{
    Q_OBJECT
public:
    PartDlg(Part * C, QWidget *parent );
    virtual ~PartDlg();

public slots:

    void OK();
    void Sort(int v);

protected:

    void resizeEvent ( QResizeEvent * e);


private:
   Part * P;
   PartWdg * PW;

   QPushButton *ok;
   QPushButton *PU;
   QPushButton *PD;
   QPushButton *PR;
   QPushButton *WR;
   QPushButton *SH;
   QPushButton *ST;
   QPushButton *SF;

   QLineEdit * LEPiP;
   QCheckBox * CBPPV;
   QComboBox * CBSort;
   int Ver;
};




#endif
