/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "PicEl.h"
#include "PicObj.h"
#include "PicGrp.h"
#include "Layers.h"
#include "Library.h"
#include "PicPComp.h"
#include "PicPadS.h"
#include "PicPin.h"
#include "PicSComp.h"
#include "SComp.h"
#include "PComp.h"
#include "DbSch.h"
#include "DbPcb.h"
#include "ObjEdit.h"

#include <QPainter>
#include <QPen>
#include <QColor>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

extern const char *sPic[];

const char *ObjName[] = {
 "El",
 "Line",
 "Polygon",
 "Rectangle",
 "Circle",
 "Power",
 "Text",
 "Group",
 "Pad Stack",
 "Pin",
 "P Component Pic",
 "S Component Pic",
 "P Component",
 "S Component",
 "Schema",
 "PCB",
 "S Net",
 "P Net",
 "Project",
 0
};

extern Library gLib;


PicGrp::PicGrp(Layers *L)
 :PicEl(L)
{
 Data=NULL;
 Lock=0;
 NS=NULL;
 AEl=NULL;
}

PicGrp::~PicGrp()
{
 if (!Lock){
  GrpEl* T;
  T=Data;
  while (T!=NULL){
   Data=T->Next;
   delete T->E;
   delete T;
   T=Data;
  }
 }
}

int PicGrp::GetIden()
{
 return kPicGrp;
}


void PicGrp::MoveSelTo(int x, int y)
{
 GrpEl* T=Data;
 x=x-Ref.x();
 y=y-Ref.y();
 CompRot(4-Rot,&x,&y,Mir+256);
 while(T!=NULL){
  if (T->E->IsSelect()){
   if (T->E->IsLock()) T->E->MoveTo(x,y);
    else ((PicGrp *)(T->E))->MoveSelTo(x,y);
  }
  T=T->Next;
 }
// SetOutl();
}

void PicGrp::MoveSelBy(int x, int y)
{
 GrpEl* T=Data;
 CompRot(4-Rot,&x,&y,Mir+256);
 while(T!=NULL){
  if (T->E->IsSelect()){
   if (T->E->IsPointSel()) T->E->MovePointBy(x,y);
   else {
    if (T->E->IsLock()) T->E->MoveBy(x,y);
    else ((PicGrp *)(T->E))->MoveSelBy(x,y);
   }
  }
  T=T->Next;
 }
// SetOutl();
}

void PicGrp::MoveSelTo(QPoint p)
{
 MoveSelTo(p.x(),p.y());
}

void PicGrp::RotateSel(int rot, int x ,int y)
{
 rot=rot & 3;
 GrpEl* T=Data;
 x=x-Ref.x();
 y=y-Ref.y();
 CompRot(4-Rot,&x,&y,Mir+256);
 QPoint p;
 while(T!=NULL){
  if (T->E->IsSelect()){
   if (T->E->IsPointSel()) p=T->E->GetSelPoint();
   else p=T->E->Pos();
   int x1=x-p.x();
   int y1=y-p.y();
   int mir=T->E->GetMirror();
    if ((rot==1 && !mir) || (rot==1 && mir)){
    p.setX(x+y1);
    p.setY(y-x1);
   }
   else if (rot==2){
    p.setX(x+x1);
    p.setY(y+y1);
   }
   else if ((rot==3 && !mir) || (rot==3 && mir)){
    p.setX(x-y1);
    p.setY(y+x1);
   }
   if (T->E->IsPointSel()) T->E->MovePointTo(p);
   else {
    if (T->E->IsLock()){
     T->E->MoveTo(p);
     T->E->Rotate(rot);
    }
    else ((PicGrp *)(T->E))->RotateSel(rot,x,y);
   }
  }
  T=T->Next;
 }
// SetOutl();
}


void PicGrp::MirrorSel(int x ,int y)
{
 GrpEl* T=Data;
 x=x-Ref.x();
 y=y-Ref.y();
 CompRot(4-Rot,&x,&y,Mir+256);
 QPoint p;
 while(T!=NULL){
  if (T->E->IsSelect()){
   if (T->E->IsPointSel()) p=T->E->GetSelPoint();
   else p=T->E->Pos();
   int x1=x-p.x();
//   int y1=y-p.y();
   int rot=T->E->GetRotate();

/*    if ((rot==1 && !mir) || (rot==3 && mir)){
    p.setX(x+y1);
    p.setY(y-x1);
   }
   else if (rot==2){
    p.setX(x+x1);
    p.setY(y+y1);
   }
   else if ((rot==3 && !mir) || (rot==1 && mir)){
    p.setX(x-y1);
    p.setY(y+x1);
   }
*/
//   if (Rot & 1) p.setY(y+y1);
   p.setX(x+x1);

   if (T->E->IsPointSel()) T->E->MovePointTo(p);
   else {
    if (T->E->IsLock()){
     T->E->MoveTo(p);
     if (rot&1) T->E->Rotate(2);
     T->E->Mirror();
    }
    else ((PicGrp *)(T->E))->MirrorSel(x,y);
   }
  }
  T=T->Next;
 }
// SetOutl();
}

void PicGrp::DeleteSel()
{
 GrpEl* T=Data;
 GrpEl* T1=NULL;
 while(T!=NULL){
  if (T->E->IsSelect() && !T->E->IsPointSel()){
   if (T->E->IsLock()){
    if (T1==NULL){
     Data=T->Next;
     delete T->E;
     delete T;
     T=Data;
    }
    else {
     T1->Next=T->Next;
     delete T->E;
     delete T;
     T=T1->Next;
    }
   }
   else {
    ((PicGrp *)(T->E))->DeleteSel();
    T=T->Next;
   }
  }
  else{
   T1=T;
   T=T->Next;
  }
 }
// SetOutl();
}

bool PicGrp::GetNearestPin(QPoint p,QPoint & p1,int tol,int mir)
{
  p=p-Ref;
  p=CompRot(4-Rot,p,Mir+256);
  if(Data!=NULL && R.contains(p) && Layer->IsVis(GetLayer(mir))){
    GrpEl* T=Data;
    GrpEl* T1=NULL;
    long long min=tol;
    QPoint p2;
    while(T!=NULL){
      if((T->E->GetIden()==kPicPin) || (T->E->GetIden()==kPicPadS)){
        if(!T->E->IsSelect()){
          p2=T->E->Pos()-p;
	  if(min>((long long)p2.x()*p2.x()+(long long)p2.y()*p2.y())){
	    min=((long long)p2.x()*p2.x()+(long long)p2.y()*p2.y());
	    T1=T;
	  }
	}  
      }
      else if(T->E->GetIden()>=kPicGrp){
        if(((PicGrp *)(T->E))->GetNearestPin(p,p1,tol,mir+Mir)){
	  p1=CompRot(Rot,p1,Mir);
          p1+=Ref;
	  return true;
	}
      }
      T=T->Next;
    }
    if(T1){
      p1=T1->E->Pos();
      p1=CompRot(Rot,p1,Mir);
      p1+=Ref;
      return true;
    }
  }
  return false;
}

bool PicGrp::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  if (Lock) return(PicEl::GetInfo(i,p,mode,mir));
  p=p-Ref;
  p=CompRot(4-Rot,p,Mir+256);
  if(Data!=NULL && R.contains(p) && Layer->IsVis(GetLayer(mir))){
    GrpEl* T=Data;
    while(T!=NULL){
      if (T->E->GetInfo(i,p,mode,mir+Mir)){
        return true;
      }
      T=T->Next;
    }
  }
  return false;
}

bool PicGrp::Select(QPoint p,int mode,int mir)
{
 int type=mode/0x10000;
 int mod=mode & 0x0ffff;
 if (Lock) return(PicEl::Select(p,mode,mir));
 p=p-Ref;
 p=CompRot(4-Rot,p,Mir+256);
 if(Data!=NULL && R.contains(p) && Layer->IsVis(GetLayer(mir))){
  GrpEl* T=Data;
  GrpEl* T1=NULL;
  while(T!=NULL){
   if (T->E->Select(p,mode,mir+Mir)){
    if((type==0) || T->E->GetIden()==type || (!T->E->IsLock(1))){
     Sel=2;
     if(T->E->GetIden()==kPicLine && mod!=kSelActOnly){
      SelPoint(((PicLine *)(T->E))->GetBegin(),2,Mir+mir);
      SelPoint(((PicLine *)(T->E))->GetEnd(),2,Mir+mir);
     }
     if(mod==0 || mod==kSelActOnly) return true;
     if(mod==kSelAct){
      if (Layer->IsAct(T->E->GetLayer(mir+Mir))){  //!!!!!!!!!!!!!!!!!!!!!!
       if(T1!=NULL) T1->E->DeSelect();
       return true;
      }
      else{
       if(T1!=NULL) T->E->DeSelect();
        else T1=T;
      }
     }
     else if (mod==kSelActOnly){
     }
    }
    else T->E->DeSelect();
   }
   T=T->Next;
  }
  if(T1!=NULL) return true;
 }
 return false;
}

bool PicGrp::Select(PicEl * E)
{
 if (PicEl::Select(E)) return true;
 if(Data!=NULL && !Lock){
  GrpEl* T=Data;
  while(T!=NULL){
   if (T->E->Select(E)){
    Sel=2;
    return true;
   }
   T=T->Next;
  }
 }
 return false;
}



bool PicGrp::Select(QRect r,int mode,int mir)
{
 int type=mode/0x10000;
 //int xmod=mode & 0xff00;
 //int mod=mode & 255;
 if (Lock) return(PicEl::Select(r,mode,mir));
 r.translate(-Ref.x(),-Ref.y());
 r=CompRot(4-Rot,r,Mir+256);
 if(Data!=NULL && r.intersects(R) && Layer->IsVis(GetLayer())){
  GrpEl* T=Data;
//  GrpEl* T1=NULL;
  while(T!=NULL){
   if(T->E->GetIden()==type || type==0  || T->E->GetIden()>=kPicGrp){
    if (T->E->Select(r,mode,Mir+mir)){
     Sel=2;
    }
   }
   T=T->Next;
  }
  if (Sel) return true;
 }
 return false;
}

void PicGrp::DeSelect()
{
// if (Lock) Sel=0;
 Sel=0;
 if(Data!=NULL){
  GrpEl* T=Data;
  while(T!=NULL){
   T->E->DeSelect();
   T=T->Next;
  }
//  Sel=0;
 }
}

void PicGrp::SelInfo(int l)
{
 if(Sel){
  PicEl::SelInfo(l);
  GrpEl* T=Data;
  while(T!=NULL){
   T->E->SelInfo(l+1);
   T=T->Next;
  }
 }
}


void PicGrp::HLSel(int fl)
{
// if (Lock && Sel==1){
 if (Sel==1){
  HiL=true;
  return;
 }
 if(Data!=NULL){
  GrpEl* T=Data;
  while(T!=NULL){
   T->E->HLSel(fl);
   T=T->Next;
  }
 }
}

void PicGrp::HLOff()
{
 HiL=false;
 if(Data!=NULL){
  GrpEl* T=Data;
  while(T!=NULL){
   T->E->HLOff();
   T=T->Next;
  }
 }
}


QString PicGrp::GetHLComp()
{
  if(Data!=NULL){
    GrpEl* T=Data;
    while(T!=NULL){
      if(T->E->GetIden()==kSComp){
        if(T->E->IsHL()) return ((SComp *)T->E)->GetAtr(kAtrRef);
      }
      if(T->E->GetIden()==kPComp){
        if(T->E->IsHL()) return ((PComp *)T->E)->GetAtr(kAtrRef);
      }
      T=T->Next;
    }
  }
  return "";
}

QString PicGrp::GetHLNet()
{
  if(Data!=NULL){
    GrpEl* T=Data;
    while(T!=NULL){
      if(T->E->GetIden()==kPicNet){
        if(T->E->IsHL()) return ((PicNet *)T->E)->GetName();
      }
      if(T->E->GetIden()==kPicPNet){
        if(T->E->IsHL()) return ((PicPNet *)T->E)->GetName();
      }
      T=T->Next;
    }
  }
  return "";
}

void PicGrp::SelNet(QString s)
{
  if(Data!=NULL){
    GrpEl* T=Data;
    while(T!=NULL){
      if(T->E->GetIden()==kPicNet){
        if(s==((PicNet *)T->E)->GetName()){
	  T->E->SelThis();
	  Sel=2;
	}  
      }
      if(T->E->GetIden()==kPicPNet){
        if(s==((PicPNet *)T->E)->GetName()){
	  T->E->SelThis();
	  Sel=2;
	}  
      }
      T=T->Next;
    }
  }
}

void PicGrp::SelComp(QString s)
{
  if(Data!=NULL){
    GrpEl* T=Data;
    while(T!=NULL){
      if(T->E->GetIden()==kSComp){
        if(s.compare(((SComp *)T->E)->GetAtr(kAtrRef))==0){
	  T->E->SelThis();
	  Sel=2;
	}  
      }
      if(T->E->GetIden()==kPComp){
        if(s.compare(((PComp *)T->E)->GetAtr(kAtrRef))==0){
	  T->E->Select(T->E);
	  Sel=2;
	  GrpEl* T1=Data;
	  unsigned long int t=Layer->GetRts();
	  if (Layer->IsVis(t)){
	    while(T1!=NULL){
	      if (T1->E->GetIden()==kPicPNet) ((PicPNet *)T1->E)->SelRts((PComp *)T->E);
	      T1=T1->Next;
	    }
	  }
	}
      }
      T=T->Next;
    }
  }
}


int PicGrp::SelPoint(QPoint p,int tol,int mode,int mir)
{
 if (Lock) return -1;
 if(Data!=NULL && Layer->IsVis(GetLayer(mir))){
  p=p-Ref;
  p=CompRot(4-Rot,p,Mir+256);
  GrpEl* T=Data;
  int x;
  int r=-1;
  while(T!=NULL){
   if(T->E->IsSelect()!=1 || T->E->IsPointSel()){
    x=T->E->SelPoint(p,tol,mode,mir+Mir);
    if (x>=0){
     Sel=2;
     r=x;
    }
   }
   T=T->Next;
  }
  return r;
 }
 return -1;
}


/*int PicGrp::SelPoint(QPoint p,int tol=0,int mode=0)
{
 if (Lock) return -1;
 if(Data!=NULL && Layer->IsVis(GetLayer())){
  p=p-Ref;
  p=CompRot(4-Rot,p,Mir+256);
  GrpEl* T=Data;
  GrpEl* T1=NULL;
  int min=tol;
  int x;
  while(T!=NULL){
   if(T->E->IsSelect()!=1 || T->E->IsPointSel()){
    x=T->E->SelPoint(p,tol,mode);
    if (x>=0){
     if (x<min){
      if (T1!=NULL) T1->E->DeSelect();
      T1=T;
      min=x;
     }
     else {
      T->E->DeSelect();
     }
    }
   }
   T=T->Next;
  }
  if(T1!=NULL){
   Sel=2;
   if (mode<2){
     T=Data;
    if (T1->E->IsPointSel()) p=T1->E->GetSelPoint();
    while(T!=NULL){
     if (T->E->GetIden()<kPicGrp && (!T->E->IsSelect()==1 || T->E->IsPointSel()))
           T->E->SelPoint(p,2,mode);
     T=T->Next;
    }
   }
   return min;
  }
 }
 return -1;
}*/


void PicGrp::MovePointTo(QPoint p)
{
 GrpEl* T=Data;
 p=p-Ref;
 p=CompRot(4-Rot,p,Mir+256);
 while(T!=NULL){
  if (T->E->IsSelect()){
   T->E->MovePointTo(p);
  }
  T=T->Next;
 }
// SetOutl();
}

void PicGrp::MovePointBy(int /*x*/, int /*y*/)
{
}

QPoint PicGrp::SelPos()
{
 QPoint p;
 if(Data!=NULL){
  GrpEl* T=Data;
  while(T!=NULL){
   if (T->E->IsSelect() && (T->E->GetIden()!=kPicPNet)){
    if (T->E->IsLock()) p=T->E->Pos();
    else p=((PicGrp *)(T->E))->SelPos();
    p=CompRot(Rot,p,Mir);
    p+=Ref;
    return p;
   }
   T=T->Next;
  }
 }
 return p;
}


int PicGrp::SelRot()
{
 int  r=0;
 if(Data!=NULL){
  GrpEl* T=Data;
  while(T!=NULL){
   if (T->E->IsSelect()){
    if (T->E->IsLock()) r=T->E->GetRotate();
    else r=((PicGrp *)(T->E))->SelRot();
    r+=Rot;
    return r;
   }
   T=T->Next;
  }
 }
 return r;
}


void PicGrp::AddItem(PicEl* E)
{
 GrpEl* T;
 T=new GrpEl;
 T->E=E;
 T->Next=Data;
 Data=T;
 Ly=Ly|T->E->GetLayer();
 if (Layer->IsVis(T->E->GetLayer())){
  QRect r;
  T->E->GetORect(&r);
  R=R.unite(r);
 }

// SetOutl();
}

void PicGrp::AddItem(GrpEl* T)
{
 T->Next=Data;
 Data=T;
 Ly=Ly|T->E->GetLayer();
 if (Layer->IsVis(T->E->GetLayer())){
  QRect r;
  T->E->GetORect(&r);
  R=R.unite(r);
 }
}


void PicGrp::ListItem()
{
 GrpEl* T=Data;
 while(T){
  printf(" %s Ly=%lX\n",sPic[T->E->GetIden()],T->E->GetLayer());
  T=T->Next;
 }
}



void PicGrp::AddTreeList(TreeListItem * LI)
{
 GrpEl* T=Data;
 TreeListItem * item;

 while(T){
  item = new TreeListItem(T->E,LI);
  item->setText( 0,ObjName[T->E->GetIden()]);

  if(T->E->GetIden()>=kPicGrp){
   printf(" Add to list %s\n",sPic[T->E->GetIden()]);
   ((PicGrp *)T->E)->AddTreeList(item);
  }

  T=T->Next;
 }
}



void PicGrp::DelItem(uint n)
{
  uint i=0;
  GrpEl* T=Data;
  GrpEl* T1=Data;

  if (n==0){
   T=Data;
   Data=T->Next;
   free(T);
   free(T->E);
  } else {
   while(i!=n-1 && T!=NULL){
    T=T->Next;
    i++;
   }
   if (T!=NULL && T->Next!=NULL){
    T1=T->Next;
    T->Next=T1->Next;
    free(T1->E);
    free(T1);
   }
  }
//  SetOutl();
}


void PicGrp::AddLine(QPoint l1,QPoint l2,int Wid,QRect & r,bool cln)
{
 PicLine * L=NULL;
 GrpEl* T=Data;
 QPoint a1;
 QPoint a2;
 QPoint p;
 QPoint p1;
 bool x;

 l1=l1-Ref;
 l1=CompRot(4-Rot,l1,Mir+256);
 l2=l2-Ref;
 l2=CompRot(4-Rot,l2,Mir+256);
// printf("AddLine : begin\n");
 if(cln){
  while(T){
   if(T->E->GetIden()==kPicLine && Layer->IsAct(T->E->GetLayer())){
    a1=((PicLine *)T->E)->GetBegin();
    a2=((PicLine *)T->E)->GetEnd();
    if(l1==a1 || l1==a2){
 //    printf("AddLine : Point ==\n");
     if(l1!=a1){
      p=a1;
      a1=a2;
      a2=p;
      x=true;
     }
     else x=false;
     if(l2==a2){
      T->E->GetORect(&r);
      r=CompRot(Rot,r,Mir);
      r.translate(Ref.x(),Ref.y());
      if(x){
       ((PicLine *)T->E)->End(l2);
      }
      else{
       ((PicLine *)T->E)->Begin(l2);
      }
      Clean();
 //     SetOutl();
      return;
     }
     p=l2-l1;
     p1=a2-a1;
     if(p.x()*p1.y()==p1.x()*p.y()){
 //     printf("AddLine : Angle ==\n");
      if((p.x()>=0 && p.y()>=0 && p1.x()>=0 && p1.y()>=0) ||
         (p.x()<0 && p.y()>=0 && p1.x()<0 && p1.y()>=0) ||
         (p.x()>=0 && p.y()<0 && p1.x()>=0 && p1.y()<0) ||
         (p.x()<0 && p.y()<0 && p1.x()<0 && p1.y()<0)){
       printf("AddLine : AngleX ==\n");
      }
      else{
       if(x){
	((PicLine *)T->E)->End(l2);
       }
       else{
	((PicLine *)T->E)->Begin(l2);
       }
       T->E->GetORect(&r);
       r=CompRot(Rot,r,Mir);
       r.translate(Ref.x(),Ref.y());

 //      Clean();
 //      SetOutl();
       return;
      }

      if(p.x()*p.x()+p.y()*p.y()<p1.x()*p1.x()+p1.y()*p1.y()){
 //      printf("AddLine : Len <\n");

       T->E->GetORect(&r);
       r=CompRot(Rot,r,Mir);
       r.translate(Ref.x(),Ref.y());

       if(x){
	((PicLine *)T->E)->End(l2);
       }
       else{
	((PicLine *)T->E)->Begin(l2);
       }

 //      Clean();
 //      SetOutl();
       return;
      }
      else{
 //      printf("AddLine : Len >\n");

       if(x){
	((PicLine *)T->E)->Begin(l2);
       }
       else{
	((PicLine *)T->E)->End(l2);
       }

       T->E->GetORect(&r);
       r=CompRot(Rot,r,Mir);
       r.translate(Ref.x(),Ref.y());

       if(x){
	((PicLine *)T->E)->End(a2);
       }
       else{
	((PicLine *)T->E)->Begin(a2);
       }

 //      Clean();
 //      SetOutl();
       return;
      }
     }
    }
   }
   T=T->Next;
  }
 }

 L=new PicLine(Layer);
 L->MoveTo(l1);
 L->SetWidth(Wid);
 L->Begin(l1);
 L->End(l2);

 AddItem(L);

// Clean();
// SetOutl();

 L->GetORect(&r);
 r=CompRot(Rot,r,Mir);
 r.translate(Ref.x(),Ref.y());
}


PicEl* PicGrp::GetItem(uint n)
{
  uint i=0;
  GrpEl* T=Data;

  if (n==0){
   return Data->E;
  } else {
   while(i!=n && T!=NULL){
    T=T->Next;
    i++;
   }
   if (T!=NULL)return T->E;
   else return NULL;
  }
}


void PicGrp::SetItem(uint n,PicEl* E)
{
  uint i=0;
  GrpEl* T=Data;

  while(i!=n && T!=NULL){
   T=T->Next;
   i++;
  }
  if (T!=NULL){
   free(T->E);
   T->E=E;
  }
//  SetOutl();
}


void PicGrp::Clean(int tol,unsigned long int L)
{
 GrpEl* T=Data;
 GrpEl* T1=NULL;
 GrpEl* T2=NULL;
 GrpEl* D;
 QPoint p;
 QPoint b1;
 QPoint e1;
 QPoint b2;
 QPoint e2;
 bool x;
// bool y;
 unsigned long int L1;
 while(T!=NULL){
  if (T->E->GetIden()>=kPicGrp){
    if (T->E->GetIden()==kSComp){
      if(!((SComp *)(T->E))->GetPSComp()){
	if(T==Data){
          Data=T->Next;
	  delete T->E;
	  delete T;
	  T=NULL;
	}
	else{
          T2->Next=T->Next;
	  delete T->E;
	  delete T;
	  T=T2;
	}
      }
    }
    else ((PicGrp *)(T->E))->Clean(tol,L);
  }
  else if (T->E->GetIden()==kPicLine && (T->E->GetLayer() & L)){
   b1=((PicLine *)T->E)->GetBegin();
   e1=((PicLine *)T->E)->GetEnd();
   if(b1==e1){
     if(T==Data){
       Data=T->Next;
       delete T->E;
       delete T;
       T=NULL;
     }
     else{
       T2->Next=T->Next;
       delete T->E;
       delete T;
       T=T2;
     }
   }
   else{ 
    L1=T->E->GetLayer();
    D=T->Next;
    T1=T;
    while(D){
     if (D->E->GetIden()==kPicLine && (D->E->GetLayer()==L1) &&
         D->E->GetWidth()==T->E->GetWidth()){
      x=false;
      b1=((PicLine *)T->E)->GetBegin();
      e1=((PicLine *)T->E)->GetEnd();
      b2=((PicLine *)D->E)->GetBegin();
      e2=((PicLine *)D->E)->GetEnd();
 /*     y=((b1.x()-e1.x()==0 && b2.x()-e2.x()==0) ||
         (b1.y()-e1.y()==0 && b2.y()-e2.y()==0) ||
         (b1.y()-e1.y()==b1.x()-e1.x() && b2.y()-e2.y()==b2.x()-e2.x()));
      p=((PicLine *)T->E)->GetBegin();
      if (y && ((PicLine *)D->E)->IsConnect(&p,tol)){
       ((PicLine *)T->E)->Begin(p);
       x=true;
      }
      p=((PicLine *)T->E)->GetEnd();
      if (y && !x && ((PicLine *)D->E)->IsConnect(&p,tol)){
       ((PicLine *)T->E)->End(p);
       x=true;
      }
 */
      if (b1.x()-e1.x()==0 && b2.x()-e2.x()==0 && b1.x()==b2.x()){
       if (b1.y()<e1.y()) x=(b1.y()<=b2.y() && b2.y()<=e1.y())||
                            (b1.y()<=e2.y() && e2.y()<=e1.y());
       else               x=(b1.y()>=b2.y() && b2.y()>=e1.y())||
                            (b1.y()>=e2.y() && e2.y()>=e1.y());
       if(x){
	p=b1;
	if (p.y()>e1.y()) p=e1;
	if (p.y()>b2.y()) p=b2;
	if (p.y()>e2.y()) p=e2;
	((PicLine *)T->E)->Begin(p);

	p=b1;
	if (p.y()<e1.y()) p=e1;
	if (p.y()<b2.y()) p=b2;
	if (p.y()<e2.y()) p=e2;
	((PicLine *)T->E)->End(p);
       }
      }
      else  if((b1.y()-e1.y()==0 && b2.y()-e2.y()==0 && b1.y()==b2.y())||
              (b1.y()-e1.y()==b1.x()-e1.x() &&
               b2.y()-e2.y()==b2.x()-e2.x() &&
               b1.y()-b2.y()==b1.x()-b2.x()) ||
              (b1.y()-e1.y()==e1.x()-b1.x() &&
               b2.y()-e2.y()==e2.x()-b2.x() &&
               b1.y()-b2.y()==b2.x()-b1.x())){
       if (b1.x()<e1.x()) x=(b1.x()<=b2.x() && b2.x()<=e1.x())||
                            (b1.x()<=e2.x() && e2.x()<=e1.x());
       else               x=(b1.x()>=b2.x() && b2.x()>=e1.x())||
                            (b1.x()>=e2.x() && e2.x()>=e1.x());
       if(x){
	p=b1;
	if (p.x()>e1.x()) p=e1;
	if (p.x()>b2.x()) p=b2;
	if (p.x()>e2.x()) p=e2;
	((PicLine *)T->E)->Begin(p);

	p=b1;
	if (p.x()<e1.x()) p=e1;
	if (p.x()<b2.x()) p=b2;
	if (p.x()<e2.x()) p=e2;
	((PicLine *)T->E)->End(p);
       }
      }

      if(x){
       T1->Next=D->Next;
       delete D->E;
       delete D;
       D=T1;
      }
     }
     T1=D;
     D=D->Next;
    }
   } 
  }
  else if (T->E->GetIden()==kPicPoly && (T->E->GetLayer() & L)){
    if(!((PicPoly *)(T->E))->Clean()){
      if(T==Data){
        Data=T->Next;
	delete T->E;
	delete T;
	T=NULL;
      }
      else{
        T2->Next=T->Next;
	delete T->E;
	delete T;
	T=T2;
      }
    }
  }
  T2=T;
  if(T) T=T->Next;
  else T=Data;
 }
}


void PicGrp::SetOutl()
{
 printf("PicGrp::SetOutl %s !!!!!!!!!!!\n",sPic[GetIden()]);
/* unsigned long int t;
 if(Data!=NULL){
  QRect r;
  GrpEl* T=Data;
  R.setRect(0,0,0,0);
  Ly=0;
  while(T!=NULL){
   t=T->E->GetLayer();
   Ly=Ly|t;
   if (Layer->IsVis(t)){
    T->E->GetORect(&r);
    R=R.unite(r);
   }
   T=T->Next;
  }
 }*/
}

QPoint PicGrp::GetSelPoint()
{
  printf("GetSelPoint %s\n",sPic[GetIden()]);
  GrpEl* T=Data;
  QPoint p;
  while(T!=NULL){
    if (T->E->IsSelect()){
      printf("    SelPoint %s\n",sPic[T->E->GetIden()]);
      if (!T->E->IsLock() || T->E->IsPointSel()) p=T->E->GetSelPoint();
      break;
    }
    T=T->Next;
  }
  return CompRot(Rot,p,Mir)+Ref;
}

void PicGrp::GetSelORect(QRect* r)
{
 if(Data!=NULL){
  QRect r1;
  GrpEl* T=Data;
  r->setRect(0,0,0,0);
  while(T!=NULL){
   if (T->E->IsSelect()){
    if (T->E->IsLock()) T->E->GetORect(&r1);
    else ((PicGrp *)(T->E))->GetSelORect(&r1);
    *r=r->unite(r1);
   }
   T=T->Next;
  }
 }
 *r=CompRot(Rot,*r,Mir);
 r->translate(Ref.x(),Ref.y());
}

PicEl * PicGrp::GetSel()
{
 GrpEl * T=Data;
 PicEl * T1=NULL;
 while (T!=NULL){
  if (T->E->IsSelect()){
   if (T->E->IsLock()){
    NS=T->Next;
    return T->E;
   }
   else{
    NS=T;
    T1=((PicGrp *)(T->E))->GetSel();
    if(T1) return T1;
   }
  }
  T=T->Next;
 }
 NS=NULL;
 return NULL;
}

PicEl * PicGrp::GetNextSel()
{
 GrpEl * T=NS;
 PicEl * T1=NULL;
 if(!T) return NULL;
 if(!T->E->IsLock()){
   T1=((PicGrp *)(T->E))->GetNextSel();
   if(T1) return T1;
   T=T->Next;
 }  
 while (T!=NULL){
  if (T->E->IsSelect()){
   if (T->E->IsLock()){
    NS=T->Next;
    return T->E;
   }
   else{
    NS=T;
    T1=((PicGrp *)(T->E))->GetSel();
    if(T1) return T1;
   }
  }
  T=T->Next;
 }
 NS=NULL;
 return NULL;
}

void PicGrp::RmClearPoly()
{
  GrpEl *T=Data;
  while (T){
    if ((T->E->GetIden()>=kPicGrp) && !(T->E->IsLock()))
        ((PicGrp *)(T->E))->RmClearPoly();
    else     if(T->E->GetIden()==kPicPoly)
        ((PicPoly *)(T->E))->RmClear();
    T=T->Next;
  }
}

void PicGrp::RmUnconnectPoly()
{
  GrpEl *T=Data;
  while (T){
    if ((T->E->GetIden()>=kPicGrp) && !(T->E->IsLock()))
        ((PicGrp *)(T->E))->RmUnconnectPoly();
    else     if(T->E->GetIden()==kPicPoly)
        ((PicPoly *)(T->E))->RmUnconnect();
    T=T->Next;
  }
}

void PicGrp::ClearPoly()
{
 int ID;
 QPoint P1;
 QPoint P2;
 QPointF F1;
 QPointF F2;
 int W;
 int R;
 int Lo;
 QPainterPath Po;
 QString N;
 PicEl * E;

 int i=1;
 int j;
 bool pad=false;

 unsigned long int L;

 L=Layer->GetLyLevel(1);
 while(L){
  N="";
  Lo=0;
  pad=false;
  E=GetEl(ID,P1,P2,W,R,Lo,N,Po,L,pad);
  while(E){
   if(ID==kPicPoly){
     ID=kPicLine;
     if(Po.elementCount()<10){
       for(j=0;j<Po.elementCount()-1;j++){
         F1=Po.elementAt(j);
	 F2=Po.elementAt(j+1);
	 if(Po.elementAt(j+1).isLineTo()){
	   P1=F1.toPoint();
	   P2=F2.toPoint();
	   SubtractPoly(ID,P1,P2,W,R,pad,N,L);
	 }  
       }
/*       P1=Po.point(j);
       P2=Po.point(0);
       SubtractPoly(ID,P1,P2,W,R,pad,N,L); */
     }
   }
   else SubtractPoly(ID,P1,P2,W,R,pad,N,L);
   N="";
   Lo=0;
   pad=false;
   E=GetNextEl(ID,P1,P2,W,R,Lo,N,Po,L,pad);
  }
  i++;
  L=Layer->GetLyLevel(i);
 }
 UpdORect();
 Clean();
 i=1;
 L=Layer->GetLyLevel(i);
 while(L){
  N="";
  Lo=0;
  pad=false;
  E=GetEl(ID,P1,P2,W,R,Lo,N,Po,L,pad);
  while(E){
   if(pad)AddThermal(ID,P1,P2,W,R,pad,N,L);
   N="";
   Lo=0;
   pad=false;
   E=GetNextEl(ID,P1,P2,W,R,Lo,N,Po,L,pad);
  }
  pad=false;
  AddThermal(ID,P1,P2,W,R,pad,N,L);
  i++;
  L=Layer->GetLyLevel(i);
 }
}


void PicGrp::SubtractPoly(int &iden,QPoint &p1o,QPoint &p2o,int &W,int &r,
                          bool pad,QString &N,unsigned long int Lo)
{
  QPoint p1;
  QPoint p2;
  unsigned long int L=Lo;

  GrpEl *T=Data;
  if(Mir) L=Layer->MirLy(L);
  if((Ly & L)==0) return;
  p1=p1o-Ref;
  p1=CompRot((4-Rot),p1,Mir+256);
  p2=p2o-Ref;
  p2=CompRot((4-Rot),p2,Mir+256);
//  printf("PicGrp::SubtractPoly %s\n",sPic[GetIden()]);
  while (T){
    if ((T->E->GetIden()>=kPicGrp) && !(T->E->IsLock()))
        ((PicGrp *)(T->E))->SubtractPoly(iden,p1,p2,W,r,pad,N,L);
    else if(T->E->GetIden()==kPicPoly)
        ((PicPoly *)(T->E))->Subtract(iden,p1,p2,W,r,pad,N,L);
    T=T->Next;
  }
}

void PicGrp::AddThermal(int &iden,QPoint &p1o,QPoint &p2o,int &W,int &r,
                          bool pad,QString &N,unsigned long int Lo)
{
  QPoint p1;
  QPoint p2;
  unsigned long int L=Lo;

  GrpEl *T=Data;
  if(Mir) L=Layer->MirLy(L);
  if((Ly & L)==0) return;
  p1=p1o-Ref;
  p1=CompRot((4-Rot),p1,Mir+256);
  p2=p2o-Ref;
  p2=CompRot((4-Rot),p2,Mir+256);
  while (T){
    if ((T->E->GetIden()>=kPicGrp) && !(T->E->IsLock()))
        ((PicGrp *)(T->E))->AddThermal(iden,p1,p2,W,r,pad,N,L);
    else if(T->E->GetIden()==kPicPoly)
        ((PicPoly *)(T->E))->AddThermal(iden,p1,p2,W,r,pad,N,L);
    T=T->Next;
  }
}

void PicGrp::UpdORect(int mir)
{
 GrpEl *T=Data;
 QRect r;
 unsigned long int t;

// if(Lock!=1){
  while (T){
   if (T->E->GetIden()>=kPicGrp) ((PicGrp *)(T->E))->UpdORect((mir+Mir) & 1);
   else T->E->SetORect();
   T=T->Next;
  }
// }

 if(Data!=NULL){
  T=Data;
  R.setRect(0,0,0,0);
  Ly=0;
  while(T!=NULL){
   t=T->E->GetLayer();
   Ly=Ly|t;
   if ((mir+Mir) &1) t=Layer->MirLy(t);
   if (Layer->IsVis(t)){
     T->E->GetORect(&r);
     R=R.unite(r);
   }
   T=T->Next;
  }
 }
}

void PicGrp::UpdSelORect(int mir)
{
 UpdORect(mir);
}


bool PicGrp::IsLock(int l)
{
 if (l==0) return Lock;
 else return (l==Lock);
}

void PicGrp::SetLock(int L)
{
 Lock=L;
}

PicGrp::GrpEl * PicGrp::GetData()
{
 return Data;
}

void PicGrp::SetData(GrpEl * D)
{
 if (Data==NULL) Data=D;
}

void PicGrp::SetDate(QString * Date,QString * FName,QString * Ver)
{
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kPicText && T->E->GetSubIden()==kSIDDate){
   ((PicText *)(T->E))->SetText(Date);
   printf("SetDate :: Date %s\n",Date->toLatin1().data());
  }
  if(T->E->GetIden()==kPicText && T->E->GetSubIden()==kSIDFName){
   ((PicText *)(T->E))->SetText(FName);
   printf("SetDate :: FName %s\n",FName->toLatin1().data());
  }
  if(T->E->GetIden()==kPicText && T->E->GetSubIden()==kSIDVer){
   ((PicText *)(T->E))->SetText(Ver);
   printf("SetDate :: Ver %s\n",Ver->toLatin1().data());
  }
  T=T->Next;
 }
// SetOutl();
}


PicEl * PicGrp::GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                      int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad)
{
 PicEl * E;
 unsigned long L1;
 if(Mir) L1=Layer->MirLy(L);
 else L1=L;
 if((Ly & L1)==0) return NULL;
 AEl=Data;
 if(!AEl) return NULL;
 E=AEl->E->GetEl(iden,p1,p2,W,r,Lo,N,Po,L1,pad);
 if(E){
  if(Lock) Lo=1;
  p1=CompRot(Rot,p1,Mir);
  p1=p1+Ref;
  p2=CompRot(Rot,p2,Mir);
  p2=p2+Ref;
  TransPoly(Po,0);
//  if(iden==kPicPoly) printf("GetEl:: Polygon\n");
  return E;
 }
 return PicGrp::GetNextEl(iden,p1,p2,W,r,Lo,N,Po,L,pad);
}

PicEl * PicGrp::GetNextEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                           int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad)
{
 PicEl * E;
 if(Mir) L=Layer->MirLy(L);
 if((Ly & L)==0) return NULL;
 if(!AEl) return NULL;
 E=AEl->E->GetNextEl(iden,p1,p2,W,r,Lo,N,Po,L,pad);
 if(E){
  if(Lock) Lo=1;
  p1=CompRot(Rot,p1,Mir);
  p1=p1+Ref;
  p2=CompRot(Rot,p2,Mir);
  p2=p2+Ref;
  TransPoly(Po,0);
//  if(iden==kPicPoly) printf("GetEl:: Polygon\n");
  return E;
 }
 AEl=AEl->Next;
 while(AEl){
  E=AEl->E->GetEl(iden,p1,p2,W,r,Lo,N,Po,L,pad);
  if(E){
   if(Lock) Lo=1;
   p1=CompRot(Rot,p1,Mir);
   p1=p1+Ref;
   p2=CompRot(Rot,p2,Mir);
   p2=p2+Ref;
   TransPoly(Po,0);
//   if(iden==kPicPoly) printf("GetEl:: Polygon\n");
   return E;
  }
  AEl=AEl->Next;
 }
 return NULL;
}



void PicGrp::Paint(QPainter* P,QRect* Rec,int flag,QColor* /*col*/,
                   int x,int y,int rot,int mir,bool HL)
{
  GrpEl* T=Data;
  if ((flag & kDrawSel) && Sel==1) flag|=kDrawAll;

  while(T!=NULL){
   T->E->ReDraw(P,Rec,flag,x,y,rot,mir,HL);
   T=T->Next;
  }
#ifdef ORectDEBUG
// if(GetIden()==kPicPNet){
   QRect r=R;
   r=CompRot(rot,r,mir);
   r.translate(x,y);
   P->setPen(Qt::black);
   P->setBrush(Qt::NoBrush);
   P->drawRect(r);
// }
#endif
}

void PicGrp::TextSave(QTextStream * S, bool sel)
{
  PicEl::TextSave(S,sel);
  TextSaveNext(S,sel);
}

void PicGrp::Sort()
{
  int ch=1;
  GrpEl* T=NULL;
  GrpEl* T1=NULL;
  GrpEl* T2=NULL;
  while(ch){
   ch=0;
   T=Data;
   T1=NULL;
   T2=NULL;
   while(T!=NULL){
    if(T1!=NULL){
     if(T->E->ID < T1->E->ID){
      if(T2!=NULL) T2->Next=T;
      else Data=T;
      T1->Next=T->Next;
      T->Next=T1;
      T2=T;
      T=T1;
      T1=T2;
      ch=1;
     }
    }
    T2=T1;
    T1=T;
    T=T->Next;
   }
  }
}

void PicGrp::TextSaveNext(QTextStream * S, bool sel)
{
  GrpEl* T=Data;

  *S << "    {Lock " << Lock << " }\n";

  Sort();

  T=Data;
  while(T!=NULL){
    if (!sel || (T->E->IsSelect() && !T->E->IsPointSel()) || (Sel==1)){

      int k=T->E->GetIden();

      *S << "   {" << sPic[k];

      T->E->TextSave(S,sel);
    }
   T=T->Next;
  }

  *S << "  }\n";
}

bool  PicGrp::TLoadNext(QTextStream * S,QString* s)
{
 Sel=2;
 if (s->contains("Lock")){
  *S >> Lock;
  TextLoadSkip(S);
 }
 else if (s->contains(sPic[kPicLine])){
  PicLine* E=new PicLine(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kPicRect])){
  PicRect* E=new PicRect(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kPicGrp])){
  PicGrp* E=new PicGrp(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kPicCir])){
  PicCir* E=new PicCir(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kPicPower])){
  PicPower* E=new PicPower(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kPicPoly])){
  PicPoly* E=new PicPoly(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kPicText])){
  PicText* E=new PicText(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kPicPComp])){
  PicPComp* E=new PicPComp(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kPicSComp])){
  PicSComp* E=new PicSComp(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kSComp])){
  SComp* E=new SComp(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kPComp])){
  PComp* E=new PComp(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kPicPadS])){
  PicPadS* E=new PicPadS(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kPicPin])){
  PicPin * E=new PicPin(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kPicNet])){
  PicNet * E=new PicNet(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kPicPNet])){
  PicPNet * E=new PicPNet(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else if (s->contains(sPic[kDbPcb])){
  DbPcb * E=new DbPcb(Layer);
  E->TextLoad(S);
  AddItem(E);
 }
 else  return false;
 if(Lock) Sel=1;
 return true;
}
