/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "PicEl.h"
#include "PicPadS.h"
#include "Layers.h"
#include "PicGrp.h"
#include "Library.h"
#include "ObjEdit.h"

#include <QPainter>
#include <QPen>
#include <QColor>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

extern Library gLib;


PicPadS::PicPadS(Layers *L)
 :PicGrp(L)
{
 PinNum=0;
}

PicPadS::~PicPadS()
{
}

int PicPadS::GetIden()
{
 return kPicPadS;
}

void PicPadS::AddTreeList(TreeListItem * LI)
{
 QString s;
 s.setNum(PinNum);
 s=s+" - "+Name;
 LI->setText( 1,s);
 PicGrp::AddTreeList(LI);
}


void PicPadS::SetName(QString n)
{
 Name=n;
}
QString PicPadS::GetName()
{
 return Name;
}

int PicPadS::GetPinNum()
{
 return PinNum;
}

void PicPadS::SetPinNum(int n)
{
 PinNum=n;
}

int PicPadS::SelPoint(QPoint p,int tol,int mode,int mir)
{
 if(!Lock) return PicGrp::SelPoint(p,tol,mode,mir);
 if(Layer->IsVis(GetLayer(mir)) && (mode!=kSelActOnly 
    || Layer->IsAct(GetLayer(mir)))){
  long long x;
  p=p-Ref;
  x=(long long)p.x()*p.x()+(long long)p.y()*p.y();
  if(x<tol){
   Sel=1;
   return x;
  }
 }
 return -1;
}



bool PicPadS::LibPart(QString name)
{
 Name=name;
 PicPadS * E=(PicPadS *)gLib.GetComp(name,Layer,kPicPadS,1);
 if (E){
  Data=E->GetData();
  Lock=true;
//  SetOutl();
  return true;
 }
 return false;
}

bool PicPadS::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  if(PicEl::GetInfo(i,p,mode,mir)){
    i="Pad:";
    i+=Name;
    return true;
  }
  return false;
}

PicEl * PicPadS::GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                      int &Lo,QString &N,QPainterPath & Po,unsigned long int L,bool & pad)
{
 PicEl * E;
 E=PicGrp::GetEl(iden,p1,p2,W,r,Lo,N,Po,L,pad);
// if(N=="*PComp*") printf("Pads not in comp %s\n",Name.ascii());
// if(E && N=="*PComp*"){
 if(E && (PinNum>0)){
  N.setNum(PinNum);
  pad=true;
 }
 return E;
}

PicEl * PicPadS::GetNextEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                          int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad)
{
 PicEl * E;
 E=PicGrp::GetNextEl(iden,p1,p2,W,r,Lo,N,Po,L,pad);
// if(N=="*PComp*") printf("Pads not in comp %s\n",Name.ascii());
// if(E && N=="*PComp*"){
 if(E && (PinNum>0)){
  N.setNum(PinNum);
  pad=true;
 }
 return E;
}



void PicPadS::TextSave(QTextStream * S, bool sel)
{
 if (Lock){
  PicEl::TextSave(S,sel);
  *S << "    {Lock " << Lock << " }\n";
  *S << "    {PinNum " << PinNum << " }\n";
  *S << "    {Name " << Name << " }\n";
  *S << "   }\n";
 }
 else{
//  *S << " " << Name << " ";
  PicGrp::TextSave(S,sel);
 }
}

bool  PicPadS::TLoadNext(QTextStream * S,QString* s)
{
 if (s->contains("Name")){
  QString s1;
  *S >> s1;
  TextLoadSkip(S);
  Name=s1;
  PicGrp * E=gLib.GetComp(s1,Layer,kPicPadS);
  if (E) Data=E->GetData();
 }
 else if (s->contains("PinNum")){
  *S >> PinNum;
  TextLoadSkip(S);
 }
 else  return PicGrp::TLoadNext(S,s);
 return true;
}

