/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PicPadS_included
#define PicPadS_included

#include "PicGrp.h"
#include <QWidget>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

#include <QPainter>
#include <QColor>

class PicPadS : public PicGrp
{

public:

  PicPadS(Layers *L);
  virtual ~PicPadS();

  virtual int GetIden();

  virtual void AddTreeList(TreeListItem * LI);

  void SetName(QString n);
  QString GetName();

  int GetPinNum();
  void SetPinNum(int n);

  virtual int SelPoint(QPoint p,int tol=0,int mode=0,int mir=0);

  bool LibPart(QString name);

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);

  virtual PicEl * GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                        int &Lo,QString &N,QPainterPath & Po,unsigned long int L,bool &pad);
  virtual PicEl * GetNextEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                            int &Lo,QString &N,QPainterPath & Po,unsigned long int L,bool &pad);

  virtual void TextSave(QTextStream * S, bool sel=false);

protected:

  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:

  int PinNum;
  QString Name;

};

#endif
