/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PicPin_included
#define PicPin_included

#include "PicGrp.h"
#include <QWidget>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

class QPainter;
class QColor;

class PicPin : public PicGrp
{

public:

  PicPin(Layers *L);
  virtual ~PicPin();

  virtual int GetIden();

  virtual void AddTreeList(TreeListItem * LI);

  void SetName(QString n);
  QString GetName();

  void SetNum(int n);
  int GetNum();

  void SetPinStr(QString * S);

  bool LibPart(QString name);


  virtual void TextSave(QTextStream * S, bool sel=false);

protected:

//  virtual void SetOutl();
  virtual bool  TLoadNext(QTextStream * S,QString* s);
  virtual void Paint(QPainter* P,QRect* Rec,int flag,QColor* col,
                     int x,int y,int rot,int mir,bool HL);

private:

  int PinNum;
  QString Name;
  QString * PinS;

};

#endif
