/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "PicSComp.h"
#include "PicPin.h"
#include "Layers.h"
#include "Library.h"
#include "ObjEdit.h"

#include <QPainter>
#include <QPen>
#include <QColor>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

extern Library gLib;

PicSComp::PicSComp(Layers *L)
 :PicGrp(L)
{
 PPP=1;
 PiP=0;
 PPV=0;
 PkgL=NULL;
 CommL=NULL;
 PL=NULL;
}


PicSComp::~PicSComp()
{
 if (!Lock){
  PinLst* T;
  T=PL;
  while (T!=NULL){
   PL=T->Next;
   delete[] T->Nums;
   delete T;
   T=PL;
  }
  PkgLst* T1;
  T1=PkgL;
  while (T1!=NULL){
   PkgL=T1->Next;
   delete T1;
   T1=PkgL;
  }
  CommLst* T2;
  T2=CommL;
  while (T2!=NULL){
   CommL=T2->Next;
   delete T2;
   T2=CommL;
  }
 }
}


int PicSComp::GetIden()
{
 return kPicSComp;
}

void PicSComp::AddTreeList(TreeListItem * LI)
{
 LI->setText( 1,Name);
 PicGrp::AddTreeList(LI);
}


void PicSComp::SetName(QString n)
{
 Name=n;
}

QString PicSComp::GetName()
{
 return Name;
}

PicSComp::PinLst * PicSComp::GetPinLst()
{
 return PL;
}
void PicSComp::SetPinLst(PinLst * T)
{
 PL=T;
}

void PicSComp::UpdatePinLst()
{
 GrpEl * T=Data;
 PinLst * T1;
 PinLst * T2;
 int n;
 int i;

 T1=PL;
 while(T1){
  T1->flag=true;
  T1=T1->Next;
 }

 while (T){
  if (T->E->GetIden()==kPicPin){
   n=((PicPin *)T->E)->GetNum();
   T1=PL;
   while(T1){
    if(n==(T1->Nums)[0]){
     n=-1;
     T1->flag=false;
    }
    T1=T1->Next;
   }
   if (n!=-1){
    T1=new PinLst;
    T1->Nums=new int[PPP];
    T1->flag=false;
    for (i=0;i<PPP;i++) T1->Nums[i]=n;
    T1->Next=PL;
    PL=T1;
   }
  }
  T=T->Next;
 }

 T1=PL;
 T2=NULL;
 while(T1){
  if (T1->flag){
   if(T1!=PL){
    T2->Next=T1->Next;
    delete T1->Nums;
    delete T1;
    T1=T2;
   }
   else{
    PL=T1->Next;
    delete T1->Nums;
    delete T1;
    T1=PL;
   }
  }
  T2=T1;
  T1=T1->Next;
 }

}

int  PicSComp::GetPinNum()
{
 return GetNPin();
}

int  PicSComp::GetPinNum(int pip,int n)
{
 PinLst * T1;

 T1=PL;
 while(T1){
  if ((T1->Nums)[0]==n) return (T1->Nums)[pip];
  T1=T1->Next;
 }
 return -1;
}

bool  PicSComp::GetPinPos(QPoint * p,int n)
{
 return GetPinPos(p,PiP,n);
}


bool  PicSComp::GetPinPos(QPoint * p,int pip,int n)
{
 int nu=-1;
 PinLst * T1;
 T1=PL;
 while(T1){
  if ((T1->Nums)[pip]==n) nu=(T1->Nums)[0];
  T1=T1->Next;
 }
 if(nu==-1) return false;
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kPicPin){
   if(((PicPin *)T->E)->GetNum()==nu){
    *p=T->E->Pos();
    *p=CompRot(Rot,*p,Mir);
    *p=*p+Ref;
    return true;
   }
  }
  T=T->Next;
 }
 return false;
}

QString PicSComp::GetPinName(int n)
{
 return GetPinName(PiP,n);
}

QString PicSComp::GetPinName(int pip,int n)
{
 PinLst * T1;
 T1=PL;
 while(T1){
  if ((T1->Nums)[pip]==n) return T1->Name;
  T1=T1->Next;
 }
 QString s;
 return s;
}

int PicSComp::GetPin(QString * Net)
{
 ActP=PL;
 if (ActP){
  *Net=ActP->Name;
  return (ActP->Nums)[PiP];
 }
 return -1;
}
int PicSComp::GetNextPin(QString * Net)
{
 if (ActP) ActP=ActP->Next;
 if (ActP){
  *Net=ActP->Name;
  return (ActP->Nums)[PiP];
 }
 return -1;
}


void  PicSComp::SetPinNum(int pip,int n0,int n)
{
 PinLst * T1;

 T1=PL;
 while(T1){
  if ((T1->Nums)[0]==n0){
   (T1->Nums)[pip]=n;
   return;
  }
  T1=T1->Next;
 }
 T1=new PinLst;
 T1->Nums=new int[PPP];
 (T1->Nums)[pip]=n;
 (T1->Nums)[0]=n0;
 T1->Name="?";
 T1->Next=PL;
 PL=T1;
}

void  PicSComp::SetPinName(int n,QString s)
{
 PinLst * T1;
 if(!s.isEmpty()){
  T1=PL;
  while(T1){
//   printf("%d",(T1->Nums)[0]);
   if ((T1->Nums)[0]==n){
    T1->Name=s;
    return;
   }
   T1=T1->Next;
  }
 }
}



PicSComp::PkgLst * PicSComp::GetPkgLst()
{
 return PkgL;
}
void PicSComp::SetPkgLst(PkgLst * T)
{
 PkgL=T;
}

PicSComp::CommLst * PicSComp::GetCommLst()
{
 return CommL;
}
void PicSComp::SetCommLst(CommLst * T)
{
 CommL=T;
}

int  PicSComp::GetPPP()
{
 return PPP;
}

QString *  PicSComp::GetVal()
{
 return &Val;
}
QString *  PicSComp::GetRef()
{
 return &Reff;
}

void PicSComp::SetPPP(int n)
{
 if(!Lock){
   PinLst* T;
  T=PL;
  while (T!=NULL){
   PL=T->Next;
   delete T->Nums;
   delete T;
   T=PL;
  }
  PPP=n;
 }
}
void PicSComp::SetVal(QString * s)
{
 Val=*s;
}
void PicSComp::SetRef(QString * s)
{
 Reff=*s;
}



int PicSComp::GetNPin()
{
 PinLst * L=PL;
 int i=0;
 while(L){
  i++;
  L=L->Next;
 }
 return i;
}

QString PicSComp::GetPkg(QString type)
{
 PkgLst * L=PkgL;
// int i=0;
 while(L){
  if (L->Type==type) return L->Pkg;
  L=L->Next;
 }
 QString s;
 return s;
}

QString PicSComp::GetComm(QString type)
{
 CommLst * L=CommL;
// int i=0;
 while(L){
  if (L->Type==type) return L->Comm;
  L=L->Next;
 }
 QString s;
 return s;
}

void PicSComp::SetPkg(QString type,const char * n)
{
 PkgLst * L=PkgL;
// int i=0;
 while(L){
  if (L->Type==type){
   L->Pkg=n;
   return;
  }
  L=L->Next;
 }
 L=new PkgLst;
 L->Type=type;
 L->Pkg=n;
 L->Next=PkgL;
 PkgL=L;
}
void PicSComp::SetComm(QString type,const char * n)
{
 CommLst * L=CommL;
// int i=0;
 while(L){
  if (L->Type==type){
   L->Comm=n;
   return;
  }
  L=L->Next;
 }
 L=new CommLst;
 L->Type=type;
 L->Comm=n;
 L->Next=CommL;
 CommL=L;
}
QString PicSComp::GetTName(int i)
{
 PkgLst * L=PkgL;
 int j=0;
 while(L){
  if (i==j) return L->Type;
  L=L->Next;
  j++;
 }
 QString s;
 return s;
}

int PicSComp::GetTNum()
{
 PkgLst * L=PkgL;
 int j=0;
 while(L){
  L=L->Next;
  j++;
 }
 return j;
}


void PicSComp::SetPiP(int n)
{
 if(n<PPP) PiP=n;
 else PiP=PPP-1;
}

int PicSComp::GetPiP()
{
 return PiP;
}


void PicSComp::SetPPV(int n)
{
 PPV=n;
}

int PicSComp::GetPPV()
{
 return PPV;
}

bool PicSComp::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  if(PicEl::GetInfo(i,p,mode,mir)){
    i="Comp:";
    i+=Name;
    return true;
  }
  return false;
}

bool PicSComp::LibPart(QString name)
{
 Name=name;
 PicSComp * E=(PicSComp *)gLib.GetComp(name,Layer,kPicSComp);
 if (E){
  Data=E->GetData();
  PL=E->GetPinLst();
  PkgL=E->GetPkgLst();
  CommL=E->GetCommLst();
  PPP=E->GetPPP();
  Val=*(E->GetVal());
  Reff=*(E->GetRef());
  Lock=true;
//  SetOutl();
  return true;
 }
 return false;
}

void PicSComp::Paint(QPainter* P,QRect* Rec,int flag,QColor* /*col*/,
                     int x,int y,int rot,int mir,bool HL)
{
  GrpEl* T=Data;
  QString Str="XX";
  int i=0;
  if (flag==kDrawSel && Lock) flag=kDrawAll;

  while(T!=NULL){
   if(T->E->GetIden()==kPicPin){
    if(T->E->GetSubIden()!=kSIDPower || !Lock || PPV){
     PinLst * L=PL;
     Str.setNum(((PicPin*)T->E)->GetNum());
     while(L){
      if (L->Nums[0]==((PicPin*)T->E)->GetNum()){
       Str.setNum((L->Nums[PiP])& 0xFFFF);
       if(L->Nums[PiP]>0xFFFF) Str=(char)(((L->Nums[PiP])>>16)+'A'-1)+Str;
       break;
      }
      L=L->Next;
     }
 //    Str.setNum(i);
     i++;
     ((PicPin*)T->E)->SetPinStr(&Str);
     T->E->ReDraw(P,Rec,flag,x,y,rot,mir,HL);
     ((PicPin*)T->E)->SetPinStr(NULL);
    }
   }
   else T->E->ReDraw(P,Rec,flag,x,y,rot,mir,HL);
   T=T->Next;
  }
#ifdef ORectDEBUG
 QRect r=R;
 r=CompRot(rot,r,mir);
 r.moveBy(x,y);
 P->setPen(Qt::black);
 P->drawRect(r);
#endif
}

void PicSComp::UpdORect(int mir)
{
 GrpEl *T=Data;
 QRect r;
 unsigned long int t;

 if(!Lock){
  while (T){
   if (T->E->GetIden()>=kPicGrp) ((PicGrp *)(T->E))->UpdORect((mir+Mir) & 1);
   else T->E->SetORect();
   T=T->Next;
  }
 }

 if(Data!=NULL){
  T=Data;
  R.setRect(0,0,0,0);
  Ly=0;
  while(T!=NULL){
   if(T->E->GetIden()!=kPicPin || T->E->GetSubIden()!=kSIDPower || PPV){
    t=T->E->GetLayer();
    Ly=Ly|t;
    if((mir+Mir) &1) t=Layer->MirLy(t);
    if (Layer->IsVis(t)){
     T->E->GetORect(&r);
     R=R.unite(r);
    }
   }
   T=T->Next;
  }
 }
}


void PicSComp::TextSave(QTextStream * S, bool sel)
{
 int i;
 PicEl::TextSave(S,sel);
 if (Lock){
  *S << "    {Name " << Name << " }\n";
  *S << "    {PiP " << PiP << " }\n";
  *S << "    {PPV " << PPV << " }\n";
  *S << "    {Lock " << Lock << " }\n";
  *S << "   }\n";
 }
 else{
 //  *S << " " << Name << " ";
  *S << "    {Val " << Val << " }\n";
  *S << "    {Ref " << Reff << " }\n";
  *S << "    {PPP " << PPP << " }\n";
  *S << "    {PinL\n";
  PinLst* T=PL;
  while (T!=NULL){
   *S << "      " << T->Name;
   for (i=0;i<PPP;i++) *S << " " << T->Nums[i];
   *S << "\n";
    T=T->Next;
  }
  *S << "    }\n";
  *S << "    {Pkgs\n";
  PkgLst* T1=PkgL;
  while (T1!=NULL){
   *S << "      " << T1->Type;
   *S << " " << T1->Pkg << "\n";
    T1=T1->Next;
  }
  *S << "    }\n";

  CommLst* T2=CommL;
  while (T2!=NULL){
   *S << "    {Comm ";
   *S << T2->Type;
   *S << " " << T2->Comm << " }\n";
    T2=T2->Next;
  }

  PicGrp::TextSaveNext(S,sel);
 }
}

bool  PicSComp::TLoadNext(QTextStream * S,QString* s)
{
 if (s->contains("Val")){
  Val=TextLoadStr(S);
 }
 else if (s->contains("Ref")){
  Reff=TextLoadStr(S);
 }
 else if (s->contains("PPP")){
  *S >> PPP;
  TextLoadSkip(S);
 }
 else if (s->contains("PiP")){
  *S >> PiP;
  TextLoadSkip(S);
 }
 else if (s->contains("PPV")){
  *S >> PPV;
  TextLoadSkip(S);
 }
 else if (s->contains("PinL")){
  QString s1;
  *S >> s1;
  PinLst * T;
  while (!s1.contains("}")){
   int i;
   T=new PinLst;
   T->Next=PL;
   PL=T;
   T->Name=s1;
   T->Nums=new int[PPP];
   for (i=0;i<PPP;i++) *S >> T->Nums[i];
   *S >> s1;
  }
 }
 else if (s->contains("Pkgs")){
  QString s1;
  *S >> s1;
  PkgLst * T;
  while (!s1.contains("}")){
   T=new PkgLst;
   T->Next=PkgL;
   PkgL=T;
   T->Type=s1;
   *S >> T->Pkg;
   *S >> s1;
  }
 }
 else if (s->contains("Comm")){
  CommLst * T;
  T=new CommLst;
  T->Next=CommL;
  CommL=T;
  *S >> T->Type;
  T->Comm=TextLoadStr(S);
 }
 else if (s->contains("Name")){
  QString s1;
  *S >> s1;
  TextLoadSkip(S);
  LibPart(s1);
 }
 else  return PicGrp::TLoadNext(S,s);
 return true;
}

