/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PicSComp_included
#define PicSComp_included

#include "PicEl.h"
#include "PicGrp.h"

#include <QWidget>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

class QPainter;
class QColor;

class PicSComp : public PicGrp
{

struct PkgLst{
 QString Pkg;
 QString Type;
 PkgLst * Next;
};

struct CommLst{
 QString Comm;
 QString Type;
 CommLst * Next;
};

struct PinLst{
  int * Nums;
  bool flag;
  QString Name;
  PinLst * Next;
};


public:

  PicSComp(Layers *L);
  virtual ~PicSComp();

  virtual int GetIden();

  virtual void AddTreeList(TreeListItem * LI);

  void SetName(QString n);
  QString GetName();


  PinLst * GetPinLst();
  void SetPinLst(PinLst * T);

  void UpdatePinLst();
  int  GetPinNum(int pip,int n);
  void SetPinNum(int pip,int n0,int n);
  int  GetPinNum();
  QString GetPinName(int n);
  QString GetPinName(int pip,int n);
  void SetPinName(int n,QString s);
  bool  GetPinPos(QPoint * p,int pip,int n);
  bool  GetPinPos(QPoint * p,int n);

  int GetPin(QString * Net);
  int GetNextPin(QString * Net);

  PkgLst * GetPkgLst();
  void SetPkgLst(PkgLst * T);

  CommLst * GetCommLst();
  void SetCommLst(CommLst * T);

  int  GetPPP();
  QString *  GetVal();
  QString *  GetRef();
  void SetPPP(int n);

  void SetVal(QString * s);
  void SetRef(QString * s);

  int GetNPin();

  QString GetPkg(QString type);
  QString GetComm(QString type);
  void SetPkg(QString type,const char * n);
  void SetComm(QString type,const char * n);
  QString GetTName(int i);
  int GetTNum();

  void SetPiP(int n);
  int GetPiP();

  void SetPPV(int n);
  int GetPPV();

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);

  bool LibPart(QString name);

  virtual void TextSave(QTextStream * S, bool sel=false);

  virtual void UpdORect(int mir=0);

protected:

  virtual bool  TLoadNext(QTextStream * S,QString* s);
  virtual void Paint(QPainter* P,QRect* Rec,int flag,QColor* col,
                     int x,int y,int rot,int mir,bool HL);

private:
  QString Name;

  QString Val;
  QString Reff;
  PkgLst * PkgL;
  CommLst * CommL;
  int     PPP;
  int     PiP;
  int     PPV;
  PinLst * PL;
  PinLst * ActP;



};

#endif
