/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SComp_included
#define SComp_included

#include "PicEl.h"
#include "PicGrp.h"
#include "PicObj.h"
#include "PicSComp.h"
#include "Atr.h"
#include "CnvAtr.h"
#include "PinLst.h"

#include <QWidget>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

class QPainter;
class QColor;
class PComp;

class SComp : public PicGrp
{

/*struct PinLst {
  int Num;
  QString Net;
  SComp * C;
  PinLst * Next;
};*/


public:

  SComp(Layers *L);
  virtual ~SComp();

  virtual int GetIden();

  virtual void AddTreeList(TreeListItem * LI);

  virtual bool Select(QPoint p,int mode=0,int mir=0);
  virtual bool Select(QRect r,int mode=0,int mir=0);
  virtual bool Select(PicEl * E);
  virtual void DeSelect();

  void SetType(QString Typ,CnvAtr * CA);

  void SetVer(int Ver);

  PicText * AddAtr(int A);
  void UpdateAtr();

  QString GetAtr(int n);
  void SetAtr(int n, const char * s);
  const char * GetAtrNam(int n);

  Atrib & GetAtr();
  void SetAtr(Atrib & A);
  void SetInGrp(bool x);
  bool IsInGrp();

  PinList & GetPL();
  void SetPL(PinList & P);


  void UpdatePins();
  int GetPin(QString *net,QPoint * p,int * n);
  int GetNextPin(QString *net,QPoint * p,int * n);
//  bool GetActPin(QString *net,QPoint * p,int * n);
  void SetActPinNet(QString net);
  void GetActPinNet(QString &net);
  bool GetPinPos(QPoint * p,int n);

  PicSComp * GetPSComp();

  bool LibPart(QString name);

  bool ToPcb(PComp * C);
//  void DelPC();

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);

  virtual void TextSave(QTextStream * S, bool sel=false);

protected:

  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:
  QString Name;

  Atrib Atr;
  PinList PL;

//  PinLst * PL;
//  PinLst * ActP;

  PComp * PC;

  bool InGrp;

};
//---------------------------------------------------------------------------

/*

class SCGrp : public PicGrp
{

public:

  SCGrp(Layers *L);
  virtual ~SCGrp();

  virtual int GetIden();

  void SetType(QString Typ);

  const char * GetAtr(int n);
  void UpdateAtr();

  void UpdatePins();
  bool GetPin(QString *net,QPoint * p,int * n);
  bool GetNextPin(QString *net,QPoint * p,int * n);
  bool GetSPin(QString *net,QPoint * p,int * n);
  bool GetNextSPin(QString *net,QPoint * p,int * n);
  bool GetActPin(QString *net,QPoint * p,int * n);
  void SetActPinNet(QString net);

  bool ToPcb(PComp * C);
  void DelPC();


private:

  Atr Atr;
  SComp::PinLst * PL;
  SComp::PinLst * ActP;

  PComp * PC;
};
*/

#endif
