/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "Settings.h"
#include "Library.h"
#include "Error.h"
#include "PicPComp.h"
#include "PicSComp.h"

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QTextStream>
#include <QTextStream>
#include <QFile>
#include <QTabWidget>

extern Library gLib;
extern Errors  gErr;

Settings::Settings(QWidget *parent )
 :QWidget(parent)
{
  QLabel* Lb;

  QVBoxLayout * Layout;
  Layout = new QVBoxLayout(this);
  Layout->setSpacing(2);
  Layout->setMargin(1);

  Lb=new QLabel("Library directory:");
  Layout->addWidget( Lb );

  QHBoxLayout * BLayout;
  BLayout = new QHBoxLayout();
  BLayout->setSpacing(2);
  BLayout->setMargin(2);

  LibsCB=new QCheckBox();
  BLayout->addWidget(LibsCB);
  connect( LibsCB, SIGNAL(stateChanged(int)),SLOT (LibsCBCh(int)) );

  Libs=new QTextEdit();
  BLayout->addWidget(Libs);

  Layout->addLayout(BLayout);


  BLayout = new QHBoxLayout();
  BLayout->setSpacing(2);
  BLayout->setMargin(2);

  MWheelCB=new QCheckBox();
  BLayout->addWidget(MWheelCB);
  connect( MWheelCB, SIGNAL(stateChanged(int)),SLOT (MWheelCBCh(int)) );

  Lb=new QLabel("Mouse wheel:");
  BLayout->addWidget( Lb );

  MWheel=new QComboBox(this);
  BLayout->addWidget( MWheel );
  MWheel->addItem("center zoom + 8 way move");
  MWheel->addItem("only zoom");
  MWheel->addItem("3 way move + Zoom with CTRL");
  MWheel->addItem("Horizontal move with SHIFT + Zoom with CTRL");

  QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding,  QSizePolicy::Minimum );
  BLayout->addItem( spacer );

  Layout->addLayout(BLayout);

  BLayout = new QHBoxLayout();
  BLayout->setSpacing(2);
  BLayout->setMargin(2);

  ThPatCB=new QCheckBox();
  BLayout->addWidget(ThPatCB);
  connect( ThPatCB, SIGNAL(stateChanged(int)),SLOT (ThPatCBCh(int)) );

  Lb=new QLabel("Use thermal pattern in filled poly:");
  BLayout->addWidget( Lb );

  ThPat=new QCheckBox();
  BLayout->addWidget( ThPat );

  spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding,  QSizePolicy::Minimum );
  BLayout->addItem( spacer );

  Layout->addLayout(BLayout);

  BLayout = new QHBoxLayout();
  BLayout->setSpacing(2);
  BLayout->setMargin(2);

  EmbedLibCB=new QCheckBox();
  BLayout->addWidget(EmbedLibCB);
  connect( EmbedLibCB, SIGNAL(stateChanged(int)),SLOT (EmbedLibCBCh(int)) );

  Lb=new QLabel("Embeded library in .tdb file:");
  BLayout->addWidget( Lb );

  EmbedLib=new QCheckBox();
  BLayout->addWidget( EmbedLib );

  spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding,  QSizePolicy::Minimum );
  BLayout->addItem( spacer );

  Layout->addLayout(BLayout);

  spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Expanding );
  Layout->addItem( spacer );

  setMinimumSize( QSize( 600, 400 ) );

}

Settings::~Settings()
{

}

void Settings::SetType(int t)
{
  Type=t;
  Revert();
}

void Settings::LibsCBCh(int /*s*/)
{
  if(LibsCB->isChecked()){
    Libs->setReadOnly(false);
    Libs->setEnabled(true);
  }
  else{
    QString s;
    int t=Type;

    while(s.isEmpty()) s=gLib.GetDirs(t--);

    Libs->setPlainText(s);
    Libs->setReadOnly(true);
    Libs->setEnabled(false);
  }
}

void Settings::MWheelCBCh(int /*s*/)
{
  if(MWheelCB->isChecked()){
    MWheel->setEnabled(true);
  }
  else{
    int t=Type;
    int i=-1;
    while(i<0) i=gLib.GetMWheel(t--);
    MWheel->setCurrentIndex(i);
    MWheel->setEnabled(false);
  }
}

void Settings::ThPatCBCh(int /*s*/)
{
  if(ThPatCB->isChecked()){
    ThPat->setEnabled(true);
  }
  else{
    int t=Type;
    int i=-1;
    while(i<0) i=gLib.GetThPat(t--);
    if(i==1) ThPat->setCheckState(Qt::Checked);
    else ThPat->setCheckState(Qt::Unchecked);
  }
}

void Settings::EmbedLibCBCh(int /*s*/)
{
  if(EmbedLibCB->isChecked()){
    EmbedLib->setEnabled(true);
  }
  else{
    int t=Type;
    int i=-1;
    while(i<0) i=gLib.GetEmbedLib(t--);
    if(i==1) EmbedLib->setCheckState(Qt::Checked);
    else EmbedLib->setCheckState(Qt::Unchecked);
  }
}

void Settings::Apply()
{
  if(LibsCB->isChecked()) gLib.SetDirs(Type,Libs->toPlainText());
  else gLib.SetDirs(Type,"");

  if(MWheelCB->isChecked()) gLib.SetMWheel(Type,MWheel->currentIndex());
  else gLib.SetMWheel(Type,-1);

  if(ThPatCB->isChecked()){
    if(ThPat->isChecked()) gLib.SetThPat(Type,1);
    else gLib.SetThPat(Type,0);
  }  
  else gLib.SetThPat(Type,-1);

  if(EmbedLibCB->isChecked()){
    if(EmbedLib->isChecked()) gLib.SetEmbedLib(Type,1);
    else gLib.SetEmbedLib(Type,0);
  }  
  else gLib.SetEmbedLib(Type,-1);

  Revert();
}

void Settings::Cancel()
{
}
void Settings::Revert()
{
  QString s;
  int t=Type;
  
  while(s.isEmpty()&&(t>=0)) s=gLib.GetDirs(t--);
  
  Libs->setPlainText(s);
  if((t+1)==Type){
    LibsCB->setCheckState(Qt::Checked);
    Libs->setReadOnly(false);
    Libs->setEnabled(true);
  }  
  else{
    LibsCB->setCheckState(Qt::Unchecked);
    Libs->setReadOnly(true);
    Libs->setEnabled(false);
  }  

  t=Type;
  int i=-1;
  while((i<0)&&(t>=0)) i=gLib.GetMWheel(t--);
  MWheel->setCurrentIndex(i);
  if((t+1)==Type){
    MWheelCB->setCheckState(Qt::Checked);
    MWheel->setEnabled(true);
  }
  else{
    MWheelCB->setCheckState(Qt::Unchecked);
    MWheel->setEnabled(false);
  }

  t=Type;
  i=-1;
  while((i<0)&&(t>=0)) i=gLib.GetThPat(t--);
  if(i==1) ThPat->setCheckState(Qt::Checked);
  else ThPat->setCheckState(Qt::Unchecked);
  if((t+1)==Type){
    ThPatCB->setCheckState(Qt::Checked);
    ThPat->setEnabled(true);
  }
  else{
    ThPatCB->setCheckState(Qt::Unchecked);
    ThPat->setEnabled(false);
  }

  t=Type;
  i=-1;
  while((i<0)&&(t>=0)) i=gLib.GetEmbedLib(t--);
  if(i==1) EmbedLib->setCheckState(Qt::Checked);
  else EmbedLib->setCheckState(Qt::Unchecked);
  if((t+1)==Type){
    EmbedLibCB->setCheckState(Qt::Checked);
    EmbedLib->setEnabled(true);
  }
  else{
    EmbedLibCB->setCheckState(Qt::Unchecked);
    EmbedLib->setEnabled(false);
  }
}

void Settings::OK()
{
  Apply();
  printf("Settings OK %d\n",Type);
}


/*---------------------------------------------------------------------*/

SetDlg::SetDlg( QWidget *parent )
    : QDialog( parent )
{
  QLabel* Lb;

  QVBoxLayout * Layout;
  Layout = new QVBoxLayout(this);
  Layout->setSpacing(2);
  Layout->setMargin(1);

  Lb=new QLabel("SETTINGS:");
  Layout->addWidget( Lb );

  QTabWidget * Tab= new QTabWidget();
  Layout->addWidget(Tab);

  QHBoxLayout * BLayout;
  BLayout = new QHBoxLayout();
  BLayout->setSpacing(2);
  BLayout->setMargin(2);

  QPushButton * BT = new QPushButton( this );
  BT->setText("Cancel");
  BT->setMinimumSize( QSize( 60, 25 ) );
  BLayout->addWidget( BT );
  connect( BT, SIGNAL(clicked ()),SLOT (close()) );

  QPushButton * BT2 = new QPushButton( this );
  BT2->setText("Revert");
  BT2->setMinimumSize( QSize( 60, 25 ) );
  BLayout->addWidget( BT2 );

  QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Expanding );
  BLayout->addItem( spacer );
/*
  QPushButton * BT3 = new QPushButton( this );
  BT3->setText("Apply");
  BT3->setMinimumSize( QSize( 60, 25 ) );
  BLayout->addWidget( BT3 );
*/
  QPushButton * BT1 = new QPushButton( this );
  BT1->setText("OK");
  BT1->setMinimumSize( QSize( 60, 25 ) );
  BLayout->addWidget( BT1 );
  connect( BT1, SIGNAL(clicked ()),SLOT (accept()) );

  Layout->addLayout(BLayout);

  Settings * Set=new Settings(this);
  Set->SetType(0);
  Tab->addTab(Set,"Global");
  connect( BT1, SIGNAL(clicked ()),Set,SLOT (OK()) );
  connect( BT2, SIGNAL(clicked ()),Set,SLOT (Revert()) );
//  connect( BT3, SIGNAL(clicked ()),Set,SLOT (Apply()) );

  Set=new Settings(this);
  Set->SetType(1);
  Tab->addTab(Set,"Local");
  connect( BT1, SIGNAL(clicked ()),Set,SLOT (OK()) );
  connect( BT2, SIGNAL(clicked ()),Set,SLOT (Revert()) );
//  connect( BT3, SIGNAL(clicked ()),Set,SLOT (Apply()) );

  Set=new Settings(this);
  Set->SetType(2);
  Tab->addTab(Set,"File");
  connect( BT1, SIGNAL(clicked ()),Set,SLOT (OK()) );
  connect( BT2, SIGNAL(clicked ()),Set,SLOT (Revert()) );
//  connect( BT3, SIGNAL(clicked ()),Set,SLOT (Apply()) );

}

SetDlg::~SetDlg()
{

}

