/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef Settings_included
#define Settings_included

#include <QObject>
#include <QWidget>
#include <QEvent>
#include <QDialog>
#include <QLineEdit>
#include <QComboBox>
#include <QCheckBox>
#include <QPushButton>
#include <QLabel>
#include <QTextEdit>

class Settings : public QWidget
{
 Q_OBJECT
public:
  Settings(QWidget *parent=0 );
  virtual ~Settings();

  void SetType(int t);

signals:

  void Done();
  void Change();

public slots:
  void Apply();
  void Cancel();
  void Revert();
  void OK();

  void LibsCBCh(int s);
  void MWheelCBCh(int s);
  void ThPatCBCh(int s);
  void EmbedLibCBCh(int s);

private:




protected:

  int Type;
  QTextEdit * Libs;
  QCheckBox * LibsCB;
  
  QComboBox * MWheel;
  QCheckBox * MWheelCB;

  QCheckBox * ThPat;
  QCheckBox * ThPatCB;

  QCheckBox * EmbedLib;
  QCheckBox * EmbedLibCB;
};


/*------------------------------------------------------------------------*/

class SetDlg : public QDialog
{
    Q_OBJECT
public:
    SetDlg( QWidget *parent );
    virtual ~SetDlg();


protected:



private:


};

#endif
