/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef Table_included
#define Table_included

#include <QTableWidget>
//#include <qlined.h>

class Table : public QTableWidget
{
    Q_OBJECT
public:
    Table( int numRows, int numCols, QWidget* parent=0 );
    ~Table();

    const char* cellContent( int row, int col ) const;
    QString cellContentS( int row, int col );
    void setCellContent( int row, int col, QString & c);

    const char* GetRHead( int row ) const;
    QString GetRHeadS( int row );
    void SetRHead( int row, QString & c);

    const char* GetCHead( int col ) const;
    void SetCHead( int col, QString & c);

    void SetCellWidth(int col,int w);

    void SetSize(int row, int col);

public slots:
//    void ChangeCont(const char * s);
//    void ChangeCont(const QString& s);

protected:
//    void paintCell( QPainter*, int row, int col );
//    void mousePressEvent( QMouseEvent* );
//    void keyPressEvent( QKeyEvent* );
//    void focusInEvent( QFocusEvent* );
//    void focusOutEvent( QFocusEvent* );

//    int cellWidth ( int col);

private:
//    int indexOf( int row, int col ) const;
//    QString* contents;
//    QString* RHead;
//    QString* CHead;
//    int * ColW;
//    int curRow;
//   int curCol;

//    QLineEdit * LE;
};

#endif
