/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "Edit.h"
#include "Global.h"
#include "PicEl.h"
#include "PicObj.h"
#include "PicGrp.h"
#include "DbPrj.h"
#include "Layers.h"
#include "LyEdit.h"
#include "ButBarr.h"
#include "InfoBarr.h"
#include "Outputs.h"
#include "DrcDlg.h"
#include "DRC.h"
#include "KeyMap.h"

#include <QApplication>
#include <QPainter>
#include <QPushButton>
#include <QFont>
#include <QEvent>
#include <QTextStream>
#include <QFile>
#include <QDate>
//#include <qiodev.h>
#include <QPalette>
//#include <qmenudta.h>
#include <QMenuBar>
//#include <qpopmenu.h>
#include <QFileDialog>
//Added by qt3to4:
#include <QResizeEvent>
#include <QMenu>

#define kWSch 1
#define kWPcb 2
#define kWSchPcb 3
#define kWPrj 0

class My2Widget : public QWidget
{
 Q_OBJECT

public:
    My2Widget( QWidget *parent=0 );

    void Load(QString name);
    void LoadP(QString name);

public slots:

    void SetMSpecial();
    void SetMPrj();
    void LoadDb(QAction * A);

    void AddPrj();

    void Save();
    void SaveAs();
    void Load();
    void New();
    void Print();

    void SaveP();
    void SaveAsP();
    void LoadP();
    void NewP();

    void SaveParts();

    void About();


    void SetSchType();
    void SetVer();
    void Mirror();
    void Netlist();
    void Partlist(int t);
    void Partlist0();
    void Partlist1();
    void Partlist2();
    void Partlist3();
    void Partlist4();
    void PartlistPr(int t);
    void Annotate();
    void AddRef();
    void Clean();
    void RtsNet();

    void WiewPrj();
    void WiewPcb();
    void WiewSch();
    void WiewSchPcb();
    void WiewSchLib();
    void WiewPcbLib();
    void FitWiew();

    void ToPcb();

    void ImpPDF(QString name="");
    void ImpPDFC();

    void ExpOrcSdt(QString name="");
    void ImpOrcSdt(QString name="");
    void ImpOrcLib(QString name="");
    void ImpPComps(QString name="");

    void ProcDRC();
    void CheckCn();
    void ClearPoly();
    void RmClearPoly();
    void RmUnconnectPoly();

    void TreeView();

    void SetOutputs();
    void DoOutputs();

    void SetDrc();

    void SetKeyMap();
    void SetKeyMapP();
    void Settings();

protected:
    void resizeEvent ( QResizeEvent * e);
    void Arrange();
private:

    QString fname;
    QString pfname;

    QString bfname;
    QString date;
    QString ver;

    LySelWdg* lsw;
    LySelWdg* lswP;
    LySelWdg* lswPr;
    Edit* wg;
    Edit* wgP;
    Edit* wgPr;
    ButBarr * bb;
    ButBarr * bbP;
    ButBarr * bbPr;

    InfoBarr * ib;
    InfoBarr * ibP;
    InfoBarr * ibPr;

    QPushButton *quit;
    Layers Layer;
    Layers LayerP;
    Layers LayerPr;
    Layers LyTmp;

    PicGrp * Db;
    PicGrp * DbP;
    DbPrj  * DbPr;

    QMenuBar   * mainMenu;
    QMenu * MSpecial;
    QMenu * MPrj;
    QMenu * MPart;
    QMenu * MSetting;
    
    Outputs Out;

    DRC Drc;
    KeyMap KM;
    KeyMap KMP;

    int SetTypeID;
    QAction * MirrorID;

    int W;

};
