--------------------------------------------------------------------------------
-- 
-- CTU CAN FD IP Core 
-- Copyright (C) 2021-present Ondrej Ille
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to use, copy, modify, merge, publish, distribute the Component for
-- educational, research, evaluation, self-interest purposes. Using the
-- Component for commercial purposes is forbidden unless previously agreed with
-- Copyright holder.
-- 
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
-- 
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
-- 
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
-- 
-- -------------------------------------------------------------------------------
-- 
-- CTU CAN FD IP Core 
-- Copyright (C) 2015-2020 MIT License
-- 
-- Authors:
--     Ondrej Ille <ondrej.ille@gmail.com>
--     Martin Jerabek <martin.jerabek01@gmail.com>
-- 
-- Project advisors: 
-- 	Jiri Novak <jnovak@fel.cvut.cz>
-- 	Pavel Pisa <pisa@cmp.felk.cvut.cz>
-- 
-- Department of Measurement         (http://meas.fel.cvut.cz/)
-- Faculty of Electrical Engineering (http://www.fel.cvut.cz)
-- Czech Technical University        (http://www.cvut.cz/)
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to deal in the Component without restriction, including without limitation
-- the rights to use, copy, modify, merge, publish, distribute, sublicense,
-- and/or sell copies of the Component, and to permit persons to whom the
-- Component is furnished to do so, subject to the following conditions:
-- 
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
-- 
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
-- 
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
-- 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Register map implementation of: Control_registers
--------------------------------------------------------------------------------
-- This file is autogenerated, DO NOT EDIT!

Library ieee;
use ieee.std_logic_1164.all;

Library ctu_can_fd_rtl;
use ctu_can_fd_rtl.can_registers_pkg.all;
use ctu_can_fd_rtl.cmn_reg_map_pkg.all;

entity control_registers_reg_map is
generic (
    constant DATA_WIDTH          : natural := 32;
    constant ADDRESS_WIDTH       : natural := 8;
    constant REGISTERED_READ     : boolean := true;
    constant CLEAR_READ_DATA     : boolean := true;
    constant RESET_POLARITY      : std_logic := '0';
    constant SUP_FILT_A          : boolean := true;
    constant SUP_TRAFFIC_CTRS    : boolean := true;
    constant SUP_RANGE           : boolean := true;
    constant SUP_FILT_C          : boolean := true;
    constant SUP_FILT_B          : boolean := true
);
port (
    signal clk_sys               :in std_logic;
    signal res_n                 :in std_logic;
    signal address               :in std_logic_vector(address_width - 1 downto 0);
    signal w_data                :in std_logic_vector(data_width - 1 downto 0);
    signal r_data                :out std_logic_vector(data_width - 1 downto 0);
    signal cs                    :in std_logic;
    signal read                  :in std_logic;
    signal write                 :in std_logic;
    signal be                    :in std_logic_vector(data_width / 8 - 1 downto 0);
    signal lock_1                :in std_logic;
    signal lock_2                :in std_logic;
    signal control_registers_out :out Control_registers_out_t;
    signal control_registers_in  :in Control_registers_in_t
);
end entity control_registers_reg_map;


architecture rtl of control_registers_reg_map is
  signal reg_sel : std_logic_vector(38 downto 0);
  constant ADDR_VECT
                 : std_logic_vector(233 downto 0) := "100110100101100100100011100010100001100000011111011110011101011100011011011010011001011000010111010110010101010100010011010010010001010000001111001110001101001100001011001010001001001000000111000110000101000100000011000010000001000000";
  signal read_data_mux_in : std_logic_vector(1247 downto 0);
  signal read_data_mask_n : std_logic_vector(31 downto 0);
  signal control_registers_out_i : Control_registers_out_t;
  signal read_mux_ena                : std_logic;
begin

    ----------------------------------------------------------------------------
    -- Write address to One-hot decoder
    ----------------------------------------------------------------------------

    address_decoder_control_registers_comp : address_decoder
    generic map(
        address_width                   => 6 ,
        address_entries                 => 39 ,
        addr_vect                       => ADDR_VECT ,
        registered_out                  => false ,
        reset_polarity                  => RESET_POLARITY 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        address                         => address(7 downto 2) ,-- in
        enable                          => cs ,-- in
        addr_dec                        => reg_sel -- out
    );

    ----------------------------------------------------------------------------
    -- MODE register
    ----------------------------------------------------------------------------

    mode_reg_comp : memory_reg
    generic map(
        data_width                      => 16 ,
        data_mask                       => "0000111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "0000001000010000" ,
        auto_clear                      => "0000000000000001" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(1) ,-- in
        w_be                            => be(1 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.mode -- out
    );

    ----------------------------------------------------------------------------
    -- SETTINGS register
    ----------------------------------------------------------------------------

    settings_reg_comp : memory_reg
    generic map(
        data_width                      => 16 ,
        data_mask                       => "0000111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "0000001000000000" ,
        auto_clear                      => "0000000000000000" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 16) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(1) ,-- in
        w_be                            => be(3 downto 2) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.settings -- out
    );

    ----------------------------------------------------------------------------
    -- COMMAND register
    ----------------------------------------------------------------------------

    command_reg_comp : memory_reg
    generic map(
        data_width                      => 32 ,
        data_mask                       => "00000000000000000000011111111110" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00000000000000000000000000000000" ,
        auto_clear                      => "00000000000000000000011111111110" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(3) ,-- in
        w_be                            => be(3 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.command -- out
    );

    ----------------------------------------------------------------------------
    -- INT_STAT register
    ----------------------------------------------------------------------------

    int_stat_reg_comp : memory_reg
    generic map(
        data_width                      => 16 ,
        data_mask                       => "0000111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "0000000000000000" ,
        auto_clear                      => "0000111111111111" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(4) ,-- in
        w_be                            => be(1 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.int_stat -- out
    );

    ----------------------------------------------------------------------------
    -- INT_ENA_SET register
    ----------------------------------------------------------------------------

    int_ena_set_reg_comp : memory_reg
    generic map(
        data_width                      => 16 ,
        data_mask                       => "0000111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "0000000000000000" ,
        auto_clear                      => "0000111111111111" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(5) ,-- in
        w_be                            => be(1 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.int_ena_set -- out
    );

    ----------------------------------------------------------------------------
    -- INT_ENA_CLR register
    ----------------------------------------------------------------------------

    int_ena_clr_reg_comp : memory_reg
    generic map(
        data_width                      => 16 ,
        data_mask                       => "0000111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "0000000000000000" ,
        auto_clear                      => "0000111111111111" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(6) ,-- in
        w_be                            => be(1 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.int_ena_clr -- out
    );

    ----------------------------------------------------------------------------
    -- INT_MASK_SET register
    ----------------------------------------------------------------------------

    int_mask_set_reg_comp : memory_reg
    generic map(
        data_width                      => 16 ,
        data_mask                       => "0000111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "0000000000000000" ,
        auto_clear                      => "0000111111111111" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(7) ,-- in
        w_be                            => be(1 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.int_mask_set -- out
    );

    ----------------------------------------------------------------------------
    -- INT_MASK_CLR register
    ----------------------------------------------------------------------------

    int_mask_clr_reg_comp : memory_reg
    generic map(
        data_width                      => 16 ,
        data_mask                       => "0000111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "0000000000000000" ,
        auto_clear                      => "0000111111111111" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(8) ,-- in
        w_be                            => be(1 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.int_mask_clr -- out
    );

    ----------------------------------------------------------------------------
    -- BTR register
    ----------------------------------------------------------------------------

    btr_reg_comp : memory_reg
    generic map(
        data_width                      => 32 ,
        data_mask                       => "11111111111111111111111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00010000010100001010000110000101" ,
        auto_clear                      => "00000000000000000000000000000000" ,
        is_lockable                     => true 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(9) ,-- in
        w_be                            => be(3 downto 0) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr -- out
    );

    ----------------------------------------------------------------------------
    -- BTR_FD register
    ----------------------------------------------------------------------------

    btr_fd_reg_comp : memory_reg
    generic map(
        data_width                      => 32 ,
        data_mask                       => "11111111111110111110111110111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00010000001000000110000110000011" ,
        auto_clear                      => "00000000000000000000000000000000" ,
        is_lockable                     => true 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(10) ,-- in
        w_be                            => be(3 downto 0) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_fd -- out
    );

    ----------------------------------------------------------------------------
    -- EWL register
    ----------------------------------------------------------------------------

    ewl_reg_comp : memory_reg
    generic map(
        data_width                      => 8 ,
        data_mask                       => "11111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "01100000" ,
        auto_clear                      => "00000000" ,
        is_lockable                     => true 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(11) ,-- in
        w_be                            => be(0 downto 0) ,-- in
        lock                            => lock_1 ,-- in
        reg_value                       => control_registers_out_i.ewl -- out
    );

    ----------------------------------------------------------------------------
    -- ERP register
    ----------------------------------------------------------------------------

    erp_reg_comp : memory_reg
    generic map(
        data_width                      => 8 ,
        data_mask                       => "11111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "10000000" ,
        auto_clear                      => "00000000" ,
        is_lockable                     => true 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 8) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(11) ,-- in
        w_be                            => be(1 downto 1) ,-- in
        lock                            => lock_1 ,-- in
        reg_value                       => control_registers_out_i.erp -- out
    );

    ----------------------------------------------------------------------------
    -- CTR_PRES register
    ----------------------------------------------------------------------------

    ctr_pres_reg_comp : memory_reg
    generic map(
        data_width                      => 32 ,
        data_mask                       => "00000000000000000001111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00000000000000000000000000000000" ,
        auto_clear                      => "00000000000000000001111000000000" ,
        is_lockable                     => true 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(14) ,-- in
        w_be                            => be(3 downto 0) ,-- in
        lock                            => lock_1 ,-- in
        reg_value                       => control_registers_out_i.ctr_pres -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_A_MASK register
    ----------------------------------------------------------------------------
    FILTER_A_MASK_present_gen_t : if (SUP_FILT_A = true) generate

    filter_a_mask_reg_comp : memory_reg
    generic map(
        data_width                      => 32 ,
        data_mask                       => "00011111111111111111111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00000000000000000000000000000000" ,
        auto_clear                      => "00000000000000000000000000000000" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(15) ,-- in
        w_be                            => be(3 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.filter_a_mask -- out
    );

    end generate FILTER_A_MASK_present_gen_t;

    FILTER_A_MASK_present_gen_f : if (SUP_FILT_A = false) generate
        control_registers_out_i.filter_a_mask <= "00000000000000000000000000000000";
    end generate FILTER_A_MASK_present_gen_f;

    ----------------------------------------------------------------------------
    -- FILTER_A_VAL register
    ----------------------------------------------------------------------------
    FILTER_A_VAL_present_gen_t : if (SUP_FILT_A = true) generate

    filter_a_val_reg_comp : memory_reg
    generic map(
        data_width                      => 32 ,
        data_mask                       => "00011111111111111111111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00000000000000000000000000000000" ,
        auto_clear                      => "00000000000000000000000000000000" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(16) ,-- in
        w_be                            => be(3 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.filter_a_val -- out
    );

    end generate FILTER_A_VAL_present_gen_t;

    FILTER_A_VAL_present_gen_f : if (SUP_FILT_A = false) generate
        control_registers_out_i.filter_a_val <= "00000000000000000000000000000000";
    end generate FILTER_A_VAL_present_gen_f;

    ----------------------------------------------------------------------------
    -- FILTER_B_MASK register
    ----------------------------------------------------------------------------
    FILTER_B_MASK_present_gen_t : if (SUP_FILT_B = true) generate

    filter_b_mask_reg_comp : memory_reg
    generic map(
        data_width                      => 32 ,
        data_mask                       => "00011111111111111111111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00000000000000000000000000000000" ,
        auto_clear                      => "00000000000000000000000000000000" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(17) ,-- in
        w_be                            => be(3 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.filter_b_mask -- out
    );

    end generate FILTER_B_MASK_present_gen_t;

    FILTER_B_MASK_present_gen_f : if (SUP_FILT_B = false) generate
        control_registers_out_i.filter_b_mask <= "00000000000000000000000000000000";
    end generate FILTER_B_MASK_present_gen_f;

    ----------------------------------------------------------------------------
    -- FILTER_B_VAL register
    ----------------------------------------------------------------------------
    FILTER_B_VAL_present_gen_t : if (SUP_FILT_B = true) generate

    filter_b_val_reg_comp : memory_reg
    generic map(
        data_width                      => 32 ,
        data_mask                       => "00011111111111111111111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00000000000000000000000000000000" ,
        auto_clear                      => "00000000000000000000000000000000" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(18) ,-- in
        w_be                            => be(3 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.filter_b_val -- out
    );

    end generate FILTER_B_VAL_present_gen_t;

    FILTER_B_VAL_present_gen_f : if (SUP_FILT_B = false) generate
        control_registers_out_i.filter_b_val <= "00000000000000000000000000000000";
    end generate FILTER_B_VAL_present_gen_f;

    ----------------------------------------------------------------------------
    -- FILTER_C_MASK register
    ----------------------------------------------------------------------------
    FILTER_C_MASK_present_gen_t : if (SUP_FILT_C = true) generate

    filter_c_mask_reg_comp : memory_reg
    generic map(
        data_width                      => 32 ,
        data_mask                       => "00011111111111111111111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00000000000000000000000000000000" ,
        auto_clear                      => "00000000000000000000000000000000" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(19) ,-- in
        w_be                            => be(3 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.filter_c_mask -- out
    );

    end generate FILTER_C_MASK_present_gen_t;

    FILTER_C_MASK_present_gen_f : if (SUP_FILT_C = false) generate
        control_registers_out_i.filter_c_mask <= "00000000000000000000000000000000";
    end generate FILTER_C_MASK_present_gen_f;

    ----------------------------------------------------------------------------
    -- FILTER_C_VAL register
    ----------------------------------------------------------------------------
    FILTER_C_VAL_present_gen_t : if (SUP_FILT_C = true) generate

    filter_c_val_reg_comp : memory_reg
    generic map(
        data_width                      => 32 ,
        data_mask                       => "00011111111111111111111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00000000000000000000000000000000" ,
        auto_clear                      => "00000000000000000000000000000000" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(20) ,-- in
        w_be                            => be(3 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.filter_c_val -- out
    );

    end generate FILTER_C_VAL_present_gen_t;

    FILTER_C_VAL_present_gen_f : if (SUP_FILT_C = false) generate
        control_registers_out_i.filter_c_val <= "00000000000000000000000000000000";
    end generate FILTER_C_VAL_present_gen_f;

    ----------------------------------------------------------------------------
    -- FILTER_RAN_LOW register
    ----------------------------------------------------------------------------
    FILTER_RAN_LOW_present_gen_t : if (SUP_RANGE = true) generate

    filter_ran_low_reg_comp : memory_reg
    generic map(
        data_width                      => 32 ,
        data_mask                       => "00011111111111111111111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00000000000000000000000000000000" ,
        auto_clear                      => "00000000000000000000000000000000" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(21) ,-- in
        w_be                            => be(3 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.filter_ran_low -- out
    );

    end generate FILTER_RAN_LOW_present_gen_t;

    FILTER_RAN_LOW_present_gen_f : if (SUP_RANGE = false) generate
        control_registers_out_i.filter_ran_low <= "00000000000000000000000000000000";
    end generate FILTER_RAN_LOW_present_gen_f;

    ----------------------------------------------------------------------------
    -- FILTER_RAN_HIGH register
    ----------------------------------------------------------------------------
    FILTER_RAN_HIGH_present_gen_t : if (SUP_RANGE = true) generate

    filter_ran_high_reg_comp : memory_reg
    generic map(
        data_width                      => 32 ,
        data_mask                       => "00011111111111111111111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00000000000000000000000000000000" ,
        auto_clear                      => "00000000000000000000000000000000" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(22) ,-- in
        w_be                            => be(3 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.filter_ran_high -- out
    );

    end generate FILTER_RAN_HIGH_present_gen_t;

    FILTER_RAN_HIGH_present_gen_f : if (SUP_RANGE = false) generate
        control_registers_out_i.filter_ran_high <= "00000000000000000000000000000000";
    end generate FILTER_RAN_HIGH_present_gen_f;

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL register
    ----------------------------------------------------------------------------

    filter_control_reg_comp : memory_reg
    generic map(
        data_width                      => 16 ,
        data_mask                       => "1111111111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "0000000000001111" ,
        auto_clear                      => "0000000000000000" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(23) ,-- in
        w_be                            => be(1 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.filter_control -- out
    );

    ----------------------------------------------------------------------------
    -- RX_SETTINGS register
    ----------------------------------------------------------------------------

    rx_settings_reg_comp : memory_reg
    generic map(
        data_width                      => 8 ,
        data_mask                       => "00000001" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00000000" ,
        auto_clear                      => "00000000" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(23 downto 16) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(26) ,-- in
        w_be                            => be(2 downto 2) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.rx_settings -- out
    );

    ----------------------------------------------------------------------------
    -- RX_DATA access signallization
    ----------------------------------------------------------------------------

    rx_data_access_signaller_comp : access_signaller
    generic map(
        reset_polarity                  => RESET_POLARITY ,
        data_width                      => 32 ,
        read_signalling                 => True ,
        write_signalling                => False ,
        read_signalling_reg             => False ,
        write_signalling_reg            => False 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        cs                              => reg_sel(27) ,-- in
        read                            => read ,-- in
        write                           => write ,-- in
        be                              => be(3 downto 0) ,-- in
        write_signal                    => open ,-- out
        read_signal                     => control_registers_out_i.rx_data_read -- out
    );

    ----------------------------------------------------------------------------
    -- TX_COMMAND register
    ----------------------------------------------------------------------------

    tx_command_reg_comp : memory_reg
    generic map(
        data_width                      => 16 ,
        data_mask                       => "1111111100000111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "0000000000000000" ,
        auto_clear                      => "0000000000000111" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(29) ,-- in
        w_be                            => be(1 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.tx_command -- out
    );

    ----------------------------------------------------------------------------
    -- TX_PRIORITY register
    ----------------------------------------------------------------------------

    tx_priority_reg_comp : memory_reg
    generic map(
        data_width                      => 32 ,
        data_mask                       => "01110111011101110111011101110111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "00000000000000000000000000000001" ,
        auto_clear                      => "00000000000000000000000000000000" ,
        is_lockable                     => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 0) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(30) ,-- in
        w_be                            => be(3 downto 0) ,-- in
        lock                            => '0' ,-- in
        reg_value                       => control_registers_out_i.tx_priority -- out
    );

    ----------------------------------------------------------------------------
    -- SSP_CFG register
    ----------------------------------------------------------------------------

    ssp_cfg_reg_comp : memory_reg
    generic map(
        data_width                      => 16 ,
        data_mask                       => "0000001111111111" ,
        reset_polarity                  => RESET_POLARITY ,
        reset_value                     => "0000000000001010" ,
        auto_clear                      => "0000000000000000" ,
        is_lockable                     => true 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 16) ,-- in
        write                           => write ,-- in
        cs                              => reg_sel(32) ,-- in
        w_be                            => be(3 downto 2) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.ssp_cfg -- out
    );

    ----------------------------------------------------------------------------
    -- Read data multiplexor enable 
    ----------------------------------------------------------------------------
    read_data_keep_gen : if (CLEAR_READ_DATA = false) generate
        read_mux_ena <= read and cs;
    end generate read_data_keep_gen;

    read_data_clear_gen : if (CLEAR_READ_DATA = true) generate
        read_mux_ena <= '1';
    end generate read_data_clear_gen;

    ----------------------------------------------------------------------------
    -- Read data multiplexor
    ----------------------------------------------------------------------------

    data_mux_control_registers_comp : data_mux
    generic map(
        data_out_width                  => 32 ,
        data_in_width                   => 1248 ,
        sel_width                       => 6 ,
        registered_out                  => REGISTERED_READ ,
        reset_polarity                  => RESET_POLARITY 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_selector                   => address(7 downto 2) ,-- in
        data_in                         => read_data_mux_in ,-- in
        data_mask_n                     => read_data_mask_n ,-- in
        enable                          => read_mux_ena ,-- in
        data_out                        => r_data -- out
    );

  ------------------------------------------------------------------------------
  -- Read data driver
  ------------------------------------------------------------------------------
  read_data_mux_in <=
    -- Adress:152
    control_registers_in.timestamp_high &

    -- Adress:148
    control_registers_in.timestamp_low &

    -- Adress:144
    control_registers_in.yolo_reg &

    -- Adress:140
    control_registers_in.debug_register &

    -- Adress:136
    control_registers_in.tx_fr_ctr &

    -- Adress:132
    control_registers_in.rx_fr_ctr &

    -- Adress:128
    control_registers_out_i.ssp_cfg & control_registers_in.trv_delay &

    -- Adress:124
    control_registers_in.ts_info & control_registers_in.alc & control_registers_in.retr_ctr & control_registers_in.err_capt &

    -- Adress:120
    control_registers_out_i.tx_priority &

    -- Adress:116
    control_registers_in.txtb_info & "00000000" & "00000000" &

    -- Adress:112
    control_registers_in.tx_status &

    -- Adress:108
    control_registers_in.rx_data &

    -- Adress:104
    "00000000" & control_registers_out_i.rx_settings & control_registers_in.rx_status &

    -- Adress:100
    control_registers_in.rx_pointers &

    -- Adress:96
    control_registers_in.rx_mem_info &

    -- Adress:92
    control_registers_in.filter_status & control_registers_out_i.filter_control &

    -- Adress:88
    control_registers_out_i.filter_ran_high &

    -- Adress:84
    control_registers_out_i.filter_ran_low &

    -- Adress:80
    control_registers_out_i.filter_c_val &

    -- Adress:76
    control_registers_out_i.filter_c_mask &

    -- Adress:72
    control_registers_out_i.filter_b_val &

    -- Adress:68
    control_registers_out_i.filter_b_mask &

    -- Adress:64
    control_registers_out_i.filter_a_val &

    -- Adress:60
    control_registers_out_i.filter_a_mask &

    -- Adress:56
    "00000000" & "00000000" & "00000000" & "00000000" &

    -- Adress:52
    control_registers_in.err_fd & control_registers_in.err_norm &

    -- Adress:48
    control_registers_in.tec & control_registers_in.rec &

    -- Adress:44
    control_registers_in.fault_state & control_registers_out_i.erp & control_registers_out_i.ewl &

    -- Adress:40
    control_registers_out_i.btr_fd &

    -- Adress:36
    control_registers_out_i.btr &

    -- Adress:32
    "00000000" & "00000000" & "00000000" & "00000000" &

    -- Adress:28
    "00000000" & "00000000" & control_registers_in.int_mask_set &

    -- Adress:24
    "00000000" & "00000000" & "00000000" & "00000000" &

    -- Adress:20
    "00000000" & "00000000" & control_registers_in.int_ena_set &

    -- Adress:16
    "00000000" & "00000000" & control_registers_in.int_stat &

    -- Adress:12
    "00000000" & "00000000" & "00000000" & "00000000" &

    -- Adress:8
    control_registers_in.status &

    -- Adress:4
    control_registers_out_i.settings & control_registers_out_i.mode &

    -- Adress:0
    control_registers_in.version & control_registers_in.device_id;

    ----------------------------------------------------------------------------
    -- Read data mask - Byte enables
    ----------------------------------------------------------------------------
    read_data_mask_n <=
      be(3) & be(3) & be(3) & be(3) & be(3) & be(3) & be(3) & be(3) & 
      be(2) & be(2) & be(2) & be(2) & be(2) & be(2) & be(2) & be(2) & 
      be(1) & be(1) & be(1) & be(1) & be(1) & be(1) & be(1) & be(1) & 
      be(0) & be(0) & be(0) & be(0) & be(0) & be(0) & be(0) & be(0) ;

    Control_registers_out <= Control_registers_out_i;

    -- <RELEASE_OFF>
    ----------------------------------------------------------------------------
    -- Functional coverage
    ----------------------------------------------------------------------------
    --  psl default clock is rising_edge(clk_sys);
    -- psl device_id_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(0)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl version_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(0)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl mode_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(1)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl mode_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(1)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl settings_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(1)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl settings_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(1)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl status_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(2)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl command_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(3)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl int_stat_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(4)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_stat_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(4)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_ena_set_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(5)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_ena_set_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(5)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_ena_clr_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(6)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_mask_set_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(7)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_mask_set_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(7)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_mask_clr_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(8)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl btr_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(9)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl btr_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(9)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl btr_fd_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(10)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl btr_fd_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(10)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl ewl_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(11)='1') and ((be(0)='1')))};

    -- psl ewl_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(11)='1') and ((be(0)='1')))};

    -- psl erp_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(11)='1') and ((be(1)='1')))};

    -- psl erp_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(11)='1') and ((be(1)='1')))};

    -- psl fault_state_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(11)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl rec_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(12)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl tec_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(12)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl err_norm_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(13)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl err_fd_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(13)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl ctr_pres_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(14)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_a_mask_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(15)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_a_mask_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(15)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_a_val_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(16)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_a_val_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(16)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_b_mask_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(17)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_b_mask_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(17)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_b_val_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(18)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_b_val_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(18)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_c_mask_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(19)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_c_mask_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(19)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_c_val_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(20)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_c_val_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(20)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_ran_low_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(21)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_ran_low_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(21)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_ran_high_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(22)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_ran_high_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(22)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_control_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(23)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl filter_control_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(23)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl filter_status_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(23)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl rx_mem_info_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(24)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl rx_pointers_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(25)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl rx_status_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(26)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl rx_settings_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(26)='1') and ((be(2)='1')))};

    -- psl rx_settings_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(26)='1') and ((be(2)='1')))};

    -- psl rx_data_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(27)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl tx_status_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(28)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl tx_command_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(29)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl txtb_info_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(29)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl tx_priority_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(30)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl tx_priority_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(30)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl err_capt_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(31)='1') and ((be(0)='1')))};

    -- psl retr_ctr_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(31)='1') and ((be(1)='1')))};

    -- psl alc_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(31)='1') and ((be(2)='1')))};

    -- psl ts_info_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(31)='1') and ((be(3)='1')))};

    -- psl trv_delay_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(32)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl ssp_cfg_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(32)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl ssp_cfg_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(32)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl rx_fr_ctr_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(33)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl tx_fr_ctr_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(34)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl debug_register_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(35)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl yolo_reg_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(36)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl timestamp_low_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(37)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl timestamp_high_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(38)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- <RELEASE_ON>

end architecture rtl;
