--------------------------------------------------------------------------------
-- 
-- CTU CAN FD IP Core 
-- Copyright (C) 2021-present Ondrej Ille
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to use, copy, modify, merge, publish, distribute the Component for
-- educational, research, evaluation, self-interest purposes. Using the
-- Component for commercial purposes is forbidden unless previously agreed with
-- Copyright holder.
-- 
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
-- 
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
-- 
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
-- 
-- -------------------------------------------------------------------------------
-- 
-- CTU CAN FD IP Core 
-- Copyright (C) 2015-2020 MIT License
-- 
-- Authors:
--     Ondrej Ille <ondrej.ille@gmail.com>
--     Martin Jerabek <martin.jerabek01@gmail.com>
-- 
-- Project advisors: 
-- 	Jiri Novak <jnovak@fel.cvut.cz>
-- 	Pavel Pisa <pisa@cmp.felk.cvut.cz>
-- 
-- Department of Measurement         (http://meas.fel.cvut.cz/)
-- Faculty of Electrical Engineering (http://www.fel.cvut.cz)
-- Czech Technical University        (http://www.cvut.cz/)
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to deal in the Component without restriction, including without limitation
-- the rights to use, copy, modify, merge, publish, distribute, sublicense,
-- and/or sell copies of the Component, and to permit persons to whom the
-- Component is furnished to do so, subject to the following conditions:
-- 
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
-- 
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
-- 
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
-- 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Register map package for: CAN_Registers
--------------------------------------------------------------------------------
-- This file is autogenerated, DO NOT EDIT!

Library ieee;
use ieee.std_logic_1164.all;

package can_registers_pkg is

  type control_registers_out_t is record
     mode_rst                    : std_logic;
     mode_bmm                    : std_logic;
     mode_stm                    : std_logic;
     mode_afm                    : std_logic;
     mode_fde                    : std_logic;
     mode_tttm                   : std_logic;
     mode_rom                    : std_logic;
     mode_acf                    : std_logic;
     mode_tstm                   : std_logic;
     mode_rxbam                  : std_logic;
     mode_txbbm                  : std_logic;
     mode_sam                    : std_logic;
     mode_erfm                   : std_logic;
     settings_rtrle              : std_logic;
     settings_rtrth              : std_logic_vector(3 downto 0);
     settings_ilbp               : std_logic;
     settings_ena                : std_logic;
     settings_nisofd             : std_logic;
     settings_pex                : std_logic;
     settings_tbfbo              : std_logic;
     settings_fdrf               : std_logic;
     settings_pchke              : std_logic;
     command_rxrpmv              : std_logic;
     command_rrb                 : std_logic;
     command_cdo                 : std_logic;
     command_ercrst              : std_logic;
     command_rxfcrst             : std_logic;
     command_txfcrst             : std_logic;
     command_cpexs               : std_logic;
     command_crxpe               : std_logic;
     command_ctxpe               : std_logic;
     command_ctxdpe              : std_logic;
     int_stat_rxi                : std_logic;
     int_stat_txi                : std_logic;
     int_stat_ewli               : std_logic;
     int_stat_doi                : std_logic;
     int_stat_fcsi               : std_logic;
     int_stat_ali                : std_logic;
     int_stat_bei                : std_logic;
     int_stat_ofi                : std_logic;
     int_stat_rxfi               : std_logic;
     int_stat_bsi                : std_logic;
     int_stat_rbnei              : std_logic;
     int_stat_txbhci             : std_logic;
     int_ena_set_int_ena_set     : std_logic_vector(11 downto 0);
     int_ena_clr_int_ena_clr     : std_logic_vector(11 downto 0);
     int_mask_set_int_mask_set   : std_logic_vector(11 downto 0);
     int_mask_clr_int_mask_clr   : std_logic_vector(11 downto 0);
     btr_prop                    : std_logic_vector(6 downto 0);
     btr_ph1                     : std_logic_vector(5 downto 0);
     btr_ph2                     : std_logic_vector(5 downto 0);
     btr_brp                     : std_logic_vector(7 downto 0);
     btr_sjw                     : std_logic_vector(4 downto 0);
     btr_fd_prop_fd              : std_logic_vector(5 downto 0);
     btr_fd_ph1_fd               : std_logic_vector(4 downto 0);
     btr_fd_ph2_fd               : std_logic_vector(4 downto 0);
     btr_fd_brp_fd               : std_logic_vector(7 downto 0);
     btr_fd_sjw_fd               : std_logic_vector(4 downto 0);
     ewl_ew_limit                : std_logic_vector(7 downto 0);
     erp_erp_limit               : std_logic_vector(7 downto 0);
     ctr_pres_ctpv               : std_logic_vector(8 downto 0);
     ctr_pres_ptx                : std_logic;
     ctr_pres_prx                : std_logic;
     ctr_pres_enorm              : std_logic;
     ctr_pres_efd                : std_logic;
     filter_a_mask_bit_mask_a_val : std_logic_vector(28 downto 0);
     filter_a_val_bit_val_a_val  : std_logic_vector(28 downto 0);
     filter_b_mask_bit_mask_b_val : std_logic_vector(28 downto 0);
     filter_b_val_bit_val_b_val  : std_logic_vector(28 downto 0);
     filter_c_mask_bit_mask_c_val : std_logic_vector(28 downto 0);
     filter_c_val_bit_val_c_val  : std_logic_vector(28 downto 0);
     filter_ran_low_bit_ran_low_val : std_logic_vector(28 downto 0);
     filter_ran_high_bit_ran_high_val : std_logic_vector(28 downto 0);
     filter_control_fanb         : std_logic;
     filter_control_fane         : std_logic;
     filter_control_fafb         : std_logic;
     filter_control_fafe         : std_logic;
     filter_control_fbnb         : std_logic;
     filter_control_fbne         : std_logic;
     filter_control_fbfb         : std_logic;
     filter_control_fbfe         : std_logic;
     filter_control_fcnb         : std_logic;
     filter_control_fcne         : std_logic;
     filter_control_fcfb         : std_logic;
     filter_control_fcfe         : std_logic;
     filter_control_frnb         : std_logic;
     filter_control_frne         : std_logic;
     filter_control_frfb         : std_logic;
     filter_control_frfe         : std_logic;
     rx_settings_rtsop           : std_logic;
     rx_data_read                : std_logic;
     tx_command_txce             : std_logic;
     tx_command_txcr             : std_logic;
     tx_command_txca             : std_logic;
     tx_command_txb1             : std_logic;
     tx_command_txb2             : std_logic;
     tx_command_txb3             : std_logic;
     tx_command_txb4             : std_logic;
     tx_command_txb5             : std_logic;
     tx_command_txb6             : std_logic;
     tx_command_txb7             : std_logic;
     tx_command_txb8             : std_logic;
     tx_priority_txt1p           : std_logic_vector(2 downto 0);
     tx_priority_txt2p           : std_logic_vector(2 downto 0);
     tx_priority_txt3p           : std_logic_vector(2 downto 0);
     tx_priority_txt4p           : std_logic_vector(2 downto 0);
     tx_priority_txt5p           : std_logic_vector(2 downto 0);
     tx_priority_txt6p           : std_logic_vector(2 downto 0);
     tx_priority_txt7p           : std_logic_vector(2 downto 0);
     tx_priority_txt8p           : std_logic_vector(2 downto 0);
     ssp_cfg_ssp_offset          : std_logic_vector(7 downto 0);
     ssp_cfg_ssp_src             : std_logic_vector(1 downto 0);
  end record;


  type Control_registers_in_t is record
     device_id_device_id         : std_logic_vector(15 downto 0);
     version_ver_minor           : std_logic_vector(7 downto 0);
     version_ver_major           : std_logic_vector(7 downto 0);
     status_rxne                 : std_logic;
     status_dor                  : std_logic;
     status_txnf                 : std_logic;
     status_eft                  : std_logic;
     status_rxs                  : std_logic;
     status_txs                  : std_logic;
     status_ewl                  : std_logic;
     status_idle                 : std_logic;
     status_pexs                 : std_logic;
     status_rxpe                 : std_logic;
     status_txpe                 : std_logic;
     status_txdpe                : std_logic;
     status_stcnt                : std_logic;
     status_strgs                : std_logic;
     status_sprt                 : std_logic;
     int_stat_rxi                : std_logic;
     int_stat_txi                : std_logic;
     int_stat_ewli               : std_logic;
     int_stat_doi                : std_logic;
     int_stat_fcsi               : std_logic;
     int_stat_ali                : std_logic;
     int_stat_bei                : std_logic;
     int_stat_ofi                : std_logic;
     int_stat_rxfi               : std_logic;
     int_stat_bsi                : std_logic;
     int_stat_rbnei              : std_logic;
     int_stat_txbhci             : std_logic;
     int_ena_set_int_ena_set     : std_logic_vector(11 downto 0);
     int_mask_set_int_mask_set   : std_logic_vector(11 downto 0);
     fault_state_era             : std_logic;
     fault_state_erp             : std_logic;
     fault_state_bof             : std_logic;
     rec_rec_val                 : std_logic_vector(8 downto 0);
     tec_tec_val                 : std_logic_vector(8 downto 0);
     err_norm_err_norm_val       : std_logic_vector(15 downto 0);
     err_fd_err_fd_val           : std_logic_vector(15 downto 0);
     filter_status_sfa           : std_logic;
     filter_status_sfb           : std_logic;
     filter_status_sfc           : std_logic;
     filter_status_sfr           : std_logic;
     rx_mem_info_rx_buff_size    : std_logic_vector(12 downto 0);
     rx_mem_info_rx_mem_free     : std_logic_vector(12 downto 0);
     rx_pointers_rx_wpp          : std_logic_vector(11 downto 0);
     rx_pointers_rx_rpp          : std_logic_vector(11 downto 0);
     rx_status_rxe               : std_logic;
     rx_status_rxf               : std_logic;
     rx_status_rxmof             : std_logic;
     rx_status_rxfrc             : std_logic_vector(10 downto 0);
     rx_data_rx_data             : std_logic_vector(31 downto 0);
     tx_status_tx1s              : std_logic_vector(3 downto 0);
     tx_status_tx2s              : std_logic_vector(3 downto 0);
     tx_status_tx3s              : std_logic_vector(3 downto 0);
     tx_status_tx4s              : std_logic_vector(3 downto 0);
     tx_status_tx5s              : std_logic_vector(3 downto 0);
     tx_status_tx6s              : std_logic_vector(3 downto 0);
     tx_status_tx7s              : std_logic_vector(3 downto 0);
     tx_status_tx8s              : std_logic_vector(3 downto 0);
     txtb_info_txt_buffer_count  : std_logic_vector(3 downto 0);
     err_capt_err_pos            : std_logic_vector(3 downto 0);
     err_capt_err_erp            : std_logic;
     err_capt_err_type           : std_logic_vector(2 downto 0);
     retr_ctr_retr_ctr_val       : std_logic_vector(3 downto 0);
     alc_alc_bit                 : std_logic_vector(4 downto 0);
     alc_alc_id_field            : std_logic_vector(2 downto 0);
     ts_info_ts_bits             : std_logic_vector(5 downto 0);
     trv_delay_trv_delay_value   : std_logic_vector(6 downto 0);
     rx_fr_ctr_rx_fr_ctr_val     : std_logic_vector(31 downto 0);
     tx_fr_ctr_tx_fr_ctr_val     : std_logic_vector(31 downto 0);
     debug_register_stuff_count  : std_logic_vector(2 downto 0);
     debug_register_destuff_count : std_logic_vector(2 downto 0);
     debug_register_pc_arb       : std_logic;
     debug_register_pc_con       : std_logic;
     debug_register_pc_dat       : std_logic;
     debug_register_pc_stc       : std_logic;
     debug_register_pc_crc       : std_logic;
     debug_register_pc_crcd      : std_logic;
     debug_register_pc_ack       : std_logic;
     debug_register_pc_ackd      : std_logic;
     debug_register_pc_eof       : std_logic;
     debug_register_pc_int       : std_logic;
     debug_register_pc_susp      : std_logic;
     debug_register_pc_ovr       : std_logic;
     debug_register_pc_sof       : std_logic;
     yolo_reg_yolo_val           : std_logic_vector(31 downto 0);
     timestamp_low_timestamp_low : std_logic_vector(31 downto 0);
     timestamp_high_timestamp_high : std_logic_vector(31 downto 0);
  end record;


  type test_registers_out_t is record
     tst_control_tmaena          : std_logic;
     tst_control_twrstb          : std_logic;
     tst_dest_tst_addr           : std_logic_vector(15 downto 0);
     tst_dest_tst_mtgt           : std_logic_vector(3 downto 0);
     tst_wdata_tst_wdata         : std_logic_vector(31 downto 0);
  end record;


  type Test_registers_in_t is record
     tst_rdata_tst_rdata         : std_logic_vector(31 downto 0);
  end record;

end package;
