#
# spec file for package peda
#
# Copyright (c) 2019 Pavel Pisa <pisa@cmp.felk.cvut.cz>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Please submit bugfixes or comments via
#   https://sourceforge.net/projects/peda/
# issues tracker.
#


Name:           peda
Version:        0.96
Release:        0
Summary:        PEDA - Qt based EDA (schematic and PCB) software
License:        GPL-3.0-or-later
Group:          Productivity/Scientific/Electronics
URL:            https://sourceforge.net/projects/peda/
Source:         peda_%{version}.tar.xz
BuildRequires:  gcc-c++
BuildRequires:  pkgconfig
BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Widgets)
BuildRequires:  pkgconfig(Qt5Test)
BuildRequires:  pkgconfig(Qt5PrintSupport)
BuildRequires:  hicolor-icon-theme

%if ! 0%{?suse_version}
BuildRequires:  desktop-file-utils
%endif

%if 0%{?suse_version}
BuildRequires:  update-desktop-files
%endif

%if !0%{?suse_version}
%define  qmake5  /usr/bin/qmake-qt5
%endif

%description
PEDA is electronic design automation software for schematic
and PCB design with unique tools selection stack for manual
routing and unified PCB and schematic database developed
in Qt5 library.

%prep
%setup -q

%build
%qmake5 "CONFIG+=release" \
  CONFIG+="force_debug_info" \
  QMAKE_CFLAGS+="%optflags" \
  QMAKE_CXXFLAGS+="%optflags" \
  QMAKE_STRIP="/bin/true"
#make %{?_smp_mflags} - do not use SMP for now, there can be problem with generated makefiles
#%make_build          - fails on openSUSE_Leap_42.3 and openSUSE_Leap_42.3_Ports
make

%install
mkdir -p %{buildroot}/%{_bindir}
install -m755 src/peda %{buildroot}/%{_bindir}
mkdir -p %{buildroot}/%{_datadir}/peda
install -m755 data/update-library.sh %{buildroot}/%{_datadir}/peda
mkdir -p %{buildroot}/%{_datadir}/icons/hicolor/48x48/apps
install -m644 data/icons/peda.png %{buildroot}/%{_datadir}/icons/hicolor/48x48/apps
mkdir -p %{buildroot}/%{_datadir}/icons/hicolor/scalable/apps
install -m644 data/icons/peda.svg %{buildroot}/%{_datadir}/icons/hicolor/scalable/apps

#desktop icon
%if 0%{?suse_version}
install -m755 -d %{buildroot}%{_datadir}/applications
install -m644 data/peda.desktop %{buildroot}%{_datadir}/applications
%suse_update_desktop_file -r -i peda 'Education;Engineering'
%endif

%if 0%{?fedora} || 0%{?rhel} || 0%{?centos}
desktop-file-install --dir=%{buildroot}%{_datadir}/applications data/peda.desktop
desktop-file-validate %{buildroot}%{_datadir}/applications/peda.desktop
%endif

%files
%{_bindir}/peda
%{_datadir}/peda/
%{_datadir}/peda/update-library.sh
%{_datadir}/applications/peda.desktop
%{_datadir}/icons/hicolor/48x48/apps/peda.png
%{_datadir}/icons/hicolor/scalable/apps/peda.svg
%license LICENSE
%doc README

%changelog
