/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "ActButt.h"

//Added by qt3to4:
#include <QMouseEvent>

#include <stdio.h>
#include <stdlib.h>

#include "xpm/Cir.xpm"
#include "xpm/Rect.xpm"
#include "xpm/Line.xpm"
#include "xpm/Text.xpm"
#include "xpm/Power.xpm"
#include "xpm/AddP.xpm"
#include "xpm/Poly.xpm"
#include "xpm/Move.xpm"
#include "xpm/XMove.xpm"
#include "xpm/MoveP.xpm"
#include "xpm/MoveB.xpm"
#include "xpm/Block.xpm"
#include "xpm/Copy.xpm"
#include "xpm/CopyB.xpm"
#include "xpm/Rot.xpm"
#include "xpm/RotB.xpm"
#include "xpm/Mirror.xpm"
#include "xpm/MirrorB.xpm"
#include "xpm/Del.xpm"
#include "xpm/DelBl.xpm"
#include "xpm/MView.xpm"
#include "xpm/ZoomIn.xpm"
#include "xpm/ZoomOut.xpm"
#include "xpm/Edit.xpm"
#include "xpm/HiL.xpm"
#include "xpm/Atr.xpm"
#include "xpm/Enter.xpm"
#include "xpm/LastW.xpm"
#include "xpm/FitW.xpm"

ActButton::ActButton( QWidget *parent)
 : QPushButton(parent)
{
 button=0;
 typ=0;
 setFixedSize(29,29);
 setCheckable(true);
}

ActButton::~ActButton()
{
}

void ActButton::SetType(int type)
{
 typ=type;
 if (type==kABCir){
  QPixmap pm((const char **)Cir_xpm);
  setIcon(pm);
 }
 else if (type==kABRect){
  QPixmap pm((const char **)Rect_xpm);
  setIcon(pm);
 }
 else if (type==kABLine){
  QPixmap pm((const char **)Line_xpm);
  setIcon(pm);
 }
 else if (type==kABText){
  QPixmap pm((const char **)Text_xpm);
  setIcon(pm);
 }
 else if (type==kABPower){
  QPixmap pm((const char **)Power_xpm);
  setIcon(pm);
 }
 else if (type==kABPoly){
  QPixmap pm((const char **)Poly_xpm);
  setIcon(pm);
 }
 else if (type==kABAddP){
  QPixmap pm((const char **)AddP_xpm);
  setIcon(pm);
 }
 else if (type==kABMoveP){
  QPixmap pm((const char **)MoveP_xpm);
  setIcon(pm);
 }
 else if (type==kABMoveBl){
  QPixmap pm((const char **)MoveB_xpm);
  setIcon(pm);
 }
 else if (type==kABMove){
  QPixmap pm((const char **)Move_xpm);
  setIcon(pm);
 }
 else if (type==kABXMove){
  QPixmap pm((const char **)XMove_xpm);
  setIcon(pm);
 }
 else if (type==kABCopyBl){
  QPixmap pm((const char **)CopyB_xpm);
  setIcon(pm);
 }
 else if (type==kABCopy){
  QPixmap pm((const char **)Copy_xpm);
  setIcon(pm);
 }
 else if (type==kABRotBl){
  QPixmap pm((const char **)RotB_xpm);
  setIcon(pm);
 }
 else if (type==kABRot){
  QPixmap pm((const char **)Rot_xpm);
  setIcon(pm);
 }
 else if (type==kABMirBl){
  QPixmap pm((const char **)MirrorB_xpm);
  setIcon(pm);
 }
 else if (type==kABMir){
  QPixmap pm((const char **)Mirror_xpm);
  setIcon(pm);
 }
 else if (type==kABDel){
  QPixmap pm((const char **)Del_xpm);
  setIcon(pm);
 }
 else if (type==kABDelBl){
  QPixmap pm((const char **)DelBl_xpm);
  setIcon(pm);
 }
 else if (type==kABVWin){
  QPixmap pm((const char **)Block_xpm);
  setIcon(pm);
 }
 else if (type==kABMView){
  QPixmap pm((const char **)MView_xpm);
  setIcon(pm);
 }
 else if (type==kABZoomIn){
  QPixmap pm((const char **)ZoomIn_xpm);
  setIcon(pm);
 }
 else if (type==kABZoomOut){
  QPixmap pm((const char **)ZoomOut_xpm);
  setIcon(pm);
 }
 else if (type==kABEdit){
  QPixmap pm((const char **)Edit_xpm);
  setIcon(pm);
 }
 else if (type==kABHiL){
  QPixmap pm((const char **)HiL_xpm);
  setIcon(pm);
 }
 else if (type==kABAtr){
  QPixmap pm((const char **)Atr_xpm);
  setIcon(pm);
 }
 else if (type==kABEnter){
  QPixmap pm((const char **)Enter_xpm);
  setIcon(pm);
 }
 else if (type==kABLastW){
  QPixmap pm((const char **)LastW_xpm);
  setIcon(pm);
 }
 else if (type==kABFitW){
  QPixmap pm((const char **)FitW_xpm);
  setIcon(pm);
 }
}

int ActButton::GetButt()
{
 return button;
}


void ActButton::mousePressEvent ( QMouseEvent *e )
{
 button=e->button();
 if (button!=Qt::RightButton){
  setChecked(true);
  Select(typ,button);
 }
}

/*
void ActButton::mouseReleaseEvent ( QMouseEvent *e )
{
}
*/
