/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DbPcb_included
#define DbPcb_included

#include "PicEl.h"
#include "PicGrp.h"
#include "PicObj.h"
#include "PComp.h"
#include "DRC.h"

#include <QWidget>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

class QPainter;
class QColor;

class Part;

class PicPNet : public PicGrp
{

struct PinLst {
  PComp * P;
  int n;
  PinLst * Next;
  PinLst * Cn[6];
  int   Act;
  int   Grp;
  int x;
  int y;
};

public:

  PicPNet(Layers *L);
  virtual ~PicPNet();

  virtual int GetIden();

  virtual void AddTreeList(TreeListItem * LI);

  PicPNet::PinLst * GetPL();

  virtual void HLSel(int fl=0);

  bool IsEmpty();

  void SetName(QString N);
  QString GetName();

  void AddItem(PicEl* E);
  void AddItem(GrpEl* T);

//  bool IsConnect(PicEl * L,int tol,GrpEl * B=NULL);
  bool IsConnect(PicEl * L,int tol,int num = 0);
  bool IsConnect(QPoint p,int tol);
  bool IsConnect(QPoint p,int tol,unsigned int Ly);

  void AddPin(PComp * P,int n);
  void DelPin();

  void SelRts(PComp * P);
  void DeSelRts();
  bool IsSelRts();

  void MinRts();
  void MoveN(PinLst ** D,PinLst ** S,int Grp);
  void CheckCn();

  void RmSelPin();

  int Disjoint(int & t);

  bool IsVia(QPoint p1);

  void ClrData();

  virtual void TextSave(QTextStream * S, bool sel=false);

  virtual void UpdORect(int mir=0);
  virtual void UpdSelORect(int mir=0);

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);

  virtual PicEl * GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                        int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);
  virtual PicEl * GetNextEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                            int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);


protected:
  virtual void Paint(QPainter* P,QRect* Rec,int flag,QColor* col,
                     int x,int y,int rot,int mir,bool HL);
//  virtual void SetOutl();
  virtual bool  TLoadNext(QTextStream * S,QString* s);

private:

  QString Name;
  PinLst * PL;
  QRect Rp;
  bool SR;
  int MinX,MaxX,MinY,MaxY;
};


class DbPcb : public PicGrp
{

public:

  DbPcb(Layers *L);
  virtual ~DbPcb();

  virtual int GetIden();

  virtual void AddTreeList(TreeListItem * LI);

  PComp * FindComp(QString ref);
  bool GetCompCenter(QString ref, QPoint & p, int & rot,int & mir,int & typ);
  void GetPart(Part * P);

  void DelInvalid();

  void UpdateAtr();
  int SelXPartL();

  void CleanNets();
  void MkNets();

  int CheckCn();

  bool IsConnect(QPoint p,int tol);
  void AddWire(QPoint l1,QPoint l2,int Wid,QRect & r,bool cln=true);
  void ANetORect(QRect & r);


  virtual bool Select(QPoint p,int mode=0,int mir=0);
//  virtual bool Select(QRect r,int mode=0);
//  virtual bool Select(PicEl * E);
  virtual void DeSelect();
  virtual void DeleteSel();

  virtual void GetSelORect(QRect* r);
  bool LibPart(QString name);

  void DelDrcErr();
  bool Drc(DRC & D);

  void SetName(QString n);

  virtual void TextSave(QTextStream * S, bool sel=false);

protected:
  virtual bool TLoadNext(QTextStream * S,QString* s);

private:

 PicPNet * ANet;
 unsigned long int ALy;
 QString ViaName;

 QString Name;


};




#endif
