/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef Edit_included
#define Edit_included

#include "Global.h"
#include "PicEl.h"
#include "PicObj.h"
#include "PicGrp.h"
#include "DbPcb.h"
#include "InfoBarr.h"

#include <QLineEdit>
#include <QPainter>

#include <QEvent>
//Added by qt3to4:
#include <QPixmap>
#include <QResizeEvent>
#include <QWheelEvent>
#include <QMouseEvent>
#include <QPaintEvent>

#define SizeZH 10

class Edit : public QWidget
{
 Q_OBJECT
public:
    Edit(PicGrp * Db, QWidget *parent=0);
    virtual ~Edit();
    void SetInfo(InfoBarr * I);
    void SetDb(PicGrp * Db);
    void Zoom(QRect r);

signals:
  void Escape();
  void KeyPress(int k);
  
  void NetHL(QString s);
  void CompHL(QString s);
  void CompMove(QString s);

public slots:
  void LyVisChange();
  void LyChange();
  void LActSel(int type);
  void MActSel(int type);
  void Press(QPoint p,int but);
  void EndLE();
  void UpdatePM();
  void UpdateAll();

  void HLNet(QString s);
  void HLComp(QString s);
  void MoveComp(QString s);

  void SettingsChanged();
  
protected:
    void paintEvent( QPaintEvent * e);
    void mouseMoveEvent( QMouseEvent *e );
    void wheelEvent ( QWheelEvent * e );
    void mousePressEvent ( QMouseEvent *e );
    void mouseReleaseEvent ( QMouseEvent * e);
    void resizeEvent ( QResizeEvent * e);
    void keyPressEvent ( QKeyEvent * e ); 

private:
   void SaveZH();
   void RestoreZH();

   void RestoreSt();
   void SaveSt();

   void CopySel();
   void ReadCopy();

   void ScrToDb(QPoint * p,bool g=true);
   void DbToScr(QPoint * p);
   void DbToScr(QRect * r);
   int ConvActType(int type);
   void Release ();

   QPoint PLineT(QPoint p1,QPoint p2);


 PicGrp  * G;

 int x1;
 int y1;
 int x2;
 int y2;

 int button;

// QPainter paint;

 bool Line;
 int LineT;
 int LineD;
 QPoint l1;
 QPoint m1;
 QPoint l2;
 QRect  Bl;
 QPoint Old;
 QPoint OldP;

 bool BlSel;

 float scale;
 int XPos;
 int YPos;

 QPoint Dif;

 int LAct;
 int MAct;
 int Act;

 InfoBarr * Info;
 
 QString IStr;

 int xP;
 int yP;

 QLineEdit * LE;
 bool LEShow;
 PicText * Tx;

 PicPower * Pw;

 bool Circ;
 bool TxNew;
 bool PwNew;

 PicPoly * Poly;
 
 int Ori;

 int OB;
 int OA;
 int OO;
 QPoint Ol1;
 QPoint Ol2;
 QRect OBl;

 int ZHX[SizeZH];
 int ZHY[SizeZH];
 float ZHS[SizeZH];

 bool EWire;

 QPixmap PM;

 int LS;
 float osc;
 int OXP;
 int OYP;

 QPoint ClP;
 
 QString CopyStr;

 int MWheel;
};

#endif
