/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "ImpExp.h"

#include "PicObj.h"
#include "PicPadS.h"
#include "PicPin.h"

#include <QFont>
#include <QFile>
//Added by qt3to4:
#include <QTextStream>

#include <stdlib.h>
#include <math.h>

extern const char *sPic[];

ImpExp::ImpExp()
{
 int i;
// Lay=NULL;
 NLT=0;
 for(i=0;i<MAXAPR;i++){
  AprTTab[i]=0;
 }
}

ImpExp::~ImpExp()
{
}

bool ImpExp::ImportPdf(DbPcb * Db, QTextStream * S,int flag)
{
 QString s;
 QString s1;
 int x;
 int i=1;
// Lay=Db->GetLayers();
 if(!ReadLTT("LTT.txt",Db->GetLayers())) return false;
 if(!ReadAprTab("pcad.apr"))  return false;
 for(x=0;x<MAXAPR;x++){
  if(AprTTab[x]) printf("Flash %d d=%d typ=%d\n",x,AprDTab[x],AprTTab[x]);
 }

 if(!ReadPadTab(S,flag)) return false;
 S->device()->reset();
 for(x=0;x<MAXPAD;x++){
  if(!PadTab[x].isEmpty()) printf("%d %s\n",x,PadTab[x].toLatin1().data());
 }
 while(i>0 && !S->atEnd()){
  *S >> s;
  printf(" %d %s\n",i,s.toLatin1().data());
  if(s.contains("{COMPONENT")){
   *S >> s;
   printf("Import pdf name : %s\n",s.toLatin1().data());
//   i++;
  }
  else if(s.contains("{DETAIL")){
   i++;
  }
  else if(s.contains("{ANNOTATE")){
   if(!ReadPdfSec(Db,s,S)) return false;
  }
  else if(s.contains("{NET_DEF")){
   i++;
  }
  else if(s.contains("{N")){
   *S >> s;
   printf("  Net name : %s\n",s.toLatin1().data());
   i++;
  }
  else if(s.contains("{DG")){
   if(!ReadPdfSec(Db,s,S)) return false;
  }
  else if(s.contains("{SUBCOMP")){
   i++;
  }
  else if(s.contains("{COMP_DEF")){
   *S >> s;
   if(flag){
    s.remove(".prt");
    s=s.toUpper();
//    printf("Read Comp %s\n",(const char *)s);
    Layers Ly;
//    ImpExp IE;
    PicPComp * P=new PicPComp(&Ly);
//    if(IE.ImportPdf(P,S)){
    if(ImportPdf(P,S)){
     s+=".pco";
     QFile F(s);
     F.open(QIODevice::WriteOnly);
     QTextStream S1;
     S1.setDevice(&F);
     Ly.TextSave(&S1);
     S1<<"{"<< sPic[P->GetIden()] <<"\n";
     P->TextSave(&S1);
     F.close();
     printf("Read Comp %s OK\n",s.toLatin1().data());
    }
    delete P;
   }
   else{
    if(!SkipPdfSec(S)) return false;
   }
  }
  else if(s.contains("{I")){
   *S >> s;
   *S >> s1;
//   printf(" Comp name : %s %s\n",(const char *)s,(const char *)s1);
   PComp * C=new PComp(Db->GetLayers());
   s.remove(".prt");
   s=s.toUpper();
   if(C->LibPart(s)){
    C->SetAtr(0,s1.toLatin1().data());
    if(ReadCompSec(C,S)){
     Db->AddItem(C);
    }
    else{
     delete C;
     return false;
    }
   }
   else{
    delete C;
    printf("ERROR Neni %s %s\n",s.toLatin1().data(),s1.toLatin1().data());
    if(!SkipPdfSec(S)) return false;
   }

//   if(!SkipPdfSec(S)) return false;
  }
  else if(s.contains('[')){
   if(!ReadPdfSet(s,S,Db->GetLayers())) return false;
  }
  else if(s.contains('{')){
   printf(" Skip Sect %s\n",s.toLatin1().data());
   if(!SkipPdfSec(S)) return false;
  }
  else if(s.contains('}')){
   i--;
  }
  else{
   printf(" %s\n",s.toLatin1().data());
  }
 }
 if(i>0) return false;
 return true;
}

bool ImpExp::ReadPadTab(QTextStream * S,int /*flag*/)
{
 QString s;
 QString s1;
 int x;
 int i=1;
// Lay=Db->GetLayers();

 while(i>0 && !S->atEnd()){
  *S >> s;
  printf(" %d %s\n",i,s.toLatin1().data());
  if(s.contains("{COMPONENT")){
  }
  else if(s.contains("{DETAIL")){
   i++;
  }
  else if(s.contains("{PAD_STACK")){
   printf("Pad stack START\n");
   i++;
  }
  else if(s.contains("{Pad")){
   *S >> x;
   *S >> s;
   printf("Pad\n");
   s.remove('"');
   s.remove('}');
   printf("Pad %s %d\n",s.toLatin1().data(),x);
   if(x<MAXPAD && x>=0){
    PadTab[x]=s;
   }
  }
  else if(s.contains("{PAD_DEF")){
   *S >> s;
   printf("Read Pad def %s\n",s.toLatin1().data());
   Layers Ly;
//    ImpExp IE;
   PicPadS * P=new PicPadS(&Ly);
//    if(IE.ImportPdf(P,S)){
   if(ReadPdfSec(P,s,S)){
    s+=".pad";
    QFile F(s);
    F.open(QIODevice::WriteOnly);
    QTextStream S1;
    S1.setDevice(&F);
    Ly.TextSave(&S1);
    S1<<"{"<< sPic[P->GetIden()] <<"\n";
    P->TextSave(&S1);
    F.close();
    printf("Read Pad %s OK\n",s.toLatin1().data());
    delete P;
   }
   else{
    if(!SkipPdfSec(S)) return false;
   }
  }
  else if(s.contains('{')){
   printf(" Skip Sect %s\n",s.toLatin1().data());
   if(!SkipPdfSec(S)) return false;
  }
  else if(s.contains('}')){
   i--;
  }
  else{
//   printf(" %s\n",s.toLatin1().data());
  }
 }
 if(i>0) return false;
 return true;
}

bool ImpExp::ImportPdf(PicPComp * Db, QTextStream * S)
{
 QString s;
 QString s1;
 int i=1;
 printf("ImportPdf : PicPComp\n");
// Lay=Db->GetLayers();
// if(!ReadLTT("LTT.txt")) return false;
 while(i>0 && !S->atEnd()){
  *S >> s;
//  printf(" %d %s\n",i,(const char *)s);
  if(s.contains("{COMPONENT")){
   *S >> s;
   printf("Import pdf name : %s\n",s.toLatin1().data());
//   i++;
  }
  else if(s.contains("{SYMBOL")){
   i++;
  }
  else if(s.contains("{PIN_DEF")){
   i++;
  }
  else if(s.contains("{PIC")){
   if(!ReadPdfSec(Db,s,S)) return false;
  }
  else if(s.contains("{P")){
   if(!ReadPinSec(Db,s,S)){
    SkipPdfSec(S);
    return false;
   }
  }
  else if(s.contains('[')){
   if(!ReadPdfSet(s,S,Db->GetLayers())) return false;
  }
  else if(s.contains('{')){
   printf(" Skip comp Sect %s\n",s.toLatin1().data());
   if(!SkipPdfSec(S)) return false;
  }
  else if(s.contains('}')){
   i--;
  }
  else{
   printf(" %s\n",s.toLatin1().data());
  }
 }
 if(i>0){
  printf("Error %d\n",i);
  return false;
 }
 return true;
}


bool ImpExp::ReadCompSec(PComp * C, QTextStream * S)
{
// char c;
 QString s;
 QString s1;
 int i=1;
// int num;
 double x;
 double y;
 int rot=0;
 int mir=0;
 while(i>0 && !S->atEnd()){
  *S>>s;
  printf("ReadCompSec : %s\n",s.toLatin1().data());
  if(s.contains("{ATR")){
   i++;
  }
  else if(s.contains("{CN")){
   if(!SkipPdfSec(S)) return false;
  }
  else if(s.contains("{IN")){
   i++;
  }
  else if(s.contains("{Pl")){
   *S>>x;
   *S>>y;
   C->MoveTo((int)(x*10),(int)(-y*10));
   if(!SkipPdfSec(S)) return false;
  }
  else if(s.contains("{Ro")){
   *S>>x;
   rot=4-(int)x;
//   PicPComp * P=C->GetPPComp();
   C->RotateTo(4-(int)x);
   if(!SkipPdfSec(S)) return false;
  }
  else if(s.contains("{Nl")){
   *S>>x;
   *S>>y;
   PicText * T=new PicText(C->GetLayers());
   T->MoveTo((int)(x*10),(int)(-y*10));
//   if(mir){
//    T->SetAlig(2-TjH,TjV);
//    T->SetMirror(1);
//   }
//   else 
   T->SetAlig(TjH,TjV);
   QFont F("Courier",Ts);
   T->SetFont(F);
//   T->RotateTo((Tr+rot)&3);
   T->RotateTo(Tr);
   if(Tm) T->SetMirror(1);
   T->SetText("Ref");
   T->SetSubIden(kSIDRef);
   C->AddItem(T);
   printf("Text %s %d %d\n","Ref",(int)x,(int)-y);

   if(!SkipPdfSec(S)) return false;
  }
  else if(s.contains("{Ps")){
   ReadStr(s,S);
   if(s.contains('B')){
//    C->GetPPComp()->SetMirror(1);
    C->SetMirror(1);
    mir=1;
   }
   if(!SkipPdfSec(S)) return false;
  }
  else if(s.contains("{EX")){
   if(!ReadPdfSec(C,s,S,rot,mir)) return false;
  }
  else if(s.contains('[')){
   if(!ReadPdfSet(s,S,C->GetLayers())) return false;
  }
  else if(s.contains("{")){
   printf("Skip Comp Sec %s\n",s.toLatin1().data());
   if(!SkipPdfSec(S)) return false;
  }
  else if(s.contains("}")){
   i--;
  }
 }
 return true;
}



bool ImpExp::ReadPinSec(PicGrp * G, QString s, QTextStream * S)
{
 char c;
 QString s1;
 int i=1;
 int num;
 double x;
 double y;

 *S>>s1;
 num=0;
 if(s1[0]>='A'){
//  printf("Pin %s -",(const char *)s1);
  num=((s1[0].toLatin1())-'A'+1)<<16;
  s1=s1.right(s1.length()-1);
//  printf(" %s\n",(const char *)s1);
 }
 num+=s1.toInt();

 PicPadS * P=new PicPadS(G->GetLayers());
 P->SetPinNum(num);
 G->AddItem(P);
 while(i>0 && !S->atEnd()){
  *S >> s;
  if(s.contains("{Pt")){
   *S>>num;
   if(PadTab[num].isEmpty()) s1="null.ps";
   else s1=PadTab[num];
   if(!P->LibPart(s1)){
    printf(" Pad %d - %s not found\n",num,s1.toLatin1().data());
    SkipPdfSec(S);
    return false;
   }
  }
  else if(s.contains("{Lq")){
   *S>>c;
   while(c!='}'){
    *S>>c;
   }
  }
  else if(s.contains("{Ploc")){
   *S>>x;
   *S>>y;
   P->MoveTo((int)(x*10),(int)(-y*10));
   *S>>c;
   while(c!='}'){
    *S>>c;
   }
  }
  else if(s.contains("}")){
   i--;
  }
 }
 return true;
}

bool ImpExp::ReadPdfSec(PicGrp * G, QString s, QTextStream * S,int tr,int mir)
{
 int i=1;
 double n;
 int x;
 int y;
 int x1;
 int y1;
 int r1;
 int lin;
 QRect r;
 QPoint(l1);
 QPoint(l2);
 while(i>0 && !S->atEnd()){
  *S >> s;
  printf(" %d %s\n",i,s.toLatin1().data());
  if(s.contains("{PIC")){
   i++;
  }
  else if(s.contains("{ATR")){
   printf(" Read Sect Skip %s\n",s.toLatin1().data());
   if(!SkipPdfSec(S)) return false;
  }
  else if(s.contains("{W") || s.contains("{L")){
   lin=0;
   *S>>s;
   while(!s.contains('}')){
    n=s.toDouble();
    x=(int)(n*10);
    *S>>s;
    n=s.toDouble();
    y=(int)(n*10);
    printf("Line %d %d\n",x,-y);
    l1.setX(x);
    l1.setY(-y);
    if(lin){
     PicLine * L=new PicLine(G->GetLayers());
     L->MoveTo(l1);
     L->Begin(l1);
     L->End(l2);
     L->SetWidth(Wd);
     G->AddItem(L);
//      G->AddLine(l1,l2,Wd,r);
    }
    lin=1;
    l2=l1;
    if(!s.contains('}')){
     *S>>s;
    }
   }
  }
  else if(s.contains("{C")){
   *S>>n;
   x=(int)(n*10);
   *S>>n;
   y=(int)(-n*10);
   *S>>n;
   x1=(int)(n*10);
   PicCir * C=new PicCir(G->GetLayers());
   C->MoveTo(x,y);
   C->Circle(x,y,x1);
   C->SetWidth(Wd);
   G->AddItem(C);
   SkipPdfSec(S);
  }
  else if(s.contains("{R")){
   *S>>n;
   x=(int)(n*10);
   *S>>n;
   y=(int)(-n*10);
   *S>>n;
   x1=(int)(n*10);
   *S>>n;
   y1=(int)(-n*10);
   PicRect * R=new PicRect(G->GetLayers());
   R->Rect(x,y,x1-x,(y1-y));
   R->SetWidth(Wd);
   G->AddItem(R);
   printf("Rectangle %d %d %d %d\n",x,y,x1,y1);
   SkipPdfSec(S);
  }
  else if(s.contains("{Fl")){
   *S>>n;
   x=(int)(n*10);
   *S>>n;
   y=(int)(-n*10);
   *S>>n;
   x1=(int)n;
   if(x1>=0 && x1<MAXAPR){
    if(AprTTab[x1]==1){
     PicCir * C=new PicCir(G->GetLayers());
     C->MoveTo(x,y);
     C->Circle(x,y,AprDTab[x1]/2);
     C->SetWidth(2000);
     G->AddItem(C);
    }
    else if(AprTTab[x1]==2){
     PicRect * R=new PicRect(G->GetLayers());
     R->Rect(x-AprDTab[x1]/2,y-AprDTab[x1]/2,AprDTab[x1],AprDTab[x1]);
     R->SetWidth(2000);
     G->AddItem(R);
    }
    else{
     printf("Unknow apr type %d\n",x1);
    }
   }
   SkipPdfSec(S);
  }
  else if(s.contains("{Fr")){
   *S>>n;
   x=(int)(n*10);
   *S>>n;
   y=(int)(-n*10);
   *S>>n;
   x1=(int)(n*10);
   *S>>n;
   y1=(int)(-n*10);
   PicRect * R=new PicRect(G->GetLayers());
   R->Rect(x,y,x1-x,(y1-y));
   R->SetWidth(2000);
   G->AddItem(R);
   printf("Rectangle %d %d %d %d\n",x,y,x1,y1);
   SkipPdfSec(S);
  }
  else if(s.contains("{T")){
   ReadStr(s,S);
   *S>>n;
   x=(int)(n*10);
   *S>>n;
   y=(int)(n*10);
   PicText * T=new PicText(G->GetLayers());
   T->MoveTo(x,-y);
   if(mir){
    T->SetAlig(2-TjH,TjV);
    T->SetMirror(1);
   }
   else T->SetAlig(TjH,TjV);
   QFont F("Courier",Ts);
   T->SetFont(F);
   T->RotateTo((Tr+tr)&3);
   if(Tm) T->SetMirror(1);
   T->SetText(s);
   G->AddItem(T);
   printf("Text %s %d %d\n",s.toLatin1().data(),x,y);
   SkipPdfSec(S);
  }
  else if(s.contains("{At")){
   *S>>s;
   *S>>s;
   *S>>n;
   x=(int)(n*10);
   *S>>n;
   y=(int)(n*10);
   PicText * T=new PicText(G->GetLayers());
   T->MoveTo(x,-y);
   if(mir){
    T->SetAlig(2-TjH,TjV);
    T->SetMirror(1);
   }
   else T->SetAlig(TjH,TjV);
   QFont F("Courier",Ts);
   T->SetFont(F);
   T->RotateTo((Tr+tr)&3);
   if(Tm) T->SetMirror(1);
   T->SetText(s);
   G->AddItem(T);
   printf("Text %s %d %d\n",s.toLatin1().data(),x,y);
   SkipPdfSec(S);
  }
  else if(s.contains("{Arc")){
   *S>>n;
   x=(int)(n*10);
   *S>>n;
   y=(int)(-n*10);
   *S>>n;
   x1=(int)(n*10);
   *S>>n;
   y1=(int)(-n*10);
   r1=(int)sqrt((x-x1)*(x-x1)+(y-y1)*(y-y1));
   int a2=(int)(180*16*atan2(y1-y,x1-x)/3.141592);
   *S>>n;
   x1=(int)(n*10);
   *S>>n;
   y1=(int)(-n*10);
   int a1=(int)(180*16*atan2(y1-y,x1-x)/3.141592);
   PicCir * C=new PicCir(G->GetLayers());
   C->MoveTo(x,y);
   C->Circle(x,y,r1);
   C->SetWidth(Wd);
   printf("a1=%d a2=%d",a1/16,a2/16);
   a2=a2-a1;
   if (a2<0) a2+=360*16;
   if (a1<0) a1+=360*16;
   if(a1>=360*16) a1=a1-360*16;
   printf(" s=%d l=%d\n",a1/16,a2/16);
   C->SetArc(a1,a2);
   G->AddItem(C);
   SkipPdfSec(S);
  }
  else if(s.contains("{A")){
   *S>>n;
   x=(int)(n*10);
   *S>>n;
   y=(int)(-n*10);
   *S>>n;
   r1=(int)(n*10);
   *S>>n;
   x1=(int)(n*16);
   *S>>n;
   y1=(int)(n*16);
   PicCir * C=new PicCir(G->GetLayers());
   C->MoveTo(x,y);
   C->Circle(x,y,r1);
   C->SetWidth(Wd);
   y1=y1-x1;
   if (y1<0) y1=y1+360*16;
   x1=x1+180*16;
   if(x1>=360*16) x1=x1-360*16;
   C->SetArc(x1,y1);
   G->AddItem(C);
   SkipPdfSec(S);
  }
  else if(s.contains("{V")){
   *S>>n;
   x=(int)(n*10);
   *S>>n;
   y=(int)(n*10);
   *S>>n;
   x1=(int)n;
   PicPadS * V=new PicPadS(G->GetLayers());
   if(V->LibPart(PadTab[x1])){
    V->MoveTo(x,-y);
    G->AddItem(V);
   }
   else{
    delete V;
    printf(" Pad %s not found\n",PadTab[x1].toLatin1().data());
   }
   printf("Via %d %d %d\n",x,-y,x1);
   SkipPdfSec(S);
  }
  else if(s.contains('[')){
   if(!ReadPdfSet(s,S,G->GetLayers())) return false;
  }
  else if(s.contains('{')){
   printf(" Read Sect Skip %s\n",s.toLatin1().data());
   if(!SkipPdfSec(S)) return false;
  }
  else if(s.contains('}')){
   i--;
  }
 }
 if(i>0) return false;
 return true;
}

bool ImpExp::SkipPdfSec(QTextStream * S)
{
 char c;
 int i=1;
 do{
  *S >> c;
  if(c=='{') i++;
  if(c=='}') i--;
 } while (i>0 && !S->atEnd());
 if(i>0) return false;
 return true;
}

bool ImpExp::ReadPdfSet(QString s, QTextStream * S,Layers * Lay)
{
// int i=1;
 char x;
 double n;
// unsigned long int t;
 printf(" Set %s\n",s.toLatin1().data());

 if(s.contains("[Ly")){
  ReadStr(s,S);
  SetLy(s,Lay);
/*  if(Lay){
   t=Lay->GetLy(&s);
   Lay->SetVis(t);
   Lay->SetAct(t);
  } */
 }
 else if(s.contains("[Ls")){
  do{
   *S>>x;
  }while (x!=']');
  return true;
 }
 else if(s.contains("[Wd")){
  *S>>n;
  Wd=(int)(n*10);
  if(Wd<=1) Wd=40;
 }
 else if(s.contains("[Ts")){
  *S>>n;
  Ts=(int)(n*10);
 }
 else if(s.contains("[Tj")){
  ReadStr(s,S);
  if(s[0]=='L') TjH=0;
  else if(s[0]=='C') TjH=1;
  else if(s[0]=='R') TjH=2;
  else printf(" Bad TjH %c\n",s[0].toLatin1());
  if(s[1]=='B') TjV=2;
  else if(s[1]=='C') TjV=1;
  else if(s[1]=='T') TjV=0;
  else printf(" Bad TjV %c\n",s[1].toLatin1());
 }
 else if(s.contains("[Tr")){
  *S>>n;
  Tr=4-(int)n;
 }
 else if(s.contains("[Tm")){
  ReadStr(s,S);
  if(s[0]=='Y') Tm=1;
  else Tm=0;
 }
 else{
  printf("Unknown set %s\n",s.toLatin1().data());
  do{
   *S>>x;
  }while (x!=']');
  return false;
 }
 *S>>x;
 while(x==' '){
  *S>>x;
 }
 if(x!=']') printf(" Bad Set %c\n",x);
 if(x==']') return true;
 return false;
}

bool ImpExp::ReadStr(QString &s, QTextStream * S)
{
 char x;
 *S >> x;
 while(x!='"'){
  *S >> x;
  if(S->atEnd())return false;
 }
 s="";
 *S >> x;
 if(S->atEnd())return false;
 while(x!='"'){
  s+=x;
  *S >> x;
  if(S->atEnd())return false;
 }
 return true;
}

void ImpExp::SetLy(QString name,Layers * Lay)
{
 if(!Lay) return;
 int i=0;
 unsigned long int t=0;
 QString s("OTHER");
 while(i<NLT && name!=LT[i].N1) i++;
 if(name==LT[i].N1){
//  Lay->SetVis(LT[i].Ly);
//  Lay->SetAct(LT[i].Ly);
   t=Lay->GetLy(&LT[i].N2);
  Lay->SetVis(t);
  Lay->SetAct(t);
 }
 else{
   t=Lay->GetLy(&s);
  Lay->SetVis(t);
  Lay->SetAct(t);
 }
}

bool ImpExp::ReadAprTab(QString name)
{
 int i=0;
 QFile F(name);
 QString s;
 QString s1;
 if(!F.open(QIODevice::ReadOnly)){
  printf("Neni soubor %s\n",name.toLatin1().data());
  return false;
 }
 QTextStream S1;
 S1.setDevice(&F);
 while(!S1.atEnd()){
  S1>>s;
  printf("%s\n",s.toLatin1().data());
  if(s.contains('#')){
   if(i>0){
    return true;
    F.close();
   }
//   else S1.readLine();
  }
  if(s.toInt()==1){
   if(i==0) i=-1;
   else i=1;
  }
  if(i>0){
   i=s.toInt();
   S1>>AprDTab[i];
   AprDTab[i]=AprDTab[i]*10;
   S1>>s1;
   if(s1.contains("SQUARE")) AprTTab[i]=2;
   else AprTTab[i]=1;
  }
  S1.readLine();
 }
 F.close();
 return false;
}

bool ImpExp::ReadLTT(QString name,Layers * Lay)
{
 if(!Lay) return false;
// int i=0;
 QFile F(name);
 QString s;
 QString s1;
 if(!F.open(QIODevice::ReadOnly)){
  printf("Neni soubor %s\n",name.toLatin1().data());
  return false;
 }
 QTextStream S1;
 S1.setDevice(&F);
 while(!S1.atEnd()){
  S1>>LT[NLT].N1;
  if(LT[NLT].N1.contains("Pair:")) break;
  S1>>LT[NLT].N2;
  S1>>LT[NLT].r;
  S1>>LT[NLT].g;
  S1>>LT[NLT].b;
  if(!S1.atEnd()){
   LT[NLT].Ly=Lay->GetLy(&(LT[NLT].N2));
   Lay->SetColor(LT[NLT].Ly,LT[NLT].r,LT[NLT].g,LT[NLT].b);
   NLT++;
  }
 }
 while(!S1.atEnd()){
  S1>>s;
  S1>>s1;
  if(!S1.atEnd()){
   Lay->SetPair(s,s1);
  }
 }
 F.close();
 return true;
}

//******************************************************************


//#define DEFAULT_FONT "Nimbus sans l"
#define DEFAULT_FONT "Courier"

#define SDT_TYPE_TITLE  0x00
#define SDT_TYPE_COMP  0x02
#define SDT_TYPE_WIRE 0x03
#define SDT_TYPE_JUNCTION 0x05
#define SDT_TYPE_LABEL 0x07
#define SDT_TYPE_LINE 0x09
#define SDT_TYPE_POWER 0x0A
#define SDT_TYPE_TEXT 0x0B
#define SDT_TYPE_END 0x0F

#define TEXT_MULL 22
#define TEXT_MULL_L 18

OrcImpExp::OrcImpExp()
{
 Lay=NULL;
 sdt_lib_ref_names=NULL;
 sdt_lib_ref=NULL;
 sdt_lib_ref_cnt=0;
 sdt_part_cnt=0;

}

OrcImpExp::~OrcImpExp()
{
}

bool OrcImpExp::ImportSdt(DbSch * Db, QFile * F,int /*flag*/)
{
 Lay=Db->GetLayers();

  int  ret,rd_error=0;
  long int f_pos;
  int  o_type;
  int  o_size;
  long stream_bytes;

  ret=F->read((char *)buf,0x20);
  if(ret<=0)
  {
    printf("File read error\n");
    return false;
  }

  if(memcmp(buf,"Schematic FILE\015\012\032",0x11)) return false;


  stream_bytes=buf[0x16]+buf[0x17]*0x100l
         +buf[0x18]*0x10000l+buf[0x19]*0x1000000l;

  printf("Schematic file\n");
  printf(" %x %x %x %x\n",buf[0x19],buf[0x18],buf[0x17],buf[0x16]);
  printf("Bytes :      0x%06lX\n",stream_bytes);
  printf("Info at 0x1E :  0x%04X\n",buf[0x1E]+(buf[0x1F]<<8));
  printf("\n");

  ret=sdt_read_lib_ref(F,stream_bytes);
  if(ret<0){
    printf("Cannot read library references\n");
    return false;
  }
  sdt_part_cnt=0;
  f_pos=0x20;
  if(ret>=0)
  for(;;){
   F->seek(f_pos);
   ret=F->read((char *)buf,3);
   if(ret<=0)  {printf("File read error\n"); break;}
   o_type=buf[0];
   o_size=buf[1]+(buf[2]<<8);
   if((o_type&0xF)==0xF) break;
   if(ret<3){rd_error=-1;printf("Premature EOF\n");break;}



   if(o_size>BufLen) {rd_error=-1;printf("Object too big\n"); break;}
  ret=F->read((char *)(buf+3),o_size);
   if(ret!=o_size)  {rd_error=-1;printf("Object read error\n"); break;}

   switch(o_type & 0x0f){
    case SDT_TYPE_COMP:
     SdtComp(Db,buf+3,o_type,o_size);
     break;
    case SDT_TYPE_WIRE:
     SdtWire(Db,buf+3,o_type,o_size);
     break;
    case SDT_TYPE_LINE:
     SdtLine(Db,buf+3,o_type,o_size);
     break;
    case SDT_TYPE_JUNCTION:
     SdtJunction(Db,buf+3,o_type,o_size);
     break;
    case SDT_TYPE_LABEL:
     SdtLabel(Db,buf+3,o_type,o_size);
     break;
    case SDT_TYPE_POWER:
     SdtPower(Db,buf+3,o_type,o_size);
     break;
    case SDT_TYPE_TEXT:
     SdtText(Db,buf+3,o_type,o_size);
     break;
    default:
     printf("Obj at 0x%04lX size 0x%04X",f_pos,o_size);
     printf(" type 0x%02X\n",o_type);
     break;
   }

    f_pos=f_pos+o_size+3;
  }

  printf("End of stream 0x%04lX\n",f_pos);

  free(sdt_lib_ref_names);
  free(sdt_lib_ref);

  if(rd_error)return false;
  else{
   Lay->SetVis("WIRE");
   Lay->AddVis("POWER");
   Lay->AddVis("PrBody");
   Lay->AddVis("VAL");
   Lay->AddVis("REF");
   Lay->AddVis("PINNUM");
   Lay->AddVis("DESC");

   Lay->SetAct("DESC");

   Db->UpdORect();
   ((DbSch *)Db)->UpdateAtr();

   QRect r;
   Db->GetORect(&r);

   PicText * T=new PicText(Lay);
   T->MoveTo(r.right(),r.bottom());
   T->SetAlig(2,1);
   QFont F(DEFAULT_FONT,r.height()/40);
   T->SetFont(F);
   T->RotateTo(0);
   T->SetText("NAME");
   T->SetSubIden(kSIDFName);
   Db->AddItem(T);
   T=new PicText(Lay);
   T->MoveTo(r.right(),r.bottom()-r.height()/40-20);
   T->SetAlig(2,1);
   QFont F1(DEFAULT_FONT,r.height()/80);
   T->SetFont(F1);
   T->RotateTo(0);
   T->SetText("DATE");
   T->SetSubIden(kSIDDate);
   Db->AddItem(T);
   Db->UpdORect();
   return true;
  }
}

bool OrcImpExp::ExportSdt(DbSch * Db, QFile * F,int flag)
{
  int ret;
  int len;
  int  i;
  char head[0x20]="Schematic FILE\015\012\032";
  char head1[4];
  char buf[0x150];

  ret=F->write(head,0x20);
  if(ret<=0){
    printf("File write error\n");
    return false;
  }

  len=ExpTitle(buf);
  head1[0]=SDT_TYPE_TITLE;
  Put16((unsigned char *)head1,1,len);
  ret=F->write((const char *)head1,3);
  if(ret<=0){
    printf("File write error\n");
    return -1;
  }
  ret=F->write((const char *)buf,len);
  if(ret<=0){
    printf("File write error\n");
    return -1;
  }
  len+=3;
  len+=ExpPicGrp(Db,F,flag,Db->Pos());

  head1[0]=SDT_TYPE_END;
  Put16((unsigned char *)head1,1,0);
  ret=F->write((const char *)head1,3);
  if(ret<=0){
    printf("File write error\n");
    return -1;
  }
  len+=3;

  for(i=0;i<LibNames.count();i++){
   PutStr((unsigned char *)buf,0,LibNames[i]);
   ret=F->write((const char *)buf,LibNames[i].length()+1);
   if(ret<=0){
     printf("File write error\n");
     return -1;
   }
  }

  head[0x16]=len & 0xFF;
  head[0x17]=(len >>8) & 0xFF;
  head[0x18]=(len >>16) & 0xFF;
  head[0x19]=(len >>24) & 0xFF;

  head[0x1E]=0x01;

  F->reset();
  ret=F->write(head,0x20);
  if(ret<=0){
    printf("File write error\n");
    return false;
  }

  return true;
}

int OrcImpExp::ExpTitle(char * buf)
{
  int i;
  for(i=0;i<0x14F;i++){
    buf[i]=0;
  }
  buf[4]=3; // Pagesize D
  return i;
}

int OrcImpExp::ExpPicGrp(PicGrp * G, QFile * F,int /*flag*/,QPoint offset)
{
  unsigned char buf[512];
  unsigned char head[4];
  int i=0;
  int l;
  int ret;
  int len=0;
  PicEl* E;
  QString s="WIRE";

  G->Sort();
  while ((E=G->GetItem(i)) != NULL){
   Layers * L=E->GetLayers();
   switch(E->GetIden()){
    case kPicLine:
     if(E->GetLayer() == L->GetLy(&s)){
       head[0]=SDT_TYPE_WIRE;
     }
     else {
       head[0]=SDT_TYPE_LINE;
     }
     l=ExpSdtWire((PicLine *)E,buf,offset);
     Put16(head,1,l);
     ret=F->write((const char *)head,3);
     if(ret<=0){
       printf("File write error\n");
       return -1;
     }
     len+=3;
     ret=F->write((const char *)buf,l);
     if(ret<=0){
       printf("File write error\n");
       return -1;
     }
     len+=l;
     break;
    case kPicText:
     if((E->GetSubIden()!=kSIDDate) && (E->GetSubIden()!=kSIDFName)){
      if(E->GetLayer() == L->GetLy(&s)){
  head[0]=SDT_TYPE_LABEL;
      }
      else{
  head[0]=SDT_TYPE_TEXT;
      }
      l=ExpSdtLabel((PicText *)E,buf,offset);
      Put16(head,1,l);
      ret=F->write((const char *)head,3);
      if(ret<=0){
  printf("File write error\n");
  return -1;
      }
      len+=3;
      ret=F->write((const char *)buf,l);
      if(ret<=0){
  printf("File write error\n");
  return -1;
      }
      len+=l;
     }
     break;
    case kPicPower:
     head[0]=SDT_TYPE_POWER;
     l=ExpSdtPower((PicPower *)E,buf,offset);
     Put16(head,1,l);
     ret=F->write((const char *)head,3);
     if(ret<=0){
       printf("File write error\n");
       return -1;
     }
     len+=3;
     ret=F->write((const char *)buf,l);
     if(ret<=0){
       printf("File write error\n");
       return -1;
     }
     len+=l;
     break;
    case kSComp:
     head[0]=SDT_TYPE_COMP;
     l=ExpSdtComp((SComp *)E,buf,offset);
     Put16(head,1,l);
     ret=F->write((const char *)head,3);
     if(ret<=0){
       printf("File write error\n");
       return -1;
     }
     len+=3;
     ret=F->write((const char *)buf,l);
     if(ret<=0){
       printf("File write error\n");
       return -1;
     }
     len+=l;
     break;
    case kPicCir:
     if((E->GetLayer() == L->GetLy(&s)) && (((PicCir *)E)->GetR() < 6)){
       head[0]=SDT_TYPE_JUNCTION;
       l=ExpSdtJunction((PicCir *)E,buf,offset);
       Put16(head,1,l);
       ret=F->write((const char *)head,3);
       if(ret<=0){
   printf("File write error\n");
   return -1;
       }
       len+=3;
       ret=F->write((const char *)buf,l);
       if(ret<=0){
   printf("File write error\n");
   return -1;
       }
       len+=l;
     }
     break;
    default:
     printf("ExpPicGrp: Unsuported obj type %s\n",sPic[E->GetIden()]);
     break;
   }
   i++;
  }
  return len;
}

int OrcImpExp::sdt_read_lib_ref(QFile * F, long stream_bytes)
{
  long int f_pos, f_end;
  int  ret, ref_cnt, i;
  int  o_type;
  int  o_size;
  char *p;

  sdt_lib_ref_cnt=0;
  f_pos=0x20;
  for(;;)
  {
    F->seek(f_pos);
    ret=F->read((char *)buf,3);
    if(ret<=0)  {printf("File read error\n"); return -1;}
    o_type=buf[0];
    o_size=buf[1]+(buf[2]<<8);
    if((o_type&0xF)==0xF) break;
    if(ret!=3)  {printf("Premature EOF\n"); return -1;}
    f_pos+=o_size+3;
  };
  f_pos+=3;
  if(f_pos!=stream_bytes+0x20)
  {
    printf("Read lib ref names has problems\n");
    printf("to locate expected stream end\n");
    printf(" %lX != %lX \n",f_pos,stream_bytes+0x20);
    return -1;
  }
  f_end=F->size();
  F->seek(f_pos);
  o_size=f_end-f_pos;
  sdt_lib_ref_names=(char *)malloc(o_size);
  if(sdt_lib_ref_names==NULL)
    {printf("No mem for lib ref names\n"); return -1;}

  ret=F->read(sdt_lib_ref_names,o_size);
  if(ret<=0)
  {
    printf("Cannot read lib ref names\n");
    free(sdt_lib_ref_names);
    sdt_lib_ref_names=NULL;
    return -1;
  }
  for(i=0;i<o_size;i++){
   if(sdt_lib_ref_names[i]==' ') sdt_lib_ref_names[i]='_';
  }

  ref_cnt=0;
  for(p=sdt_lib_ref_names;
      o_size&&(*p+1<=o_size);p+=*p+1)
    {ref_cnt++;o_size-=*p+1;};

  sdt_lib_ref=(char **)malloc((ref_cnt+1)*sizeof(char*));
  if(sdt_lib_ref==NULL)
  {
    printf("No mem for lib ref names\n");
    free(sdt_lib_ref_names);
    sdt_lib_ref_names=NULL;
    return -1;
  }

  p=sdt_lib_ref_names;
  for(i=0;i<ref_cnt;i++,p+=*p+1)
  {
    sdt_lib_ref[i]=p;
  }
  sdt_lib_ref[i]=NULL;
  sdt_lib_ref_cnt=ref_cnt;
  return 0;
}

void OrcImpExp::SetLy(QString name)
{
 if(!Lay) return;
// int i=0;
 unsigned long int t=0;
 t=Lay->GetLy(&name);
 Lay->SetVis(t);
 Lay->SetAct(t);
}

void OrcImpExp::SetLy(QString name,QString name1)
{
 if(!Lay) return;
// int i=0;
 unsigned long int t=0;
 t=Lay->GetLy(&name);
 Lay->SetAct(t);
 t|=Lay->GetLy(&name1);
 Lay->SetVis(t);
}

void OrcImpExp::GetPoint(QPoint *l,unsigned char * buf,int pos)
{
  if(buf[pos+1]>127) l->setX(((buf[pos]+256*buf[pos+1])-65536)*3);
  else l->setX((buf[pos]+256*buf[pos+1])*3);
  if(buf[pos+3]>127) l->setY(((buf[pos+2]+256*buf[pos+3])-65536)*3);
  else l->setY((buf[pos+2]+256*buf[pos+3])*3);
}

void OrcImpExp::PutPoint(QPoint *l,unsigned char * buf,int pos)
{
  int x;
  if(l->x()>=0) x=(l->x()+1)/3;
  else x=(l->x()-1)/3;
  buf[pos]=x & 0xFF;
  buf[pos+1]=(x >> 8) & 0xFF;

  if(l->y()>=0) x=(l->y()+1)/3;
  else x=(l->y()-1)/3;
  buf[pos+2]=x & 0xFF;
  buf[pos+3]=(x >> 8) & 0xFF;
}

int OrcImpExp::Get16(unsigned char *buf,int offset)
{
  int retval;
  retval = ((buf[offset+1] & 255) <<8) | (buf[offset] & 255);
  if(buf[offset+1]&128)
    retval = retval | (65535<<16);
  return retval;
}

void OrcImpExp::Put16(unsigned char *buf,int offset, int val)
{
  buf[offset]=val & 0xFF;
  buf[offset+1]=(val >> 8) & 0xFF;
}

QString OrcImpExp::GetStr(unsigned char *buf,int offset)
{
 unsigned char c;
 c=buf[offset+1+buf[offset]];
 buf[offset+1+buf[offset]]=0;
 QString s((char *)(buf+offset+1));
 buf[offset+1+buf[offset]]=c;
 return s;
}

void OrcImpExp::PutStr(unsigned char *buf,int offset,QString str)
{
 buf[offset]=str.length() & 0xFF;
 memcpy(buf+offset+1,str.toLatin1(),str.length() & 0xFF);
}


int OrcImpExp::SdtWire(DbSch * Db,unsigned char * buf,int /*type*/,int /*size*/)
{
 QPoint l1;
 QPoint l2;

 GetPoint(&l1,buf,0);
 GetPoint(&l2,buf,4);
// printf("Line %x %x, %x %x\n",buf[1],buf[0],buf[3],buf[2]);
// printf("Line %x %x, %x %x\n",buf[5],buf[4],buf[7],buf[6]);
// printf("Line %d,%d  %d,%d\n",l1.x(),l1.y(),l2.x(),l2.y());
 SetLy("WIRE");
 PicLine * L=new PicLine(Lay);
 L->MoveTo(l1);
 L->Begin(l1);
 L->End(l2);
 L->SetWidth(2);
 Db->AddItem(L);
 return 0;
}

int OrcImpExp::SdtLine(DbSch * Db,unsigned char * buf,int /*type*/,int /*size*/)
{
 QPoint l1;
 QPoint l2;

 GetPoint(&l1,buf,0);
 GetPoint(&l2,buf,4);
// printf("Line %x %x, %x %x\n",buf[1],buf[0],buf[3],buf[2]);
// printf("Line %x %x, %x %x\n",buf[5],buf[4],buf[7],buf[6]);
// printf("Line %d,%d  %d,%d\n",l1.x(),l1.y(),l2.x(),l2.y());
 SetLy("DESC");
 PicLine * L=new PicLine(Lay);
 L->MoveTo(l1);
 L->Begin(l1);
 L->End(l2);
 L->SetWidth(2);
 Db->AddItem(L);
 return 0;
}

int OrcImpExp::ExpSdtWire(PicLine * L,unsigned char * buf,QPoint offset)
{
 QPoint l1;
 QPoint l2;

 l1=L->GetBegin()+offset;
 l2=L->GetEnd()+offset;

 PutPoint(&l1,buf,0);
 PutPoint(&l2,buf,4);

// printf("Line %x %x, %x %x\n",buf[1],buf[0],buf[3],buf[2]);
// printf("Line %x %x, %x %x\n",buf[5],buf[4],buf[7],buf[6]);
// printf("Line %d,%d  %d,%d\n",l1.x(),l1.y(),l2.x(),l2.y());
 return 8;
}

int OrcImpExp::SdtLabel(DbSch * Db,unsigned char * buf,int /*type*/,int /*size*/)
{
 QPoint l1;
 int Ts;
 int Tr=0;
 unsigned char c;

 c=buf[7+buf[6]];
 buf[7+buf[6]]=0;
 QString s((char *)(buf+7));
 buf[7+buf[6]]=c;

 GetPoint(&l1,buf,0);
 Ts=Get16(buf,4);
 if(Ts<0){
  Ts=-Ts;
  Tr=1;
 }
 SetLy("WIRE");
 PicText * T=new PicText(Lay);
 T->MoveTo(l1);
 T->SetAlig(0,2);
// QFont F("Helvetica",Ts*20);
 QFont F(DEFAULT_FONT,Ts*TEXT_MULL_L);
 T->SetFont(F);
 T->RotateTo(Tr);
 T->SetText(s);
 Db->AddItem(T);
// printf("Text %s %d %d\n",(const char *)s,l1.x(),l1.y());
 return 0;
}

int OrcImpExp::ExpSdtLabel(PicText * T,unsigned char * buf,QPoint offset)
{
 QPoint l1;
 int Ts;
 int Tr=0;
// unsigned char c;
 int h,v;

 l1=T->Pos()+offset;
 T->GetAlig(&h,&v);
 if((h != 0) || (v != 2)){
   printf("Warning unsuported text align %s\n",T->GetText().toLatin1().data());
 }
 Ts=(T->GetFont().pointSize()+8)/TEXT_MULL;
 Tr=T->GetRotate();
 if(Tr > 1){
   printf("Warning unsuported text rotation %s\n",T->GetText().toLatin1().data());
   Tr&=1;
 }
 if(Tr) Ts=-Ts;

 printf("ExpText %s %d %d\n",T->GetText().toLatin1().data(),l1.x(),l1.y());
 PutPoint(&l1,buf,0);
 Put16(buf,4,Ts);
 PutStr(buf,6,T->GetText());

 return (7+T->GetText().length());
}

int OrcImpExp::SdtText(DbSch * Db,unsigned char * buf,int /*type*/,int /*size*/)
{
 QPoint l1;
 int Ts;
 int Tr=0;
 unsigned char c;

 c=buf[7+buf[6]];
 buf[7+buf[6]]=0;
 QString s((char *)(buf+7));
 buf[7+buf[6]]=c;

 GetPoint(&l1,buf,0);
 Ts=Get16(buf,4);
 if(Ts<0){
  Ts=-Ts;
  Tr=1;
 }
 SetLy("DESC");
 PicText * T=new PicText(Lay);
 T->MoveTo(l1);
 T->SetAlig(0,2);
// QFont F("Helvetica",Ts*20);
 QFont F(DEFAULT_FONT,Ts*16);
 T->SetFont(F);
 T->RotateTo(Tr);
 T->SetText(s);
 Db->AddItem(T);
// printf("Text %s %d %d\n",(const char *)s,l1.x(),l1.y());
 return 0;
}


int OrcImpExp::SdtComp(DbSch * Db,unsigned char * buf,int /*type*/,int /*size*/)
{
/*
 * 00-03   pos
 * 04-07   offs_ref
 * 08-0B   offs_val
 * 0C   flags
     *    0-4    which device
     *    5-6    orientation
     *    7      mirror
 * 0D   flags
     *    1      invisible ref
     *    2      invisible part
     *    6      has partfields
     *    7      multipart

 * 0E      fld invisible
 *
 * 18-1B   ??? time stamp
 * 1C-?    ref
 *         val
 *
 * if fld 1-8 then 8x(offs_pos,name)
 */

 QString s;
 QString s1;
 QPoint l1;
 QPoint lr,lv;
 QRect r;
 QRect r1;
 int d;

 if(sdt_part_cnt>sdt_lib_ref_cnt) return -1;
 s=GetStr((unsigned char *)(sdt_lib_ref[sdt_part_cnt]),0);
 s=s.replace('/','-');
 sdt_part_cnt++;

 s1=GetStr(buf,0x1c);
 GetPoint(&l1,buf,0);

 SComp * C=new SComp(Lay);
 if(C->LibPart(s)){
  if(s1[s1.length()-1].toLatin1()>='A'){
   C->GetPSComp()->SetPiP(s1[s1.length()-1].toLatin1()-'A');
   s1=s1.left(s1.length()-1);
  }
  C->SetAtr(0,s1.toLatin1().data());
  d=0x1c;
  d+=1+buf[d];
  s1=GetStr(buf,d);
  d+=1+buf[d];
  C->SetAtr(1,s1.toLatin1().data());

  if(buf[0xD] & 0x40){
   d+=4;
   s1=GetStr(buf,d);
   d+=1+buf[d];
   C->SetAtr(4,s1.toLatin1().data());

   d+=4;
   s1=GetStr(buf,d);
   d+=1+buf[d];
   C->SetAtr(2,s1.toLatin1().data());

   d+=4;
   s1=GetStr(buf,d);
   d+=1+buf[d];
   C->SetAtr(3,s1.toLatin1().data());

   d+=4;
   s1=GetStr(buf,d);
   d+=1+buf[d];
   C->SetAtr(5,s1.toLatin1().data());

   d+=4;
   s1=GetStr(buf,d);
   d+=1+buf[d];
   C->SetAtr(6,s1.toLatin1().data());

  }

  C->MoveTo(l1);
  C->RotateTo((4-((buf[0xC]>>5)&3))&3);
  if(buf[0xC]&0x80) C->SetMirror(1);
  SetLy("SIZEB");
  C->UpdORect();
  C->GetORect(&r);
  d=l1.x()-r.left()+1;
  d=(d/10)*10;
//  printf("dx:%d ",d);
  if(d>0) C->MoveBy(d,0);
  d=l1.y()-r.top()+1;
  d=(d/10)*10;
//  printf("dy:%d\n",d);
  if(d>0) C->MoveBy(0,d);

  lr=C->Pos();
  lv=C->Pos();

  C->GetPSComp()->SetPPV(0);
  SetLy("SIZEB");
  C->UpdORect();
  C->GetORect(&r);
  SetLy("SIZEB","PrBody");
  C->UpdORect();
  C->GetORect(&r1);

//  printf("%d:%d %d:%d  %d:%d\n",r1.top(),r.top(),r1.bottom(),r.bottom(),r1.right(),r.right());


  if(r1.top()>=r.top()-3 && r1.bottom()<=r.bottom()+3){
   lr.setX(r.left()+10);
   lr.setY(r.top());
   lv.setX(r.left()+10);
   lv.setY(r.bottom()+25);
  }
  else if(r1.top()>=r.top()-3){
   lr.setX(r.left()+10);
   lr.setY(r.top()-25);
   lv.setX(r.left()+10);
   lv.setY(r.top());
  }
  else if(r1.bottom()<=r.bottom()+3){
   lr.setX(r.left()+10);
   lr.setY(r.bottom()+25);
   lv.setX(r.left()+10);
   lv.setY(r.bottom()+50);
  }
  else if(r1.right()<=r.right()+3){
   lr.setX(r.right()+20);
   lr.setY(r.top()+25);
   lv.setX(r.right()+20);
   lv.setY(r.top()+50);
  }
  else{
   lr.setX(r.right()+20);
   lr.setY(r.top()-25);
   lv.setX(r.right()+20);
   lv.setY(r.bottom()+25);
  }

  PicText * T;
  QFont F(DEFAULT_FONT,16);

  if((buf[0xD] & 2)==0){
   GetPoint(&l1,buf,4);
   SetLy("REF");
   T=C->AddAtr(0);
   T->SetFont(F);
   T->SetAlig(0,2);
   if(buf[0xC]&0x80){
    T->RotateTo((C->GetRotate())&3);
    T->SetMirror(1);
   }
   else T->RotateTo((4-C->GetRotate())&3);
   C->Select(T);
   C->MoveSelTo(lr+l1);
   C->DeSelect();
  }

  if((buf[0xD] & 4)==0){
   GetPoint(&l1,buf,8);
   SetLy("VAL");
   T=C->AddAtr(1);
   T->SetFont(F);
   T->SetAlig(0,2);
   if(buf[0xC]&0x80){
    T->RotateTo((C->GetRotate())&3);
    T->SetMirror(1);
   }
   else T->RotateTo((4-C->GetRotate())&3);
   C->Select(T);
   C->MoveSelTo(lv+l1);
   C->DeSelect();
  }

  Db->AddItem(C);
//  printf("Comp %s %s r:%d\n",(const char *)s,(const char *)C->GetAtr(0),(4-((buf[0xC]>>5)&3))&3);
//  printf("   %d,%d fl:%X\n",l1.x(),l1.y(),buf[0xC]);
//  printf("   ORect: %d,%d %d,%d\n",r.left(),r.top(),r.right(),r.bottom());
//  GetPoint(&l1,buf,4);
//  printf("   %d,%d  ",l1.x(),l1.y());
//  GetPoint(&l1,buf,8);
//  printf("   %d,%d\n",l1.x(),l1.y());
 }
 else{
  delete C;
  printf("ERROR Neni %s %s\n",s.toLatin1().data(),s1.toLatin1().data());
  return -1;
 }
 return 0;
}

int OrcImpExp::ExpSdtComp(SComp * C,unsigned char * buf,QPoint offset)
{
/*
 * 00-03   pos
 * 04-07   offs_ref
 * 08-0B   offs_val
 * 0C   flags
     *    0-4    which device
     *    5-6    orientation
     *    7      mirror
 * 0D   flags
     *    1      invisible ref
     *    2      invisible part
     *    6      has partfields
     *    7      multipart

 * 0E      fld invisible
 *
 * 18-1B   ??? time stamp
 * 1C-?    ref
 *         val
 *
 * if fld 1-8 then 8x(offs_pos,name)
 */

 QPoint l1;
 QPoint lr;
 QPoint lv;
 QRect  r,r1;
 int flg;
 int i,j;
 int ppv;
 char vis=6;
 QString s;

 LibNames.append(C->GetPSComp()->GetName());

 Lay=C->GetLayers();
 Lay->Store();
 SetLy("SIZEB");
 C->UpdORect();
 C->GetORect(&r);

 l1=r.topLeft()+offset;
 PutPoint(&l1,buf,0);
 l1.setX(0);
 l1.setY(0);

 PutPoint(&l1,buf,4); //!!!!! ref pos
 PutPoint(&l1,buf,8); //!!!!! val pos

  ppv=C->GetPSComp()->GetPPV();
  C->GetPSComp()->SetPPV(0);
  SetLy("SIZEB");
  C->UpdORect();
  C->GetORect(&r);
  SetLy("SIZEB","PrBody");
  C->UpdORect();
  C->GetORect(&r1);
  C->GetPSComp()->SetPPV(ppv);

//  printf("%d:%d %d:%d  %d:%d\n",r1.top(),r.top(),r1.bottom(),r.bottom(),r1.right(),r.right());


  if(r1.top()>=r.top()-3 && r1.bottom()<=r.bottom()+3){
   lr.setX(r.left()+10);
   lr.setY(r.top());
   lv.setX(r.left()+10);
   lv.setY(r.bottom()+25);
  }
  else if(r1.top()>=r.top()-3){
   lr.setX(r.left()+10);
   lr.setY(r.top()-25);
   lv.setX(r.left()+10);
   lv.setY(r.top());
  }
  else if(r1.bottom()<=r.bottom()+3){
   lr.setX(r.left()+10);
   lr.setY(r.bottom()+25);
   lv.setX(r.left()+10);
   lv.setY(r.bottom()+50);
  }
  else if(r1.right()<=r.right()+3){
   lr.setX(r.right()+20);
   lr.setY(r.top()+25);
   lv.setX(r.right()+20);
   lv.setY(r.top()+50);
  }
  else{
   lr.setX(r.right()+20);
   lr.setY(r.top()-25);
   lv.setX(r.right()+20);
   lv.setY(r.bottom()+25);
  }

 i=0;
 PicEl * T=C->GetItem(i);
 while(T){
  if(T->GetIden()==kPicText){
   if(T->GetSubIden()==kSIDRef){
    vis=vis & 4;
    C->Select(T);
    lr=C->SelPos()-lr;
    C->DeSelect();
    PutPoint(&lr,buf,4); //!!!!! ref pos
   }
   if(T->GetSubIden()==kSIDVal){
    vis=vis & 2;
    C->Select(T);
    lv=C->SelPos()-lv;
    C->DeSelect();
    PutPoint(&lv,buf,8); //!!!!! val pos
   }
  }
  i++;
  T=C->GetItem(i);
 }


 flg=((4-C->GetRotate())&3) << 5;
 if(C->GetMirror()) flg |= 0x80;

 for(i=0xC;i<0x1C;i++) buf[i]=0;

 if(C->GetPSComp()->GetPPP()>1){
  flg|=(C->GetPSComp()->GetPiP()+1) & 0xf;
  buf[0xC]=flg & 0xff;
  buf[0xD]=0xC0 | vis;    //!!!!! val and ref visibility
  s=(C->GetAtr(0));
  s+='A'+C->GetPSComp()->GetPiP();
  PutStr(buf,i,s);
  i+=s.length()+1;
 }
 else{
  buf[0xC]=flg & 0xff;
  buf[0xD]=0x40 | vis;    //!!!!! val and ref visibility
  s=(C->GetAtr(0));
  PutStr(buf,i,s);
  i+=s.length()+1;
 }

// printf("%s rot %d flg %02X vis %d, %02X\n",C->GetAtr(0),C->GetRotate(),flg,vis,buf[0xD]);

 buf[0xE]=0x0F;
 s=(C->GetAtr(1));
 PutStr(buf,i,s);
 i+=s.length()+1;

 l1.setX(0);
 l1.setY(0);
 for(j=0;j<8;j++){
  if(j==0){
   s=(C->GetAtr(4));
  }
  else if(j==1){
   s=(C->GetAtr(2));
  }
  else if(j==2){
   s=(C->GetAtr(3));
  }
  else if(j==3){
   s=(C->GetAtr(5));
  }
  else if(j==4){
   s=(C->GetAtr(6));
  }
  else{
   s="";
  }
  PutPoint(&l1,buf,i);
  i+=4;
  PutStr(buf,i,s);
  i+=s.length()+1;
 }
 Lay->ReStore();
 return i;
}


int OrcImpExp::SdtJunction(DbSch * Db,unsigned char * buf,int /*type*/,int /*size*/)
{
 QPoint l1;

 GetPoint(&l1,buf,0);
 SetLy("WIRE");
 PicCir * T=new PicCir(Lay);
 T->MoveTo(l1);
 T->SetR(4);
 T->SetWidth(2000);
 Db->AddItem(T);
// printf("Text %s %d %d\n",(const char *)s,l1.x(),l1.y());
 return 0;
}

int OrcImpExp::ExpSdtJunction(PicCir * T,unsigned char * buf,QPoint offset)
{
 QPoint l1;

 l1=T->GetCenter()+offset;

 PutPoint(&l1,buf,0);
 return 4;
}


int OrcImpExp::ExpSdtPower(PicPower * T,unsigned char * buf,QPoint offset)
{
 QPoint l1;
 int rot;

 l1=T->Pos()+offset;
 rot=T->GetRotate();

 PutPoint(&l1,buf,0);
 if(rot == 0) rot=1;
 else if(rot == 1) rot=2;
 else if(rot == 2) rot=0;
 else  rot=3;

 buf[4]=T->GetType() | (rot << 2);

 PutStr(buf,5,T->GetText());

 return (6+T->GetText().length());
}

int OrcImpExp::SdtPower(DbSch * Db,unsigned char * buf,int /*type*/,int /*size*/)
{
 QPoint l1;
 int ori;
 int typ;

 GetPoint(&l1,buf,0);
 SetLy("POWER");

 typ=buf[4]&3;
 ori=(buf[4]>>2)&3;

 unsigned char c;

 c=buf[6+buf[5]];
 buf[6+buf[5]]=0;
 QString s((char *)(buf+6));
 buf[6+buf[5]]=c;


 SetLy("POWER");
 PicPower * T=new PicPower(Lay);
 T->SetWidth(2);
 QFont F(DEFAULT_FONT,16);
 T->SetFont(F);
 if(ori == 0) T->RotateTo(2);
 else if(ori == 2) T->RotateTo(1);
 else if(ori == 3) T->RotateTo(3);
 T->SetText(s);
 T->SetType(typ);
 Db->AddItem(T);
 T->MoveTo(l1);


/*
 PicLine * L=new PicLine(Lay);
 L->SetWidth(2);
 PicText * T=new PicText(Lay);
// QFont F("Helvetica",20);
 QFont F(DEFAULT_FONT,16);
 T->SetFont(F);
 T->RotateTo(0);
 T->SetText(s);

 if(ori==0){
  if(typ==0 || typ==1){
   L->MoveTo(l1);
   L->Begin(l1);
   L->End(l1.x(),l1.y()-20);

   PicCir * K=new PicCir(Lay);
   K->MoveTo(l1.x(),l1.y()-25);
   K->SetR(5);
   K->SetWidth(2);
   Db->AddItem(K);
  }
  else{
   L->MoveTo(l1);
   L->Begin(l1);
   L->End(l1.x(),l1.y()-30);
   Db->AddItem(L);

   L=new PicLine(Lay);
   L->SetWidth(4);
   L->MoveTo(l1.x()-15,l1.y()-30);
   L->Begin(l1.x()-15,l1.y()-30);
   L->End(l1.x()+15,l1.y()-30);

  }
  T->MoveTo(l1.x(),l1.y()-27);
  T->SetAlig(1,2);
 }
 else if(ori==1){
  if(typ==0 || typ==1){
   L->MoveTo(l1);
   L->Begin(l1);
   L->End(l1.x(),l1.y()+20);

   PicCir * K=new PicCir(Lay);
   K->MoveTo(l1.x(),l1.y()+25);
   K->SetR(5);
   K->SetWidth(2);
   Db->AddItem(K);
  }
  else{
   L->MoveTo(l1);
   L->Begin(l1);
   L->End(l1.x(),l1.y()+30);
   Db->AddItem(L);

   L=new PicLine(Lay);
   L->SetWidth(4);
   L->MoveTo(l1.x()-15,l1.y()+30);
   L->Begin(l1.x()-15,l1.y()+30);
   L->End(l1.x()+15,l1.y()+30);

  }
  T->MoveTo(l1.x(),l1.y()+27);
  T->SetAlig(1,0);
 }
 else if(ori==2){
  if(typ==0 || typ==1){
   L->MoveTo(l1);
   L->Begin(l1);
   L->End(l1.x()-20,l1.y());

   PicCir * K=new PicCir(Lay);
   K->MoveTo(l1.x()-25,l1.y());
   K->SetR(5);
   K->SetWidth(2);
   Db->AddItem(K);
  }
  else{
   L->MoveTo(l1);
   L->Begin(l1);
   L->End(l1.x()-25,l1.y());
   Db->AddItem(L);

   L=new PicLine(Lay);
   L->SetWidth(4);
   L->MoveTo(l1.x()-25,l1.y()-10);
   L->Begin(l1.x()-25,l1.y()-10);
   L->End(l1.x()-25,l1.y()+10);

  }
  T->MoveTo(l1.x()-27,l1.y());
  T->SetAlig(2,1);
 }
 else if(ori==3){
  if(typ==0 || typ==1){
   L->MoveTo(l1);
   L->Begin(l1);
   L->End(l1.x()+20,l1.y());

   PicCir * K=new PicCir(Lay);
   K->MoveTo(l1.x()+25,l1.y());
   K->SetR(5);
   K->SetWidth(2);
   Db->AddItem(K);
  }
  else{
   L->MoveTo(l1);
   L->Begin(l1);
   L->End(l1.x()+25,l1.y());
   Db->AddItem(L);

   L=new PicLine(Lay);
   L->SetWidth(4);
   L->MoveTo(l1.x()+25,l1.y()-10);
   L->Begin(l1.x()+25,l1.y()-10);
   L->End(l1.x()+25,l1.y()+10);

  }
  T->MoveTo(l1.x()+27,l1.y());
  T->SetAlig(0,1);
 }

 Db->AddItem(L);

 Db->AddItem(T);
*/
// printf("Text %s %d %d\n",(const char *)s,l1.x(),l1.y());
 return 0;
}



bool OrcImpExp::LibSkipComm(QTextStream * S)
{
 int i=10;
 QString s;
 *S >> s;
 while(i && !s.contains('}')){
  *S >> s;
  i--;
 }
 if (i) return true;
 return false;
}


void OrcImpExp::SetDirName(QString n)
{
  DirName=n;
}


bool OrcImpExp::ImportLib(QTextStream * S,int flag,PicGrp ** Co, Layers * L)
{
 QString s;
 QString s1;
 QString s2;
 QString n;
 int i=1;
 int XS;
 int YS;
 int PP=1;
 int p;
 Layers Ly;
 PicSComp *C=NULL;
 if(L) Lay=L;
 else Lay=&Ly;

 while(i>0){
  *S >> s;
  if(s[0]==0x27 || s[0]==0x1A || (S->atEnd() && s.isEmpty())){
   if(C){
    SetLy("SIZEB");
    PicRect * T=new PicRect(Lay);
    T->Rect(0,0,XS*30,YS*30);
    T->SetWidth(0);
    C->AddItem(T);
    if(i==2){
     SetLy("PrBody");
     T=new PicRect(Lay);
     T->Rect(0,0,XS*30,YS*30);
     T->SetWidth(2);
     C->AddItem(T);
     i=5;
    }
    if(i==3){
     printf("Chybi vektory\n");
     i=5;
    }
   }
   if(i==5 && C){
    if(!L || flag){
      n+=".sco";
      QFile F(DirName+n);
      if(F.open(QIODevice::WriteOnly)){
       QTextStream S1;
       S1.setDevice(&F);
       Lay->TextSave(&S1);
       S1<<"{"<< sPic[C->GetIden()] <<"\n";
       C->TextSave(&S1);
       F.close();
      }
      else printf("Error open file %s\n",n.toLatin1().data());
    }
    printf("Read Comp %s OK\n",n.toLatin1().data());
    if(L){
      if(Co) *Co=C;
      return true;
    }
    delete C;
    C=NULL;
    i=1;
    if(s[0]==0x1A || S->atEnd()) return true;
   }
   if(s[0]==0x1A || S->atEnd()) return false;
   p=s.indexOf(0x27,1);
   while(p<0){
    *S >> s1;
    s+="_"+s1;
    p=s.indexOf(0x27,1);
   }
   if(p>1){
    n=s.mid(1,p-1);
    n=n.replace('/','-');
    C=new PicSComp(Lay);
    *S >> s;
    while(s.contains(0x27)){
     p=s.indexOf(0x27,1);
     while(p<0){
      *S >> s1;
      s+="_"+s1;
      p=s.indexOf(0x27,1);
     }
     s=s.replace('/','-');
     if(n!=s.mid(1,p-1)){
      s="ln -s -f "+n+".sco "+DirName+s.mid(1,p-1)+".sco";
//     printf("system: %s\n",(const char *)s);
      if(!L || flag) system(s.toLatin1().data());
     }
     *S >> s;
    }
    if(s.contains("REFERENCE")){
     *S >> s1;
     s1.remove("'");
     s1=s1+"?";
     C->SetRef(&s1);
     printf("Set REF %s\n",s1.toLatin1().data());
     *S >> s;
    }
    if(s.contains("PACKAGE")){
      s1=S->readLine();
      s1=s1.simplified();
      printf("Set Pkg %s\n",s1.toLatin1().data());
      int j=0;
      s2=s1.section(' ',j,j);
      while(!s2.isEmpty()){
        C->SetPkg(s2.section(':',0,0),s2.section(':',1,1).toLatin1().data());
        j++;
        s2=s1.section(' ',j,j);
      }
    }
    LibSkipComm(S);
    *S >> XS;
    LibSkipComm(S);
    *S >> YS;
    LibSkipComm(S);
    *S >> s1;
    PP=1;
    if(!s1.contains("GRIDARRAY"))  PP=s1.toInt();

    if(PP==0) C->SetPPP(1);
    else C->SetPPP(PP);
    printf("Comp %s %d %d %d\n",n.toLatin1().data(),XS,YS,PP);
    i=2;
   }
  }
  else if(i==2){
   if(s[0]=='L' || s[0]=='R' || s[0]=='T' || s[0]=='B'){
    SetLy("PrBody");
//    printf("        %s\n",(const char *)s);
    int x,pn,j;
    int pn0=0;
    char t=s[0].toLatin1();
    s1=s.right(s.length()-1);
    x=s1.toInt();
    PicPin * P=new PicPin(Lay);
    for(j=0;j<PP;j++){
//     *S >> pn;
     *S >> s1;
     if(s1.contains(0x27)){
      p=s1.indexOf(0x27,1);
      s1=s1.mid(1,p-1);
     }
     pn=0;
     if(s1[0]>='A'){
//      printf("Pin %s -",(const char *)s1);
      pn=((s1[0].toLatin1())-'A'+1)<<16;
      s1=s1.right(s1.length()-1);
//      printf(" %s\n",(const char *)s1);
     }
     pn+=s1.toInt();
     if(j==0){
      P->SetNum(pn);
      pn0=pn;
     }
     C->SetPinNum(j,pn0,pn);
    }
    *S >> s;
    if(s.contains("SHORT") || s.contains("DOT") || s.contains("CLK")){
     *S >> s2;
    }
    else {
     s2=s;
     s="NORM";
    }
    if(s2.contains("CLK")){
     *S >> s2;
     s=s+"CLK";
    }
    pn=90;
    if(s.contains("SHORT")) pn=30;
    if(P->LibPart(s)){
     if(t=='L'){
      P->MoveTo(-pn,x*30);
     }
     else if(t=='R'){
      P->MoveTo(XS*30+pn,x*30);
      P->SetMirror(1);
     }
     else if(t=='T'){
      P->RotateTo(1);
      P->MoveTo(x*30,-pn);
     }
     else if(t=='B'){
      P->RotateTo(1);
      P->SetMirror(1);
      P->MoveTo(x*30,YS*30+pn);
     }
     C->AddItem(P);
     if(s2.contains("PWR")) P->SetSubIden(kSIDPower);
     }
    else{
     delete P;
     P=NULL;
     printf(" neni PIN %s\n",s.toLatin1().data());
    }
    *S >> s;
    if(!s.contains("'")) *S >> s;
    p=s.indexOf(0x27,1);
    while(p<0){
     *S >> s1;
     s+=" "+s1;
     p=s.indexOf(0x27,1);
    }
    s1=s.mid(1,p-1);

    if(!s2.contains("PWR")){
     SetLy("PrBody");
     PicText * T=new PicText(Lay);
 //    QFont F("Helvetica",24);
     QFont F(DEFAULT_FONT,19);
     QFontMetrics FM(F);
     T->SetFont(F);
     T->SetText(s1);
     if(t=='L'){
      T->MoveTo(10,x*30);
      T->SetAlig(0,1);
      T->RotateTo(0);
     }
     else if(t=='R'){
      T->MoveTo(XS*30-10,x*30);
      T->SetAlig(2,1);
      T->RotateTo(0);
     }
     else if(t=='T'){
      T->MoveTo(x*30,10);
      T->SetAlig(2,1);
      T->RotateTo(3);
     }
     else if(t=='B'){
      T->MoveTo(x*30,YS*30-10);
      T->SetAlig(0,1);
      T->RotateTo(3);
     }
     C->AddItem(T);
    }

    if(P && PP==0){
     pn=s1.toInt();
     P->SetNum(pn);
     C->SetPinNum(0,pn,pn);
    }
    if(P && s2.contains("PWR")){
     C->SetPinName(pn0,s1);
    }
   }
   else if(s.contains("VECTOR")){
    QRect r;
    SetLy("PrBody");
    r.setRect(2,2,XS*30-4,YS*30-4);
    C->UpdORect();
    C->Select(r,256);
    C->DeleteSel();
    i=4;
   }
   else i=3;
  }
  else if(i==3 && s.contains("VECTOR")){
   QRect r;
   SetLy("PrBody");
   r.setRect(2,2,XS*30-4,YS*30-4);
   C->UpdORect();
   C->Select(r,256);
   C->DeleteSel();
   i=4;
  }
  else if(i==4){
   double x1,x2,y1,y2;
   if(s.contains("LINE")){
    *S >> x1;
    *S >> y1;
    *S >> x2;
    *S >> y2;
    x1=x1*30;
    x2=x2*30;
    y1=y1*30;
    y2=y2*30;
    SetLy("PrBody");
    PicLine * L=new PicLine(Lay);
    L->MoveTo((int)x1,(int)y1);
    L->Begin((int)x1,(int)y1);
    L->End((int)x2,(int)y2);
    L->SetWidth(2);
    C->AddItem(L);
   }
   else if(s.contains("CIRCLE")){
    *S >> x1;
    *S >> y1;
    *S >> x2;
    x1=x1*30;
    x2=x2*30;
    y1=y1*30;
    SetLy("PrBody");
    PicCir * T=new PicCir(Lay);
    T->MoveTo((int)x1,(int)y1);
    T->SetR((int)x2);
//    T->SetWidth(2000);
    T->SetWidth(2);
    C->AddItem(T);
   }
   else if(s.contains("ARC")){
    double x3,y3,r;
    *S >> x1;
    *S >> y1;
    *S >> x2;
    *S >> y2;
    *S >> x3;
    *S >> y3;
    *S >> r;
    x1=x1*30;
    y1=y1*30;
    r=r*30;
/*    if(x2==0){
     if(y2<0) x2=-90*16;
     else x2=90*16;
    }
    else{
     if(x2<0) x2=-180*16;
     else x2=0;
    }*/
    x2=16*180/3.141592*atan2(y2,x2);
    if(x2<0)x2+=360*16;
    x3=16*180/3.141592*atan2(y3,x3);
    if(x3<0)x3+=360*16;
    SetLy("PrBody");
    PicCir * T=new PicCir(Lay);
    T->MoveTo((int)x1,(int)y1);
    T->SetR((int)r);
    if((x3-x2)>0){
      if((x3-x2)<180*16) T->SetArc((int)x2,(int)(x3-x2));
      else T->SetArc((int)x3,(int)(x2-x3+360*16));
    } 
    else{
      if((x2-x3)<180*16) T->SetArc((int)x3,(int)(x2-x3));
      else T->SetArc((int)x2,(int)(x3-x2+360*16));
    }
    T->SetWidth(2);
    C->AddItem(T);
   }
   else if(s.contains("TEXT")){
    *S >> x1;
    *S >> y1;
    *S >> x2;
    x1=x1*30;
    x2=x2*20;
    y1=y1*30;
    *S >> s;
    p=s.indexOf(0x27,1);
    while(p<0){
     *S >> s1;
     s+="_"+s1;
     p=s.indexOf(0x27,1);
    }
    s1=s.mid(1,p-1);
    SetLy("PrBody");
    PicText * T=new PicText(Lay);
    T->MoveTo((int)x1,(int)y1);
    T->SetAlig(0,2);
//    QFont F("Helvetica",(int)x2);
    QFont F(DEFAULT_FONT,(int)x2);
    T->SetFont(F);
    T->RotateTo(0);
    T->SetText(s1);
    C->AddItem(T);
   }
   else if(s.contains("END")){
    i=5;
   }
  }
  else{
//   printf("%s\n",(const char *)s);
  }
 }
 if(i>0) return false;
 return true;
}



