/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ImpExp_included
#define ImpExp_included

#include "Global.h"
#include "PicEl.h"
#include "PicGrp.h"
#include "PicPComp.h"
#include "DbPcb.h"
#include "DbSch.h"
#include "Layers.h"

#include <QString>
#include <QStringList>
#include <QFile>
//Added by qt3to4:
#include <QTextStream>

#define MaxLT 50
#define MAXPAD 100
#define MAXAPR 256

class ImpExp
{

struct LyTrans {
  QString N1;
  QString N2;
  int r;
  int g;
  int b;
  int r1;
  int g1;
  int b1;
  unsigned long int Ly;
};


public:

 ImpExp();
 virtual ~ImpExp();

 bool ImportPdf(DbPcb * Db, QTextStream * S,int flag=0);
 bool ImportPdf(PicPComp * Db, QTextStream * S);

protected:

 bool ReadPdfSec(PicGrp * G, QString s, QTextStream * S,int tr=0,int mir=0);
 bool ReadPinSec(PicGrp * G, QString s, QTextStream * S);
 bool SkipPdfSec(QTextStream * S);
 bool ReadCompSec(PComp * C, QTextStream * S);

 bool ReadPdfSet(QString s, QTextStream * S,Layers * Lay);
 bool ReadStr(QString &s, QTextStream * S);

 void SetLy(QString name,Layers * Lay);
 bool ReadLTT(QString name,Layers * Lay);

 bool ReadPadTab(QTextStream * S,int flag);

 bool ReadAprTab(QString name);

private:

 int Wd;
 int Ts;
 int TjH;
 int TjV;
 int Tr;
 int Tm;

// Layers * Lay;

 LyTrans LT[MaxLT];
 int NLT;

 QString PadTab[MAXPAD];

 int AprDTab[MAXAPR];
 int AprTTab[MAXAPR];


};


#define BufLen 1000

class OrcImpExp
{
public:

 OrcImpExp();
 virtual ~OrcImpExp();

 bool ImportSdt(DbSch * Db, QFile * F,int flag=0);
 bool ImportLib(QTextStream * S,int flag=0,PicGrp ** Co=NULL, Layers * L=NULL);
 bool ExportSdt(DbSch * Db, QFile * F,int flag=0);

 void SetDirName(QString n);
private:

 void SetLy(QString name);
 void SetLy(QString name,QString name1);
 void GetPoint(QPoint *l,unsigned char * buf,int pos);
 int  Get16(unsigned char *buf,int offset);
 QString GetStr(unsigned char *buf,int offset);
 void PutPoint(QPoint *l,unsigned char * buf,int pos);
 void Put16(unsigned char *buf,int offset, int val);
 void PutStr(unsigned char *buf,int offset,QString str);


 int sdt_read_lib_ref(QFile * F, long stream_bytes);
 int SdtWire(DbSch * Db,unsigned char * buf,int type,int size);
 int SdtLine(DbSch * Db,unsigned char * buf,int type,int size);
 int SdtLabel(DbSch * Db,unsigned char * buf,int type,int size);
 int SdtComp(DbSch * Db,unsigned char * buf,int type,int size);
 int SdtJunction(DbSch * Db,unsigned char * buf,int type,int size);
 int SdtPower(DbSch * Db,unsigned char * buf,int type,int size);
 int SdtText(DbSch * Db,unsigned char * buf,int type,int size);

 int ExpPicGrp(PicGrp * G, QFile * F,int flag,QPoint offset);
 int ExpTitle(char * buf);

 int ExpSdtWire(PicLine * L,unsigned char * buf,QPoint offset);
 int ExpSdtLabel(PicText * T,unsigned char * buf,QPoint offset);
 int ExpSdtJunction(PicCir * T,unsigned char * buf,QPoint offset);
 int ExpSdtPower(PicPower * T,unsigned char * buf,QPoint offset);
 int ExpSdtComp(SComp * C,unsigned char * buf,QPoint offset);


 bool LibSkipComm(QTextStream * S);

 QStringList LibNames;

 char *sdt_lib_ref_names;
 char **sdt_lib_ref;
 int sdt_lib_ref_cnt;
 int sdt_part_cnt;

 Layers * Lay;
 unsigned char buf[BufLen];
 
 QString DirName;

};

#endif
