/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ImpPComp_included
#define ImpPComp_included

#include "Global.h"
#include "PicEl.h"
#include "PicGrp.h"
#include "PicPComp.h"
#include "DbPcb.h"
#include "DbSch.h"
#include "Layers.h"

#include <QString>
#include <QStringList>
#include <QFile>
//Added by qt3to4:
#include <QTextStream>

#define MaxLT 50
#define MAXPAD 100
#define MAXAPR 256

class ImpPComp
{
public:

 ImpPComp();
 virtual ~ImpPComp();

 int Import(QTextStream * S);
 PicPComp * ImportOne(QTextStream * S,QString & name,Layers & Ly,int fl);
 void SetDirName(QString n);

private:

 void Rotate(int &x,int &y,int angle);
 void Rotate(int &x,int &y,int x1,int y1,int angle);

 void CreatePad(Layers & Ly,QString name,int angle);

 void ProcCmd(QString & cmd,PicPComp * P,Layers & Ly,QString s,int angle);

 void AddPad(PicPComp * C,Layers & Ly,int n,int x,int y,int r,QString name,int angle);
 void Pad(PicPComp * P,Layers & Ly,QString s,int angle);
 void Pads(PicPComp * P,Layers & Ly,QString s,int angle);
 void Bga1(PicPComp * P,Layers & Ly,QString s,int angle);
 void Bga2(PicPComp * P,Layers & Ly,QString s,int angle);
 void Drill(PicPComp * P,Layers & Ly,QString s,int angle);
 void Circ(PicPComp * P,Layers & Ly,QString s,int angle);
 void Rect(PicPComp * P,Layers & Ly,QString s,int angle);
 void Line(PicPComp * P,Layers & Ly,QString s,int angle);
 void Arc(PicPComp * P,Layers & Ly,QString s,int angle);
 void Body(PicPComp * P,Layers & Ly,QString s,int angle);
 void BodyR(PicPComp * P,Layers & Ly,QString s,int angle);
 void BodyL(PicPComp * P,Layers & Ly,QString s,int angle);
 void BodyC(PicPComp * P,Layers & Ly,QString s,int angle);


 QString GetParam(QString & p,char sep);
 void Save(PicGrp *P,Layers & Ly,QString name);
 void RmComm(QString & s);

protected:

 QString DirName;
};

#endif
