/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "InfoBarr.h"
#include "ActButt.h"
#include "KeyMap.h"

#include <QPushButton>
#include <QEvent>
#include <QPixmap>
#include <QWidget>
#include <QRect>
#include <QPainter>
#include <QString>
#include <QValidator>

//Added by qt3to4:
#include <QPaintEvent>
#include <QResizeEvent>
#include <QLabel>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>


InfoBarr::InfoBarr( QWidget *parent)
 :  QWidget(parent)
{
 setMinimumSize(300,44);
 setMaximumSize(2000,44);

 X=0;
 Y=0;
 GX=10;
 GY=10;
 GX2=1;
 GY2=1;
 GrV=false;
 Gr=true;
 ActL=0;
 ActM=0;
 SelML=0;
 SelMM=0;
 SelBML=0;
 SelBMM=0;
 ZoomTL=0;
 ZoomTM=0;
 VWinTL=0;
 VWinTM=0;
 LineML=0;
 LineMM=0;
 MulF=1;

// QIntValidator * iv= new QIntValidator(-32767,23767,this);

 QFont LEFont=QFont( "Times", 10 );
 QFont CBFont=QFont( "Fixed", 7 );
 QFont LBFont=QFont( "Times", 12 );

 LEX= new QLineEdit(this);
 LEX->setGeometry(width()-60,2,40,16);
// LEX->setValidator(iv);
 LEX->setFont(QFont( "Times", 10 ));

 LEY= new QLineEdit(this);
 LEY->setGeometry(width()-60,22,40,16);
// LEY->setValidator(iv);
 LEY->setFont(QFont( "Times", 10 ));

 BL= new QPushButton("L",this);
 BL->setGeometry(width()-18,2,16,16);
 connect( BL, SIGNAL(clicked()), this, SLOT(PresL()) );

 BM= new QPushButton("M",this);
 BM->setGeometry(width()-18,2,16,16);
 connect( BM, SIGNAL(clicked()), this, SLOT(PresM()) );

 LEGX= new QLineEdit(this);
 LEGX->setFont(QFont( "Times", 10 ));
 LEGX->setText("10");
// connect( LEGX, SIGNAL(textChanged(const char *)), this, SLOT(SetGX(const char *)) );
 connect( LEGX, SIGNAL(textChanged(const QString&)), this, SLOT(SetGX(const QString&)) );


 LEGY= new QLineEdit(this);
 LEGY->setFont(QFont( "Times", 10 ));
 LEGY->setText("10");
// connect( LEGY, SIGNAL(textChanged(const char *)), this, SLOT(SetGY(const char *)) );
 connect( LEGY, SIGNAL(textChanged(const QString&)), this, SLOT(SetGY(const QString&)) );

 LEGX2= new QLineEdit(this);
 LEGX2->setFont(QFont( "Times", 10 ));
 LEGX2->setText("1");
// connect( LEGX, SIGNAL(textChanged(const char *)), this, SLOT(SetGX(const char *)) );
 connect( LEGX2, SIGNAL(textChanged(const QString&)), this, SLOT(SetGX2(const QString&)) );


 LEGY2= new QLineEdit(this);
 LEGY2->setFont(QFont( "Times", 10 ));
 LEGY2->setText("1");
// connect( LEGY, SIGNAL(textChanged(const char *)), this, SLOT(SetGY(const char *)) );
 connect( LEGY2, SIGNAL(textChanged(const QString&)), this, SLOT(SetGY2(const QString&)) );

 BG= new QCheckBox("Gr",this);
 connect( BG, SIGNAL(toggled(bool)), this, SLOT(SetGr(bool)) );
 BG->setChecked(true);

 BGV= new QCheckBox("GV",this);
 connect( BGV, SIGNAL(toggled(bool)), this, SLOT(SetGV(bool)) );

 BFP= new QCheckBox("Fill Poly",this);
 connect( BFP, SIGNAL(toggled(bool)), this, SLOT(ChangeSettings()) );

 BSnaP= new QCheckBox("Snap Pin",this);
 BInfo= new QCheckBox("Show Info",this);

 Metric= new QCheckBox("Metric",this);
 Metric2= new QCheckBox("AltMetric",this);
 AltGr= new QCheckBox("Alt Grid",this);

 CBSelML= new QComboBox(this);
// CBSelML->insertStrList(SelMode);
 CBSelML->insertItem(1,"Normal");
 CBSelML->insertItem(2,"Sel Act");
 CBSelML->insertItem(3,"Only Act");
 CBSelML->setFont(CBFont);
 connect( CBSelML, SIGNAL( activated ( int )), this, SLOT(SetSelML(int)) );

 CBSelMM= new QComboBox(this);
// CBSelMM->insertStrList(SelMode);
 CBSelMM->insertItem(1,"Normal");
 CBSelMM->insertItem(2,"Sel Act");
 CBSelMM->insertItem(3,"Only Act");
 CBSelMM->setFont(CBFont);
 connect( CBSelMM, SIGNAL( activated ( int )), this, SLOT(SetSelMM(int)) );

 CBSelBML= new QComboBox(this);
// CBSelBML->insertStrList(SelBMode);
 CBSelBML->insertItem(1,"All");
 CBSelBML->insertItem(2,"Partial");
 CBSelBML->insertItem(3,"and Points");
 CBSelBML->setFont(CBFont);
 connect( CBSelBML, SIGNAL( activated ( int )), this, SLOT(SetSelBML(int)) );

 CBSelBMM= new QComboBox(this);
// CBSelBMM->insertStrList(SelBMode);
 CBSelBMM->insertItem(1,"All");
 CBSelBMM->insertItem(2,"Partial");
 CBSelBMM->insertItem(3,"and Points");
 CBSelBMM->setFont(CBFont);
 connect( CBSelBMM, SIGNAL( activated ( int )), this, SLOT(SetSelBMM(int)) );

 CBZoomTL= new QComboBox(this);
// CBZoomTL->insertStrList(ZoomT);
 CBZoomTL->insertItem(1,"Zoom Normal");
 CBZoomTL->insertItem(2,"To Center");
 CBZoomTL->setFont(CBFont);
 connect( CBZoomTL, SIGNAL( activated ( int )), this, SLOT(SetZoomTL(int)) );

 CBZoomTM= new QComboBox(this);
// CBZoomTM->insertStrList(ZoomT);
 CBZoomTM->insertItem(1,"Zoom Normal");
 CBZoomTM->insertItem(2,"To Center");
 CBZoomTM->setFont(CBFont);
 connect( CBZoomTM, SIGNAL( activated ( int )), this, SLOT(SetZoomTM(int)) );

 CBVWinTL= new QComboBox(this);
// CBVWinTL->insertStrList(VWinT);
 CBVWinTL->insertItem(1,"Normal");
 CBVWinTL->insertItem(2,"Half Screen");
 CBVWinTL->setFont(CBFont);
 connect( CBVWinTL, SIGNAL( activated ( int )), this, SLOT(SetVWinTL(int)) );

 CBVWinTM= new QComboBox(this);
// CBVWinTM->insertStrList(VWinT);
 CBVWinTM->insertItem(1,"Normal");
 CBVWinTM->insertItem(2,"Half Screen");
 CBVWinTM->setFont(CBFont);
 connect( CBVWinTM, SIGNAL( activated ( int )), this, SLOT(SetVWinTM(int)) );

 CBLineML= new QComboBox(this);
// CBLineML->insertStrList(LineM);
 CBLineML->insertItem(1,"Single");
 CBLineML->insertItem(2,"Continuous");
 CBLineML->setFont(CBFont);
 connect( CBLineML, SIGNAL( activated ( int )), this, SLOT(SetLineML(int)) );

 CBLineMM= new QComboBox(this);
// CBLineMM->insertStrList(LineM);
 CBLineMM->insertItem(1,"Single");
 CBLineMM->insertItem(2,"Continuous");
 CBLineMM->setFont(CBFont);
 connect( CBLineMM, SIGNAL( activated ( int )), this, SLOT(SetLineMM(int)) );

 CBLineTL= new QComboBox(this);
// CBLineTL->insertStrList(LineT);
 CBLineTL->insertItem(1,"Any");
 CBLineTL->insertItem(2,"Orto");
 CBLineTL->insertItem(3,"Diag1");
 CBLineTL->insertItem(4,"Diag2");
 CBLineTL->insertItem(5,"OrtoDiag"); 
 CBLineTL->setFont(CBFont);

 CBLineTM= new QComboBox(this);
// CBLineTM->insertStrList(LineT);
 CBLineTM->insertItem(1,"Any");
 CBLineTM->insertItem(2,"Orto");
 CBLineTM->insertItem(3,"Diag1");
 CBLineTM->insertItem(4,"Diag2");
 CBLineTM->insertItem(5,"OrtoDiag"); 
 CBLineTM->setFont(CBFont);


 CBWidL= new QComboBox(this);
 CBWidL->setEditable(true);
 CBWidL->setFont(CBFont);
// CBWidL->insertStrList(Wid);
 CBWidL->insertItem(1,"12");
 CBWidL->insertItem(2,"60");
 CBWidL->insertItem(3,"8");
 CBWidL->insertItem(4,"0");
 CBWidL->insertItem(5,"2000");
 CBWidL->setInsertPolicy(QComboBox::InsertAtTop);

 CBWidM= new QComboBox(this);
 CBWidM->setEditable(true);
 CBWidM->setFont(CBFont);
// CBWidM->insertStrList(Wid);
 CBWidM->insertItem(1,"12");
 CBWidM->insertItem(2,"60");
 CBWidM->insertItem(3,"8");
 CBWidM->insertItem(4,"0");
 CBWidM->insertItem(5,"2000");
 CBWidM->setInsertPolicy(QComboBox::InsertAtTop);

 Lb1L= new QLabel(this);
 Lb1L->setFont(LBFont);
 Lb1M= new QLabel(this);
 Lb1M->setFont(LBFont);

 Lb2L= new QLabel(this);
 Lb2L->setFont(LBFont);
 Lb2M= new QLabel(this);
 Lb2M->setFont(LBFont);

 Lb3L= new QLabel(this);
 Lb3L->setFont(LBFont);
 Lb3M= new QLabel(this);
 Lb3M->setFont(LBFont);

 BBolL= new QCheckBox("B",this);
 BBolL->setFont(QFont( "Times", 12 ,true));
 BBolM= new QCheckBox("B",this);
 BBolM->setFont(QFont( "Times", 12 ,true));
 BItL= new QCheckBox("I",this);
 BItL->setFont(QFont( "Times", 12 ,false,true));
 BItM= new QCheckBox("I",this);
 BItM->setFont(QFont( "Times", 12 ,false,true));

 CBFonL= new QComboBox(this);
 CBFonL->setEditable(true);
 CBFonL->setFont(CBFont);
// CBFonL->insertStrList(Fon);
 CBFonL->insertItem(1,"Times");
 CBFonL->insertItem(2,"Helvetica");
 CBFonL->insertItem(3,"Courier");
 CBFonL->insertItem(4,"Arial"); 
 CBFonL->setInsertPolicy(QComboBox::InsertAtTop);

 CBFonM= new QComboBox(this);
 CBFonM->setEditable(true);
 CBFonM->setFont(CBFont);
// CBFonM->insertStrList(Fon);
 CBFonM->insertItem(1,"Times");
 CBFonM->insertItem(2,"Helvetica");
 CBFonM->insertItem(3,"Courier");
 CBFonM->insertItem(4,"Arial"); 
 CBFonM->setInsertPolicy(QComboBox::InsertAtTop);

 CBFSizL= new QComboBox(this);
 CBFSizL->setEditable(true);
 CBFSizL->setFont(CBFont);
// CBFSizL->insertStrList(FSiz);
 CBFSizL->insertItem(1,"24");
 CBFSizL->insertItem(2,"17");
 CBFSizL->insertItem(3,"12");
 CBFSizL->setInsertPolicy(QComboBox::InsertAtTop);

 CBFSizM= new QComboBox(this);
 CBFSizM->setEditable(true);
 CBFSizM->setFont(CBFont);
// CBFSizM->insertStrList(FSiz);
 CBFSizM->insertItem(1,"24");
 CBFSizM->insertItem(2,"17");
 CBFSizM->insertItem(3,"12");
 CBFSizM->setInsertPolicy(QComboBox::InsertAtTop);

 CBHAlL= new QComboBox(this);
// CBHAlL->insertStrList(HAl);
 CBHAlL->insertItem(1,"Left");
 CBHAlL->insertItem(2,"Center");
 CBHAlL->insertItem(3,"Right"); 
 CBHAlL->setFont(CBFont);

 CBHAlM= new QComboBox(this);
// CBHAlM->insertStrList(HAl);
 CBHAlM->insertItem(1,"Left");
 CBHAlM->insertItem(2,"Center");
 CBHAlM->insertItem(3,"Right"); 
 CBHAlM->setFont(CBFont);

 CBVAlL= new QComboBox(this);
// CBVAlL->insertStrList(VAl);
 CBVAlL->insertItem(1,"Top");
 CBVAlL->insertItem(2,"Center");
 CBVAlL->insertItem(3,"Bottom");
 CBVAlL->setFont(CBFont);
 CBVAlL->setCurrentIndex(2);

 CBVAlM= new QComboBox(this);
// CBVAlM->insertStrList(VAl);
 CBVAlM->insertItem(1,"Top");
 CBVAlM->insertItem(2,"Center");
 CBVAlM->insertItem(3,"Bottom");
 CBVAlM->setFont(CBFont);
 CBVAlM->setCurrentIndex(2);

 CBAtrL= new QComboBox(this);
// CBAtrL->insertStrList(Atr);
 CBAtrL->insertItem(1,"REF");
 CBAtrL->insertItem(2,"VAL");
 CBAtrL->insertItem(3,"SUBV");
 CBAtrL->insertItem(4,"COMM");
 CBAtrL->insertItem(5,"PKG");
 CBAtrL->setFont(CBFont);

 CBAtrM= new QComboBox(this);
// CBAtrM->insertStrList(Atr);
 CBAtrM->insertItem(1,"REF");
 CBAtrM->insertItem(2,"VAL");
 CBAtrM->insertItem(3,"SUBV");
 CBAtrM->insertItem(4,"COMM");
 CBAtrM->insertItem(5,"PKG");
 CBAtrM->setFont(CBFont);

 CBCNamL= new QComboBox(this);
 CBCNamL->setEditable(true);
 CBCNamL->setFont(CBFont);
// CBCNamL->insertStrList(CNam);
 CBCNamL->insertItem(1,"R");
 CBCNamL->insertItem(2,"C");
 CBCNamL->insertItem(3,"D");
 CBCNamL->setInsertPolicy(QComboBox::InsertAtTop);

 CBCNamM= new QComboBox(this);
 CBCNamM->setEditable(true);
 CBCNamM->setFont(CBFont);
// CBCNamM->insertStrList(CNam);
 CBCNamM->insertItem(1,"R");
 CBCNamM->insertItem(2,"C");
 CBCNamM->insertItem(3,"D");
 CBCNamM->setInsertPolicy(QComboBox::InsertAtTop);

 CBOriL= new QComboBox(this);
// CBOriL->insertStrList(Ori);
 CBOriL->insertItem(1,"0");
 CBOriL->insertItem(2,"90");
 CBOriL->insertItem(3,"180");
 CBOriL->insertItem(4,"270");
 CBOriL->setFont(CBFont);

 CBOriM= new QComboBox(this);
// CBOriM->insertStrList(Ori);
 CBOriM->insertItem(1,"0");
 CBOriM->insertItem(2,"90");
 CBOriM->insertItem(3,"180");
 CBOriM->insertItem(4,"270");
 CBOriM->setFont(CBFont);

 CBRL= new QComboBox(this);
 CBRL->setEditable(true);
 CBRL->setFont(CBFont);
// CBRL->insertStrList(R);
 CBRL->insertItem(1,"0");
 CBRL->insertItem(2,"4");
 CBRL->insertItem(3,"10");
 CBRL->insertItem(4,"60");
 CBRL->insertItem(5,"100");
 CBRL->setInsertPolicy(QComboBox::InsertAtTop);

 CBRM= new QComboBox(this);
 CBRM->setEditable(true);
 CBRM->setFont(CBFont);
// CBRM->insertStrList(R);
 CBRM->insertItem(1,"0");
 CBRM->insertItem(2,"4");
 CBRM->insertItem(3,"10");
 CBRM->insertItem(4,"60");
 CBRM->insertItem(5,"100");
 CBRM->setInsertPolicy(QComboBox::InsertAtTop);

 CBCirML= new QComboBox(this);
// CBCirML->insertStrList(CirM);
 CBCirML->insertItem(1,"Cir");
 CBCirML->insertItem(2,"Arc");
 CBCirML->setFont(CBFont);

 CBCirMM= new QComboBox(this);
// CBCirMM->insertStrList(CirM);
 CBCirMM->insertItem(1,"Cir");
 CBCirMM->insertItem(2,"Arc");
 CBCirMM->setFont(CBFont);

 CBCopyML= new QComboBox(this);
 CBCopyML->insertItem(1,"Normal");
 CBCopyML->insertItem(2,"To Clipboard");
 CBCopyML->insertItem(3,"From Clipboard");
 CBCopyML->setFont(CBFont);

 CBCopyMM= new QComboBox(this);
 CBCopyMM->insertItem(1,"Normal");
 CBCopyMM->insertItem(2,"To Clipboard");
 CBCopyMM->insertItem(3,"From Clipboard");
 CBCopyMM->setFont(CBFont);

 CBPTypeL= new QComboBox(this);
 CBPTypeL->insertItem(1,"Circle");
 CBPTypeL->insertItem(2,"Arrow");
 CBPTypeL->insertItem(3,"Bar");
 CBPTypeL->insertItem(4,"Wave");
 CBPTypeL->setFont(CBFont);

 CBPTypeM= new QComboBox(this);
 CBPTypeM->insertItem(1,"Circle");
 CBPTypeM->insertItem(2,"Arrow");
 CBPTypeM->insertItem(3,"Bar");
 CBPTypeM->insertItem(4,"Wave");
 CBPTypeM->setFont(CBFont);

 CBPolyNL= new QComboBox(this);
 CBPolyNL->setEditable(true);
 CBPolyNL->setFont(CBFont);
 CBPolyNL->setInsertPolicy(QComboBox::InsertAtTop);

 CBPolyNM= new QComboBox(this);
 CBPolyNM->setEditable(true);
 CBPolyNM->setFont(CBFont);
 CBPolyNM->setInsertPolicy(QComboBox::InsertAtTop);

 CBPolyCL= new QComboBox(this);
 CBPolyCL->setEditable(true);
 CBPolyCL->setFont(CBFont);
 CBPolyCL->setInsertPolicy(QComboBox::InsertAtTop);

 CBPolyCM= new QComboBox(this);
 CBPolyCM->setEditable(true);
 CBPolyCM->setFont(CBFont);
 CBPolyCM->setInsertPolicy(QComboBox::InsertAtTop);
}

InfoBarr::~InfoBarr()
{
}

QString InfoBarr::GetParam(QString & p)
{
  QString s;
  int i;
  if(!p.contains(',')){
    s=p;
    p="";
    return s;
  }
  i=p.indexOf(',');
  s=p.left(i);
  p.remove(0,i+1);
  return s;
}

void InfoBarr::Set(int fn,QString p)
{
  QString s;
  int b=Qt::LeftButton;
  int x;
  Qt::CheckState st;
  s=GetParam(p);
  if((s=="L") || (s=="M")){
    if(s=="M") b=Qt::MidButton;
    s=GetParam(p);
  }
  if(fn==fnSetWd){
    if(b==Qt::LeftButton) CBWidL->setEditText(s);
    else CBWidM->setEditText(s);
  }
  else if(fn==fnSetRadius){
    if(b==Qt::LeftButton) CBRL->setEditText(s);
    else CBRM->setEditText(s);
  }
  else if(fn==fnSetFont){
    if(b==Qt::LeftButton) CBFonL->setEditText(s);
    else CBFonM->setEditText(s);
    s=GetParam(p);
    if(!s.isEmpty()){
      if(b==Qt::LeftButton) CBFSizL->setEditText(s);
      else CBFSizM->setEditText(s);
    }
    s=GetParam(p);
    if(!s.isEmpty()){
      st=Qt::Unchecked;
      if(s.contains("B",Qt::CaseInsensitive)) st=Qt::Checked;
      if(b==Qt::LeftButton) BBolL->setCheckState(st);
      else BBolM->setCheckState(st);
    }
    s=GetParam(p);
    if(!s.isEmpty()){
      st=Qt::Unchecked;
      if(s.contains("I",Qt::CaseInsensitive)) st=Qt::Checked;
      if(b==Qt::LeftButton) BItL->setCheckState(st);
      else BItM->setCheckState(st);
    }
    s=GetParam(p);
    if(!s.isEmpty()){
      x=0;
      if(s.contains("Cent",Qt::CaseInsensitive)) x=1;
      if(s.contains("Right",Qt::CaseInsensitive)) x=2;
      if(b==Qt::LeftButton) CBHAlL->setCurrentIndex(x);
      else CBHAlM->setCurrentIndex(x);
    }
    s=GetParam(p);
    if(!s.isEmpty()){
      x=0;
      if(s.contains("Cent",Qt::CaseInsensitive)) x=1;
      if(s.contains("Bot",Qt::CaseInsensitive)) x=2;
      if(b==Qt::LeftButton) CBVAlL->setCurrentIndex(x);
      else CBVAlM->setCurrentIndex(x);
    }
  }
  else if(fn==fnSetOrient){
    x=0;
    if(s.contains("90",Qt::CaseInsensitive)) x=1;
    if(s.contains("180",Qt::CaseInsensitive)) x=2;
    if(s.contains("270",Qt::CaseInsensitive)) x=3;
    if(b==Qt::LeftButton) CBOriL->setCurrentIndex(x);
    else CBOriM->setCurrentIndex(x);
  }
  else if(fn==fnSetLineType){
    x=0;
    if(s.contains("Orto",Qt::CaseInsensitive)) x=1;
    if(s.contains("Diag1",Qt::CaseInsensitive)) x=2;
    if(s.contains("Diag2",Qt::CaseInsensitive)) x=3;
    if(s.contains("OrtoDiag",Qt::CaseInsensitive)) x=4;
    if(b==Qt::LeftButton) CBLineTL->setCurrentIndex(x);
    else CBLineTM->setCurrentIndex(x);
  }
  else if(fn==fnSetLineMode){
    x=0;
    if(s.contains("Cont",Qt::CaseInsensitive)) x=1;
    if(b==Qt::LeftButton){
      CBLineML->setCurrentIndex(x);
      SetLineML(x);
    }  
    else{
      CBLineMM->setCurrentIndex(x);
      SetLineMM(x);
    }
  }
  else if(fn==fnSetPwrType){
    x=0;
    if(s.contains("Arrow",Qt::CaseInsensitive)) x=1;
    if(s.contains("Bar",Qt::CaseInsensitive)) x=2;
    if(s.contains("Wave",Qt::CaseInsensitive)) x=3;
    if(b==Qt::LeftButton) CBPTypeL->setCurrentIndex(x);
    else CBPTypeM->setCurrentIndex(x);
  }
  else if(fn==fnSetCopyMode){
    x=0;
    if(s.contains("To",Qt::CaseInsensitive)) x=1;
    if(s.contains("From",Qt::CaseInsensitive)) x=2;
    if(b==Qt::LeftButton) CBCopyML->setCurrentIndex(x);
    else CBCopyMM->setCurrentIndex(x);
  }
  else if(fn==fnSetSelMode){
    x=0;
    if(s.contains("Act",Qt::CaseInsensitive)) x=1;
    if(s.contains("Only",Qt::CaseInsensitive)) x=2;
    if(b==Qt::LeftButton){
      CBSelML->setCurrentIndex(x);
      SetSelML(x);
    }
    else{
      CBSelMM->setCurrentIndex(x);
      SetSelMM(x);
    }
  }
  else if(fn==fnSetBlSelMode){
    x=0;
    if(s.contains("Part",Qt::CaseInsensitive)) x=1;
    if(s.contains("Point",Qt::CaseInsensitive)) x=2;
    if(b==Qt::LeftButton){
      CBSelBML->setCurrentIndex(x);
      SetSelBML(x);
    }
    else{
      CBSelBMM->setCurrentIndex(x);
      SetSelBMM(x);
    }
  }
  else if(fn==fnAltGrid){
    if(AltGr->isChecked()) st=Qt::Unchecked;
    else st=Qt::Checked;
    AltGr->setCheckState(st);
  }
}

void InfoBarr::SetMulF(int f)
{
  MulF=f;
}

int InfoBarr::GetMulF()
{
  return MulF;
}


void InfoBarr::SetActL(int a)
{
 ActL=a;
 Arrange();
}

void InfoBarr::SetActM(int a)
{
 ActM=a;
 Arrange();
}


void InfoBarr::SetXY(int x,int y)
{
 X=x;
 Y=y;
 QString s;
 bool m;
 if(AltGr->isChecked()) m=Metric2->isChecked();
 else m=Metric->isChecked();

 if(m) s.setNum(0.01*roundf((float)(-Y)*2.54/MulF));
 else s.setNum((float)(-Y)/MulF);
 LEY->setText(s);
 if(m)  s.setNum(0.01*roundf((float)(X)*2.54/MulF));
 else  s.setNum((float)(X)/MulF);
 LEX->setText(s);
// update();
}

void InfoBarr::SetOri(int Butt,int O)
{
 if(Butt==Qt::LeftButton){
  CBOriL->setCurrentIndex((4-O) & 3);
 }
 else{
  CBOriM->setCurrentIndex((4-O) & 3);
 }
}


float InfoBarr::GetGX()
{
 if(AltGr->isChecked()){
  if(Metric2->isChecked()) return GX2*MulF/0.0254;
  else return GX2*MulF;
 }
 else{
  if(Metric->isChecked()) return GX*MulF/0.0254;
  else return GX*MulF;
 } 
}

float InfoBarr::GetGY()
{
 if(AltGr->isChecked()){
  if(Metric2->isChecked()) return GY2*MulF/0.0254;
  else return GY2*MulF;
 }
 else{
  if(Metric->isChecked()) return GY*MulF/0.0254;
  else return GY*MulF;
 }
}

bool InfoBarr::IsVisGr()
{
 return GrV;
}

bool InfoBarr::IsOnGr()
{
 return Gr;
}

bool InfoBarr::IsOnFP()
{
  return BFP->isChecked();
}

bool InfoBarr::IsOnSnaP()
{
  return BSnaP->isChecked();
}

bool InfoBarr::IsOnInfo()
{
  return BInfo->isChecked();
}

int InfoBarr::GetSelML()
{
 return SelML;
}
int InfoBarr::GetSelMM()
{
 return SelMM;
}

int InfoBarr::GetSelBML()
{
 return SelBML;
}
int InfoBarr::GetSelBMM()
{
 return SelBMM;
}


int InfoBarr::GetZoomTL()
{
 return ZoomTL;
}
int InfoBarr::GetZoomTM()
{
 return ZoomTM;
}

int InfoBarr::GetVWinTL()
{
 return VWinTL;
}
int InfoBarr::GetVWinTM()
{
 return VWinTM;
}

int InfoBarr::GetLineML()
{
 return LineML;
}
int InfoBarr::GetLineMM()
{
 return LineMM;
}

int InfoBarr::GetLineTL()
{
 return CBLineTL->currentIndex();
}
int InfoBarr::GetLineTM()
{
 return CBLineTM->currentIndex();
}


int InfoBarr::GetWidL()
{
 QString s;
 s=CBWidL->currentText();
 return s.toFloat()*MulF;
}

int InfoBarr::GetWidM()
{
 QString s;
 s=CBWidM->currentText();
 return s.toFloat()*MulF;
}

QFont InfoBarr::GetFonL()
{
 QString s;
 s=CBFSizL->currentText();
 int siz=s.toInt();
 int w;
 if(BBolL->isChecked()) w=QFont::Bold;
 else w=QFont::Normal;
 QFont F(CBFonL->currentText(),siz,w,BItL->isChecked());
 F.setRawMode(false);
 return F;
}

QFont InfoBarr::GetFonM()
{
 QString s;
 s=CBFSizM->currentText();
 int siz=s.toInt();
 int w;
 if(BBolM->isChecked()) w=QFont::Bold;
 else w=QFont::Normal;
 QFont F(CBFonM->currentText(),siz,w,BItM->isChecked());
 F.setRawMode(false);
 return F;
}

int InfoBarr::GetHAlL()
{
 return CBHAlL->currentIndex();
}
int InfoBarr::GetHAlM()
{
 return CBHAlM->currentIndex();
}
int InfoBarr::GetVAlL()
{
 return CBVAlL->currentIndex();
}
int InfoBarr::GetVAlM()
{
 return CBVAlM->currentIndex();
}

int InfoBarr::GetAtrL()
{
 return CBAtrL->currentIndex();
}
int InfoBarr::GetAtrM()
{
 return CBAtrM->currentIndex();
}

QString InfoBarr::GetCNam(int Butt)
{
 if (Butt==Qt::LeftButton) return CBCNamL->currentText();
 else return CBCNamM->currentText();
}

void InfoBarr::SetCName(QString n)
{
  if(CBCNamL->isVisible()) CBCNamL->setEditText(n);
  if(CBCNamM->isVisible()) CBCNamM->setEditText(n);
}

int InfoBarr::GetOriL()
{
 return (4-CBOriL->currentIndex())&3;
}
int InfoBarr::GetOriM()
{
 return (4-CBOriM->currentIndex())&3;
}

int InfoBarr::GetRL()
{
 QString s;
 s=CBRL->currentText();
 return s.toFloat()*MulF;
}

int InfoBarr::GetRM()
{
 QString s;
 s=CBRM->currentText();
 return s.toFloat()*MulF;
}

int InfoBarr::GetCirML()
{
 return CBCirML->currentIndex();
}
int InfoBarr::GetCirMM()
{
 return CBCirMM->currentIndex();
}

int InfoBarr::GetCopyML()
{
 return CBCopyML->currentIndex();
}
int InfoBarr::GetCopyMM()
{
 return CBCopyMM->currentIndex();
}

int InfoBarr::GetPTypeL()
{
 return CBPTypeL->currentIndex();
}
int InfoBarr::GetPTypeM()
{
 return CBPTypeM->currentIndex();
}

QString InfoBarr::GetPolyNL()
{
 return CBPolyNL->currentText();
}
QString InfoBarr::GetPolyNM()
{
 return CBPolyNM->currentText();
}

int InfoBarr::GetPolyCL()
{
 return CBPolyCL->currentText().toFloat()*MulF;
}
int InfoBarr::GetPolyCM()
{
 return CBPolyCM->currentText().toFloat()*MulF;
}

void InfoBarr::PresL()
{
 bool m;
 if(AltGr->isChecked()) m=Metric2->isChecked();
 else m=Metric->isChecked();

 QString st=LEX->text();
 if(m) X=st.toFloat()*MulF/0.0254;
 else  X=st.toFloat()*MulF;
 st=LEY->text();
 if(m) Y=-st.toFloat()*MulF/0.0254;
 else  Y=-st.toFloat()*MulF;
 QPoint p(X,Y);
 Press(p,Qt::LeftButton);
}

void InfoBarr::PresM()
{
 bool m;
 if(AltGr->isChecked()) m=Metric2->isChecked();
 else m=Metric->isChecked();

 QString st=LEX->text();
 if(m) X=st.toFloat()*MulF/0.0254;
 else  X=st.toFloat()*MulF;
 st=LEY->text();
 if(m) Y=-st.toFloat()*MulF/0.0254;
 else  Y=-st.toFloat()*MulF;
 QPoint p(X,Y);
 Press(p,Qt::MidButton);
}

//void InfoBarr::SetGX(const char * s)
void InfoBarr::SetGX(const QString &s)
{
 bool ok;
// QString st=s;
 GX=s.toFloat(&ok);
}

void InfoBarr::SetGX2(const QString &s)
{
 bool ok;
// QString st=s;
 GX2=s.toFloat(&ok);
}

//void InfoBarr::SetGY(const char * s)
void InfoBarr::SetGY(const QString &s)
{
 bool ok;
// QString st=s;
 GY=s.toFloat(&ok);
}

void InfoBarr::SetGY2(const QString &s)
{
 bool ok;
// QString st=s;
 GY2=s.toFloat(&ok);
}

void InfoBarr::SetGr(bool on)
{
 Gr=on;
}

void InfoBarr::SetGV(bool on)
{
 GrV=on;
 Change();
}

void InfoBarr::ChangeSettings()
{
  Change();
}

void InfoBarr::SetSelML(int m)
{
 SelML=m;
}

void InfoBarr::SetSelMM(int m)
{
 SelMM=m;
}

void InfoBarr::SetSelBML(int m)
{
 SelBML=m;
}

void InfoBarr::SetSelBMM(int m)
{
 SelBMM=m;
}

void InfoBarr::SetZoomTL(int m)
{
 ZoomTL=m;
}

void InfoBarr::SetZoomTM(int m)
{
 ZoomTM=m;
}

void InfoBarr::SetVWinTL(int m)
{
 VWinTL=m;
}

void InfoBarr::SetVWinTM(int m)
{
 VWinTM=m;
}

void InfoBarr::SetLineML(int m)
{
 LineML=m;
}

void InfoBarr::SetLineMM(int m)
{
 LineMM=m;
}


void InfoBarr::paintEvent( QPaintEvent * /*e*/)
{
 QPainter paint( this );

 QRect r;

 paint.setFont(QFont( "Times", 12 ));
 r.setRect(width()-90,2,20,16);
 paint.drawText(r,Qt::AlignCenter,"X:");
 r.setRect(width()-90,22,20,16);
 paint.drawText(r,Qt::AlignCenter,"Y:");

/* QString s;
 s.setNum(Y);
 paint.setPen(black);
 r.setRect(width()-80,5,70,30);
 paint.drawText(r,AlignCenter,s);

 s.setNum(X);
 paint.setPen(black);
 r.setRect(width()-160,5,70,30);
 paint.drawText(r,AlignCenter,s);
 */
}

void InfoBarr::resizeEvent ( QResizeEvent * /*e*/)
{
 int a=0;
 if(MulF!=1) a=30;

 LEX->setGeometry(width()-65,2,40,16);
 LEY->setGeometry(width()-65,22,40,16);
 BL->setGeometry(width()-20,2,16,16);
 BM->setGeometry(width()-20,22,16,16);

 LEGX->setGeometry(width()-120-a,2,25,16);
 LEGY->setGeometry(width()-120-a,22,25,16);
 BG->setGeometry(width()-300-a,2,40,16);
 BGV->setGeometry(width()-260-a,2,40,16);
 BFP->setGeometry(width()-300-a,22,85,16);

 BSnaP->setGeometry(width()-210-a,2,85,16);
 BInfo->setGeometry(width()-210-a,22,85,16);

 if(MulF==1){
   Metric->hide();
   Metric2->hide();
   AltGr->hide();
   LEGX2->hide();
   LEGY2->hide();
 }
 else{
   Metric->setGeometry(width()-380-a,22,70,16);
   Metric->show();
   Metric2->setGeometry(width()-380-a,2,70,16);
   Metric2->show();
   AltGr->setGeometry(width()-460-a,2,70,16);
   AltGr->show();
   LEGX2->setGeometry(width()-120,2,25,16);
   LEGY2->setGeometry(width()-120,22,25,16);
   LEGX2->show();
   LEGY2->show();
 }

 Arrange();
}


void InfoBarr::Arrange()
{
 int x=10;
 int y1=2;
 int y2=18;
 Lb1L->hide();
 Lb2L->hide();
 Lb3L->hide();


 if(ActL & kIBSelM){
  CBSelML->setGeometry(x,y1,65,y2);
  x+=70;
  CBSelML->show();
 } else CBSelML->hide();

 if(ActL & kIBSelBM){
  CBSelBML->setGeometry(x,y1,85,y2);
  x+=90;
  CBSelBML->show();
 } else CBSelBML->hide();

 if(ActL & kIBZoomT){
  CBZoomTL->setGeometry(x,y1,85,y2);
  x+=90;
  CBZoomTL->show();
 } else CBZoomTL->hide();

 if(ActL & kIBVWinT){
  CBVWinTL->setGeometry(x,y1,85,y2);
  x+=90;
  CBVWinTL->show();
 } else CBVWinTL->hide();

 if(ActL & kIBLineM){
  CBLineML->setGeometry(x,y1,85,y2);
  x+=90;
  CBLineML->show();
 }
 else {
  CBLineML->hide();
 }

 if(ActL & kIBLineT){
  CBLineTL->setGeometry(x,y1,85,y2);
  x+=90;
  CBLineTL->show();
 }
 else {
  CBLineTL->hide();
 }

 if(ActL & kIBWid){
  Lb1L->setGeometry(x,y1,30,y2);
  x+=35;
  CBWidL->setGeometry(x,y1-2,65,y2);
  x+=70;
  CBWidL->show();
  Lb1L->setText("Wd:");
  Lb1L->show();
 }
 else CBWidL->hide();

 if(ActL & kIBFont){
  CBFonL->setGeometry(x,y1-2,85,y2);
  x+=90;
  CBFonL->show();
  CBFSizL->setGeometry(x,y1-2,55,y2);
  x+=60;
  CBFSizL->show();
  BBolL->setGeometry(x,y1,30,y2);
  x+=35;
  BBolL->show();
  BItL->setGeometry(x,y1,30,y2);
  x+=35;
  BItL->show();
  CBHAlL->setGeometry(x,y1,55,y2);
  x+=60;
  CBHAlL->show();
  CBVAlL->setGeometry(x,y1,55,y2);
  x+=60;
  CBVAlL->show();
 }
 else {
  CBFonL->hide();
  CBFSizL->hide();
  BBolL->hide();
  BItL->hide();
  CBHAlL->hide();
  CBVAlL->hide();
 }

/* if(ActL & kIBAtr){
  CBAtrL->setGeometry(x,y1,65,y2);
  x+=70;
  CBAtrL->show();
 }
 else */
 CBAtrL->hide(); 

 if(ActL & kIBCNam){
  CBCNamL->setGeometry(x,y1-2,95,y2);
  x+=100;
  CBCNamL->show();
 }
 else CBCNamL->hide();

 if(ActL & kIBOri){
  CBOriL->setGeometry(x,y1,45,y2);
  x+=50;
  CBOriL->show();
 }
 else CBOriL->hide();

 if(ActL & kIBR){
  Lb2L->setGeometry(x,y1,25,y2);
  x+=30;
  CBRL->setGeometry(x,y1-2,65,y2);
  x+=70;
  CBRL->show();
  Lb2L->setText("R:");
  Lb2L->show();
 }
 else CBRL->hide();

 if(ActL & kIBCirM){
  CBCirML->setGeometry(x,y1,45,y2);
  x+=50;
  CBCirML->show();
 }
 else CBCirML->hide();

 if(ActL & kIBCopyM){
  CBCopyML->setGeometry(x,y1,95,y2);
  x+=100;
  CBCopyML->show();
 }
 else CBCopyML->hide();

 if(ActL & kIBPType){
  CBPTypeL->setGeometry(x,y1,75,y2);
  x+=80;
  CBPTypeL->show();
 }
 else CBPTypeL->hide();

 if(ActL & kIBPolyN){
  Lb2L->setGeometry(x,y1,30,y2);
  x+=35;
  Lb2L->setText("Net:");
  Lb2L->show();
  CBPolyNL->setGeometry(x,y1,75,y2);
  x+=80;
  CBPolyNL->show();
  Lb3L->setGeometry(x,y1,30,y2);
  x+=35;
  Lb3L->setText("Clr:");
  Lb3L->show();
  CBPolyCL->setGeometry(x,y1,55,y2);
  x+=60;
  CBPolyCL->show();
 }
 else{
  CBPolyNL->hide();
  CBPolyCL->hide();
 } 

 y1+=22;
 x=10;
 Lb1M->hide();
 Lb2M->hide();
 Lb3M->hide();

 if(ActM & kIBSelM){
  CBSelMM->setGeometry(x,y1,65,y2);
  x+=70;
  CBSelMM->show();
 } else CBSelMM->hide();

 if(ActM & kIBSelBM){
  CBSelBMM->setGeometry(x,y1,85,y2);
  x+=90;
  CBSelBMM->show();
 } else CBSelBMM->hide();

 if(ActM & kIBZoomT){
  CBZoomTM->setGeometry(x,y1,85,y2);
  x+=90;
  CBZoomTM->show();
 } else CBZoomTM->hide();

 if(ActM & kIBVWinT){
  CBVWinTM->setGeometry(x,y1,85,y2);
  x+=90;
  CBVWinTM->show();
 } else CBVWinTM->hide();

 if(ActM & kIBLineM){
  CBLineMM->setGeometry(x,y1,85,y2);
  x+=90;
  CBLineMM->show();
 }
 else {
  CBLineMM->hide();
 }

 if(ActM & kIBLineT){
  CBLineTM->setGeometry(x,y1,85,y2);
  x+=90;
  CBLineTM->show();
 }
 else {
  CBLineTM->hide();
 }

 if(ActM & kIBWid){
  Lb1M->setGeometry(x,y1,30,y2);
  x+=35;
  Lb1M->setText("Wd:");
  Lb1M->show();
  CBWidM->setGeometry(x,y1-2,65,y2);
  x+=70;
  CBWidM->show();
 }
 else CBWidM->hide();

 if(ActM & kIBFont){
  CBFonM->setGeometry(x,y1-2,85,y2);
  x+=90;
  CBFonM->show();
  CBFSizM->setGeometry(x,y1-2,55,y2);
  x+=60;
  CBFSizM->show();
  BBolM->setGeometry(x,y1,30,y2);
  x+=35;
  BBolM->show();
  BItM->setGeometry(x,y1,30,y2);
  x+=35;
  BItM->show();
  CBHAlM->setGeometry(x,y1,55,y2);
  x+=60;
  CBHAlM->show();
  CBVAlM->setGeometry(x,y1,55,y2);
  x+=60;
  CBVAlM->show();
 }
 else {
  CBFonM->hide();
  CBFSizM->hide();
  BBolM->hide();
  BItM->hide();
  CBHAlM->hide();
  CBVAlM->hide();
 }

/* if(ActM & kIBAtr){
  CBAtrM->setGeometry(x,y1,65,y2);
  x+=70;
  CBAtrM->show();
 }
 else  */
 CBAtrM->hide();

 if(ActM & kIBCNam){
  CBCNamM->setGeometry(x,y1-2,95,y2);
  x+=100;
  CBCNamM->show();
 }
 else CBCNamM->hide();

 if(ActM & kIBOri){
  CBOriM->setGeometry(x,y1,45,y2);
  x+=50;
  CBOriM->show();
 }
 else CBOriM->hide();

 if(ActM & kIBR){
  Lb2M->setGeometry(x,y1,25,y2);
  x+=30;
  CBRM->setGeometry(x,y1-2,65,y2);
  x+=70;
  CBRM->show();
  Lb2M->setText("R:");
  Lb2M->show();
 }
 else CBRM->hide();


 if(ActM & kIBCirM){
  CBCirMM->setGeometry(x,y1,45,y2);
  x+=50;
  CBCirMM->show();
 }
 else CBCirMM->hide();

 if(ActM & kIBCopyM){
  CBCopyMM->setGeometry(x,y1,95,y2);
  x+=100;
  CBCopyMM->show();
 }
 else CBCopyMM->hide();

 if(ActM & kIBPType){
  CBPTypeM->setGeometry(x,y1,75,y2);
  x+=80;
  CBPTypeM->show();
 }
 else CBPTypeM->hide();

 if(ActM & kIBPolyN){
  Lb2M->setGeometry(x,y1,30,y2);
  x+=35;
  Lb2M->setText("Net:");
  Lb2M->show();
  CBPolyNM->setGeometry(x,y1,75,y2);
  x+=80;
  CBPolyNM->show();
  Lb3M->setGeometry(x,y1,30,y2);
  x+=35;
  Lb3M->setText("Clr:");
  Lb3M->show();
  CBPolyCM->setGeometry(x,y1,55,y2);
  x+=60;
  CBPolyCM->show();
 }
 else{
  CBPolyNM->hide();
  CBPolyCM->hide();
 } 
}

QComboBox *  InfoBarr::GetCBAtrL()
{
 return CBAtrL;
}

QComboBox *  InfoBarr::GetCBAtrM()
{
 return CBAtrM;
}
