/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Error.h"
#include "Global.h"
#include "Layers.h"
#include <stdlib.h>
//#include <qtstream.h>
//Added by qt3to4:
#include <QTextStream>

extern Errors gErr;

Layers::Layers()
{
 int i;
 int j;
 Exist=0;
 Wir=0;
 Rts=0;
 Mir=0;
 Act=0;
 
 Ref=0;
 Val=0;
 SVal=0;
 Comm=0;
 Print=0;
 
/* Name=(char *)calloc(6*32,sizeof(char));*/
 for(i=0;i<32;i++){
  Colors[i]=NULL;
  HLCol[i]=NULL;
  for(j=0;j<LyLEN;j++) Name[i][j]=' ';
  Name[i][j]=0;
  Level[i]=0;
  Pair[i]=0;
 }
}

Layers::~Layers()
{
}

unsigned long int Layers::Add(int r,int g,int b,char N[LyLEN])
{
 int i;
 int j;
 unsigned long int t;

 i=0;
 t=1;
 while(t & Exist){
  i++;
  t=t*2;
 };
 Colors[i]=new QColor(r,g,b);
 //Colors[i]->setLazyAlloc(false);
 //Colors[i]->setRgb(r,g,b);
// Colors[i]->alloc();
 Colors[i]->setRgb(r,g,b);
 for(j=0;j<LyLEN;j++) Name[i][j]=N[j];
 Exist=Exist|t;
 Change();
 return t;
}

void Layers::SetVis(unsigned long int L)
{
 Vis=L;
 Change();
}

void Layers::SetEn(unsigned long int L)
{
 En=L;
 Change();
}

void Layers::SetAct(unsigned long int L)
{
 if ((L & Vis)==L) Act=L;
 else {
  unsigned long int t;
  unsigned long int t1=1;
  t=L-(L & Vis);
  QString s="Layer ";
  s+=GetName(t);
  s+=" is not Visible\n\nSet it Visible ?";
  while (!(t1 & t)) t1=t1*2;
  if (gErr.YesNoWarn(s)){
   AddVis(t1);
   Act=t1;
   SetAct(L);
  }
 }
 Change();
}

void Layers::SetAct(const char * name)
{
 unsigned long int t=1;
 int i=0;
 int j;
 do{
  j=0;
  while(j<LyLEN && name[j]==Name[i][j] && name[j]!=0) j++;
  if (j==LyLEN || Name[i][j]==' '){
   SetAct(t);
   return;
  }
  t=t*2;
  i++;
 }while (t>1);
}

void Layers::SetAct(const QString & name)
{
 printf("Layers:SetAct %s\n",name.toLatin1().data());
 SetAct(name.left(6).toLatin1().data());
}

void Layers::SetActNext(int d)
{
  unsigned long int t=Act;
  if(d>0){
    do{
      t=t<<1;
      if(t==0) t=1;
    }while((t & Vis)!=t);
    SetAct(t);
  }  
  if(d<0){
    do{
      t=t>>1;
      if(t==0) t=0x80000000;
    }while((t & Vis)!=t);
    SetAct(t);
  }
}

void Layers::SetVis(const char * name)
{
 unsigned long int t=1;
 int i=0;
 int j;
 do{
  j=0;
  while(j<LyLEN && name[j]==Name[i][j] && name[j]!=0) j++;
  if (j==LyLEN || Name[i][j]==' '){
   SetVis(t);
   return;
  }
  t=t*2;
  i++;
 }while (t>1);
}

void Layers::AddVis(const char * name)
{
 unsigned long int t=1;
 int i=0;
 int j;
 do{
  j=0;
  while(j<LyLEN && name[j]==Name[i][j] && name[j]!=0) j++;
  if (j==LyLEN || Name[i][j]==' '){
   AddVis(t);
   return;
  }
  t=t*2;
  i++;
 }while (t>1);
}



void Layers::AddVis(unsigned long int L)
{
 Vis=Vis|L;
 Change();
 VisChange();
}

void Layers::AddAct(unsigned long int L)
{
 SetAct(GetAct()|L);
 Change();
}

void Layers::AddEn(unsigned long int L)
{
 En=En|L;
 Change();
}

void Layers::AddDef(unsigned long int L)
{
 if(!(L & Exist)){
  int i;
  unsigned long int t;
  i=0;
  t=1;
  do {
   if(t & L){
    if (Colors[i]==NULL) Colors[i]=new QColor(0,0,0);
    if (HLCol[i]==NULL) HLCol[i]=new QColor(0,0,0);
    Exist=Exist|t;
   }
   t=t*2;
   i++;
  } while(t>1);
  Change();
  VisChange();
 }
}


void Layers::DelVis(unsigned long int L)
{
 if (!(L & Act)){
  Vis=Vis &(L^AllLy);
  Change();
  VisChange();
 }
 else {
  unsigned long int t;
  t=(L & Act);
  QString s="Layer ";
  s+=GetName(t);
  s+=" is Active\nDo not set unvisible";
  gErr.Warn(s);
  Change();
 }
}

void Layers::DelAct(unsigned long int L)
{
 SetAct(Act&(L^AllLy));
 Change();
}


void Layers::DelEn(unsigned long int L)
{
 En=En &(L^AllLy);
 Change();
}

void Layers::DelDef(unsigned long int L)
{
 unsigned long int t=1;
 int i=0;
 Exist=Exist &(L^AllLy);
 Act=Act &(L^AllLy);
 Vis=Vis &(L^AllLy);
 do{
  if(t & L){
   Pair[i]=0;
  }
  i++;
  t=t*2;
 }while(t>1);
 for(i=0;i<32;i++) Level[i]&=(L^AllLy);
 Change();
}

bool Layers::IsAct(unsigned long int L)
{
 return ((L & Act)!=0);
}

bool Layers::IsEn(unsigned long int L)
{
 return ((L & En)!=0);
}

bool Layers::IsVis(unsigned long int L)
{
 return ((L & Vis)!=0);
}

bool Layers::IsDef(unsigned long int L)
{
 return ((L & Exist)!=0);
}

bool Layers::IsWir(unsigned long int L)
{
 return ((L & Wir)!=0);
}

bool Layers::IsRts(unsigned long int L)
{
 return ((L & Rts)!=0);
}

unsigned long int Layers::GetAct()
{
 return Act;
}

unsigned long int Layers::GetDef()
{
 return Exist;
}

bool Layers::IsDef(QString * name)
{
 int i;
 unsigned long int t=1;
 char N[6];

 for(i=0;i<name->length();i++){
  N[i]=name->at(i).toLatin1();
 }

 while(i<LyLEN) {
  N[i]=' ';
  i++;
 }
 do{
  if (t & Exist) {
   if (CmpName(N,t)) return true;
  }
  t=t*2;
 }while(t>1);
 return false;
}

unsigned long int Layers::GetLy(QString * name)
{
 int i;
 unsigned long int t=1;
 char N[6];


 for(i=0;i<name->length();i++){
  N[i]=name->at(i).toLatin1();
 }

 while(i<LyLEN) {
  N[i]=' ';
  i++;
 }

 do{
  if (t & Exist) {
   if (CmpName(N,t)) return(t);
  }
  t=t*2;
 }while(t>1);
 return(Add(0,0,0,N));
}

unsigned long int Layers::GetRts()
{
 unsigned long int t=1;
 do{
  if(t & Rts) return t;
  t=t*2;
 }while(t>1);
 return 0;
}



bool Layers::CmpName(char N[LyLEN],unsigned long int L)
{
  int i=0;
  unsigned long int t=1;
  while(!(t & L)){
   i++;
   t=t*2;
  };
  int j;
  for(j=0;j<LyLEN;j++) if(Name[i][j]!=N[j]) return false;
  return true;
}

void Layers::SetAlpha(int a)
{
  int i;
  for(i=0;i<32;i++){
    if(Colors[i]) Colors[i]->setAlpha(a);
  }
}

bool Layers::GetColor(QColor** col,unsigned long int L,int Mir)
{
 int i;
 unsigned long int t;

 if(Mir) L=MirLy(L);

 if (L & Exist){
  i=0;
  t=1;
  while(!(t & L)){
   i++;
   t=t*2;
  };
  *col=(Colors[i]);
  if (L & Vis) return 1;
  else return 0;
 }
 else return 0;

}

bool Layers::GetHLColor(QColor** col,unsigned long int L,int Mir)
{
 int i;
 unsigned long int t;

 if(Mir) L=MirLy(L);

 if (L & Exist){
  i=0;
  t=1;
  while(!(t & L)){
   i++;
   t=t*2;
  };
  *col=(HLCol[i]);
  if (L & Vis) return 1;
  else return 0;
 }
 else return 0;

}


bool Layers::GetVisColor(QColor** col,unsigned long int L,int Mir)
{
 int i;
 unsigned long int t;

 if(Mir) L=MirLy(L);

 if (L & Exist & Vis & (Act ^ AllLy)){
  i=0;
  t=1;
  while(!(t & L & Vis & Exist)){
   i++;
   t=t*2;
  };
  *col=(Colors[i]);
  return 1;
 }
 else return 0;
}

bool Layers::GetActColor(QColor** col,unsigned long int L,int Mir)
{
 int i;
 unsigned long int t;

 if(Mir) L=MirLy(L);

 if (L & Exist & Act){
  i=0;
  t=1;
  while(!(t & L & Act & Exist)){
   i++;
   t=t*2;
  };
  *col=(Colors[i]);
  return 1;
 }
 else return 0;
}


void Layers::SetColor(unsigned long int L,int r,int g,int b)
{
 int i=0;
 unsigned long int t=1;
// printf("SetColor : %d %d %d\n",r,g,b);
 do {
  if(t & L){
   if(Colors[i]==NULL){
    Colors[i]=new QColor(r,g,b);
   } else {
    Colors[i]->setRgb(r,g,b);
   }
   Change();
   VisChange();
  }
  i++;
  t=t*2;
 } while (t>1);
}


void Layers::SetHLColor(unsigned long int L,int r,int g,int b)
{
 int i=0;
 unsigned long int t=1;
// printf("SetHLColor : %d %d %d\n",r,g,b);
 do {
  if(t & L){
   if(HLCol[i]==NULL){
    HLCol[i]=new QColor(r,g,b);
//    HLCol[i]->alloc();
    HLCol[i]->setRgb(r,g,b);
   } else {
    HLCol[i]->setRgb(r,g,b);
   }
//   Change();
//   VisChange();
  }
  i++;
  t=t*2;
 } while (t>1);
}


const char* Layers::GetName(unsigned long int L)
{
 int i;
 unsigned long int t;

 if (L & Exist){
  i=0;
  t=1;
  while(!(t & L)){
   i++;
   t=t*2;
  };
  return Name[i];
 }
 else return("NoName");
}

void Layers::SetName(unsigned long int L,char N[LyLEN])
{
 int i=0;
 int j;
 unsigned long int t=1;

 while(!(t & L)){
  i++;
  t=t*2;
 }
 for(j=0;j<LyLEN;j++) Name[i][j]=N[j];
 Change();
}

int Layers::GetActType()
{
  return GetType(Act);
}

int Layers::GetType(unsigned long int L)
{
 if(L & Wir) return 1;
 if(L & Rts) return 2;
 if(L & Ref) return 3;
 if(L & Val) return 4;
 if(L & SVal) return 5;
 if(L & Comm) return 6;
 if(L & Print) return 7;
 return 0;
}

unsigned long int Layers::GetWire()
{
  return Wir;
}

unsigned long int Layers::GetPrint()
{
  return Print;
}

unsigned long int Layers::GetAtrLy()
{
  return Ref | Val | SVal | Comm;
}


void Layers::SetType(unsigned long int L,int t)
{
 Wir=Wir &(L^AllLy);
 Rts=Rts &(L^AllLy);
 Ref=Ref &(L^AllLy);
 Val=Val &(L^AllLy);
 SVal=SVal &(L^AllLy);
 Comm=Comm &(L^AllLy);
 Print=Print &(L^AllLy);
 if(t==1){
  Wir=Wir|L;
 }
 else if(t==2){
  Rts=Rts|L;
 }
 else if(t==3){
  Ref=Ref|L;
 }
 else if(t==4){
  Val=Val|L;
 }
 else if(t==5){
  SVal=SVal|L;
 }
 else if(t==6){
  Comm=Comm|L;
 }
 else if(t==7){
  Print=Print|L;
 }
}

void Layers::SetPair(QString na,QString pna)
{
 int i;
 unsigned long int t;
 unsigned long int t1;
 unsigned long int t2;

 t1=GetLy(&na);

 i=0;
 t=1;
 while(!(t & t1)){
  i++;
  t=t*2;
 }
 t2=GetLy(&pna);
 Pair[i]=t2;

 i=0;
 t=1;
 while(!(t & t2)){
  i++;
  t=t*2;
 }
 Pair[i]=t1;
}

void Layers::SetPair(int n,int p)
{
 if(p<0){
  Pair[n]=0;
  return;
 }
 unsigned long int t=1;
 while(p){
  t=t*2;
  p--;
 }
 Pair[n]=t;
}

/*void Layers::SetMir(int M)
{
 Mir=M;
}

void Layers::Mirror()
{
 if(Mir) Mir=0;
 else Mir=1;
}*/

unsigned long int Layers::MirLy(unsigned long int L)
{
 int i=0;
 unsigned long int t=1;
 unsigned long int p=0;
 do{
  if(IsDef(t) && (t & L)){
   if(Pair[i]) p=p | Pair[i];
   else p=p | t;
  }
  i++;
  t=t*2;
 } while(t>1);
 return p;
}

unsigned long int Layers::PairLy(unsigned long int L)
{
 int i=0;
 unsigned long int t=1;
 while (!(t & L)){
  i++;
  t=t*2;
 }
 return Pair[i];
}

const char* Layers::GetPairN(unsigned long int t)
{
 return(GetName(PairLy(t)));
}

QString Layers::GetLevels(unsigned long int L)
{
 int i=0;
 QString s;
 QString o;
 for(i=0;i<32;i++){
   if(L & Level[i]){
     s.setNum(i);
     if(!o.isEmpty()) o+=',';
     o+=s;
   }
 }
 return o;
}

unsigned long int Layers::GetLyLevel(int t)
{
 return Level[t];
}

void Layers::SetLevel(unsigned long int L,int t)
{
  Level[t]=L;
}

void Layers::AddLevel(unsigned long int L,int t)
{
  Level[t]|=L;
}

bool Layers::IsConnect(unsigned long int L,unsigned long int L1)
{
  int i;

  for(i=0;i<32;i++){
    if((L & Wir & Level[i]) && (L1 & Wir & Level[i])) return true;
  }
  return false;
}


void Layers::Store()
{
 int i;
 int j;

 SD[0]=Exist;
 SD[1]=Vis;
 SD[2]=En;
 SD[3]=Act;
 SD[4]=Wir;
 SD[5]=Rts;

 for(i=0;i<32;i++){
  for(j=0;j<LyLEN;j++){
   SName[i][j]=Name[i][j];
  }
  SPair[i]=Pair[i];
  if(Colors[i]) Colors[i]->getRgb(&SC[i][0],&SC[i][1],&SC[i][2]);
  if(HLCol[i]) HLCol[i]->getRgb(&SCH[i][0],&SCH[i][1],&SCH[i][2]);
 }
}

void Layers::ReStore()
{
 int i;
 int j;

 Exist=SD[0];
 Vis=SD[1];
 En=SD[2];
 Act=SD[3];
 Wir=SD[4];
 Rts=SD[5];

 for(i=0;i<32;i++){
  for(j=0;j<LyLEN;j++){
   Name[i][j]=SName[i][j];
  }
  Pair[i]=SPair[i];
  if(Colors[i]) Colors[i]->setRgb(SC[i][0],SC[i][1],SC[i][2]);
  if(HLCol[i]) HLCol[i]->setRgb(SCH[i][0],SCH[i][1],SCH[i][2]);
 }
}


void Layers::TextSave(QTextStream * S,bool Pcb)
{
 unsigned long int t=1;
 int i=0;

 if (Pcb) *S << "{LayerP\n";
 else *S << "{Layer\n";
 do {
  if (IsDef(t)){
   *S << " {Ly " << GetName(t) << "\n";
   *S << "  {Col " << Colors[i]->red() << " "
      << Colors[i]->green() << " " << Colors[i]->blue() <<" }\n";
   if(HLCol[i]){
    *S << "  {HLC " << HLCol[i]->red() << " "
       << HLCol[i]->green() << " " << HLCol[i]->blue() <<" }\n";
   }
   *S << "  {Stat " << IsVis(t) << " "
      << IsAct(t) << " " << IsEn(t) <<" "
      << GetType(t) <<" "<< GetLevels(t) <<" }\n";
   *S << " }\n" ;
  }
  i++;
  t=t*2;
 } while (t>1);
 t=1;
 i=0;
 do {
  if(IsDef(t) && Pair[i]){
   *S << " {Pair " << GetName(t) << " " << GetName(Pair[i]) << " }\n";
  }
  i++;
  t=t*2;
 } while (t>1);

 *S << "}\n" ;
}

void Layers::TextLoad(QTextStream * S)
{
  unsigned long int t=1;
//  unsigned long int t1=1;
  QString s;
  QString s1;
  QString pna;
  int p=1;
  char na[LyLEN+1];
  int r,g,b;
  int hr=0,hg=0,hb=0;
  int v,a,e;
  int lev[32];
  int tt=0;
  int i;
  int j;

  *S >> s;
  while (p>0 && !S->atEnd()){
   if (s.contains("Ly")){
    p++;
    *S >> na;
    i=strlen(na);
    while (i<LyLEN) na[i++]=' ';
    na[i]=0;
   }
   else if (s.contains("Col")){
    *S >> r;
    *S >> g;
    *S >> b;

     *S >> s1;
    while(!s1.contains('}')){
      *S >> s1;
    }
   }
   else if (s.contains("HLC")){
    *S >> hr;
    *S >> hg;
    *S >> hb;

     *S >> s1;
    while(!s1.contains('}')){
      *S >> s1;
    }
   }
   else if (s.contains("Stat")){
    *S >> v;
    *S >> a;
    *S >> e;
    *S >> s1;
    if (!s1.contains('}')){
     tt=s1.toInt();
     *S >> s1;
    }
    else tt=0;
    for(j=0;j<32;j++) lev[j]=0;
    if (!s1.contains('}')){
     j=0;
     while(s1.contains(',')){
       lev[j]=s1.left(s1.indexOf(',')).toInt();
       s1.remove(0,s1.indexOf(',')+1);
       j++;
     }
     lev[j]=s1.toInt();
     *S >> s1;
    }

    while(!s1.contains('}')){
      *S >> s1;
    }
   }
   else if (s.contains("Pair")){
    if(p==1){
     *S >> s1;
     *S >> pna;
     SetPair(s1,pna);

    }
     *S >> s1;
    while(!s1.contains('}')){
      *S >> s1;
    }
   }
   else if (s.contains("}")){
    p--;
    if (p==1){
     t=1;
     for(i=0;i<32;i++){
      if(IsDef(t)){
       j=0;
       while (j<LyLEN && na[j]==Name[i][j]) j++;
       if (j==LyLEN) i=33;
      }
      t=t*2;
     }
     if (i==32){
      t=Add(r,g,b,na);
      if (v) AddVis(t);
      else DelVis(t);
      if (a) AddAct(t);
      else DelAct(t);
      if (e) AddEn(t);
      else DelEn(t);
      SetType(t,tt);
      for(j=0;j<32;j++) if(lev[j]) AddLevel(t,lev[j]);
      SetHLColor(t,hr,hg,hb);
      hr=0;
      hg=0;
      hb=0;
     }
    }
   }
   else {

     *S >> s1;
    while(!s1.contains('}')){
      *S >> s1;
    }
   }
   if (p) *S >> s;
  }
}
