/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "ColSel.h"
#include "LyEdit.h"

#include "Global.h"
#include "PicEl.h"
#include "PicObj.h"
#include "PicGrp.h"
#include "Layers.h"
#include "Dlg.h"

#include <QLineEdit>
#include <QCheckBox>
#include <QPainter>
#include <QFont>
#include <QEvent>
#include <QTextStream>
#include <QFile>
//#include <qiodev.h>

//Added by qt3to4:
#include <QPaintEvent>
#include <QLabel>
#include <QMouseEvent>

#include <stdio.h>
#include <stdlib.h>

//extern Layers *Layer;

LySelWdg::LySelWdg(Layers *L, QWidget *parent )
        : QWidget( parent )
{
 Layer=L;
 XOfs=0;
 QFontMetrics FM( QFont("fixed",12) );
 wid=FM.width("XXXXXX")+10;
 connect( &*Layer, SIGNAL(Change()),this, SLOT(LyChange()) );

}

void LySelWdg::LyChange()
{
 update();
}

void LySelWdg::paintEvent( QPaintEvent * e)
{
    QPainter paint( this );

//    int i;
    QRect r;
    r=e->rect();

    paint.translate(XOfs,0);

//    r=paint.xFormDev(r);
    QRegion region = QRegion(r) * paint.combinedTransform().inverted();
    r = region.boundingRect();
    paint.setFont(QFont("fixed",12));
    r.setRect(0,0,wid,19);
    unsigned long int t=1;
    do{
     if(Layer->IsDef(t)){
      QColor * col;
      if(Layer->GetColor(&col,t)){
       if (Layer->IsAct(t)){
        paint.setBrush(*col);
       }
       else {
        paint.setBrush(Qt::white);
       }
      }
      else {
       paint.setBrush(Qt::NoBrush);
      }
      paint.setPen(Qt::black);
      paint.drawRect(r);
      if(!Layer->IsAct(t))paint.setPen(*col);
      paint.drawText(r,Qt::AlignCenter,Layer->GetName(t));
      r.translate(wid,0);
     }
     t=t*2;
    } while (t>1);

}

void LySelWdg::mousePressEvent ( QMouseEvent *e )
{

 button=e->button();
 QPoint p;
 p=e->pos();

/*
 QPainter paint;
 paint.begin(this);
 paint.translate(XOfs,0);
 p=paint.xFormDev(p);
 paint.end();
*/
 Move=false;
 
 if (button!=Qt::RightButton){

  Px=p.x();

 } else {

 }
}

void LySelWdg::mouseReleaseEvent ( QMouseEvent *e )
{

 QPoint p;
 p=e->pos();

/*
 QPainter paint;
 paint.begin(this);
 paint.translate(XOfs,0);
 p=paint.xFormDev(p);
 paint.end();
*/

 if (e->button()!=Qt::RightButton){

  if(!Move){
   int i=(Px-XOfs)/wid+1;
   unsigned long int t=1;
   do{
    if(Layer->IsDef(t)){
     i--;
     if(i==0 && button==Qt::LeftButton) Layer->SetAct(t);
     if(i==0 && button==Qt::MidButton){
      if (Layer->IsVis(t)) Layer->DelVis(t);
      else Layer->AddVis(t);
     }
    }
    t=t*2;
   } while (t>1);
//   update();
  }
 } else {
//  LyDlg* Dl= new LyDlg(&*Layer);
//  Dl->show();
  LyDlgM* Dl= new LyDlgM(&*Layer);
  Dl->show();
 }
}

void LySelWdg::mouseMoveEvent ( QMouseEvent *e )
{

 QPoint p;
 p=e->pos();

/*
 QPainter paint;
 paint.begin(this);
 paint.translate(XOfs,0);
 p=paint.xFormDev(p);
 paint.end();
*/
 if (Move || (button==Qt::LeftButton && ((Px-p.x())>5 || (Px-p.x())<-5))){
  XOfs=XOfs-5*(Px-p.x());
  Px=p.x();
  if (XOfs>0) XOfs=0;
  if (XOfs<-(32*wid-width())) XOfs=-(32*wid-width());
  Move=true;
  update();
 }
}

//------------------------------------------------------------


LyInterf::LyInterf()
{
  Lay=NULL;
  Ly=0;
  No=-1;
}

LyInterf::LyInterf(Layers *L,unsigned long int t)
{
  Lay=L;
  Ly=t;

  No=0;
  unsigned long int t1=1;
  do{
   No++;
   t1=t1*2;
  }while(!(t&t1) && t1>1);
}

LyInterf::~LyInterf()
{
}

void LyInterf::SetLy(unsigned long int L)
{
  Ly=L;
}

void LyInterf::SetLayers(Layers* L)
{
  Lay=L;
}

void LyInterf::SetName(const char * Na)
{
 char N[6];
 int i=0;
 while(Na[i]!=0 && i<6){
  N[i]=Na[i];
  i++;
 }
 while(i<6){
  N[i]=' ';
  i++;
 }
 Lay->SetName(Ly,N);
}

void LyInterf::SetCol(int r, int g,int b)
{
 Lay->SetColor(Ly,r,g,b);
}

void LyInterf::Act (bool on)
{
  if(on) Lay->AddAct(Ly);
  else Lay->DelAct(Ly);
}
void LyInterf::Vis (bool on)
{
  if(on) Lay->AddVis(Ly);
  else Lay->DelVis(Ly);
}

void LyInterf::Co (bool /*on*/)
{
}

void LyInterf::On (bool on)
{
 if(on) Lay->AddDef(Ly);
 else Lay->DelDef(Ly);
}

void LyInterf::Type (int t)
{
 Lay->SetType(Ly,t);
}


//--------------------------------------------------------------


LyDlg::LyDlg( Layers* L,QWidget *parent )
        : QDialog( parent )
{
 Ly=L;
 setMinimumSize( 600, 500 );
 setMaximumSize( 600, 500 );

 QPushButton* Ok;
 Ok = new QPushButton( "OK", this);
 Ok->setGeometry( width()-85, height()-35, 75, 30 );
 Ok->setFont( QFont( "Times", 18, QFont::Bold ) );
 connect( Ok, SIGNAL(clicked()),this, SLOT(End()) );

 int i;
 unsigned long int t=1;
 QString s;

 QLabel*     La;

 for(i=0;i<32;i++){
  int y=(i%16)*25;
  int x=(i/16)*300;

  LyIn[i]= new LyInterf(L,t);

  s.setNum(i);
  La=new QLabel(s,this);
  La->setGeometry(10+x,y+30,20,20);

  Le[i]=new QLineEdit(this);
  Le[i]->setGeometry(x+50,y+30,50,20);
   connect( Le[i],SIGNAL(textChanged(const char *)),LyIn[i],SLOT(SetName(const char *)));

  CbEx[i]=new QCheckBox(this);
  CbEx[i]->setGeometry(x+30,y+35,10,10);
   connect( CbEx[i],SIGNAL(toggled(bool)),LyIn[i],SLOT(On(bool)));

  CbVis[i]=new QCheckBox(this);
  CbVis[i]->setGeometry(x+110,y+35,10,10);
   connect( CbVis[i],SIGNAL(toggled(bool)),LyIn[i],SLOT(Vis(bool)));

  CbAct[i]=new QCheckBox(this);
  CbAct[i]->setGeometry(x+130,y+35,10,10);
   connect( CbAct[i],SIGNAL(toggled(bool)),LyIn[i],SLOT(Act(bool)));

  CBTyp[i]=new QComboBox(this);
  CBTyp[i]->setGeometry(x+180,y+30,70,20);
//  CBTyp[i]->insertStrList(LyTyp);
  CBTyp[i]->insertItem(1,"NORM");
  CBTyp[i]->insertItem(2,"WIRE");
  CBTyp[i]->insertItem(3,"RTS");
  CBTyp[i]->setFont(QFont( "Times", 10 ));
   connect( CBTyp[i],SIGNAL(activated(int)),LyIn[i],SLOT(Type(int)));


  t=t*2;
 }
 LyChange();
 connect( L, SIGNAL(Change()),this, SLOT(LyChange()) );
}


LyDlg::~LyDlg()
{
 int i;
 for(i=0;i<23;i++){
  delete(LyIn[i]);
 }
}

void LyDlg::End()
{
 delete(this);
}


void LyDlg::LyChange()
{
 int i;
 unsigned long int t=1;

 for(i=0;i<32;i++){

  CbEx[i]->setChecked(Ly->IsDef(t));
  if (Ly->IsDef(t)){
   Le[i]->show();
   if (Le[i]!=focusWidget()) Le[i]->setText(Ly->GetName(t));
   CbVis[i]->show();
   CbVis[i]->setChecked(Ly->IsVis(t));
   CbAct[i]->show();
   CbAct[i]->setChecked(Ly->IsAct(t));
   CBTyp[i]->show();
   CBTyp[i]->setCurrentIndex(Ly->GetType(t));
  }
  else {
   Le[i]->hide();
   CbVis[i]->hide();
   CbAct[i]->hide();
   CBTyp[i]->hide();
  }
  t=t*2;
 }
 update();
}


LyDlg::LyDlg(QWidget *parent)
{
 LyDlg(NULL,parent);
}


void LyDlg::SetNo(int * /*n*/)
{

}

void LyDlg::paintEvent( QPaintEvent * /*e*/)
{
 QPainter paint( this );
 QRect r;
// int x,y;
 int i;
 unsigned long int t=1;
 for(i=0;i<32;i++){
  int y=(i%16)*25;
  int x=(i/16)*300;
  if(Ly->IsDef(t)){
   QColor * c;
   Ly->GetColor(&c,t);
   paint.setPen(Qt::black);
   paint.setBrush(*c);
   r.setRect(x+150,y+30,20,20);
   paint.drawRect(r);
  }
  t=t*2;
 }
}

void LyDlg::mousePressEvent ( QMouseEvent *e )
{

 QPoint p;
 p=e->pos();
 int x=p.x();
 int y=p.y()-30;
 int x1;
 int y1;

 if(x>150 && x<(150+20)){
  x1=0;
 }
 else if(x>(150+300) && x<(150+300+20)){
  x1=16;
 }
 else return;

 if((y%25)<20 && (y/25)<16 && (y/25)>=0){
  y1=(y/25)+x1;
  unsigned long int t=1;
  for(x1=0;x1<y1;x1++) t=t*2;
  if (Ly->IsDef(t)){
   QColor * c;
   Ly->GetColor(&c,t);
    ColSel * CS=new ColSel(*c);
    connect( CS,SIGNAL(SetCol(int,int,int)),LyIn[y1],SLOT(SetCol(int,int,int)));
   CS->show();
  }
 }
}



//--------------------------------------------------------------

//static const char *LyTyp[] = { "NORM", "WIRE", "RTS", 0 };


LyDlgM::LyDlgM( Layers* L,QWidget *parent)
        : QDialog( parent )
{
 Ly=L;
 setMinimumSize( 700, 500 );
 setMaximumSize( 700, 500 );

 Ok = new QPushButton( "OK", this);
 Ok->setFont( QFont( "Times", 14, QFont::Bold ) );
 connect( Ok, SIGNAL(clicked()),this, SLOT(End()) );

 BCancel = new QPushButton( "Cancel", this);
 BCancel->setFont( QFont( "Times", 14, QFont::Bold ) );
 connect( BCancel, SIGNAL(clicked()),this, SLOT(Cancel()) );

 BNew = new QPushButton( "New", this);
 BNew->setFont( QFont( "Times", 14, QFont::Bold ) );
 connect( BNew, SIGNAL(clicked()),this, SLOT(New()) );


 BDel = new QPushButton( "Del", this );
 BDel->setFont( QFont( "Times", 14, QFont::Bold ) );
 connect( BDel, SIGNAL(clicked()),this, SLOT(Del()) );


 int i;
 QString s;

 for(i=0;i<32;i++){

  s.setNum(i+1);
  La[i]=new QLabel(s,this);
  La[i]->hide();

  Le[i]=new QLineEdit(this);
  Le[i]->hide();

  Pa[i]=new QLineEdit(this);
  Pa[i]->hide();

  Lev[i]=new QLineEdit(this);
  Lev[i]->hide();

  CbVis[i]=new QCheckBox(this);
  CbVis[i]->hide();

  CbAct[i]=new QCheckBox(this);
  CbAct[i]->hide();

  CBTyp[i]=new QComboBox(this);
  CBTyp[i]->hide();

 }
 Arrange();
// LyChange();
// connect( L, SIGNAL(Change()),this, SLOT(LyChange()) );
}




LyDlgM::~LyDlgM()
{
// int i;
// for(i=0;i<23;i++){
//  delete(LyIn[i]);
// }
}

void LyDlgM::Arrange()
{
 int j;
 int i;
 int n;
 unsigned long int t;
 unsigned long int t1;
 int x;
 int y;
 QString s;


 n=31;
 t=0x80000000;

 while(!Ly->IsDef(t) && n>=0){
  t=t/2;
  n--;
 }
 n++;
 N=n;

 setMinimumSize( 700, ((N+1)/2)*25+100 );
 setMaximumSize( 700, ((N+1)/2)*25+100 );

 Ok->setGeometry( 700-85, ((N+1)/2)*25+100-35, 75, 30 );
 BCancel->setGeometry( 700-170, ((N+1)/2)*25+100-35, 75, 30 );
 BNew->setGeometry( 700-340, ((N+1)/2)*25+100-35, 75, 30 );
 BDel->setGeometry( 700-255, ((N+1)/2)*25+100-35, 75, 30 );

// printf("N:%d\n",n);

 t=1;

 for(i=0;i<n;i++){
  y=(i%((n+1)/2))*25;
  x=(i/((n+1)/2))*350;

  if(Ly->IsDef(t)){
   Le[i]->show();
   CbVis[i]->show();
   CbAct[i]->show();
   CBTyp[i]->show();
   Pa[i]->show();
   Lev[i]->show();

   La[i]->setGeometry(10+x,y+30,20,20);
   La[i]->show();

   Le[i]->setGeometry(x+30,y+30,60,20);
   Le[i]->setText(Ly->GetName(t));

   CbVis[i]->setGeometry(x+100,y+35,10,10);
   CbVis[i]->setChecked(Ly->IsVis(t));

   CbAct[i]->setGeometry(x+120,y+35,10,10);
   CbAct[i]->setChecked(Ly->IsAct(t));

   CBTyp[i]->setGeometry(x+170,y+30,60,20);
//   CBTyp[i]->insertStrList(LyTyp);
   CBTyp[i]->insertItem(1,"NORM");
   CBTyp[i]->insertItem(2,"WIRE");
   CBTyp[i]->insertItem(3,"RTS");
   CBTyp[i]->insertItem(4,"REF");
   CBTyp[i]->insertItem(5,"VAL");
   CBTyp[i]->insertItem(6,"SVAL");
   CBTyp[i]->insertItem(7,"COMM");
   CBTyp[i]->insertItem(8,"PRINT");
   
   CBTyp[i]->setFont(QFont( "Times", 10 ));
   CBTyp[i]->setCurrentIndex(Ly->GetType(t));

   Pa[i]->setGeometry(x+240,y+30,25,20);
   t1=Ly->PairLy(t);
   if(t1){
    j=0;
    while(t1){
     j++;
     t1=t1/2;
    }
    s.setNum(j);
   }
   else s="";
   Pa[i]->setText(s);

   Lev[i]->setGeometry(x+270,y+30,35,20);
   s=Ly->GetLevels(t);
   Lev[i]->setText(s);

  }
  else{
   Le[i]->hide();
   CbVis[i]->hide();
   CbAct[i]->hide();
   CBTyp[i]->hide();
   Pa[i]->hide();
   Lev[i]->hide();
  }

  t=t*2;
 }

 if(i<32){
  La[i]->hide();
  Le[i]->hide();
  CbVis[i]->hide();
  CbAct[i]->hide();
  CBTyp[i]->hide();
  Pa[i]->hide();
  Lev[i]->hide();
 }

 update();
}

void LyDlgM::New()
{
 int i=0;
 unsigned long int t=1;

 while(i<32 && Ly->IsDef(t)){
  i++;
  t=t*2;
 }
 if (i<32){
  Ly->AddDef(t);
 }
 Arrange();
}

void LyDlgM::Del()
{
 int i=0;
 unsigned long int t=1;
 StrDlg DL(this);
 QString s;
 QString s1="Delete layer number :";
 if (DL.GetStr(&s,s1)){
  i=s.toInt();
  if(i){
   i--;
   while(i){
    i--;
    t=t*2;
   }
   Ly->DelDef(t);
   Arrange();
  }
 }
}

void LyDlgM::Cancel()
{
 delete(this);
}

void LyDlgM::End()
{
 int i=0;
 unsigned long int t=1;
 char N[6];
 int j=0;
 QString Na;

 for(j=0;j<32;j++) Ly->SetLevel(0,j);

 do{
  if(Ly->IsDef(t)){
   Na=Le[i]->text();
   j=0;
   while(Na[j]!=0 && j<6){
    N[j]=Na[j].toLatin1();
    j++;
   }
   while(j<6){
    N[j]=' ';
    j++;
   }
   Ly->SetName(t,N);

   if(CbVis[i]->isChecked()) Ly->AddVis(t);
   else Ly->DelVis(t);
   if(CbAct[i]->isChecked()) Ly->AddAct(t);
   else Ly->DelAct(t);
   Ly->SetType(t,CBTyp[i]->currentIndex());
   Na=Pa[i]->text();
   j=Na.toInt();
   Ly->SetPair(i,j-1);
   Na=Lev[i]->text();
   while(Na.contains(',')){
     j=Na.left(Na.indexOf(',')).toInt();
     Ly->AddLevel(t,j);
     Na.remove(0,Na.indexOf(',')+1);
   }
   j=Na.toInt();
   Ly->AddLevel(t,j);
  }
  i++;
  t=t*2;
 }while (t>1);

 delete(this);
}


/*void LyDlg::LyChange()
{
 int i;
 unsigned long int t=1;

 for(i=0;i<32;i++){

  CbEx[i]->setChecked(Ly->IsDef(t));
  if (Ly->IsDef(t)){
   Le[i]->show();
   if (Le[i]!=focusWidget()) Le[i]->setText(Ly->GetName(t));
   CbVis[i]->show();
   CbVis[i]->setChecked(Ly->IsVis(t));
   CbAct[i]->show();
   CbAct[i]->setChecked(Ly->IsAct(t));
   CBTyp[i]->show();
   CBTyp[i]->setCurrentIndex(Ly->GetType(t));
  }
  else {
   Le[i]->hide();
   CbVis[i]->hide();
   CbAct[i]->hide();
   CBTyp[i]->hide();
  }
  t=t*2;
 }
 update();
}
*/

//LyDlg::LyDlg(QWidget *parent=0, const char *name=0 )
//{
// LyDlg(NULL,parent,name);
//}


/*
void LyDlg::SetNo(int * n)
{

}
*/

void LyDlgM::paintEvent( QPaintEvent * /*e*/)
{
 QPainter paint( this );
 QRect r;
// int x,y;
 int i;
 unsigned long int t=1;
 for(i=0;i<32;i++){
  int y=(i%((N+1)/2))*25;
  int x=(i/((N+1)/2))*350;
  if(Ly->IsDef(t)){
   QColor * c;
   Ly->GetColor(&c,t);
   paint.setPen(Qt::black);
   paint.setBrush(*c);
   r.setRect(x+140,y+30,20,20);
   paint.drawRect(r);

   Ly->GetHLColor(&c,t);
   if(c){
    paint.setPen(Qt::black);
    paint.setBrush(*c);
    r.setRect(x+310,y+30,20,20);
    paint.drawRect(r);
   }
  }
  t=t*2;
 }
}

void LyDlgM::mousePressEvent ( QMouseEvent *e )
{

 QPoint p;
 p=e->pos();
 int x=p.x();
 int y=p.y()-30;
 int x1;
 int y1;
 int HL=0;

 if(x>140 && x<(140+20)){
  x1=0;
 }
 else if(x>(140+350) && x<(140+350+20)){
  x1=(N+1)/2;
 }
 else if(x>310 && x<(310+20)){
  x1=0;
  HL=1;
 }
 else if(x>(310+350) && x<(310+350+20)){
  x1=(N+1)/2;
  HL=1;
 }
 else return;

 if((y%25)<20 && (y/25)<16 && (y/25)>=0){
  y1=(y/25)+x1;
  unsigned long int t=1;
  for(x1=0;x1<y1;x1++) t=t*2;
  if (Ly->IsDef(t)){
   QColor * c;
   if (HL) Ly->GetHLColor(&c,t);
   else Ly->GetColor(&c,t);
   ColSelM * CS=new ColSelM(c);

//    connect( CS,SIGNAL(SetCol(int,int,int)),LyIn[y1],SLOT(SetCol(int,int,int)));
   CS->show();
  }
 }
}


