/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "PComp.h"
#include "Layers.h"
#include "Library.h"
#include "ObjEdit.h"

#include <QPainter>
#include <QPen>
#include <QColor>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>


extern Library gLib;

PComp::PComp(Layers *L)
 :PicGrp(L)
{
 PP=NULL;
 X=false;
}

PComp::~PComp()
{
 if (PP) delete[] PP;
}

int PComp::GetIden()
{
 return kPComp;
}

void PComp::AddTreeList(TreeListItem * LI)
{
 if(Atr.GetAtr(0)!=NULL) LI->setText( 1,*Atr.GetAtr(0));
 PicGrp::AddTreeList(LI);
}

bool PComp::IsValid()
{
 if(GetPPComp()) return true;
 return false;
}


QString  PComp::GetAtr(int n)
{
/* if (!Atr && n==kAtrRef) return Reff;
 if (!Atr) return NULL;
 if (n>=0 && n<AtrN) return Atr[n];
 return NULL;*/

 QString * s;
 if (n>=0 && n<AtrN){
  s=Atr.GetAtr(n);
  if(s) return *s;
 }
 return "";
}

Atrib & PComp::GetAtr()
{
 return Atr;
}

void PComp::SetAtr(int n, const char * s)
{
 if (n>=0 && n<AtrN) Atr.SetAtr(n,s);
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kPicText){
   T->E->SetORect();
  }
  T=T->Next;
 }
// SetOutl();

}

const char * PComp::GetAtrNam(int n)
{
 if (n>=0 && n<AtrN) return Atr.GetName(n);
 return NULL;
}


PicPComp * PComp::GetPPComp()
{
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kPicPComp) return (PicPComp *)(T->E);
  T=T->Next;
 }
 return NULL;
}


void PComp::SetAtr(Atrib & A)
{
 Atr=A;
 UpdateAtr();
}

void PComp::SetPinL(PinList & P)
{
 PL=P;
}


bool PComp::Select(QPoint p,int mode,int mir)
{
 bool x=PicGrp::Select(p,mode,mir);
 if (x){
  GrpEl * T=Data;
  while(T){
   if(T->E->GetIden()==kPicPComp && T->E->IsSelect()){
    DeSelect();
    Lock=2;
    Sel=1;
   }
   T=T->Next;
  }
 }
 return x;
}

bool PComp::Select(QRect r,int mode,int mir)
{
 bool x=PicGrp::Select(r,mode,mir);
 if (x){
  GrpEl * T=Data;
  while(T){
   if(T->E->GetIden()==kPicPComp && T->E->IsSelect()){
    DeSelect();
    Lock=2;
    Sel=1;
   }
   T=T->Next;
  }
 }
 return x;
}

bool PComp::Select(PicEl * E)
{
 bool x=PicGrp::Select(E);
 if (x){
  GrpEl * T=Data;
  while(T){
   if(T->E->GetIden()==kPicPComp && T->E->IsSelect()){
    DeSelect();
    Lock=2;
    Sel=1;
   }
   T=T->Next;
  }
 }
 if(Sel==1) Lock=2;
 return x;
}

void PComp::DeSelect()
{
 if (Lock==2) Lock=0;
 PicGrp::DeSelect();
}


PicText * PComp::AddAtr(int A)
{
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kPicText && T->E->GetSubIden()==kSIDRef+A)
   return (PicText *)T->E;
  T=T->Next;
 }
 PicText * E=new PicText(Layer);
 E->SetSubIden(kSIDRef+A);
 E->SetText(Atr.GetAtr(A));
 AddItem(E);
 return E;
}


void PComp::UpdateAtr()
{
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kPicText && T->E->GetSubIden()>=kSIDRef){
   ((PicText *)(T->E))->SetText(Atr.GetAtr(T->E->GetSubIden()-kSIDRef));
  }
  T=T->Next;
 }
}

/*void PComp::DelAtr()
{
 if (X) return;
 printf("DelAtr\n");
 GrpEl * T=Data;
 GrpEl * T1=Data;
 while(T){
  if(T->E->GetIden()==kPicText){
   printf(" DelAtr %d\n",T->E->GetSubIden());
   if (T==Data){
    Data=T->Next;
    delete T->E;
    delete T;
    T=Data;
   }
   else{
    T1->Next=T->Next;
    delete T->E;
    delete T;
    T=T1->Next;
   }
  }
  else{
   T1=T;
   T=T->Next;
  }
 }
 Atr=NULL;
}*/

bool PComp::LibPart(QString name)
{
 PicPComp * E=new PicPComp(Layer);
 if (E->LibPart(name)){
  AddItem(E);
//  if(Atr[0].isEmpty()) Atr[0]=*(E->GetRef());
//  if(Atr[1].isEmpty()) Atr[1]=*(E->GetVal());
//  SetOutl();
//  Lock=2;
  return true;
 }
 else {
  delete E;
  return false;
 }
}

bool PComp::ChLibPart(QString name)
{
 GrpEl * T=Data;
 GrpEl * T1=Data;
 while(T){
  if(T->E->GetIden()==kPicPComp) break;
  T1=T;
  T=T->Next;
 }
 if(T){
  if(((PicPComp *)T->E)->GetName()==name){
   return true;
  }
  else{
   delete T->E;
   T->E=new PicPComp(Layer);
   if (((PicPComp *)T->E)->LibPart(name)){
//    SetOutl();
    return true;
   }
   else{
    delete T->E;
    if (T==Data){
     Data=T->Next;
     delete T;
    }
    else{
     T1->Next=T->Next;
     delete T;
    }
   }
  }
 }
 else {
  if(LibPart(name)){
   Lock=0;
   return true;
  }
 }
 return false;
}

void PComp::MkPinP()
{
 int i;
 int j;
 if (PP) delete[] PP;

 PicPComp * PC;
 PC=GetPPComp();
 i=PC->GetMaxPN()+1;
 PP=new PinP[i];
 for(j=0;j<i;j++){
  PP[i].E=PC->GetPinP(&(PP[i].P),i);
 }
}

void PComp::GetPinR()
{
// APL=PL;
 PL.GetPinR();
}

void PComp::GetPinPosRes()
{
 PicPComp * P=GetPPComp();
 P->GetPinPosRes();
}

bool PComp::GetPinPos(QPoint & p,int & num)
{
 PicPComp * P=GetPPComp();
 if(P->GetPinPos(p,num)){
  p=CompRot(Rot,p,Mir);
  p+=Ref;
  return true;
 }
 return false;
}


bool PComp::GetPin(QString * net,int * num)
{
 return PL.GetPinNext(num,net);
}

bool PComp::GetPinP(QPoint * p,int num)
{
 PicPComp * P=GetPPComp();
 bool x=P->GetPinP(p,num);
 *p=CompRot(Rot,*p,Mir);
 *p+=Ref;
 return x;
}

unsigned long int PComp::GetPinL(int num)
{
 PicPComp * P=GetPPComp();
 if(Mir){
//  printf("GetPinL: MirLy\n");
  return Layer->MirLy(P->GetPinL(num));
 }
 else return P->GetPinL(num);
}


/*void PComp::SetSC(SComp * S)
{
 SC=S;
 SCG=NULL;
}

void PComp::SetSCG(SCGrp * S)
{
 SC=NULL;
 SCG=S;
}*/

void PComp::GetCenter(QPoint & p, int & rot,int & mir,int & typ)
{
  QRect r;
  PicPComp * PP=GetPPComp();
  unsigned long int L;
  QString s;
  
  PP->GetORect(&r);
  p=r.center();
  if(abs(p.x())<100) p.setX(0);
  if(abs(p.y())<100) p.setY(0);
  p=CompRot(Rot,p,Mir);
  p=p+Ref;
  rot=Rot;
  mir=Mir;
  typ=1;
  s="DRILL";
  L=Layer->GetLy(&s);
  if(L&Ly) typ=2;
}

bool PComp::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  if(PicGrp::GetInfo(i,p,mode,mir)){
    QString * s;
    s=Atr.GetAtr(kAtrRef);
    if(s){
      i+=" R:";
      i+=*s;
    }
    return true;
  }
  return false;
}

PicEl * PComp::GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                      int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad)
{
 PicEl* E;
 int i;
 QString * s;
 N="*PComp*";
// printf("PComp ::");
 E=PicGrp::GetEl(iden,p1,p2,W,r,Lo,N,Po,L,pad);
// printf(" Net %s\n",(const char *)N);
 if(N=="*PComp*" || E==NULL){
  N="";
  if(E){
   if(iden==kPicRect || iden==kPicCir){
    i=1;
    QPoint p;
    int x1,x2,y1,y2;
    if(iden==kPicRect){
     x1=p1.x();
     x2=p2.x();
     y1=p1.y();
     y2=p2.y();
     if(x1>x2){
      x1=p2.x();
      x2=p1.x();
     }
     if(y1>y2){
      y1=p2.y();
      y2=p1.y();
     }
    }
    else{
     x1=p1.x()-r;
     x2=p1.x()+r;
     y1=p1.y()-r;
     y2=p1.y()+r;
    }
    GetPinPosRes();
    while(GetPinPos(p,i)){
     if(p.x()>x1 && p.x()<x2 && p.y()>y1 && p.y()<y2){
      s=PL.GetNet(i);
      if(s){
       N=*s;
//        printf("PComp::GetEl comp %s pin %d add net %s\n",(const char  *)*(Atr.GetAtr(0)),i,(const char *)(*s));
      }
      else  N="";
      break;
     }
    }
   }
  }
 }
 else{
  if(iden!=kPicText){
   i=N.toInt();
   s=PL.GetNet(i);
   if(s && iden==kPicPoly) printf("PComp : net:%s pin:%d id:%d\n",s->toLatin1().data(),i,iden);
 //  else  printf("PComp : net ERR pin:%d \n",i);
   if(s) N=*s;
   else  {
     N="";
 //    printf("PComp : net ERR pin:%d %s N=%s\n",i,GetAtr(kAtrRef),N.ascii());
   }
  }
 }
 pad=true;
 return E;
}

PicEl * PComp::GetNextEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                          int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad)
{
 PicEl* E;
 int i;
 QString * s;
 N="*PComp*";
// printf("PComp ::");
 E=PicGrp::GetNextEl(iden,p1,p2,W,r,Lo,N,Po,L,pad);
// printf(" Net %s\n",(const char *)N);
 if(N=="*PComp*" || E==NULL){
  N="";
  if(E){
   if(iden==kPicRect || iden==kPicCir){
    i=1;
    QPoint p;
    int x1,x2,y1,y2;
    if(iden==kPicRect){
//     printf("PComp::GetNextEl = kPicRect\n");
     x1=p1.x();
     x2=p2.x();
     y1=p1.y();
     y2=p2.y();
     if(x1>x2){
      x1=p2.x();
      x2=p1.x();
     }
     if(y1>y2){
      y1=p2.y();
      y2=p1.y();
     }
    }
    else{
//     printf("PComp::GetNextEl = kPicCir\n");
     x1=p1.x()-r;
     x2=p1.x()+r;
     y1=p1.y()-r;
     y2=p1.y()+r;
    }
    GetPinPosRes();
    while(GetPinPos(p,i)){
//     printf("  %d < %d <%d    %d < %d  < %d\n",x1,p.x(),x2,y1,p.y(),y2);
     if(p.x()>x1 && p.x()<x2 && p.y()>y1 && p.y()<y2){
      s=PL.GetNet(i);
      if(s){
       N=*s;
//       printf("PComp::GetNextEl comp %s pin %d add net %s\n",(const char  *)*(Atr.GetAtr(0)),i,(const char *)(*s));
      }
      else  N="";
      break;
     }
    }
   }
  }
 }
 else{
  if(iden!=kPicText){
   i=N.toInt();
   s=PL.GetNet(i);
   if(s && iden==kPicPoly) printf("PComp : net:%s pin:%d id:%d\n",s->toLatin1().data(),i,iden);
 //  else  printf("PComp : net ERR pin:%d\n",i);
   if(s) N=*s;
   else  N="";
  }
 }
 pad=true;
 return E;
}



void PComp::TextSave(QTextStream * S, bool sel)
{
// int i;
 PicEl::TextSave(S,sel);
 Atr.TextSave(S);
 PicGrp::TextSaveNext(S,sel);
}

bool  PComp::TLoadNext(QTextStream * S,QString* s)
{
 if(Atr.TextLoadNext(S,s)) return true;
 else return PicGrp::TLoadNext(S,s);
}

