/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "Part.h"

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

#include <QFontMetrics>
#include <QRect>
#include <QDateTime>
#include <QFile>
#include <QFileInfo>


#include "Error.h"

extern Errors  gErr;


Part::Part()
{
 PL=NULL;
 Head="Rozpiska pro %B | Datum : %m";
 Tail="Strana %p | vytvoreno dne %d";
 Typ=0;
 tab=40;
 tab1=20;
 tab2=80;
}

Part::~Part()
{
 PartL * L;
 while(PL){
  L=PL->Next;
  delete PL;
  PL=L;
 }
}

void Part::AddAtr(Atrib & A)
{
 PartL * L;
  
 QString * s=A.GetAtr(kAtrPartL);
 if(s && !s->isEmpty()) return;
 
 L=PL;
 while(L){
  if(L->Atr.OneData(A)) return;
  L=L->Next;
 }

 L=new PartL;
 L->Next=PL;
 L->Atr=A;
 L->St=0;
 L->BName=BName;
 L->typ=0;
 PL=L;
}

void Part::AddCenter(DbPcb * P,int x, int y)
{
  PartL * L=PL;
  QPoint p(x,y);
  while(L){
    if(P->GetCompCenter(*(L->Atr.GetAtr(kAtrRef)),L->p,L->rot,L->mir,L->typ)) L->p-=p;
    L=L->Next;
  }
}

void Part::List()
{
 QString * s;
 PartL * L=PL;
 while(L){
  s=L->Atr.GetAtr(kAtrRef);
  if(s) printf("%s ",s->toLatin1().data());
  else printf("Null REF ");
  s=L->Atr.GetAtr(kAtrVal);
  if(s) printf("%s\n",s->toLatin1().data());
  else printf("Null VAL\n");
  L=L->Next;
 }
}

void Part::SetType(int t)
{
 Typ=t;
}


QString * Part::GetHead()
{
 return &Head;
}
QString * Part::GetTail()
{
 return &Tail;
}



static const char *RefP[] = { "R", "P" ,"C", "D", "T", "L",
                              "U", "IO", "IC", "X", "CN", "RE", "BT", "J",0 };

int Part::CmpAtr(Atrib & A1,Atrib & A2,int fl)
{
// printf("Part::CmpAtr start typ=%d %s %s\n",Typ,A1.GetAtr(kAtrRef)->ascii(),A2.GetAtr(kAtrRef)->ascii());
 QString s1;
 QString s2;
// int i;
 int x1;
 int x2;
 double v1;
 double v2;
 bool v;
 if(Typ==0 || Typ==2){
  if(fl!=0) return fl;
  if(*A1.GetAtr(kAtrRef)!=*A2.GetAtr(kAtrRef)){
   A1.GetRef(s1);
   A2.GetRef(s2);
   if(s1!=s2){
    x1=0;
    while(RefP[x1] && s1!=RefP[x1]) x1++;
    if(!RefP[x1])x1=s1.at(0).toLatin1();
    x2=0;
    while(RefP[x2] && s2!=RefP[x2]) x2++;
    if(!RefP[x2]) x2=s2.at(0).toLatin1();
    if(x1>x2) return -1;
    return 1;
   }
   if(A1.GetRefNum()>A2.GetRefNum()) return -1;
   return 1;
  }
 }
 if(Typ==1 || Typ==3 || Typ==4){
  A1.GetRef(s1);
  A2.GetRef(s2);
  if(s1!=s2){
   x1=0;
   while(RefP[x1] && s1!=RefP[x1]) x1++;
   if(!RefP[x1])x1=s1.at(0).toLatin1();
   x2=0;
   while(RefP[x2] && s2!=RefP[x2]) x2++;
   if(!RefP[x2]) x2=s2.at(0).toLatin1();
   if(x1>x2) return -1;
   return 1;
  }
  else if(*A1.GetAtr(kAtrVal)!=*A2.GetAtr(kAtrVal)){
   v=A2.ValToNum(A2.GetAtr(kAtrVal)->toLatin1().data(),v2);
   if(A1.ValToNum(A1.GetAtr(kAtrVal)->toLatin1().data(),v1)){
    if(v){
     if(v1>v2) return -1;
     return 1;
    }
    else return -1;
   }
   else{
    if(v) return 1;
   }
   if((*A1.GetAtr(kAtrVal))>*A2.GetAtr(kAtrVal)) return -1;
   return 1;
  }
  else if(*A1.GetAtr(kAtrSubV)!=*A2.GetAtr(kAtrSubV)){
   v=A2.ValToNum(A2.GetAtr(kAtrSubV)->toLatin1().data(),v2);
   if(A1.ValToNum(A1.GetAtr(kAtrSubV)->toLatin1().data(),v1)){
    if(v){
     if(v1>v2) return -1;
     return 1;
    }
    else return -1;
   }
   else{
    if(v) return 1;
   }
   if((*A1.GetAtr(kAtrSubV))>*A2.GetAtr(kAtrSubV)) return -1;
   return 1;
  }
  else if(*A1.GetAtr(kAtrComm)!=*A2.GetAtr(kAtrComm)){
   if((*A1.GetAtr(kAtrComm))>*A2.GetAtr(kAtrComm)) return -1;
   return 1;
  }
  else if(*A1.GetAtr(kAtrPkg)!=*A2.GetAtr(kAtrPkg)){
   if((*A1.GetAtr(kAtrPkg))>*A2.GetAtr(kAtrPkg)) return -1;
   return 1;
  }
  else if(fl!=0){
   return fl;
  }
  else{
   if(A1.GetRefNum()>A2.GetRefNum()) return -1;
   return 1;
  }
 }
 return 0;
}


void Part::Sort()
{
 printf("Part::Sort\n");
 PartL * L;
 PartL * T;
 PartL * LM=NULL;
 bool ch=true;
 int x;
 while(ch){
  L=PL;
  ch=false;
  while(L && L->Next){
//   printf("CmpAtr %s %s\n",(const char *)*(L->Atr.GetAtr(kAtrRef)),
//                            (const char *)*(L->Next->Atr.GetAtr(kAtrRef)));
   if(L->BName==L->Next->BName) x=0;
   else x=(L->BName < L->Next->BName)*2-1;
   x=CmpAtr(L->Atr,L->Next->Atr,x);
//   printf("Part::CmpAtr OK\n");
//   printf("%d\n",x);
   if(x<0){
    ch=true;
    if(L==PL){
     PL=L->Next;
     LM=L->Next;
     T=L->Next;
     L->Next=L->Next->Next;
     T->Next=L;
    }
    else{
     LM->Next=L->Next;
     LM=L->Next;
     T=L->Next;
     L->Next=L->Next->Next;
     T->Next=L;
    }
   }
   else{
    LM=L;
    L=L->Next;
   }
  }
 }
 printf("Part::Sort OK\n");
}

void Part::SetFName(QString & n)
{
 QFileInfo FI(n);
 FName=n;
 BName=FI.baseName();
}


bool Part::ConvHead(const char * H,QString * L,QString * R,int pn)
{
 QDate Date;
 QFileInfo FI(FName);
 int i;
 QString * x;
 QString s;
 *L="";
 *R="";
 i=0;
 x=L;
 while(H[i]){
  if(H[i]=='%'){
   i++;
   if(H[i]=='f'){
    *x=*x+FI.baseName();
   }
   else if(H[i]=='F'){
    *x=*x+(FI.baseName()).toUpper();
   }
   else if(H[i]=='b'){
    *x=*x+BName;
   }
   else if(H[i]=='B'){
    *x=*x+BName.toUpper();
   }
   else if(H[i]=='d'){
    Date=Date.currentDate();
    *x=*x+Date.toString();
   }
   else if(H[i]=='D'){
    Date=Date.currentDate();
    *x=*x+(Date.toString()).toUpper();
   }
   else if(H[i]=='m'){
    Date=(FI.lastModified()).date();
    *x=*x+Date.toString();
   }
   else if(H[i]=='M'){
    Date=(FI.lastModified()).date();
    *x=*x+(Date.toString()).toUpper();
   }
   else if(H[i]=='p'){
    s.setNum(pn);
    *x=*x+s;
   }
   i++;
  }
  else if(H[i]=='|'){
   x=R;
   i++;
  }
  else{
   *x=*x+H[i];
   i++;
  }
 }
 return true;
}

int Part::WriteCsv(QTextStream &S,int flag)
{
  QString * s;
  QString  s1;
  QString  Ls;
  QString  Ps;
  QString  Rs;
  PartL * L=PL;

  int poc;
  int bpoc;
  
  if(Typ==0 || Typ==2){
    S << "REF;VALUE;PACKAGE;COMMENT;X[mils];Y[mils];ROT;SIDE;TYP\n";
    while(L){
      if((flag==0)||((flag==1)&&(!L->mir))||((flag==2)&&(L->mir))){
	s=L->Atr.GetAtr(kAtrRef);
	if(s && !s->isEmpty()){
	  S << (*s);
	}
	S << ";";
	s=L->Atr.GetAtr(kAtrVal);
	if(s) s1=*s;
	s=L->Atr.GetAtr(kAtrSubV);
	if(s && !s->isEmpty()){
	  s1=s1+"/";
	  s1=s1+*s;
	}
	S << s1 << ";";

	s=L->Atr.GetAtr(kAtrPkg);
	if(s && !s->isEmpty()){
	  S << (*s);
	}
	S << ";";

	s=L->Atr.GetAtr(kAtrComm);
	if(s && !s->isEmpty()){
	  S << (*s);
	}
	S << ";";

	if(L->typ){
          S << (L->p.x()+5)/10 << ";" << (5-L->p.y())/10 << ";" << ((4-(L->rot))&3)*90 << ";";
	  if(L->mir) S << "BOT;";
	  else S << "TOP;";
	  if(L->typ==1) S << "SMD;";
	  else S << " ;";
	}
	S << "\n";
      }
      L=L->Next;
    }
  }


  if(Typ==1 || Typ==3){
    S << "COUNT;VALUE;PACKAGE;COMMENT;REFERENCES\n";
    while(L){
      s=L->Atr.GetAtr(kAtrVal);
      if(s){
        if(!s->isEmpty()) Ls=*s;
        else Ls="NoValue";
        s=L->Atr.GetAtr(kAtrSubV);
        if(s && !s->isEmpty()){
          Ls=Ls+"/";
          Ls=Ls+*s;
        }
	Ls=Ls+";";

        s=L->Atr.GetAtr(kAtrPkg);
        if(s && !s->isEmpty()){
          Ls=Ls+*s;
        }
	Ls=Ls+";";

        s=L->Atr.GetAtr(kAtrComm);
        if(s && !s->isEmpty()){
          Ls=Ls+*s;
        }

        poc=1;
        bpoc=1;

        if(Typ==3){
	    s1=L->BName;
            Rs=s1+":";
	}
	else{
	 s=L->Atr.GetAtr(kAtrRef);
         if(s) Rs=*s;
	} 

	while(L->Next && (*L->Atr.GetAtr(kAtrVal))==(*L->Next->Atr.GetAtr(kAtrVal))
              && (*L->Atr.GetAtr(kAtrSubV))==(*L->Next->Atr.GetAtr(kAtrSubV))
              && (*L->Atr.GetAtr(kAtrComm))==(*L->Next->Atr.GetAtr(kAtrComm))
              && (*L->Atr.GetAtr(kAtrPkg))==(*L->Next->Atr.GetAtr(kAtrPkg))){


          s=L->Next->Atr.GetAtr(kAtrRef);
	  if(Typ==3){
	    if(L->BName!=L->Next->BName){
	      s1.setNum(bpoc);
	      Rs+=s1+" ";
	      s1=L->Next->BName;
	      Rs+=s1+":";
	      bpoc=0;
	    }
	  }
	  else{
            if(!Rs.isEmpty()) Rs+=" ";
            Rs=Rs+*s;
	  }
          L=L->Next;
          poc++;
	  bpoc++;
        }
	if(Typ==3){
	  s1.setNum(bpoc);
	  Rs+=s1;
	}

	S << poc << ';' << Ls << ';' << Rs << "\n";
      }	
      L=L->Next;
    }
    S << "Resistors tolerance 5% unless otherwise noted.\n";
    S << "MLCC Capacitors are X5R 50V for value <1uF, \n";
    S << "X5R 6.3V for value >=1uF unless otherwise noted.\n";
  }
  if(Typ==4){
    S << "COUNT;TOP;BOTTOM;VALUE;PACKAGE\n";
    while(L){
      s=L->Atr.GetAtr(kAtrVal);
      if(s){
        if(!s->isEmpty()) Ls=*s;
        else Ls="NoValue";
        s=L->Atr.GetAtr(kAtrSubV);
        if(s && !s->isEmpty()){
          Ls=Ls+"/";
          Ls=Ls+*s;
        }
	Ls=Ls+";";

        s=L->Atr.GetAtr(kAtrPkg);
        if(s && !s->isEmpty()){
          Ls=Ls+*s;
        }
	Ls=Ls+";";

        poc=1;
        bpoc=0;
	if(L->mir) bpoc++;

	while(L->Next && (*L->Atr.GetAtr(kAtrVal))==(*L->Next->Atr.GetAtr(kAtrVal))
              && (*L->Atr.GetAtr(kAtrSubV))==(*L->Next->Atr.GetAtr(kAtrSubV))
              && (*L->Atr.GetAtr(kAtrComm))==(*L->Next->Atr.GetAtr(kAtrComm))
              && (*L->Atr.GetAtr(kAtrPkg))==(*L->Next->Atr.GetAtr(kAtrPkg))){


          L=L->Next;
          poc++;
	  if(L->mir) bpoc++;
        }

	S << poc << ';' << poc-bpoc << ';' << bpoc << ';' << Ls << "\n";
      }
      L=L->Next;
    }
  }
  if(Typ==5){
    S << "VALUE;DESIGNATOR;FOOTPRINT\n";
    while(L){
      s=L->Atr.GetAtr(kAtrVal);
      if(s){
        if(!s->isEmpty()) Ls=*s;
        else Ls="NoValue";
        s=L->Atr.GetAtr(kAtrSubV);
        if(s && !s->isEmpty()){
          Ls=Ls+" ";
          Ls=Ls+*s;
        }

        s=L->Atr.GetAtr(kAtrPkg);
        if(s && !s->isEmpty()){
          Ps=*s;
        }
	else Ps=" ";

        poc=1;
        bpoc=1;

	s=L->Atr.GetAtr(kAtrRef);
        if(s) Rs=*s;

	while(L->Next && (*L->Atr.GetAtr(kAtrVal))==(*L->Next->Atr.GetAtr(kAtrVal))
              && (*L->Atr.GetAtr(kAtrSubV))==(*L->Next->Atr.GetAtr(kAtrSubV))
              && (*L->Atr.GetAtr(kAtrComm))==(*L->Next->Atr.GetAtr(kAtrComm))
              && (*L->Atr.GetAtr(kAtrPkg))==(*L->Next->Atr.GetAtr(kAtrPkg))){


          s=L->Next->Atr.GetAtr(kAtrRef);
          if(!Rs.isEmpty()) Rs+=" ";
          Rs=Rs+*s;
          L=L->Next;
          poc++;
	  bpoc++;
        }

	S << Ls << ',' << Rs << ',' << Ps << "\n";
      }
      L=L->Next;
    }
  }
  if(Typ==6){
    S << "DESIGNATOR,Mid X,Mid Y,LAYER,ROTATION\n";
    while(L){
      if((flag==0)||((flag==1)&&(!L->mir))||((flag==2)&&(L->mir))){
	s=L->Atr.GetAtr(kAtrRef);
	if(s && !s->isEmpty()){
	  S << (*s);
	}
	S << ",";

	if(L->typ){
          S << 0.00254*L->p.x() << "mm," << -0.00254*L->p.y() << "mm," ;
	  if(L->mir) S << "Bottom,";
	  else S << "Top,";
	  S << ((4-(L->rot))&3)*90;
	}
	S << "\n";
      }
      L=L->Next;
    }
  }
  return 0;
}

int Part::DrawPage(QPainter &P,QFont &Font,int NP,int /*Form*/)
{
 QString * s;
 QString  s1;
 QString  Ls;
 QString  Rs;
 PartL * L=PL;

 int pg=1;
 int x=60;
 int y=40;
 int ls;
 int poc;
 QRect r;
 QRect rp;
 QRect r1;
 QFontMetrics FM(Font);

 ls=FM.lineSpacing();
 if(PL){
  BName=PL->BName;
 }

 P.setPen(Qt::black);
 Font.setBold(true);
 P.setFont(Font);

 if(NP>10000 && (Typ==0 || Typ==2)){
  Font.setBold(true);
  P.setFont(Font);
  tab=0;
  while(L){
   s=L->Atr.GetAtr(kAtrRef);
   if(s && !s->isEmpty()){
    r.setRect(x,y,200,100);
    r1=P.boundingRect(r,Qt::AlignLeft|Qt::AlignTop,*s);
    if(r1.width()>tab) tab=r1.width();
   }
   L=L->Next;
  }
  tab+=5;
  L=PL;
 }

 while(L && pg<=NP){
  printf("Part Typ %d pg %d\n",Typ,pg);
  if(Typ==0 || Typ==2){
   if(BName!=L->BName){
     pg++;
    y=40;
    x=60;
    BName=L->BName;
   }

   if (y==40 && x<200){
    if(NP==pg && NP<10000){
     Font.setBold(true);
     P.setFont(Font);
     P.drawLine(x,y,x+475,y);
     ConvHead(Head.toLatin1().data(),&Ls,&Rs,NP);
     r.setRect(x,y,475,ls+ls/2);
     P.drawText(r,Qt::AlignLeft|Qt::AlignVCenter,Ls);
     P.drawText(r,Qt::AlignRight|Qt::AlignVCenter,Rs);

     y=y+ls+ls/2;
     P.drawLine(x,y,x+475,y);
     y=y+ls;
    }
    else {
     y=y+ls+ls/2;
     y=y+ls;
    }
   }

   s=L->Atr.GetAtr(kAtrRef);
   if(s && !s->isEmpty()){
    Font.setBold(true);
    P.setFont(Font);
    y=y+ls/2;
    r.setRect(x,y,tab-10,100);
    r1=P.boundingRect(r,Qt::AlignLeft|Qt::AlignTop,*s);
    if (pg==NP) P.drawText(r1,Qt::AlignLeft|Qt::AlignTop,*s);
 //   printf("%d %d %d %d %s\n",r1.left(),r1.top(),r1.width(),r1.height(),
 //                              (const char *)*s);

    Font.setBold(false);
    P.setFont(Font);
    s=L->Atr.GetAtr(kAtrVal);
    if(s) s1=*s;
    s=L->Atr.GetAtr(kAtrSubV);
    if(s && !s->isEmpty()){
     s1=s1+"/";
     s1=s1+*s;
    }
    r.setRect(x+tab,y,230-tab,100);
    r1=P.boundingRect(r,Qt::AlignLeft|Qt::AlignTop,s1);
    if (pg==NP) P.drawText(r1,Qt::AlignLeft|Qt::AlignTop,s1);
    y=y+ls;

    s=L->Atr.GetAtr(kAtrComm);
    if(s && !s->isEmpty()){
     r.setRect(x+tab,y,230-tab,200);
     r1=P.boundingRect(r,Qt::AlignLeft|Qt::AlignTop,*s);
     if (pg==NP) P.drawText(r1,Qt::AlignLeft|Qt::AlignTop,*s);
     y=y+r1.height();
    }
    if(y>800-5*ls){
     if(x<200){
      y=40;
      y=y+2*ls+ls/2;
      x=305;
     }
     else{
      pg++;
      y=40;
      x=60;
     }
    }
   }
   else printf("DrawPage : Error\n");
  }

  if(Typ==1 || Typ==3){

   if (y==40 && x<200){
    if(NP==pg && NP<10000){
     Font.setBold(true);
     P.setFont(Font);
     P.drawLine(x,y,x+475,y);
     ConvHead(Head.toLatin1().data(),&Ls,&Rs,NP);
     r.setRect(x,y,475,ls+ls/2);
     P.drawText(r,Qt::AlignLeft|Qt::AlignVCenter,Ls);
     P.drawText(r,Qt::AlignRight|Qt::AlignVCenter,Rs);

     y=y+ls+ls/2;
     P.drawLine(x,y,x+475,y);
     y=y+ls;
    }
    else {
     y=y+ls+ls/2;
     y=y+ls;
    }
   }

   s=L->Atr.GetAtr(kAtrVal);
   if(s){
    Font.setBold(false);
    P.setFont(Font);
    y=y+ls/2;
    rp.setRect(x,y,tab-10,100);
//    r1=P.boundingRect(r,AlignLeft|AlignTop,*s);
//    if (pg==NP) P.drawText(r1,AlignLeft|AlignTop,*s);
 //   printf("%d %d %d %d %s\n",r1.left(),r1.top(),r1.width(),r1.height(),
 //                              (const char *)*s);

//    s=L->Atr.GetAtr(kAtrVal);
    if(!s->isEmpty()) s1=*s;
    else s1="NoValue";
    s=L->Atr.GetAtr(kAtrSubV);
    if(s && !s->isEmpty()){
     s1=s1+"/";
     s1=s1+*s;
    }
    s=L->Atr.GetAtr(kAtrPkg);
    if(s && !s->isEmpty()){
     s1=s1+" - ";
     s1=s1+*s;
    }
    r.setRect(x+tab,y,230-tab,100);
    r1=P.boundingRect(r,Qt::AlignLeft|Qt::AlignTop,s1);
    if (pg==NP) P.drawText(r1,Qt::AlignLeft|Qt::AlignTop,s1);
    y=y+ls;

    s=L->Atr.GetAtr(kAtrComm);
    if(s && !s->isEmpty()){
     r.setRect(x,y,230,200);
     r1=P.boundingRect(r,Qt::AlignLeft|Qt::AlignTop,*s);
     if (pg==NP) P.drawText(r1,Qt::AlignLeft|Qt::AlignTop,*s);
     y=y+r1.height();
    }

    poc=1;

    s=L->Atr.GetAtr(kAtrRef);
    if(s) s1=*s;

    while(L->Next && (*L->Atr.GetAtr(kAtrVal))==(*L->Next->Atr.GetAtr(kAtrVal))
          && (*L->Atr.GetAtr(kAtrSubV))==(*L->Next->Atr.GetAtr(kAtrSubV))
          && (*L->Atr.GetAtr(kAtrComm))==(*L->Next->Atr.GetAtr(kAtrComm))
          && (*L->Atr.GetAtr(kAtrPkg))==(*L->Next->Atr.GetAtr(kAtrPkg))){

     if(L->BName!=L->Next->BName && Typ==3){
      r.setRect(x+tab2,y,230-tab2,200);
      r1=P.boundingRect(r,Qt::AlignLeft|Qt::AlignTop,s1);
      if (pg==NP) P.drawText(r1,Qt::AlignLeft|Qt::AlignTop,s1);
      r.setRect(x+tab1,y,tab2-tab1,200);
      y=y+r1.height();
      s1=L->BName;
      s1+=" :";
      r1=P.boundingRect(r,Qt::AlignLeft|Qt::AlignTop,s1);
      if(pg==NP) P.drawText(r1,Qt::AlignLeft|Qt::AlignTop,s1);
      s1="";
     }

     L=L->Next;
     s=L->Atr.GetAtr(kAtrRef);
     if(!s1.isEmpty()) s1+=", ";
     s1=s1+*s;
     poc++;

    }

    if(Typ==3){
     r.setRect(x+tab2,y,230-tab2,200);
     r1=P.boundingRect(r,Qt::AlignLeft|Qt::AlignTop,s1);
     if (pg==NP) P.drawText(r1,Qt::AlignLeft|Qt::AlignTop,s1);
     r.setRect(x+tab1,y,tab2-tab1,200);
     y=y+r1.height();
     s1=L->BName;
     s1+=" :";
     r1=P.boundingRect(r,Qt::AlignLeft|Qt::AlignTop,s1);
     if(pg==NP) P.drawText(r1,Qt::AlignLeft|Qt::AlignTop,s1);
     s1="";
    }

    if(Typ==1){
     r.setRect(x+tab1,y,230-tab1,200);
     r1=P.boundingRect(r,Qt::AlignLeft|Qt::AlignTop,s1);
     if (pg==NP) P.drawText(r1,Qt::AlignLeft|Qt::AlignTop,s1);
     y=y+r1.height();
    }

    s1.setNum(poc);
    s1+="ks";
    r1=P.boundingRect(rp,Qt::AlignLeft|Qt::AlignTop,s1);
    if (pg==NP) P.drawText(r1,Qt::AlignLeft|Qt::AlignTop,s1);


    if(y>800-5*ls){
     if(x<200){
      y=40;
      y=y+2*ls+ls/2;
      x=305;
     }
     else{
      pg++;
      y=40;
      x=60;
     }
    }
   }
   else printf("DrawPage : Error\n");
  }

  L=L->Next;
 }
 x=60;
 y=800-ls+ls/2;
 if(NP<10000){
  Font.setBold(true);
  P.setFont(Font);
  P.drawLine(x,y,x+475,y);
  ConvHead(Tail.toLatin1().data(),&Ls,&Rs,NP);
  r.setRect(x,y,475,ls+ls/2);
  P.drawText(r,Qt::AlignLeft|Qt::AlignVCenter,Ls);
  P.drawText(r,Qt::AlignRight|Qt::AlignVCenter,Rs);

  y=y+ls+ls/2;
  P.drawLine(x,y,x+475,y);
 }
 return pg;
}
