/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "PartDlg.h"
#include "Dlg.h"
//#include "FontSel.h"


#include <QLabel>
#include <QPainter>
#include <QPalette>
#include <QFontDialog>
#include <QPrintDialog>
//Added by qt3to4:
#include <QResizeEvent>
#include <QMouseEvent>
#include <QPaintEvent>
#include <QFileDialog>

PartDlg::PartDlg(Part * C, QWidget *parent )
    : QDialog( parent )
{
 P=C;
// QLabel *L;
 ok = new QPushButton( "Ok", this );
 ok->setFont( QFont( "Times", 18, QFont::Bold ) );
 connect( ok, SIGNAL(clicked()), SLOT(OK()) );

 PW= new PartWdg(P,this);
 PW->show();

 PU = new QPushButton( "Page +", this );
 PU->setFont( QFont( "Times", 18, QFont::Bold ) );
 connect( PU, SIGNAL(clicked()), PW,SLOT(IncPN()));

 PD = new QPushButton( "Page -", this );
 PD->setFont( QFont( "Times", 18, QFont::Bold ) );
 connect( PD, SIGNAL(clicked()), PW,SLOT(DecPN()));

 PR = new QPushButton( "Print", this );
 PR->setFont( QFont( "Times", 18, QFont::Bold ) );
 connect( PR, SIGNAL(clicked()), PW,SLOT(Print()));

 WR = new QPushButton( "Write csv", this );
 WR->setFont( QFont( "Times", 18, QFont::Bold ) );
 connect( WR, SIGNAL(clicked()), PW,SLOT(WrCsv()));

 SH = new QPushButton( "Head", this );
 SH->setFont( QFont( "Times", 18, QFont::Bold ) );
 connect( SH, SIGNAL(clicked()), PW,SLOT(SetHead()));

 ST = new QPushButton( "Tail", this );
 ST->setFont( QFont( "Times", 18, QFont::Bold ) );
 connect( ST, SIGNAL(clicked()), PW,SLOT(SetTail()));

 SF = new QPushButton( "Font", this );
 SF->setFont( QFont( "Times", 18, QFont::Bold ) );
 connect( SF, SIGNAL(clicked()), PW,SLOT(SetFont()));


 setMinimumSize( 700, 600 );
 setMaximumSize( 700, 900 );
}

PartDlg::~PartDlg()
{
 if (P) delete P;
}



void PartDlg::Sort(int /*v*/)
{

}



void PartDlg::OK()
{
 accept();
 delete this;
}


void PartDlg::resizeEvent ( QResizeEvent * /*e*/)
{
 int w;
 int h;


   w=width();
   h=height();

 PU->setGeometry( w-85,h-120, 75,30 );
 PD->setGeometry( w-85,h-160, 75,30 );

 PR->setGeometry( w-85,20, 75,30 );
 WR->setGeometry( w-85,60, 75,30 );
 SH->setGeometry( w-85,100, 75,30 );
 ST->setGeometry( w-85,140, 75,30 );
 SF->setGeometry( w-85,180, 75,30 );

 ok->setGeometry( w-85,h-40, 75,30 );
 PW->setGeometry( 0,0, w-100,h );
}



//-=---------------------------------------------------------------------------


PartWdg::PartWdg(Part * C, QWidget *parent )
    : QWidget( parent )
{
 P=C;

 HOff=0;
 VOff=0;

 Zoom=100;
 PN=1;

 Font.setFamily("times new roman");
 Font.setPointSize(12);

 VS=new QScrollBar(Qt::Vertical,this);
 connect( VS, SIGNAL(valueChanged(int)), SLOT(MoveY(int)) );


 QPalette p(Qt::white);
 setPalette(p);

/* QPainter  paint;
 paint.begin(this);
 MaxP=P->DrawPage(paint,Font,20000);
 paint.end(); */
 MaxP=10;

}

PartWdg::~PartWdg()
{

}


void PartWdg::IncPN()
{
 if(PN<MaxP) PN++;
 update();
}

void PartWdg::DecPN()
{
 if(PN>1) PN--;
 update();
}


void PartWdg::MoveY(int y)
{
 VOff=y;
 update();
}

void PartWdg::SetHead()
{
 QString * s;
 QString s1;
 StrDlg DL(NULL);
 s=P->GetHead();
 s1=*s;
 QString s2="Db Type :";
 if (DL.GetStr(&s1,s2)){
  *s=s1;
  update();
 }
}

void PartWdg::SetTail()
{
 QString * s;
 QString s1;
 StrDlg DL(NULL);
 s=P->GetTail();
 s1=*s;
 QString s2="Db Type :";
 if (DL.GetStr(&s1,s2)){
  *s=s1;
  update();
 }
}

void PartWdg::SetFont()
{
 bool ok;

 Font=QFontDialog::getFont(&ok, Font, this);
 if(ok){
//  printf("Font sel OK\n");QFont 

  QPainter  paint;
  paint.begin(this);
  MaxP=P->DrawPage(paint,Font,20000);
  paint.end();
  update();
 }
}



void PartWdg::Print()
{
 QPrinter prt;
 QPainter p;

 QPrintDialog printDialog(&prt, this);

 int i;
// prt.setMinMax(1,MaxP);
 if(printDialog.exec() == QDialog::Accepted){
  p.begin(&prt);

  for(i=prt.fromPage();i<=prt.toPage();i++){
   P->DrawPage(p,Font,i);
   if(i<prt.toPage()) prt.newPage();
  }

  p.end();
 }
}

void PartWdg::WrCsv()
{
  QString s;
  s = QFileDialog::getSaveFileName(this, tr("Save File"),0,tr("*.csv"));
  if (s.isEmpty()) return;

  QFile F(s);
  F.open(QIODevice::WriteOnly);

  QTextStream S;
  S.setDevice(&F);

  P->Sort();
//  P->List();
  P->WriteCsv(S,0);
  S<<"\n";
  F.close();
}



void PartWdg::paintEvent( QPaintEvent * /*e*/)
{
 QPainter  paint;
 paint.begin(this);
 paint.translate(-HOff,-VOff);
 P->DrawPage(paint,Font,PN);
 paint.end();
}

void PartWdg::mouseMoveEvent( QMouseEvent * /*e*/ )
{
}

void PartWdg::mousePressEvent ( QMouseEvent * /*e*/ )
{
}

void PartWdg::mouseReleaseEvent ( QMouseEvent * /*e*/)
{
}

void PartWdg::resizeEvent ( QResizeEvent * /*e*/)
{
 int w;
 int h;


   w=width();
   h=height();

 if(h>=841){
  VS->hide();
 }
 else{
  VS->setGeometry( w-15,0, 15,h );
  VS->setRange(0,841-h);
//  VS->setSteps(1,h);
  VS->show();
 }
}











