/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PicEl_included
#define PicEl_included

#include "Global.h"
#include "Layers.h"

#include <QWidget>
#include <QTextStream>


enum {
 kPicEl=0,
 kPicLine,
 kPicPoly,
 kPicRect,
 kPicCir,
 kPicPower,
 kPicText,
 kPicGrp,
 kPicPadS,
 kPicPin,
 kPicPComp,
 kPicSComp,
 kPComp,
 kSComp,
// kSCGrp,
 kDbSch,
 kDbPcb,
 kPicNet,
 kPicPNet,
 kDbPrj
};


enum {
 kSIDNone=0,
 kSIDPinN,
 kSIDRef,
 kSIDVal,
 kSIDSubV,
 kSIDComm,
 kSIDPkg,
 kSIDPower,
 kSIDDate,
 kSIDFName,
 kSIDVer,
 kSIDEnd
};




// #define ORectDEBUG

class QPainter;
class QPainterPath;
class QColor;
class QString;

class PicEl
{

public:

  PicEl(Layers * L);
  virtual ~PicEl();

  virtual int GetIden();
  virtual int GetSubIden();
  const char * GetsSID(int i);
  void SetSubIden(int i);

   void Draw(QPainter* P,int flag=kDrawAll);
   void DrawTo(QPainter* P,int x,int y,int rot,int flag=kDrawAll);
   void ReDraw(QPainter* P,QRect* Rec,int flag=kDrawAll,
               int x=0,int y=0,int rot=0,int mir=0,bool HL=false);

  void MoveTo(int x, int y);
  void MoveBy(int x, int y);
  void MoveTo(QPoint p);
  void Rotate(int rot);
  void RotateTo(int rot);

  virtual bool Select(int x,int y,int mode=0,int mir=0);
  virtual bool Select(QPoint p,int mode=0,int mir=0);

  virtual bool Select(QRect r,int mode=0,int mir=0);
  virtual bool Select(PicEl * E);

  virtual int SelPoint(int x,int y,int tol=0,int mode=0,int mir=0);
  virtual int SelPoint(QPoint p,int tol=0,int mode=0,int mir=0);

  virtual bool SelPoint(QRect r,int mode=0,int mir=0);

  virtual void MovePointTo(int x, int y);
  virtual void MovePointTo(QPoint p);
  virtual void MovePointBy(int x, int y);

  void SelThis(int s=1, int sp=0);
  void HL();
  bool IsHL();

  virtual void DeSelect();

  virtual bool GetInfo(QString & i,QPoint p,int mode=0,int mir=0);

  virtual void SelInfo(int l=0);

  virtual void HLSel(int fl=0);
  virtual void HLOff();

  virtual int IsSelect();
  virtual bool IsPointSel();

  virtual QPoint GetSelPoint();

  int GetMirror();
  void SetMirror(int m);
  void Mirror();

  int GetRotate();
  int X();
  int Y();
  QPoint Pos();

  unsigned long int GetLayer();
  unsigned long int GetLayer(int m);
  void SetLayer(unsigned long int L);
  void SetWidth(int w);
  int GetWidth();
  void GetORect(QRect* r);
//  void GetORect(int rot,QRect* r);

  virtual void TextSave(QTextStream * S, bool sel=false);
  void TextLoad(QTextStream * S);

  virtual bool IsLock(int l=0);

  Layers * GetLayers();
  void SetORect();

  virtual PicEl * GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                        int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);
  virtual PicEl * GetNextEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                            int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad);




  unsigned long long ID;


protected:

  virtual void  Paint(QPainter* P,QRect* Rec,int flag,QColor* col,
                      int x,int y,int rot,int mir,bool HL);
  virtual void  SetOutl();
  virtual bool  TLoadNext(QTextStream * S,QString* s);

   void TextLoadSkip(QTextStream * S);
   QString TextLoadStr(QTextStream * S);

  void CompRot(int rot,int* x,int* y,int mir);
  QPoint CompRot(int rot,const QPoint &p,int mir);
  QRect CompRot(int rot,const QRect & r,int mir);

  void TransPoly(QPainterPath & Po, int fl);

protected:

  Layers * Layer;

  int wid;
  QRect R;
  QPoint Ref;
  unsigned long int Ly;
  int Rot;
  int Mir;
  int Sel;
  int SelP;
  int SID;

  bool HiL;

private:

};

#endif
