/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "PicEl.h"
#include "PicPin.h"
#include "Layers.h"
#include "PicGrp.h"
#include "PicObj.h"
#include "Library.h"
#include "ObjEdit.h"

#include <QPainter>
#include <QPen>
#include <QColor>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

extern Library gLib;


PicPin::PicPin(Layers *L)
 :PicGrp(L)
{
 PinNum=0;
 PinS=NULL;
}

PicPin::~PicPin()
{
}

int PicPin::GetIden()
{
 return kPicPin;
}

void PicPin::AddTreeList(TreeListItem * LI)
{
 LI->setText( 1,Name);
 PicGrp::AddTreeList(LI);
}


void PicPin::SetName(QString n)
{
 Name=n;
}
QString PicPin::GetName()
{
 return Name;
}

void PicPin::SetNum(int n)
{
 PinNum=n;
}
int PicPin::GetNum()
{
 return PinNum;
}

void PicPin::SetPinStr(QString * S)
{
 PinS=S;
}

bool PicPin::LibPart(QString name)
{
 Name=name;
 PicPin * E=(PicPin *)gLib.GetComp(name,Layer,kPicPin);
 if (E){
  Data=E->GetData();
  Lock=true;
//  SetOutl();
  return true;
 }
 return false;
}



void PicPin::Paint(QPainter* P,QRect* Rec,int flag,QColor* /*col*/,
                   int x,int y,int rot,int mir,bool HL)
{
  GrpEl* T=Data;
  if (flag==kDrawSel && Lock) flag=kDrawAll;

  while(T!=NULL){
   if(Lock && T->E->GetIden()==kPicText && T->E->GetSubIden()==kSIDPinN){
    ((PicText*)T->E)->SText(PinS);
    T->E->ReDraw(P,Rec,flag,x,y,rot,mir,HL);
    ((PicText*)T->E)->SText(NULL);
   }
   else T->E->ReDraw(P,Rec,flag,x,y,rot,mir,HL);
   T=T->Next;
  }
#ifdef ORectDEBUG
 QRect r=R;
 r=CompRot(rot,r,mir);
 r.moveBy(x,y);
 P->setPen(Qt::black);
 P->drawRect(r);
#endif
}


void PicPin::TextSave(QTextStream * S, bool sel)
{
 if (Lock){
  PicEl::TextSave(S,sel);
  *S << "    {Lock " << Lock << " }\n";
  *S << "    {PinNum " << PinNum << " }\n";
  *S << "    {Name " << Name << " }\n";
  *S << "   }\n";
 }
 else{
//  *S << " " << Name << " ";
  PicGrp::TextSave(S,sel);
 }
}

bool  PicPin::TLoadNext(QTextStream * S,QString* s)
{
 if (s->contains("Name")){
  QString s1;
  *S >> s1;
  TextLoadSkip(S);
  Name=s1;
  PicGrp * E=gLib.GetComp(s1,Layer,kPicPin);
  if (E) Data=E->GetData();
 }
 else if (s->contains("PinNum")){
  *S >> PinNum;
  TextLoadSkip(S);
 }
 else  return PicGrp::TLoadNext(S,s);
 return true;
}

