/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PinLst_included
#define PinLst_included

#include <QString>
//#include <qtstream.h>
//Added by qt3to4:
#include <QTextStream>



class PinList
{

struct PinLst {
  int Num;
  QString Net;
//  SComp * C;
  PinLst * Next;
};


public:

 PinList();
 virtual ~PinList();

 PinList  &operator=(PinList &A);

 PinList::PinLst ** GetPL();
 int * GetPoc();

 void SetActPinNet(QString net);
 void GetActPinNet(QString &net);

 void GetPinR();
 bool GetPinNext(int * n,QString *net);

 bool GetPin(int * n,QString *net);
 bool GetNextPin(int * n,QString *net);

 void Clean();
 void AddPin(int n);
 void SetNet(int n, QString net);
 QString * GetNet(int n);

 bool TextLoad(QTextStream * S);
 void TextSave(QTextStream * S, bool sel=false);

protected:



private:

  PinLst  ** PL;
  PinLst  * AP;

  int * Poc;

};


#endif
