/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "SComp.h"
#include "PComp.h"
#include "Layers.h"
#include "Library.h"
#include "ObjEdit.h"

#include <QPainter>
#include <QPen>
#include <QColor>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

//static const char *AtrName[] = { "Ref", "Val", "SubV", "Comm", "Pkg", 0 };


extern Library gLib;

SComp::SComp(Layers *L)
 :PicGrp(L)
{
// PL=NULL;
// PC=NULL;
 InGrp=false;
// Atr=new QString[AtrN];
}


SComp::~SComp()
{
}

int SComp::GetIden()
{
 return kSComp;
}

void SComp::AddTreeList(TreeListItem * LI)
{
 if(Atr.GetAtr(0)!=NULL) LI->setText( 1,*Atr.GetAtr(0));
 PicGrp::AddTreeList(LI);
}


QString  SComp::GetAtr(int n)
{
 QString * s;
 if (n>=0 && n<AtrN){
  s=Atr.GetAtr(n);
//  printf("SComp::GetAtr %s\n",s->toLatin1().data());
  if(s) return *s;
 }
 return "";
}

void SComp::SetAtr(int n, const char * s)
{
 if (n>=0 && n<AtrN) Atr.SetAtr(n,s);
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kPicText){
   T->E->SetORect();
  }
  T=T->Next;
 }
// SetOutl();
}

const char * SComp::GetAtrNam(int n)
{
 if (n>=0 && n<AtrN) return Atr.GetName(n);
 return NULL;
}

/*QString * SComp::GetAtr()
{
 return Atr;
}*/

/*void SComp::SetAtr(QString * A)
{
 if(Atr && !InGrp) delete[] Atr;
 Atr=A;
}*/

Atrib & SComp::GetAtr()
{
 return Atr;
}

void SComp::SetAtr(Atrib & A)
{
 Atr=A;
}

PinList & SComp::GetPL()
{
 return PL;
}

void SComp::SetPL(PinList & P)
{
 PL=P;
}


void SComp::SetInGrp(bool x)
{
 InGrp=x;
}

bool SComp::IsInGrp()
{
 return InGrp;
}

void SComp::UpdatePins()
{
/* PinLst * L=PL;
 while (PL){
  L=L->Next;
  delete PL;
  PL=L;
 }
 PL=NULL;
 PicSComp * P=GetPSComp();
 if(P){
  int i;
  QString s;
  i=P->GetPin(&s);
  while(i>=0){
   L=new PinLst;
   L->Num=i;
   L->Net=s.copy();
   L->Next=PL;
   PL=L;
   i=P->GetNextPin(&s);
  }
 }*/

 int i;
 QString s;

// printf("UpdatePins: %s\n",GetAtr(kAtrRef));
 if(!InGrp) PL.Clean();
// printf("UpdatePins: Clean\n");

 PicSComp * P=GetPSComp();

 if(P){
//  printf("UpdatePins: GetPSComp\n");
//  printf("UpdatePins: GetPin\n");
  i=P->GetPin(&s);
  while(i>=0){
//   printf("UpdatePins: AddPin\n");
   PL.AddPin(i);
//   printf("UpdatePins: SetNet\n");
   PL.SetNet(i,s);
//   printf("UpdatePins: GetNextPin\n");
   i=P->GetNextPin(&s);
  }
 }
// printf("UpdatePins: OK\n");

}

int SComp::GetPin(QString *net,QPoint * p,int * n)
{
 if(PL.GetPin(n,net)){
  if(GetPinPos(p,*n))return 1;
  return 2;
 }
 return 0;
}

int SComp::GetNextPin(QString *net,QPoint * p,int * n)
{
 if(PL.GetNextPin(n,net)){
  if(GetPinPos(p,*n))return 1;
  return 2;
 }
 return 0;
}

/*bool SComp::GetActPin(QString *net,QPoint * p,int * n)
{
 if (ActP){
  PicSComp * P=GetPSComp();
  *net=ActP->Net.copy();
  P->GetPinPos(p,ActP->Num);
  *p=CompRot(Rot,*p,Mir);
  *p=*p+Ref;
  *n=ActP->Num;
  return true;
 }
 return false;
}*/



void SComp::SetActPinNet(QString net)
{
// ActP->Net=net.copy();
 PL.SetActPinNet(net);
}

void SComp::GetActPinNet(QString &net)
{
// ActP->Net=net.copy();
 PL.GetActPinNet(net);
}


bool SComp::GetPinPos(QPoint * p,int n)
{
 PicSComp * P=GetPSComp();
 if (P->GetPinPos(p,n)){
  *p=CompRot(Rot,*p,Mir);
  *p=*p+Ref;
  return true;
 }
 return false;
}


PicSComp * SComp::GetPSComp()
{
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kPicSComp) return (PicSComp *)(T->E);
  T=T->Next;
 }
 return NULL;
}


bool SComp::Select(QPoint p,int mode,int mir)
{
 bool x=PicGrp::Select(p,mode,mir);
 if (x){
  GrpEl * T=Data;
  while(T){
   if(T->E->GetIden()==kPicSComp && T->E->IsSelect()){
    DeSelect();
    Lock=2;
    Sel=1;
   }
   T=T->Next;
  }
 }
 return x;
}

bool SComp::Select(QRect r,int mode,int mir)
{
 bool x=PicGrp::Select(r,mode,mir);
 if (x){
  GrpEl * T=Data;
  while(T){
   if(T->E->GetIden()==kPicSComp && T->E->IsSelect()){
    DeSelect();
    Lock=2;
    Sel=1;
   }
   T=T->Next;
  }
 }
 return x;
}

bool SComp::Select(PicEl * E)
{
 bool x=PicGrp::Select(E);
 if (x){
  GrpEl * T=Data;
  while(T){
   if(T->E->GetIden()==kPicSComp && T->E->IsSelect()){
    DeSelect();
    Lock=2;
    Sel=1;
   }
   T=T->Next;
  }
 }
 return x;
}

void SComp::DeSelect()
{
 if (Lock==2) Lock=0;
 PicGrp::DeSelect();
}


PicText * SComp::AddAtr(int A)
{
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kPicText && T->E->GetSubIden()==kSIDRef+A)
   return (PicText *)T->E;
  T=T->Next;
 }
 PicText * E=new PicText(Layer);
 E->SetSubIden(kSIDRef+A);
 E->SetText(Atr.GetAtr(A));
 AddItem(E);
 return E;
}

void SComp::SetType(QString Typ,CnvAtr * CA)
{
 GrpEl * T=Data;
// int i;
 PicSComp * P=GetPSComp();

 CA->Convert(P->GetComm(Typ),P->GetPkg(Typ),Atr);

 while(T){
  if(T->E->GetIden()==kPicText){
   T->E->SetORect();
  }
  T=T->Next;
 }
// SetOutl();
}

void SComp::SetVer(int Ver)
{
 Atr.SetVer(Ver);
 UpdateAtr();
}


void SComp::UpdateAtr()
{
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kPicText && T->E->GetSubIden()>=kSIDRef){
   ((PicText *)(T->E))->SetText(Atr.GetAtr(T->E->GetSubIden()-kSIDRef));
  }
  T=T->Next;
 }
 UpdORect();
}

bool SComp::LibPart(QString name)
{
 PicSComp * E=new PicSComp(Layer);
 if (E->LibPart(name)){
  AddItem(E);
//  if(Atr[0].isEmpty()) Atr[0]=*(E->GetRef());
//  if(Atr[1].isEmpty()) Atr[1]=*(E->GetVal());
  if(E->GetRef() && !(E->GetRef()->isEmpty())){
//   printf("LibPart : set Ref\n");
//   if(Atr.isEmpty(kAtrRef)) printf("LibPart : Ref is empty\n");
   if(Atr.isEmpty(kAtrRef)) Atr.SetAtr(kAtrRef,*(E->GetRef()));
   if(Atr.isEmpty(kAtrVal)){
     if(E->GetVal()->isEmpty()) Atr.SetAtr(kAtrVal,name);
     else Atr.SetAtr(kAtrVal,*(E->GetVal()));
   }
  }
//  SetOutl();
//  Lock=2;
  return true;
 }
 else {
  delete E;
  return false;
 }
}

bool SComp::ToPcb(PComp * C)
{
 if(C->ChLibPart(*Atr.GetAtr(kAtrPkg))){
  C->SetAtr(Atr);
  C->SetPinL(PL);
  return true;
 }
 return false;
}

bool SComp::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  if(PicGrp::GetInfo(i,p,mode,mir)){
    QString * s;
    s=Atr.GetAtr(kAtrRef);
    if(s){
      i+=" R:";
      i+=*s;
    }
    return true;
  }
  return false;
}

void SComp::TextSave(QTextStream * S, bool sel)
{
// int i;
 PicEl::TextSave(S,sel);
 Atr.TextSave(S);
/* *S << "    {PinCn\n";
 PinLst* T=PL;
 while (T!=NULL){
  *S << "      "<< T->Num;
  *S << " " << T->Net << "\n";
   T=T->Next;
 }
 *S << "    }\n";*/
 PicGrp::TextSaveNext(S,sel);
}

bool  SComp::TLoadNext(QTextStream * S,QString* s)
{
// int i;
 if(Atr.TextLoadNext(S,s)) return true;
 else if (s->contains("PinCn")){
/*  QString s1;
  *S >> s1;
  PinLst * T;
  while (!s1.contains("}")){
   T=new PinLst;
   T->Next=PL;
   PL=T;
   T->Num=s1.toInt();
   *S >> T->Net;
   *S >> s1;
  }*/
  TextLoadSkip(S);
 }
 else  return PicGrp::TLoadNext(S,s);
 return true;
}

//-----------------------------------------------------------------------------
/*
SCGrp::SCGrp(Layers *L)
 :PicGrp(L)
{
 PL=NULL;
 PC=NULL;
 Atr=NULL;
}


SCGrp::~SCGrp()
{
 if(PC){
  PC->DelAtr();
  PC->SetPinL(NULL);
  PC->SetSC(NULL);
 }
 printf("SComp Del\n");
 SComp::PinLst* T;
 T=PL;
 while (T!=NULL){
  PL=T->Next;
  delete T;
  T=PL;
 }
}

int SCGrp::GetIden()
{
 return kSCGrp;
}


void SCGrp::SetType(QString Typ)
{
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kSComp){
   ((SComp *)(T->E))->SetType(Typ);
   return;
  }
  T=T->Next;
 }
}

const char * SCGrp::GetAtr(int n)
{
 if (n>=0 && n<AtrN && Atr) return Atr[n];
 return NULL;
}

void SCGrp::UpdateAtr()
{
 GrpEl * T=Data;
 SComp * C;
 while(T){
  if(T->E->GetIden()==kSComp){
   C=(SComp *)T->E;
   if (C->IsInGrp()){
    C->SetAtr(Atr);
   }
   else{
    if(!Atr){
     Atr=C->GetAtr();
     C->SetInGrp(true);
    }
    else{
     C->SetAtr(Atr);
     C->SetInGrp(true);
    }
   }
   C->UpdateAtr();
  }
  T=T->Next;
 }
}

void SCGrp::UpdatePins()
{
 SComp::PinLst * L=PL;
 while (PL){
  L=L->Next;
  delete PL;
  PL=L;
 }
 PL=NULL;

 PicSComp * P;
 GrpEl * T=Data;
 SComp * C;
 int i;
 while(T){
  if(T->E->GetIden()==kSComp){
   C=(SComp *)T->E;
   P=C->GetPSComp();
   if(P){
    QString s;
    i=P->GetPin(&s);
    while(i>=0){
     L=new SComp::PinLst;
     L->Num=i;
     L->C=C;
     L->Net=s.copy();
     L->Next=PL;
     PL=L;
     i=P->GetNextPin(&s);
    }
   }
  }
  T=T->Next;
 }
}

bool SCGrp::GetPin(QString *net,QPoint * p,int * n)
{
 ActP=PL;
 return GetActPin(net,p,n);
}
bool SCGrp::GetNextPin(QString *net,QPoint * p,int * n)
{
 if(ActP) ActP=ActP->Next;
 return GetActPin(net,p,n);
}

bool SCGrp::GetSPin(QString *net,QPoint * p,int * n)
{
 ActP=PL;
 while(ActP && ActP->C->IsSelect()!=1) ActP=ActP->Next;
 if (ActP) return GetActPin(net,p,n);
 return false;
}
bool SCGrp::GetNextSPin(QString *net,QPoint * p,int * n)
{
 if(ActP) ActP=ActP->Next;
 while(ActP && ActP->C->IsSelect()!=1) ActP=ActP->Next;
 if (ActP) return GetActPin(net,p,n);
 return false;
}

bool SCGrp::GetActPin(QString *net,QPoint * p,int * n)
{
 if (ActP){
  *net=ActP->Net.copy();
  ActP->C->GetPinPos(p,ActP->Num);
  *p=CompRot(Rot,*p,Mir);
  *p=*p+Ref;
  *n=ActP->Num;
  return true;
 }
 return false;
}

void SCGrp::SetActPinNet(QString net)
{
 ActP->Net=net.copy();
}

bool SCGrp::ToPcb(PComp * C)
{
 if (PC && PC!=C) return false;
 if(C->ChLibPart(Atr[kAtrPkg])){
  C->SetAtr(Atr);
  C->SetPinL(PL);
  C->SetSCG(this);
  PC=C;
  return true;
 }
 return false;
}

void SCGrp::DelPC()
{
 PC=NULL;
}

*/
