/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Table.h"
//#include <qpainter.h>
//#include <qnamespace.h>
//#include <qprinter.h>

/*
  Constructs a Table widget.
*/

Table::Table( int numRows, int numCols, QWidget *parent )
    : QTableWidget(parent)
{
//    curRow = curCol = -1;      // set currently selected cell
//    setFocusPolicy( StrongFocus );    // we accept keyboard focus
//    setBackgroundMode( PaletteBase );    // set widgets background
//    setNumCols( numCols );      // set number of col's in table    
//    setNumRows( numRows );      // set number of rows in table

    setColumnCount( numCols );
    setRowCount( numRows );

//    setCellWidth( 0 );      // set width of cell in pixels
//    setCellHeight( 20 );      // set height of cell in pixels
//    resize( 400, 200 );        // set default size in pixels

//    contents = new QString[numRows * numCols];  // make room for contents
//    RHead = new QString[numRows];
//    CHead = new QString[numCols+1];
//    ColW = new int[numCols+1];
//    int i;
//    for(i=1;i<numCols+1;i++) ColW[i]=100;
//    ColW[0]=20;

//    LE=new QLineEdit(this);
//    LE->hide();
//    connect( LE, SIGNAL(textChanged(const char *)), this,SLOT(ChangeCont(const char *)) );
//    connect( LE, SIGNAL(textChanged(const QString&)), this,SLOT(ChangeCont(const QString&)) );

//    setTableFlags( Tbl_autoScrollBars |    // always vertical scroll bar
//       Tbl_hScrollBar |    // ditto for horizontal
//       Tbl_clipCellPainting |  // avoid drawing outside cell
//       Tbl_smoothScrolling);  // easier to see the scrolling

}


/*
  Destructor: deallocates memory for contents
*/

Table::~Table()
{
//    delete[] contents;        // deallocation
//    delete[] RHead;
//    delete[] CHead;
//    delete[] ColW;

}

void Table::SetSize(int row, int col)
{

// setNumCols( col );
// setNumRows( row );

  setColumnCount( col );
  setRowCount( row );

/* int ocol=numCols()-1;
 int orow=numRows()-1;

 curRow = curCol = -1;

 QString * co = new QString[col * row];
 QString * RH = new QString[row];
 QString * CH = new QString[col+1];
 int * CW = new int[col+1];
 int i,j;
 for(i=0;(i<orow && i<row);i++){
  for(j=0;(j<ocol && j<col);j++){
   co[i*col+j]=cellContent(i,j);
  }
 }
 for(j=-1;(j<ocol && j<col);j++){
  CH[j+1]=GetCHead(j);
  CW[j+1]=ColW[j+1];
 }
 for(i=0;(i<orow && i<row);i++){
  RH[i]=GetRHead(i);
 }

 delete[] contents;        // deallocation
 delete[] RHead;
 delete[] CHead;
 delete[] ColW;

 contents=co;
 RHead=RH;
 CHead=CH;
 ColW=CW;

 setNumCols( col+1 );
 setNumRows( row+1 );

// update();
*/
}


/*
  Return content of cell
*/

const char* Table::cellContent( int row, int col ) const
{
//    return text( row, col );
  if(item(row,col)==NULL) return "";
  return item(row,col)->text().toLatin1().data();
}


QString Table::cellContentS( int row, int col )
{
  if(item(row,col)==NULL) return "";
  return item(row,col)->text();
}

/*
  Set content of cell
*/

void Table::setCellContent( int row, int col, QString & c )
{
//  setText( row, col,c );
  if(item(row,col)==NULL){
    QTableWidgetItem *I = new QTableWidgetItem;
    setItem(row,col,I);
  }
  item(row,col)->setText(c);

//    contents[indexOf( row, col )] = c;    // contents lookup and assign
//    updateCell( row+1, col+1 );      // show new content
}

//void Table::ChangeCont(const char * s)
/*
void Table::ChangeCont(const QString& s)
{
 if(curRow>0 && curCol>0){
  setCellContent(curRow-1,curCol-1,s);
 }
}
*/


/*
  Handles cell painting for the Table widget.
*/

/*
void Table::paintCell( QPainter* p, int row, int col )
{
 int w = cellWidth( col );      // width of cell in pixels
 int h = cellHeight( row );      // height of cell in pixels
 int x2 = w - 1;
 int y2 = h - 1;

 p->drawLine( x2, 0, x2, y2 );
 p->drawLine( 0, y2, x2, y2 );

 if (row==0) p->drawLine( 0, y2-1, x2, y2-1 );
 if (col==0) p->drawLine( x2-1, 0, x2-1, y2 );


 if (row == curRow && col == curCol){
  int x=100,y=100;

  if(colXPos(col,&x) && rowYPos(row,&y) && row>0 && col>0){
   LE->setGeometry(x,y,w-1,h-1);
   LE->show();
//   LE->setFocus();
  }
  else LE->hide();
 }
 else{
  if (row>0 && col>0){
   p->setFont(QFont( "helvetica", 12 ));
   p->drawText( 0, 0, w, h, AlignLeft, contents[indexOf(row-1,col-1)] );
  }
  else{
   p->setFont(QFont( "times", 14 ,QFont::Bold));
   if(row==0)
    p->drawText( 0, 0, w, h, AlignCenter, CHead[col]);
   else
    p->drawText( 0, 0, w, h, AlignCenter, RHead[row-1]);
  }
 }
}
*/

/*
  Handles mouse press events for the Table widget.
  The current cell marker is set to the cell the mouse is clicked in.
*/

/*
void Table::mousePressEvent( QMouseEvent* e )
{
    int oldRow = curRow;      // store previous current cell
    int oldCol = curCol;
    QPoint clickedPos = e->pos();    // extract pointer position
    curRow = findRow( clickedPos.y() );    // map to row; set current cell
    curCol = findCol( clickedPos.x() );    // map to col; set current cell
    if ( (curRow != oldRow) || (curCol != oldCol) ) {
      updateCell( oldRow, oldCol );
     updateCell( curRow, curCol );
     if (curRow>0 && curCol>0) {
      LE->setText(cellContent(curRow-1, curCol-1));
      LE->setFocus();
     }
    }
}

*/

/*
  Handles key press events for the Table widget.
  Allows moving the current cell marker around with the arrow keys
*/

/*

void Table::keyPressEvent( QKeyEvent* e )
{
 int oldRow = curRow;      // store previous current cell
 int oldCol = curCol;
 int edge = 0;
 switch( e->key() ) {
  case Key_Left:
   if( curCol > 1 ) {
    curCol--;
    edge = leftCell();
    if ( curCol < edge )
     setLeftCell( edge - 1 );
   }
   break;
  case Key_Right:
   if( curCol < numCols()-1 ) {
    curCol++;
    edge = lastColVisible();
    if ( curCol >= edge )
     setLeftCell( leftCell() + 1 );
   }
   break;
  case Key_Up:
   if( curRow > 1 ) {
    curRow--;
    edge = topCell();
    if ( curRow < edge )
     setTopCell( edge - 1 );
   }
   break;
  case Key_Down:
   if( curRow < numRows()-1 ) {
    curRow++;
    edge = lastRowVisible();
    if ( curRow >= edge )
     setTopCell( topCell() + 1 );
   }
   break;
  default:        // If not an interesting key,
   e->ignore();      // we don't accept the event
   return;
 }

 if ( (curRow != oldRow) || (curCol != oldCol) ) {
   updateCell( oldRow, oldCol );
  updateCell( curRow, curCol );
  if (curRow>0 && curCol>0) {
   LE->setText(cellContent(curRow-1, curCol-1));
   LE->setFocus();
  }
 }
}
*/


/*
  Handles focus reception events for the Table widget.
  Repaint only the current cell; to avoid flickering
*/

/*
void Table::focusInEvent( QFocusEvent* )
{
  updateCell( curRow, curCol );    // draw current cell
}
*/

/*
  Handles focus loss events for the Table widget.
  Repaint only the current cell; to avoid flickering
*/
/*
void Table::focusOutEvent( QFocusEvent* )
{
  updateCell( curRow, curCol );    // draw current cell
}
*/

/*
  Utility function for mapping from 2D table to 1D array
*/

/*
int Table::indexOf( int row, int col ) const
{
  return (row * (numCols()-1)) + col;
}
*/
const char* Table::GetRHead( int row ) const
{
//  return verticalHeader()->label(row);
// return RHead[row];

  if(verticalHeaderItem(row)==NULL) return "";
  return verticalHeaderItem(row)->text().toLatin1().data();
}


QString Table::GetRHeadS( int row )
{
  if(verticalHeaderItem(row)==NULL) return "";
  return verticalHeaderItem(row)->text();
}

void Table::SetRHead( int row, QString & c)
{
//  verticalHeader()->setLabel(row,c);
// RHead[row]=c;
// updateCell(row+1,0);

  if(verticalHeaderItem(row)==NULL){
    QTableWidgetItem *I = new QTableWidgetItem;
    setVerticalHeaderItem(row,I);
  }
  verticalHeaderItem(row)->setText(c);
}

const char* Table::GetCHead( int col ) const
{
//  return horizontalHeader()->label(col);
// return CHead[col+1];

  if(horizontalHeaderItem(col)==NULL) return "";
  return horizontalHeaderItem(col)->text().toLatin1().data();
}

void Table::SetCHead( int col, QString & c)
{
//  horizontalHeader()->setLabel(col,c);
// CHead[col+1]=c;
// updateCell(0,col+1);

  if(horizontalHeaderItem(col)==NULL){
    QTableWidgetItem *I = new QTableWidgetItem;
    setHorizontalHeaderItem(col,I);
  }
  horizontalHeaderItem(col)->setText(c);
}


void Table::SetCellWidth(int /*col*/,int /*w*/)
{
// ColW[col+1]=w;
// updateTableSize();
}
/*
int Table::cellWidth ( int col)
{
 return ColW[col];
}
*/
