#ifndef CACHE_TEST_PERFORMANCE_DATA_H
#define CACHE_TEST_PERFORMANCE_DATA_H

#include <array>
#include <tuple>
using std::array;
using std::tuple;

/**
 * Cache hits amd misses recorded after creation of these test.
 * Values are invalidated by any change of testcases.
 * Values were not checked manually, failure of test indicates only a change
 * not a bug.
 */
constexpr std::array<tuple<unsigned, unsigned>, 2460>
    cache_test_performance_data { {
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 18, 28 }, { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 18, 28 }, { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 16, 30 }, { 18, 3 }, { 18, 3 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 16, 30 }, { 18, 3 }, { 18, 3 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 16, 30 }, { 18, 3 }, { 18, 3 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 16, 30 }, { 18, 3 }, { 18, 3 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 18, 28 }, { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 18, 28 }, { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 16, 30 }, { 18, 3 }, { 18, 3 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 16, 30 }, { 18, 3 }, { 18, 3 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 16, 30 }, { 18, 3 }, { 18, 3 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 16, 30 }, { 18, 3 }, { 18, 3 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 18, 28 }, { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 18, 28 }, { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 16, 30 }, { 18, 3 }, { 18, 3 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 16, 30 }, { 18, 3 }, { 18, 3 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 45, 3 },  { 26, 3 }, { 29, 3 }, { 48, 3 },  { 21, 3 }, { 27, 4 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 35, 2 },  { 27, 3 }, { 25, 3 },
        { 35, 2 },  { 27, 3 }, { 25, 3 }, { 45, 3 },  { 26, 3 }, { 29, 3 },
        { 48, 3 },  { 21, 3 }, { 27, 4 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 16, 30 }, { 18, 3 }, { 18, 3 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 16, 30 }, { 18, 3 }, { 18, 3 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 44, 2 },  { 19, 2 }, { 19, 2 },
        { 0, 0 },   { 0, 0 },  { 0, 0 },  { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 33, 1 },  { 19, 1 }, { 19, 1 }, { 33, 1 },  { 19, 1 }, { 19, 1 },
        { 44, 2 },  { 19, 2 }, { 19, 2 }, { 0, 0 },   { 0, 0 },  { 0, 0 },
    } };

#endif // CACHE_TEST_PERFORMANCE_DATA_H
