#
# spec file for package arkanoid
#
# Copyright (c) 2020 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#

%define unmangled_version 0.7-1
Name:           arkanoid
Version:		0.7
Release:        1
Summary:    80s classics game
License:        CC-PDDC
URL:            http://prymula.ct8.pl
Source0:	%{name}-%{unmangled_version}.tar.gz
%if 0%{?suse_version}==1530
BuildRequires:	libSDL2-devel, libSDL2_ttf-devel, pkgconfig, pkgconfig(sdl2)
Requires:       libSDL2-2_0-0, libSDL2_ttf-2_0-0
%else
BuildRequires:	SDL2-devel, SDL2_ttf-devel, pkgconfig, pkgconfig(sdl2)
Requires:       SDL2, SDL2_ttf
%endif
BuildArch:	x86_64

%description


%prep
%setup -n %{name}-%{unmangled_version} -n %{name}-%{unmangled_version}

%build
make

%install
mkdir -p %{buildroot}/usr
mkdir -p %{buildroot}/usr/bin
mkdir -p %{buildroot}%{_datadir}
#mkdir -p %{buildroot}%{_datadir}/fonts
mkdir -p %{buildroot}%{_datadir}/arkanoid
mkdir -p %{buildroot}%{_datadir}/pixmaps
mkdir -p %{buildroot}%{_datadir}/applications

#%make_install

install -m 0755 arkanoid %{buildroot}/usr/bin
install -m 0644 icon/arkanoid.png %{buildroot}%{_datadir}/pixmaps
install -m 0644 icon/gumka_arkanoid.bmp %{buildroot}%{_datadir}/pixmaps
install -m 0644 arkanoid.desktop %{buildroot}%{_datadir}/applications
#install -m 0644 SpicyRice.ttf %{buildroot}%{_datadir}/fonts
install -m 0644 SpicyRice.ttf %{buildroot}%{_datadir}/arkanoid



%files
%defattr(0755,root,root)
/usr/bin/arkanoid
%{_datadir}/arkanoid/
%defattr(0644,root,root)
%{_datadir}/pixmaps/arkanoid.png
%{_datadir}/pixmaps/gumka_arkanoid.bmp
%{_datadir}/applications/arkanoid.desktop
%{_datadir}/arkanoid/SpicyRice.ttf
#%{_datadir}/fonts/SpicyRice.ttf

%changelog
