/*
	arkanoid - moja implementacja klasyka
	wymaga: SDL2, SDL_TTF2
	09-01-2021
	licencja: Public Domain
	edytor: VS Code
	utworzono na platformie: Windows 10 - MinGW32
*/

#include "arkanoid.h"
#include "levels.h"

Kafel kafle[8][8];
SDL_Surface * gumka_kafla;
SDL_Window  *gWindow=NULL;
SDL_Renderer * renderer=NULL;
SDL_Texture * tex_screen=NULL;

int liczba_kafli=0;
int wynik, najlepszy, poziom, zycia;

void rysuj_obrazek (int x, int y, SDL_Surface * obrazek, int przezroczystosc);
SDL_Surface * utworz_powierzchnie(int sz, int w, int r, int g, int b);

SDL_Rect set_rect(int x, int y, int w, int h)
{
	SDL_Rect rect;
	rect.x = x;
	rect.y = y;
	rect.w = w;
	rect.h = h;
	return rect;
}

Uint32 getpixel(SDL_Surface *surface, int x, int y)
{
	int bpp = surface->format->BytesPerPixel;
	/* Here p is the address to the pixel we want to retrieve */
	Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

	switch(bpp) {
		case 1:
			return *p;
		case 2:
			return *(Uint16 *)p;
		case 3:
			if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
				return p[0] << 16 | p[1] << 8 | p[2];
			else
				return p[0] | p[1] << 8 | p[2] << 16;
		case 4:
			return *(Uint32 *)p;
		default:
			return 0;
	}
}



void putpixel(SDL_Surface *surface, int x, int y, Uint8 R, Uint8 G, Uint8 B)
{
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x *
               surface->format->BytesPerPixel;
    if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
    {
       p[0] = R;
       p[1] = G;
       p[2] = B;
    }
    else
    {
       p[0] = B;
       p[1] = G;
       p[2] = R;
    }
}

SDL_Surface * preparuj_tekst(int r, int b, int g, char *bufor) {

   SDL_Color fgcolor;

   fgcolor.r = r;
   fgcolor.b = b;
   fgcolor.g = g;

   return TTF_RenderText_Solid(font_panel, bufor,  fgcolor);
}


void print_text(int r, int g, int b, char *c, int x, int y, int z) {

	SDL_Surface * obraz_info;
	SDL_Surface * gum_info;
	SDL_Rect zrodlo, cel;

	obraz_info = (SDL_Surface *) preparuj_tekst(r, g, b, c);

	// chce wymazac napis
	//cel = set_rect(obraz_info->clip_rect.x, obraz_info->clip_rect.y,
	//				obraz_info->w, obraz_info->h);
	cel = set_rect(x, y,
					obraz_info->w, obraz_info->h);
	zrodlo = set_rect(0, 0, obraz_info->w,  obraz_info->h);
	gum_info=utworz_powierzchnie(obraz_info->w, obraz_info->h, 65, 190, 215);

	SDL_BlitSurface(gum_info, &zrodlo, obraz, &cel);
	SDL_FreeSurface(gum_info);

	rysuj_obrazek(x, y, obraz_info, 1);
	SDL_FreeSurface(obraz_info);
}


SDL_Surface * ustaw_kolor (Kolor kol) {

	SDL_Surface * kafel;
	SDL_Rect cel;

	kafel = SDL_CreateRGBSurface(SDL_SWSURFACE, XKAFLA, YKAFLA,16,0,0,0,0);
	cel = set_rect(0, 0, XKAFLA, YKAFLA);
	SDL_FillRect(kafel, &cel, SDL_MapRGB(kafel->format, kol.r, kol.g, kol.b));

	return kafel;

}

void ustaw_kolor_tla(void) {

   SDL_Rect przez;
	//obraz->clip_rect.x=0;
	//obraz->clip_rect.y=0;
	//obraz->clip_rect.w=640;
	//obraz->clip_rect.h=480;
	asm("nop");
   przez = set_rect(0, 0, obraz->w, obraz->h);
   //przez = set_rect(0, 0, 640, 480);

   SDL_FillRect(obraz, &przez, SDL_MapRGB(obraz->format,65,190,215));
   //SDL_Flip(obraz);
   SDL_RenderPresent ( renderer );
}

void erase (RuchomyObiekt *p){

	SDL_Rect zrodlo, cel;

    cel = set_rect(p->px, p->py, p->gumka->w, p->gumka->h);
	zrodlo = set_rect(0, 0, p->gumka->w, p->gumka->h);
	SDL_BlitSurface(p->gumka,&zrodlo,obraz,&cel);
}


void przerysuj(RuchomyObiekt *p) {
	SDL_Rect zrodlo, cel;
	// wymazuje stara pozycje
    cel = set_rect(p->px, p->py, p->gumka->w, p->gumka->h);
	zrodlo = set_rect(0, 0, p->gumka->w, p->gumka->h);
	SDL_BlitSurface(p->gumka,&zrodlo,obraz,&cel);
    // rysuje na nowej pozycji
    cel = set_rect(p->ax, p->ay, p->obraz->w, p->obraz->h);
	zrodlo = set_rect(0, 0, p->obraz->w, p->obraz->h);
	SDL_BlitSurface(p->obraz,&zrodlo,obraz,&cel);

}

void rysuj_obrazek (int x, int y, SDL_Surface * obrazek, int przezroczystosc) {

   SDL_Rect srcrect, destrect;

	if (przezroczystosc) SDL_SetColorKey(obrazek,SDL_TRUE,getpixel(obrazek,0,0));

   destrect = set_rect(x, y, obrazek->w, obrazek->h);
   srcrect = set_rect(0,0,obrazek->w, obrazek->h);
   SDL_BlitSurface(obrazek,&srcrect,obraz,&destrect);
}


SDL_Surface * utworz_powierzchnie(int sz, int w, int r, int g, int b) {

	SDL_Surface * powierzchnia;
	SDL_Rect cel;

	powierzchnia = SDL_CreateRGBSurface(SDL_SWSURFACE, sz, w,16,0,0,0,0);
	cel = set_rect(0, 0, sz, w);
	SDL_FillRect(powierzchnia, &cel, SDL_MapRGB(powierzchnia->format, r, g, b));

	return powierzchnia;
}

Uint32 ruch_pilki(Uint32 interval, void *param)
{
	SDL_Rect zrodlo, cel;
	Teczka * t = (Teczka *) param;
	int i, j;

	przerysuj(t->pilka);

	if (t->pilka->ax <= 5) t->pilka->kx=5;
	if (t->pilka->ax >= 605) t->pilka->kx=-5;
	if (t->pilka->ay <=30) t->pilka->ky=5;

	/* odpicie przez paletke */
	if (t->pilka->ax+XPILKI >= t->paletka->ax && (t->pilka->ax) <= (t->paletka->ax+XPALETKI) &&
		t->pilka->ay >= 420) {

		/* odbicie lewym brzegiem */
		if (t->pilka->ax >= t->paletka->ax && t->pilka->ax <= t->paletka->ax+30) {
			t->pilka->kx=-5;
			printf ("kx = -5\n");

		}
		/* odbicie lewym srodkiem */
		else if (t->pilka->ax >= t->paletka->ax+30  && t->pilka->ax <= t->paletka->ax+60) {
			t->pilka->kx=-2;
			printf ("kx = -2\n");
		}
		/* odbicie prawym srodkiem */
		else if (t->pilka->ax >= t->paletka->ax+60  && t->pilka->ax <= t->paletka->ax+90) {
			t->pilka->kx=2;
			printf ("kx = 2\n");
		}
		/* odbicie prawym brzegiem */
		else if (t->pilka->ax >= t->paletka->ax+90 && t->pilka->ax <= t->paletka->ax+120) {
//			t->pilka->kx=-5;
			t->pilka->kx=5;
			printf ("kx = 5\n");

		}

		/* odbijamy od paletki */
		t->pilka->ky=-5;
	}

	int flaga_zmiany=0; // zapobiega przebijaniu sie pilki przez kafle
	/* reakcje pilki z kaflami */
	for (i=0; i<8; i++) {

		for (j=0; j<8; j++) {
			if (kafle[i][j].obraz != NULL) {

				if (t->pilka->ay+YPILKI >= kafle[i][j].y &&
					t->pilka->ay <= kafle[i][j].y+YKAFLA &&
					t->pilka->ax >= kafle[i][j].x-XPILKI &&
					t->pilka->ax <= kafle[i][j].x+XKAFLA) {
#define XTOL 1
// #define YTOL 3
					printf ("twardosc: %d\n", kafle[i][j].twardosc);
					if (kafle[i][j].twardosc !=2) {
						rysuj_obrazek(kafle[i][j].x, kafle[i][j].y, gumka_kafla, 0);
						kafle[i][j].obraz=NULL;
					// w ktora strone znikajacy kafel odbije pilke

					// lewy przeg kafla

						printf ("ax: %d   kafel %d \n", t->pilka->ax, kafle[i][j].x+XKAFLA);

						if (t->pilka->ay+YPILKI >= kafle[i][j].y &&
							t->pilka->ay <= kafle[i][j].y+YKAFLA &&
							t->pilka->ax >= kafle[i][j].x-XPILKI &&
							t->pilka->ax <= kafle[i][j].x-XPILKI+XTOL) {

							if (!flaga_zmiany) {
								t->pilka->kx = -5;
								flaga_zmiany=1;
							}

							printf ("lewy bok\n");
							liczba_kafli--;
							wynik+=PUNKTY;
//
						}
					// prawy  przeg kafla
						else if (t->pilka->ay+YPILKI >= kafle[i][j].y &&
							t->pilka->ay <= kafle[i][j].y+YKAFLA &&
							t->pilka->ax <= kafle[i][j].x+XKAFLA &&
							t->pilka->ax >= kafle[i][j].x+XKAFLA-XTOL) {

							if (!flaga_zmiany) {
								t->pilka->kx = 5;
								flaga_zmiany=1;
							}
							printf ("prawy bok\n");
							liczba_kafli--;
							wynik+=PUNKTY;
//
						}
						else if (t->pilka->ky == 5) {
							if (!flaga_zmiany) {
								t->pilka->ky =-5;
								flaga_zmiany=1;
							}
							printf ("zmina kirunku: do gory (%d)\n", t->pilka->ay);
							liczba_kafli--;
							wynik+=PUNKTY;
						}
						else if (t->pilka->ky == -5) {
							if (!flaga_zmiany) {
								t->pilka->ky =5;
								flaga_zmiany=1;
							}
							printf ("zmina kirunku: na dól %d \n", t->pilka->ay );
							liczba_kafli--;
							wynik+=PUNKTY;
						}


					printf ("\n\nliczba kafli: %d\n", liczba_kafli);
					}
					/* jesli twardosc 2 */
					else {
						if (t->pilka->ay+YPILKI >= kafle[i][j].y &&
							t->pilka->ay <= kafle[i][j].y+YKAFLA &&
							t->pilka->ax >= kafle[i][j].x-XPILKI &&
							t->pilka->ax <= kafle[i][j].x-XPILKI+XTOL) {

							if (!flaga_zmiany) {
								t->pilka->kx = -5;
								flaga_zmiany=1;
							}
							printf ("lewy bok\n");
//							liczba_kafli--;
							kafle[i][j].twardosc=1;
//
						}
					// prawy  przeg kafla
						else if (t->pilka->ay+YPILKI >= kafle[i][j].y &&
							t->pilka->ay <= kafle[i][j].y+YKAFLA &&
							t->pilka->ax <= kafle[i][j].x+XKAFLA &&
							t->pilka->ax >= kafle[i][j].x+XKAFLA-XTOL) {

							if (!flaga_zmiany) {
								t->pilka->kx = 5;
								flaga_zmiany=1;
							}

							printf ("prawy bok\n");
//							liczba_kafli--;
							kafle[i][j].twardosc=1;
//
						}

						else if (t->pilka->ky == 5) {
							if (!flaga_zmiany) {
								t->pilka->ky =-5;
								flaga_zmiany=1;
							}
							printf ("zmina kirunku: do gory (%d)\n", t->pilka->ay);
							liczba_kafli--;
						}
						else if (t->pilka->ky == -5) {
							if (!flaga_zmiany) {
								t->pilka->ky =5;
								flaga_zmiany=1;
							}
							printf ("zmina kirunku: na dól %d \n", t->pilka->ay );
							liczba_kafli--;
						}
						printf("opuszczam Twardosc 2\n");
					}

				}
			}
		}
	}



	t->pilka->px=t->pilka->ax;
	t->pilka->py=t->pilka->ay;
	t->pilka->ax+=t->pilka->kx;
	t->pilka->ay+=t->pilka->ky;

	//return interval;
}



/* poziom liczymy od zera */
void zaladuj_poziom(SDL_Surface ** kolor_kafla, int poziom) {

	int i, j, l, x, y;

	printf ("bede rysowac poziom: %d\n", poziom);
   /* dane odczytwane beda dla poziomu 'level' */
	l = poziom*8;
	liczba_kafli=0;
	x=0;
	y=30;
	// wiersze
	for (i=0; i < 8; ++i) {
		// kolumny
		for (j = 0; j < 8; ++j) {

			printf ("levels -%d-", levels[i+l][j]);
			/* jesli pole rozne od zera to jakis kafel */
			if (levels[i+l][j] != 48) {
				kafle[i][j].obraz= kolor_kafla[levels[i+l][j]-48];

				if (levels[i+l][j] != 52) kafle[i][j].twardosc=1;
				else kafle[i][j].twardosc=2;

				kafle[i][j].x = x;
				kafle[i][j].y = y;
				liczba_kafli++;
			}
			else {
				kafle[i][j].obraz= NULL;
			}
			x+=XKAFLA;
		}
		x=0;
		y+=YKAFLA;

		putchar('\n');
//      if (i == 19) putchar('\n');
	}

}

void wyswietl_kafle(void) {

	int i, j;
	SDL_Rect zrodlo, cel;

	for (i=0; i < 8; ++i) {

		for (j = 0; j < 8; ++j) {

			if (kafle[i][j].obraz != NULL) {
				printf ("rysuje\n");
				cel = set_rect(kafle[i][j].x, kafle[i][j].y, kafle[i][j].obraz->w, kafle[i][j].obraz->h);
				zrodlo = set_rect(0, 0, kafle[i][j].obraz->w, kafle[i][j].obraz->h);
				SDL_BlitSurface(kafle[i][j].obraz, &zrodlo, obraz, &cel);

			}
			//else printf ("Kafle nie maja przydzielonego obrazu\n");
		}
	}
}

SDL_Surface * utworz_kafle(SDL_Surface ** tab) {
	int i;
	Kolor kolory[4]  = {{62, 246, 26}, // zielony
									{246, 26, 202}, // filoet
									{26, 36, 246}, // indygo
									{246, 26, 52}}; // czerwony
	//								{253, 157, 79}  // pomaranczowy
	for (i=0; i<8; i++) {
			tab[i] = ustaw_kolor(kolory[i]);
	}

}

SDL_bool end() {
	SDL_Rect zrodlo, cel;
	char txt1[30] = "G A M E   O V  E R";
	char txt2[10] = "Wynik";
	char txt3[24];
	ustaw_kolor_tla();

	print_text(0, 0, 0, txt1,  200, 200, 10);
	print_text(234, 0, 0, txt2,  250, 250, 10);
	sprintf (txt3, "%d", wynik);
	print_text(33, 249, 11, txt3, 260, 300, 10);

	cel = set_rect(0, 0, obraz->w, obraz->h);
	zrodlo = set_rect(0, 0, obraz->w, obraz->h);
 	tex_screen = SDL_CreateTextureFromSurface(renderer, obraz);
	SDL_RenderClear ( renderer );
	SDL_RenderCopy(renderer, tex_screen,&zrodlo,&cel);
	SDL_RenderPresent(renderer);
	SDL_DestroyTexture(tex_screen);

	sleep(5);
	return SDL_TRUE;
}

SDL_bool file_exist(){
	char *file;

	#if WINDOWS
	char * FILE_NAME = "\\arkanoid.txt";
	char * HOME = "HOMEPATH";

	#elif LINUX
	char * FILE_NAME = "/.arkanoid.txt";
	char * HOME = "HOME";
	#endif


	if (!getenv(HOME)) exit (1);

	file=(char *)malloc(strlen(getenv(HOME))+strlen(FILE_NAME)+1);
	
	strcpy(file, getenv(HOME));
	strcat(file, FILE_NAME);
	printf("1");

	if (access(file, F_OK)==0){
		printf("PLIK istnieje %s",file);
		free(file);
		return SDL_TRUE;
	}
	printf("PLIK nie istnieje %s",file);
	free(file);
	return SDL_FALSE;
	
}

void save_hiscore(){
	char *file;

	#if WINDOWS
	char * FILE_NAME = "\\arkanoid.txt";
	char * HOME = "HOMEPATH";

	#elif LINUX
	char * FILE_NAME = "/.arkanoid.txt";
	char * HOME = "HOME";
	#endif


	char bufor[48];

	if (!getenv(HOME)) exit (1);


	//file=(char *)malloc(strlen(getenv(HOME)+strlen(FILE_NAME)+1));
	file=(char *)malloc(strlen(getenv(HOME))+strlen(FILE_NAME)+1);

	strcpy(file, getenv(HOME));
	strcat(file, FILE_NAME);

	sprintf(bufor,"%d",najlepszy);

	FILE * f = fopen(file, "w");
	fwrite(bufor, sizeof(char), strlen(bufor), f);
	fclose(f);
	printf ("Zapisałem: %s\n", file);
	free(file);



}

void load_hiscore(){
	char *file;

	#if WINDOWS
	char * FILE_NAME = "\\arkanoid.txt";
	char * HOME = "HOMEPATH";

	#elif LINUX
	char * FILE_NAME = "/.arkanoid.txt";
	char * HOME = "HOME";
	#endif


	char bufor[48];

	if (!getenv(HOME)) exit (1);

	//file=(char *)malloc(strlen(getenv(HOME)+strlen(FILE_NAME)+1));
	file=(char *)malloc(strlen(getenv(HOME))+strlen(FILE_NAME)+1);

	strcpy(file, getenv(HOME));
	strcat(file, FILE_NAME);

	FILE * f = fopen(file, "r");
	fscanf(f, "%s", bufor);
	fclose(f);
	free(file);

	najlepszy=atoi(bufor);

// najlepszy=0;
}




 SDL_bool gra () {

	int wykonano, rozpoczecie;
	int px, py, kx, ky;
	char bufor[50];
	SDL_bool quit=SDL_TRUE;

	SDL_Surface * tablica_kolorow_kafli[4];
	SDL_TimerID uchwyt_pilki;
	Uint32 predkosc_pilki=50, czas_zwloki=50;
	RuchomyObiekt pilka, paletka;
	Teczka teczka;
//	Teczka2 teczka2;
//	Kafel kafle[4][8];
	int powolna_paletka=0, pauza=0;
	SDL_Rect zrodlo, cel;
	char level_bufor[24], score_bufor[24], lives_bufor[24], hi_bufor[24];

	wynik=000;
	pilka.ax=640/2-XPILKI/2;
	pilka.ay=420;
	pilka.px=pilka.ax;
	pilka.py=pilka.ay;
	pilka.kx=-5;
	pilka.ky=-5;

	zycia=2;
	poziom=1;
	//najlepszy=1000;

	asm("nop");
	ustaw_kolor_tla();

	pilka.obraz=utworz_pilke();
	//pilka.obraz = SDL_LoadBMP("ball.bmp");
	//pilka.gumka=utworz_powierzchnie(XPILKI, YPILKI, 65, 190, 215);
#if WINDOWS
	pilka.gumka = SDL_LoadBMP("icon/gumka_arkanoid.bmp");
#elif LINUX
	pilka.gumka = SDL_LoadBMP("/usr/share/pixmaps/gumka_arkanoid.bmp");
#endif
	
	SDL_SetColorKey(pilka.gumka,SDL_TRUE,getpixel(pilka.gumka,0,0));
	rysuj_obrazek(pilka.ax, pilka.ay, pilka.obraz, 1);  // colorskey powinno byc 1

	paletka.ax=640/2-XPALETKI/2;
	paletka.ay=450;
//	paletka.px=paletka.ax;
	paletka.py=paletka.ay;

	paletka.obraz=utworz_powierzchnie(XPALETKI, YPALETKI, 0, 0, 0);
	paletka.gumka=utworz_powierzchnie(XPALETKI, YPALETKI, 65, 190, 215);

	rysuj_obrazek(paletka.ax, paletka.ay, paletka.obraz, 0);


	teczka.pilka=&pilka;
	teczka.paletka=&paletka;

	utworz_kafle(tablica_kolorow_kafli);
	zaladuj_poziom(tablica_kolorow_kafli, poziom-1);
	wyswietl_kafle();
	gumka_kafla=utworz_powierzchnie(XKAFLA, YKAFLA, 65, 190, 215);

	rozpoczecie = wykonano = 0;

	sprintf (level_bufor, "%d", poziom);
	print_text(253, 255, 100, level_bufor, 250, 0, 2);
	sprintf (lives_bufor, "%d", zycia);
	print_text(33, 249, 11, lives_bufor, 400, 0, 2);
	sprintf (hi_bufor, "%d", najlepszy);
	print_text(249, 33, 11, hi_bufor, 550, 0, 3);

	//SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);

	while(!wykonano) {

		SDL_Event event;
//		SDL_KeyboardEvent zd_klawiszy;


        if (pilka.ax+pilka.obraz->w <= 0){
            pilka.ax=640;
        }

      while (SDL_PollEvent (&event)) {

         switch (event.type) {

            case SDL_KEYDOWN:
               printf("Naciśnięto klawisz: %s\n", SDL_GetKeyName(event.key.keysym.sym));

               if (event.key.keysym.sym==SDLK_ESCAPE)
                  wykonano = 1;

					if (event.key.keysym.sym==SDLK_SPACE && !rozpoczecie) {
//						teczka.poprzedni_y=pilka.ay;
//						uchwyt_pilki = SDL_AddTimer(predkosc_pilki, ruch_pilki, &teczka);
						rozpoczecie = 1;
					}

                    //printf("powolna_paleka: %d", powolna_paletka);
					if (event.key.keysym.sym==SDLK_LEFT && paletka.ax>0) {
						printf("PALETKA LEWA\n");
						if(powolna_paletka>=1) {
							paletka.px=paletka.ax;
							paletka.ax-=10;
							przerysuj(&paletka);
							if (!rozpoczecie) {
								pilka.px=pilka.ax;
								pilka.ax-=10;
								przerysuj(&pilka);
							}
							powolna_paletka=0;
						}
					}
					if (event.key.keysym.sym==SDLK_RIGHT && paletka.ax<(640-XPALETKI)) {
						if(powolna_paletka>=1) {
							paletka.px=paletka.ax;
							paletka.ax+=10;
							przerysuj(&paletka);
							if (!rozpoczecie) {
								pilka.px=pilka.ax;
								pilka.ax+=10;
								przerysuj(&pilka);
							}
							powolna_paletka=0;
						}
					}
					if (event.key.keysym.sym==SDLK_r) {
						wyswietl_kafle();
						sprintf (score_bufor, "%d", wynik);
						print_text(255, 255, 255, score_bufor, 10, 0, 3);
						sprintf (level_bufor, "%d", poziom);
						print_text(253, 255, 100, level_bufor, 250, 0, 2);
						sprintf (lives_bufor, "%d", zycia);
						print_text(33, 249, 11, lives_bufor, 400, 0, 2);
						sprintf (hi_bufor, "%d", najlepszy);
						print_text(249, 33, 11, hi_bufor, 550, 0, 3);
						przerysuj(&paletka);
						przerysuj(&pilka);
					}

               break;

            case SDL_QUIT:
				if (wynik>najlepszy){
					najlepszy=wynik;
					save_hiscore();
				}
				SDL_DestroyTexture(tex_screen);
				SDL_DestroyRenderer(renderer);
    			SDL_DestroyWindow(gWindow);
               exit(0);
               break;

            case SDL_MOUSEMOTION:
				break;

				case SDL_MOUSEBUTTONDOWN:
					//if (!pauza) pauza=1;
					//else pauza=0;
				break;

				case SDL_MOUSEBUTTONUP:
				break;

            default:
            break;
         }

		}

		if (pilka.ay+pilka.obraz->h>=480){
			printf("Nowe rozdanie!\n\n\n");
			if(--zycia == -1){
				wykonano=1;
				quit=SDL_TRUE;
				goto label;
			}

			//erase (&paletka);
			//erase (&pilka);
			// wymazujemy caly ekran, erase(&paletka) nie wymazuje dokladnie
			ustaw_kolor_tla();
			wyswietl_kafle();
			//pisz_info(253, 255, 100, poziom, 250, 0, 2);
			//pisz_info(33, 249, 11, zycia, 400, 0, 2);
			//pisz_info(249, 33, 11, najlepszy, 550, 0, 3);
			sprintf (level_bufor, "%d", poziom);
			print_text(253, 255, 100, level_bufor, 250, 0, 2);
			sprintf (lives_bufor, "%d", zycia);
			print_text(33, 249, 11, lives_bufor, 400, 0, 2);
			sprintf (hi_bufor, "%d", najlepszy);
			print_text(249, 33, 11, hi_bufor, 550, 0, 3);
			rozpoczecie=0;
			pilka.ax=640/2-XPILKI/2;
			pilka.ay=420;
			pilka.px=pilka.ax;
			pilka.py=pilka.ay;
			pilka.kx=-5;
			pilka.ky=-5;
			paletka.ax=640/2-XPALETKI/2;
			paletka.ay=450;
		//	paletka.px=paletka.ax;
			paletka.py=paletka.ay;

			if(powolna_paletka>=1) {
				paletka.px=paletka.ax;
				paletka.ax-=10;
				przerysuj(&paletka);
				if (!rozpoczecie) {
					pilka.px=pilka.ax;
					pilka.ax-=10;
					przerysuj(&pilka);
				}
				powolna_paletka=0;
			}
		}
// zapobiega wywietleniu -1 zycia
label:

	//pisz_info(255, 255, 255, wynik, 0, 0, 4);
	sprintf (score_bufor, "%d", wynik);
	print_text(255, 255, 255, score_bufor, 10, 0, 3);


	if (rozpoczecie) {
		if(!pauza) {

			ruch_pilki(0, &teczka);
		}
	}
	powolna_paletka+=1;


	if (!liczba_kafli) {
		printf ("poziom zaliczony\n");
		if (pilka.py>300 && poziom<8) {
			poziom++;
			printf ("rysuj nowy poziom  liczba kafli przed: %d\n", liczba_kafli);
			zaladuj_poziom(tablica_kolorow_kafli, poziom-1);
			wyswietl_kafle();
			sprintf (level_bufor, "%d", poziom);
			print_text(253, 255, 100, level_bufor, 250, 0, 2);
			printf("liczba kafli po: %d\n", liczba_kafli);
			//pisz_info(253, 255, 100, poziom, 180, 0, 1);
		}
		else if (pilka.py>300 && poziom>=8){
			poziom=1;
			zaladuj_poziom(tablica_kolorow_kafli, poziom-1);
			wyswietl_kafle();
			sprintf (level_bufor, "%d", poziom);
			print_text(253, 255, 100, level_bufor, 250, 0, 2);
			printf("liczba kafli po: %d\n", liczba_kafli);
			//wykonano=1;
		}
//		teczka2.czas=&zwloka;
//		uchwyt_pilki = SDL_AddTimer(czas_zwloki, zwloka_dla_pilki, &teczka2);
	}



	cel = set_rect(0, 0, obraz->w, obraz->h);
	zrodlo = set_rect(0, 0, obraz->w, obraz->h);
 	tex_screen = SDL_CreateTextureFromSurface(renderer, obraz);
	SDL_RenderClear ( renderer );
	SDL_RenderCopy(renderer, tex_screen,&zrodlo,&cel);
	SDL_RenderPresent(renderer);
	SDL_DestroyTexture(tex_screen);

	SDL_Delay(40);
    //SDL_Delay(500);
	}
	if (wynik>najlepszy){
		najlepszy=wynik;
		save_hiscore();
	}
//	SDL_RemoveTimer(uchwyt_pilki);
	/* przywrocenie orginalnych ustawien */
	//SDL_EnableKeyRepeat(0, SDL_DEFAULT_REPEAT_INTERVAL);
	return quit;
}



 int main (int argc, char ** argv) {



    if (SDL_Init (SDL_INIT_VIDEO | SDL_INIT_TIMER) < 0)
   {
      printf ("Nie mozna zainicjowac SDL: %s\n", SDL_GetError ());
      exit (1);
   }
   atexit (SDL_Quit);

    gWindow = SDL_CreateWindow( "Arkanoid", SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED, 640, 480, SDL_WINDOW_SHOWN );
		if( gWindow == NULL )
		{
			printf( "Window could not be created! SDL_Error: %s\n", SDL_GetError() );
			exit(1);
		}
		else
		{
			renderer = SDL_CreateRenderer(gWindow, -1,0);
			SDL_SetRenderDrawColor ( renderer ,65, 190, 215 , 255 );
			SDL_RenderClear ( renderer );
			//Get window surface
			obraz = SDL_GetWindowSurface( gWindow );

		}


   /* inicjalizacja fontow */
   if(TTF_Init()==-1) {
      printf("TTF_Init: %s\n", TTF_GetError());
   exit(2);
   }
   atexit (TTF_Quit);



	#if WINDOWS
	#define NAZWAFONTU "SpicyRice.ttf"
	#elif LINUX
	//#define NAZWAFONTU "/usr/share/fonts/SpicyRice.ttf"
	#define NAZWAFONTU "/usr/share/arkanoid/SpicyRice.ttf"
	#endif

   if((font_panel = TTF_OpenFont(NAZWAFONTU, WIELKOSCFONTU)) == NULL) {
       printf("TTF_OpenFont: %s\n", TTF_GetError());
       exit(1);
	}
	if (file_exist()){
		load_hiscore();
	}
	else {
		najlepszy=0;
	}
	while(SDL_TRUE){
		if (gra()==SDL_TRUE){
			if (end()==SDL_TRUE){
				printf ("\n\nkontynuje\n");
				continue;
			}
			else break;
		}
	}
	printf ("\n\nwychodze\n");
	SDL_DestroyTexture(tex_screen);
    SDL_DestroyRenderer(renderer);
    SDL_DestroyWindow(gWindow);
	return 0;
}
//	vi: sw=4: ts=4
