/* 
 * FlappyUfo - gra dla klikaczy
 * Przemyslaw R. Pietraszczyk
 * rozpoczecie: 01-IX-2021
 * licencja: GPL
 * edytor: Geany
 */

package flappyufo;

import java.awt.*;  // Toolkit
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ImageIcon;
//import javax.swing.JButton;
//import javax.swing.JComponent;
//import javax.swing.JMenuBar;
//import javax.swing.JMenu;
//import javax.swing.JMenuItem;
//import javax.swing.JOptionPane;
//import javax.swing.Box;
//import javax.swing.JTextArea;
//import javax.swing.JDialog;
//import javax.swing.JTextField;
//import javax.swing.JCheckBox;
//import javax.swing.BorderFactory;
//import javax.swing.WindowConstants;
//import java.awt.event.*;
//import java.awt.event.WindowEvent;
//import java.awt.event.WindowAdapter;
//import java.awt.event.ComponentAdapter;
//import java.awt.event.ComponentEvent;
//import java.awt.event.ItemEvent;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import java.util.*; //Timer
import java.util.ArrayList;
import java.util.List;


import java.beans.*; //property change stuff
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.*;

import java.awt.image.BufferedImage;
import java.awt.image.*;
import javax.imageio.ImageIO;
import javax.imageio.*;


public class FlappyUfo extends JPanel {

	static JFrame frame;
	static FlappyUfo flappyufo;
	static Timer timer = new Timer();
	private Graphics bg;
    private Image bufor;
   // static private int x;
    //static private int y;
    static BufferedImage wallPaperImage = null;
    BufferedImage borderImage = null;
    BufferedImage startScreen = null;
    BufferedImage nextLevelImage = null;
    static BufferedImage redPipe = null;
    static BufferedImage ufo = null;
    static BufferedImage gameOverImage = null;
    static BufferedImage aboutImage = null; 
    static BufferedImage [] numbers;
   // static BufferedImage flappyIcon = null;
    static boolean go = false;
    static boolean nextLevel = false;
    static boolean gameOver = false;
    static boolean about = false;
    static char key;
    static Actions actions;
    static BufferedImage board;
    static int actualx = 0;
    static private Rectangle rect;
    static int [][] transition ={{100, 250},{200, 350}, {300, 450}};
    static int lastTransition;
    static Random genRand;
    static BufferedImage img;
    static int ufox = 50, ufoy = 250;
    static List<Integer> countscore;
    static int score = 0;
    static int hiScore;
	static HiScore HiScoreFile;
	static wavResource wav;
	static Image icon;
	static Color clouds = new Color(255, 255, 255);
	static Color sky = new Color(65, 190, 215);

    public FlappyUfo (){
		
		numbers = new BufferedImage[10];
		countscore = new ArrayList<Integer>();
		wallPaperImage = LoadIMG("/clouds.png");
		startScreen = LoadIMG("/start.png");
		redPipe = LoadIMG("/pipered.png");
		nextLevelImage = LoadIMG("/nextlevel.png");
		ufo = LoadIMG("/ufo-small.png");
		gameOverImage = LoadIMG("/gameover.png");
		aboutImage = LoadIMG("/about.png");
		
		icon = Toolkit.getDefaultToolkit().getImage( "flappyufo.png" );    

		for (int i=0; i<10; i++) {
			String numbname = "/"+i+".png";
			numbers[i]=LoadIMG(numbname);
		}
		genRand = new Random();
		CreateBoard();
		try{
			HiScoreFile = new HiScore();
		} catch (IOException e) {}
		
		hiScore = Integer.valueOf(HiScoreFile.load());
		wav = new wavResource();
		
	}
    
    private static void createAndShowGUI() {

        frame=new JFrame("Flappy Ufo");
		//Image icon = Toolkit.getDefaultToolkit().getImage(flappyIcon);
		
		frame.setIconImage(icon);    
		final int frameWidth = 310;
        final int frameHeight = 590;
        final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setBounds((int) screenSize.getWidth() - frameWidth,
                (int) screenSize.getHeight() - frameHeight, frameWidth, frameHeight);
        frame.setResizable(false);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    
		actions = new Actions();
		frame.addKeyListener(actions);
    
		flappyufo = new FlappyUfo();
		frame.add(flappyufo);
		flappyufo.setBounds(5,5, 300,540);
		frame.setLayout(null);  // potrzebne - wyposrodkowywuje obrazek
		frame.setVisible(true);
		frame.setFocusable(true);
		
		// zapobiega utracie KeyEvent po wyjsciu z okien dialogowych
        /*
        frame.addFocusListener(new FocusListener(){
            public void focusGained(FocusEvent e){
                //System.out.println("Focus GAINED:"+e);
            }
            public void focusLost(FocusEvent e){
                //System.out.println("Focus LOST:"+e);

                // FIX FOR GNOME/XWIN FOCUS BUG
                e.getComponent().requestFocus();
            }
        });
        */
        timer.schedule(new KeyTicks(), 0, 50);  // lepiej 1000
        
	}
	private void drawInfo(Graphics g, int x, int y, boolean scr){
		
		String s;
		if (scr) s = String.valueOf(score);
		else s = String.valueOf(hiScore);

		char sign;
		int ii;

		for (int i=0; i<s.length(); i++){
			sign = s.charAt(i);
			ii = Integer.valueOf(sign); // zwraca kod ASCII znaku
			ii -= 48; // odejmujemy do indeksu

			g.drawImage(numbers[ii], x,y, numbers[ii].getWidth(), numbers[ii].getHeight(), null);
			x+= numbers[ii].getWidth();
		}
	}
	protected void paintComponent(Graphics g){
		super.paintComponent(g);
		
		Integer count;
		
        if (!go && !nextLevel && !gameOver && !about){
			g.drawImage(startScreen, getInsets().left, getInsets().top, null);
        }
        else if (go && !gameOver){
			if (actualx >= 900) {
				go = false;
				nextLevel = true;
				actualx =0 ;
			}
			// dodaje pounkty po przekroczeniu rury
			if (countscore.size() != 0){
				count = (int) countscore.get(0);
				if (count == actualx) {
					score++;
					countscore.remove(count);
					wav.play("/point.wav");
				}
			}

			img = board.getSubimage(actualx, 0, 300, 540);
			g.drawImage(img, 0, 0, img.getWidth(), img.getHeight(), null);
			g.drawImage(ufo, ufox, ufoy, ufo.getWidth(), ufo.getHeight(), null);
			drawInfo(g, 15, 5, true); // pisz punkty
			drawInfo(g, 200, 5, false); // pisz najlepszy
			actualx+=1;

		}
		else if (nextLevel) {
			g.drawImage(nextLevelImage, getInsets().left, getInsets().top, null);

		}
		else if (gameOver) {
			g.drawImage(gameOverImage, getInsets().left, getInsets().top, null);
			drawInfo(g, 120, 380, true);

		}
		else if (about) {
			g.drawImage(aboutImage, getInsets().left, getInsets().top, null);
		}
		
	}
	
	static private void CreateBoard () {
       // Image img;
		int r;
		
		board = new BufferedImage(1300, 540, BufferedImage.TYPE_INT_RGB);
		Graphics2D graphics = board.createGraphics();
		//graphics.setPaint( new Color (183,93,93));
		//graphics.fillRect(0, 0,board.getWidth(), board.getHeight());
		
		for (int x=0;x<1300;x+=300){
			graphics.drawImage(wallPaperImage, x, 0, null);
			
		}
		lastTransition = r = genRand.nextInt(3);
		for (int x=300;x<1000;x+=140){
			
			graphics.drawImage(redPipe, x, transition[r][0], redPipe.getWidth(), -redPipe.getHeight(), null);
			graphics.drawImage(redPipe, x, transition[r][1], null);
			
			if (lastTransition == 0) r = lastTransition = 1;
			else if (lastTransition == 2) r = lastTransition = 1;
			else lastTransition = r = genRand.nextInt(3);

		}
		graphics.dispose();
        //board.flush();
    }
	

    private BufferedImage LoadIMG(String file) {

        try {
            return ImageIO.read(getClass().getResourceAsStream(file));
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }
    
    
    public static void main(final String[] args) {

        javax.swing.SwingUtilities.invokeLater(new RunnableImplementation());
    }
    private static final class RunnableImplementation implements Runnable {
        public void run(){
			
            createAndShowGUI();
        }
    }
    
    static class KeyTicks extends TimerTask {
        char key;
        public void run() {

			key = actions.getKey();
			// Akcja
			if (go) {
				if (key == ' ' && ufoy >10) {
					 ufoy-=10;
				}
				else if (ufoy <10) {
					go =false;
					gameOver = true;
					//wav.stop();
					wav.play("/die.wav");
					//try {
					//	Thread.sleep(500);
					//} catch (InterruptedException e) {
					//	Thread.currentThread().interrupt();
					//}
					
				}
				else { 
					if (ufoy+ufo.getHeight() >= 535){
						go =false;
						gameOver = true;
						//wav.stop();
						wav.play("/die.wav");
						//try{
						//	Thread.sleep(500);}
						//} catch (InterruptedException e) {
						//	Thread.currentThread().interrupt();
						//}

					}
					else ufoy+=5;
				}
				if (checkCollisions()){
					go =false;
					gameOver = true;
				}
			}
			// Start
			else if (!go && key == ' ' && !nextLevel && !gameOver){
				go =true;
				score = 0;
				ufoy = 250;
				actualx = 0;
				CreateBoard();
				countscore.clear();
				for (int i=300; i<=900; i+=140)
				{
					countscore.add(i);
				}
				wav.play("/swoosh.wav");

				
			}
			else if (nextLevel){
				if (key == 'p' || key == 'P') {
					nextLevel = false;
					CreateBoard();
					ufoy = 250;
					go = true;
					countscore.clear();
					for (int i=300; i<=900; i+=140)
					{
						countscore.add(i);
					}
					wav.play("/swoosh.wav");
				}
			}
			else if (gameOver){
				if (key == 'q' || key == 'Q') {
					ufoy=250;
					nextLevel = false;
					gameOver = false;
					go = false;
					if (score > hiScore) {
						hiScore = score;
						HiScoreFile.save(String.valueOf(hiScore));
					}
				}
			}
			else if (!go && (key == 'A' || key == 'a')){
				about = true;
			}
			else if (about && (key == 'q' || key == 'Q')) {
				about = false;
			}
			flappyufo.repaint();
			
        }
        
        private boolean checkCollisions(){
			
			int startX = Math.max(ufox,0);
			int endX = Math.min(ufox + ufo.getWidth(), img.getWidth());
			int startY = Math.max(ufoy - ufo.getHeight(),0); //because Y goes from top to bottom
			int endY = Math.min(ufoy, img.getHeight());
			
			
			for (int y = startY; y < endY; y++) {
				for (int x = startX; x < endX; x++) {
					
					if (clouds.equals(new Color(img.getRGB(x, y))) || sky.equals(new Color(img.getRGB(x, y)))) {
					}
					else {
						//System.out.println("board x y: "+new Color(img.getRGB(x, y)));
						//System.out.println("clouds: "+ clouds);
						//System.out.println("sky: "+ sky);
						wav.play("/hit.wav");
						try
						{
							Thread.sleep(500);
						}
						catch(InterruptedException ex)
						{
							Thread.currentThread().interrupt();
						}
						return true;  // niesmiertelnosc, powyzsze try tez trzeba odkomentowac
						
					}
				}
			}
			return false;
		}
    }
}
        
        
		
