/* 
 * FlappyUfo - gra dla klikaczy
 * Przemyslaw R. Pietraszczyk
 * rozpoczecie: 01-IX-2021
 * licencja: GPL
 * edytor: Geany
 */
 
package flappyufo;

/**
 *
 * @author przem
 */

import java.io.FileWriter;
import java.io.File;
import java.io.IOException;
import java.io.FileNotFoundException;  // Import this class to handle errors
import java.util.Scanner;
import java.util.*;

public class HiScore {
    public String userDir="", userHome="", osName="", osVersion="", jvmVersion="";
    String name = "/.flappyufo.txt";
    public HiScore() throws IOException{
        for (Map.Entry<?,?> e : System.getProperties().entrySet()) {
            //System.out.println(String.format("%s = %s", e.getKey(), e.getValue())); 
            if (e.getKey().equals("user.dir")) {
                userDir=String.format("%s", e.getValue());
            }
            if (e.getKey().equals("user.home")) {
                userHome=String.format("%s", e.getValue());
                
            }
            if (e.getKey().equals("os.name")) {
                osName=String.format("%s", e.getValue());
                
            }
            if (e.getKey().equals("os.version")) {
                osVersion=String.format("%s", e.getValue());
                
            }
            if (e.getKey().equals("java.vm.version")) {
                jvmVersion=String.format("%s", e.getValue());
                
            }
        }
        
        
        File file=new File (userHome+name);
        if (file.createNewFile()){
            System.out.println("Plik zostal utworzony");
            try {
                FileWriter myWriter = new FileWriter(userHome+name);
                myWriter.write("0");
                myWriter.close();
                System.out.println("Successfully wrote to the file.");
            } catch (IOException e) {
                System.out.println("An error occurred.");
                e.printStackTrace();
            }
        }
        else {
            System.out.println("Plik istnieje");
        }
    }
    public void save(String hi){

        try {
            FileWriter myWriter = new FileWriter(userHome+name);
            
            myWriter.write(hi);
            myWriter.close();
            System.out.println("Successfully wrote to the file.");
        } catch (IOException e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
    }
    public String load() {
        String data = "";
        
        try {
            File myObj = new File(userHome+name);
            Scanner myReader = new Scanner(myObj);
            while (myReader.hasNextLine()) {
            data = myReader.nextLine();
            System.out.println(data);
        }
        myReader.close();
        } catch (FileNotFoundException e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
            return "0";
        }
        return data;
    }
    
}
