/*
 * Frozen Bubble - zastrzel wszyskie kulki
 * 2022-09-13 by PRP
 * Licencja: Public Domain
 * Edytor: Atom
 * Program bazuje na:
 * -This source code copyrighted by Lazy Foo' Productions (2004-2020)
 * and may not be redistributed without written permission.
 * -Andrew Lim Chong Liang https://github.com/andrew-lim/sdl2-boilerplate
 */
#include "ball.h"

Ball::Ball() {
}

bool Ball::loadFromFile( int n, SDL_Surface * balls_bmp, SDL_Renderer * renderer)
{
	SDL_Texture* newTexture = NULL;

	SDL_Rect cut, paste;

	paste.x = 0;
	paste.y = 0;
	paste.w = 75;
	paste.h = 75;

	cut.x = n*75;
	cut.y = 0;
	cut.w = 75;
	cut.h = 75;


	surface = SDL_CreateRGBSurface(0,75,75,32,0,0,0,0);
	//SDL_SetSurfaceBlendMode(surface, SDL_BLENDMODE_BLEND);
	SDL_SetColorKey( surface, SDL_TRUE, SDL_MapRGB( surface->format, 0, 0, 0 ) );
	SDL_BlitSurface(balls_bmp, &cut, surface, &paste);
	
    newTexture = SDL_CreateTextureFromSurface( renderer, surface );
	if( newTexture == NULL )
	{
		printf( "Unable to create texture - SDL Error: %s\n", SDL_GetError() );
	}
	
	mWidth = surface->w;
	mHeight = surface->h;

	//Return success
	texture = newTexture;
	return texture != NULL;
}

SDL_Texture* Ball::getTexture() {
	return this->texture;
}
