/*
 * Frozen Bubble - zastrzel wszyskie kulki
 * 2022-09-13 by PRP
 * Licencja: Public Domain
 * Edytor: Atom
 * Program bazuje na:
 * -This source code copyrighted by Lazy Foo' Productions (2004-2020)
 * and may not be redistributed without written permission.
 * -Andrew Lim Chong Liang https://github.com/andrew-lim/sdl2-boilerplate
 */
#include <vector>
#include "game.h"
#include "tool.h"
#include "balls.h"


Game::Game()
:frameSkip(0), angle(0), rotateIndex(0){
}

Game::~Game() {
	//delete actual_ball;
	//delete octagon;
    this->stop();
}

void Game::start() {
    //int flags = SDL_WINDOW_SHOWN ;
    if (SDL_Init(SDL_INIT_EVERYTHING)) {
        return ;
    }
    //Set texture filtering to linear
	//if( !SDL_SetHint( SDL_HINT_RENDER_SCALE_QUALITY, "1" ) )
	//{
	//	printf( "Warning: Linear texture filtering not enabled!" );
	//}
    // Ten sposób tworzenia okna i renderu gwarantuje że duszki nie będą przerywać
    window = SDL_CreateWindow( "Frozen Bubble", SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED, DISPLAY_WIDTH, DISPLAY_HEIGHT, SDL_WINDOW_SHOWN );
	if( window == NULL )
	{
		printf( "Window could not be created! SDL Error: %s\n", SDL_GetError() );
		return;
	}
    renderer = SDL_CreateRenderer( window, -1, SDL_RENDERER_ACCELERATED | SDL_RENDERER_PRESENTVSYNC );
	if( renderer == NULL )
	{
		printf( "Renderer could not be created! SDL Error: %s\n", SDL_GetError() );
		return;
	}
	if(TTF_Init()==-1) {
		printf("TTF_Init: %s\n", TTF_GetError());
		return;
	}
    this->running = 1;
}

void Game::draw(Wall *wall, Missile * m) {
	SDL_Rect dst;

	SDL_SetRenderDrawColor(renderer, 255, 255, 255, SDL_ALPHA_OPAQUE);
	SDL_RenderClear(renderer);
	asm("nop");
	
	for (int j = 0; j < YSIZEWALL; j++) {
		for (int i = 0; i < XSIZEWALL; i++){
			asm("nop");
			if (!wall->checkNULL(j, i) && wall->checkActive(j, i)) {
				dst.x = wall->wall[j]->balls[i]->getPosX() - wall->wall[j]->balls[i]->getVarCollider();
				dst.y = wall->wall[j]->balls[i]->getPosY() - wall->wall[j]->balls[i]->getVarCollider();
				dst.w = BALL_SIZE;
				dst.h = BALL_SIZE;
				SDL_RenderCopy(renderer, wall->wall[j]->balls[i]->m->getTexture(), NULL, &dst);
			}
		}	
	}
	asm("nop");
	if (m->checkActive()) {
			//printf(" X: %d        Y: %d\n", m->getPosX(), m->getPosY());
			dst.x = m->getPosX()-m->getVarCollider();
			dst.y = m->getPosY()-m->getVarCollider();
			dst.w = BALL_SIZE;
			dst.h = BALL_SIZE;
			SDL_RenderCopy(renderer, m->m->getTexture(), NULL, &dst);
			//SDL_RenderCopyEx(renderer, ball[i]->texture, NULL, &dst, angle, NULL, SDL_FLIP_NONE);
	}
	
	lineRGBA(renderer, lineX1, lineY1, lineX2, lineY2, 255, 45, 34, 100);
	SDL_RenderPresent(renderer);
}

void Game::stop() {
    if (NULL != renderer) {
        SDL_DestroyRenderer(renderer);
        renderer = NULL;
    }
    if (NULL != window) {
        SDL_DestroyWindow(window);
        window = NULL;
    }
    SDL_Quit() ;
}

void Game::fillRect(SDL_Rect* rc, int r, int g, int b ) {
    SDL_SetRenderDrawColor(renderer, r, g, b, SDL_ALPHA_OPAQUE);
    SDL_RenderFillRect(renderer, rc);
}

void Game::fpsChanged( int fps ) {
    char szFps[ 128 ] ;
    sprintf( szFps, "%s: %d FPS", "Frozen Bubble", fps );
    SDL_SetWindowTitle(window, szFps);
}

void Game::onQuit() {
    running = 0 ;
}

void Game::run() {
    int past = SDL_GetTicks();
    int now = past, pastFps = past ;
    int fps = 0, framesSkipped = 0 ;
    int shot = 0;
    bool first = false;
    std::vector<Back*> backVec;
    int crt = 90;
	Back *back;
	Ball *ball[4] = {new Ball(), new Ball(), new Ball(), new Ball()};
	
    if( !loadMedia(ball)){
		printf( "Failed to load media!\n" );
		exit(1);
	}
	asm("nop");
	Wall wall(ball);
	Missile *missile = new Missile(ball);
	//SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);
	//lineX1 = 199;
	lineX2 = 199;
	//lineY1 = 550;
	lineY2 = 600;

	missile->setAngle(99);
	lineX1 = 100*cos(missile->getAngle()) + missile->getPosX();
	lineY1 = 100*sin(missile->getAngle()) + missile->getPosY();

	//missile->addVelX(missile->getPosX() + cos(missile->getAngle()));
	//missile->setPosX(199);
	printf("AAAAA getPOSX: %f\n", missile->getPosX());
	printf("AAAAA getVelX: %f\n", missile->getVelX());

	//missile->addVelX(cos(missile->getAngle()) + missile->getPosX()+ missile->getVelX());

    SDL_Event event ;
    while ( running ) {
        int timeElapsed = 0 ;
        if (SDL_PollEvent(&event)) {
            switch (event.type) {
                case SDL_QUIT:    onQuit();            break;
                case SDL_KEYUP:
                case SDL_KEYDOWN:
                
                	if (event.key.keysym.sym==SDLK_ESCAPE)
						running = 0;
						
					if (event.key.keysym.sym==SDLK_SPACE) {
						//if (end) {
						//	szlam.reset();
						//	end = false;
						//	score = 0;
						//	figure = rand()%7;
						//}
					}
					if (event.key.keysym.sym==SDLK_UP) {
						printf("BBBBBB getPOSX: %f\n", missile->getPosX());
						printf("BBBBBB getVelX: %f\n", missile->getVelX());

						if (event.key.repeat == 0) {
							shot = 1;
							first = false; 

							//missile->addVelX(-(missile->getPosX() + cos(missile->getAngle())));

						}
					}
					if (event.key.keysym.sym==SDLK_LEFT) {	
						missile->addAngle(-0.1);		
						//lineX1 -= missile->getPosX() + cos(missile->getAngle());
						//lineY1 -= missile->getPosY() + sin(missile->getAngle());
						
						lineX1 = 100*cos(missile->getAngle()) + missile->getPosX();
						lineY1 = 100*sin(missile->getAngle()) + missile->getPosY();

						missile->addVelX(-(missile->getPosX() + cos(missile->getAngle())));
						// do dupy
						//missile->addVelY(missile->getPosY() + sin(missile->getAngle()));

						printf("angleRad: %f   --- VelX: %f\n", missile->getAngle(), missile->getVelX());
						//missile->setPosX(missile->getPosX() + cos(missile->getAngle()));
						//printf("PosX: %d\n", missile->getPosX());
					}
					if (event.key.keysym.sym==SDLK_RIGHT) {	
						missile->addAngle(0.1);
						
						//lineX1 += missile->getPosX() + cos(missile->getAngle());
						//lineY1 += missile->getPosY() + sin(missile->getAngle());

						lineX1 = 100*cos(missile->getAngle()) + missile->getPosX();
						lineY1 = 100*sin(missile->getAngle()) + missile->getPosY();


						missile->addVelX(missile->getPosX() + cos(missile->getAngle()));
						// do dupy
						//missile->addVelY(missile->getPosY() + sin(missile->getAngle()));


						printf("angleRad: %f   -- VelX: %f\n", missile->getAngle(), missile->getVelX());
						//missile->setPosX(missile->getPosX() + cos(missile->getAngle()));
						//printf("PosX: %d\n", missile->getPosX());
					}
					if (event.key.keysym.sym==SDLK_DOWN) {
						if (event.key.repeat == 0) 
							missile->changeColor(ball);
					}
					break;
                case SDL_MOUSEBUTTONDOWN:
                case SDL_MOUSEBUTTONUP:
                case SDL_MOUSEMOTION:
                    break ;
            }

        }
        // update/draw
        timeElapsed = (now=SDL_GetTicks()) - past ;
        if ( timeElapsed >= UPDATE_INTERVAL  ) {
            past = now ;
            //update();
            if ( framesSkipped++ >= frameSkip ) {
				if (shot) {
					//printf("CCCCC getPOSX: %f\n", missile->getPosX());
					//printf("CCCCC getVelX: %f\n", missile->getVelX());
					missile->move();
					for (int j = YSIZEWALL-1; j >= 0; j--) {
						for (int i = XSIZEWALL-1; i >= 0; i--) {
							//printf("BALLS[%d]->ACTIVE: %d\n", i, wall.balls[i]->active);
							if (!wall.checkNULL(j, i)) {
								back = wall.wall[j]->balls[i]->collisions(missile->getCollider(), missile);
								wall.wall[j]->balls[i]->fixIndex(missile);
								backVec.push_back(back);
							}
							// TODO - zwolnić pamięć po 'back'!!!!
						
						}
					}	
					//if (first) {
					//	printf("BACK: %d\n", backVec.size());
					asm("nop");
					for (unsigned int i = 0; i < backVec.size(); i++) {
						//if (backVec[i] != NULL)
						//std::cout << i << " : " << backVec[i]->indexDel << " " << std::endl;
					}
					//printf ("SIZE: %d\n", backVec.size());
					Back *tmp = NULL;
					if (backVec.size() != 0) {
						//printf ("AKUKU\n");
						/* Dodajemy pocisk do muru */
						//printf ("color: %d     indexadd: %d",  backVec[0]->color, backVec[0]->indexAdd);
						//wall.add(ball, backVec[0]->color, backVec[0]->indexAdd);
						//delete missile;
						//missile = new Missile(ball);
						 for (auto it : backVec) {
							if (it != NULL) {
								std::cout << "IndexAdd:" << it->indexAdd << "    IndexDel:" << it->indexDel << "   Address_of_Land:" << it << std::endl;
								tmp = it;
							///	break;
							}
						}
						if (tmp && tmp->indexDel == -1) {
							
							wall.add(ball, tmp->color, tmp->indexAdd);
							printf("MMMMMMMMMMMMM\n");
							delete missile;
							missile = new Missile(ball);
							shot = 0;
							missile->setAngle(99);
							lineX1 = 100*cos(missile->getAngle()) + missile->getPosX();
							lineY1 = 100*sin(missile->getAngle()) + missile->getPosY();
							missile->addVelX(cos(missile->getAngle()) + missile->getPosX());
							
						//	printf("DDDDDD getPOSX: %f\n", missile->getPosX());
						//	printf("DDDDDD getVelX: %f\n", missile->getVelX());
							//wall.print();

						
						}
						//}
						/* szukany piłek w kolorze pocisku */
						//if (backVec[0]->indexAdd == -2) {
					
						//}
					}
						
				//	} // first
					first = true;

				}
				//if (shot) {
					//first = false;
					//shot = 0;
				//}
				backVec.clear();
				//for (auto i = backVec.begin(); i != backVec.end(); ++i)
				//	std::cout << " indexAdd: " << i.indexAdd << "    indexDel: "<<i.indexDel<<std::endl;
				//missile->entry = false;

				draw(&wall, missile);

                angle=0;
                ++fps ;
                framesSkipped = 0 ;
            }
        }
        // fps
        if ( now - pastFps >= 1000 ) {
            pastFps = now ;
            fpsChanged( fps );
            fps = 0 ;
        }
        // sleep?
        SDL_Delay( 1 );
    }
}

void Game::update() {

    if ( keys[SDLK_LEFT] ) {
       
        angle=10;
        rotateIndex+=10;

        if (rotateIndex <= -350) rotateIndex = 0;
        else if (rotateIndex >= 350) rotateIndex = 0;
        //rotor=rotozoomSurface(octagon->octagon_img, angle, 1, SMOOTHING_OFF);
        //octagon->texture = SDL_CreateTextureFromSurface(renderer, rotor);

		//SDL_BlitSurface(rotor, NULL, octagon->octagon_img, &dest);
       // SDL_FreeSurface(rotor);

    } else if ( keys[SDLK_RIGHT] ) {
        //octagon.x += HERO_SPEED ;
        angle=-10;
        rotateIndex-=10;


        if (rotateIndex <= -350) rotateIndex = 0;
        else if (rotateIndex >= 350) rotateIndex = 0;
        //rotor=rotozoomSurface(octagon->octagon_img, angle, 1, SMOOTHING_OFF);
       // octagon->texture = SDL_CreateTextureFromSurface(renderer, rotor);

		//SDL_BlitSurface(rotor, NULL, octagon->octagon_img, &dest);
       // SDL_FreeSurface(rotor);

    } else if ( keys[SDLK_UP] ) {
        //octagon.y -= HERO_SPEED ;
        angle=10;
        rotateIndex+=10;

        if (rotateIndex <= -350) rotateIndex = 0;
        else if (rotateIndex >= 350) rotateIndex = 0;
        //rotor=rotozoomSurface(octagon->octagon_img, angle, 1, SMOOTHING_OFF);
       // octagon->texture = SDL_CreateTextureFromSurface(renderer, rotor);

		//SDL_BlitSurface(rotor, NULL, octagon->octagon_img, &dest);
       // SDL_FreeSurface(rotor);
    } else if ( keys[SDLK_DOWN] ) {
        //octagon.y += HERO_SPEED ;
        angle=-10;
        rotateIndex-=10;

        if (rotateIndex <= -350) rotateIndex = 0;
        else if (rotateIndex >= 350) rotateIndex = 0;
        //rotor=rotozoomSurface(octagon->octagon_img, angle, 1, SMOOTHING_OFF);
       // octagon->texture = SDL_CreateTextureFromSurface(renderer, rotor);

		//SDL_BlitSurface(rotor, NULL, octagon->octagon_img, &dest);
       // SDL_FreeSurface(rotor);
    }
}

void Game::onKeyDown( SDL_Event* evt ) {
    keys[ evt->key.keysym.sym ] = 1 ;
}

void Game::onKeyUp( SDL_Event* evt ) {
    keys[ evt->key.keysym.sym ] = 0 ;
}
bool Game::loadMedia(Ball *ball[])
{

#define SIZEFONT 35

#if WINDOWS
#define FONT "assets/Bevan.ttf"
#elif LINUX
#define FONT "/usr/share/frozenbubble/Bevan.ttf"
#endif
	//SDL_RWops *rw = SDL_RWFromConstMem((const unsigned char *) IMAGE_DATA, sizeof(IMAGE_DATA));
	//balls_bmp = SDL_LoadBMP_RW(rw, 1); // automatycznie zwalnia pamięć po 'rw'
	SDL_Surface *bmp;
	//Loading success flag
	bool success = true;
	//char buf[256];
	bmp = create_balls();
	for (int i = 0; i<4; i++) {
		//Load dot texture
		//sprintf(buf, "./assets/ball-%d.bmp",i);
		//if( !ball[i]->loadFromFile( buf, renderer))
		if( !ball[i]->loadFromFile( i, bmp, renderer))

		{
			printf( "Failed to load dot texture!\n" );
			success = false;
		}
	}
	if((gFont = TTF_OpenFont(FONT, SIZEFONT)) == NULL) {
       printf("TTF_OpenFont: %s\n", TTF_GetError());
       exit(1);
	}

	return success;
}

int main(int argc, char** argv){
    Game game;
    game.start();
	game.run();

    return 0;
}
