/*
 * Frozen Bubble - zastrzel wszyskie kulki
 * 2022-09-13 by PRP
 * Licencja: Public Domain
 * Edytor: Atom
 * Program bazuje na:
 * -This source code copyrighted by Lazy Foo' Productions (2004-2020)
 * and may not be redistributed without written permission.
 * -Andrew Lim Chong Liang https://github.com/andrew-lim/sdl2-boilerplate
 */

#ifndef GAME_H
#define GAME_H

#include <SDL2/SDL.h>
#include <SDL2/SDL_ttf.h>
#include <SDL2/SDL2_gfxPrimitives.h>
#include <cstdio>
#include <iostream>
#include <map>
#include "ball.h"
#include "wall.h"
#include "missile.h"
#include "balls.h"

/*
enum {
    DISPLAY_WIDTH  = 400
    , DISPLAY_HEIGHT = 600
    , UPDATE_INTERVAL = 1000/60
    , HERO_SPEED = 2
    , SHAPE_SIZE = 200
    , BALL_SIZE = 50
    , RED_BALL = 0
    , YELLOW_BALL = 75
    , GREEN_BALL = 150
    , BLUE_BALL = 225

};
*/
class Game {
public:
    Game();
    ~Game();
    void start();
    void stop() ;
    
	void draw(Wall *wall, Missile * m);
    void fillRect(SDL_Rect* rc, int r, int g, int b );
    void fpsChanged( int fps );
    void onQuit();
    void onKeyDown( SDL_Event* event );
    void onKeyUp( SDL_Event* event );
    void run();
    void update();
    bool loadMedia(Ball *ball[]);
    //bool loadMedia(SmallBall *ball[]);
    //bool checkCollision(Circle& a, Circle& b);
    SDL_Renderer* renderer;
    //Sprite * octagon ;
	//SmallBall *surface; //*actual_ball;


private:
    std::map<int,int> keys; // No SDLK_LAST. SDL2 migration guide suggests std::map
    int frameSkip ;
    int running ;
    SDL_Window* window;
    SDL_Rect dst;
    double angle;
    int rotateIndex;
    TTF_Font* gFont = NULL;
    Sint16 lineX1, lineX2, lineY1, lineY2;
    //SDL_Surface *surfaceBall[4], *surfaceBigBall;
};
#endif //GAME_H
