#include "missile.h"

Uint32 getpixel(SDL_Surface *surface, int x, int y)
{
	int bpp = surface->format->BytesPerPixel;
	/* Here p is the address to the pixel we want to retrieve */
	Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

	switch(bpp) {
		case 1:
			return *p;
		case 2:
			return *(Uint16 *)p;
		case 3:
			if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
				return p[0] << 16 | p[1] << 8 | p[2];
			else
				return p[0] | p[1] << 8 | p[2] << 16;
		case 4:
			return *(Uint32 *)p;
		default:
			return 0;
	}
}


void putpixel(SDL_Surface *surface, int x, int y, Uint8 R, Uint8 G, Uint8 B, Uint8 A)
{
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x *
               surface->format->BytesPerPixel;
    if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
    {
       p[0] = R;
       p[1] = G;
       p[2] = B;
       p[3] = A;
    }
    else
    {
    	p[0] = A;
       p[1] = B;
       p[2] = G;
       p[3] = R;
    }
}

Missile::Missile (){}


Missile::Missile (Ball **ball) {
	int r;
	mPosX = 200;
    mPosY = 575;
	active = WAITING;
	//Set collision circle size
	mCollider.r = BALLSIZE / 2;
	angleRad = 99;
	//entry = false;
    //Initialize the velocity
	mVelX = 1;  //dx
    mVelY = -1;  //dy;
	//Move collider relative to the circle
	shiftColliders();

	
	
	//m = new Missile(*ball[rand()%4]);  // deep copy
	r = rand()%4;
	m = new Ball(*ball[r]);
	color = r;
	//this->angleRad = 12;
}

// ten konstruktor wywoływany jest w metodzie 'add' klasy 'Wall'
Missile::Missile (Ball **ball, int c, int x, int y) {
	mPosX = x;
    mPosY = y;
	active = ACTIVE;
	//Set collision circle size
	mCollider.r = BALLSIZE / 2;
	angleRad = 12;
	//entry = false;
    //Initialize the velocity
	mVelX = 1;  //dx
    mVelY = -1;  //dy;
	//Move collider relative to the circle
	//shiftColliders();
	shiftColliders();

	asm("nop");
	m = new Ball(*ball[c]);
	color = c;
	//this->angleRad = 12;
}

int Missile::checkActive() {
	return active;
}

void Missile::setPosX(double x){
	this->mPosX = x;
}

void Missile::setPosY(double y) {
	this->mPosY = y;
}

void Missile::addPosY(double y) {
	this->mPosY += y;
}

void Missile::addPosX(double x) {
	this->mPosX += x;
}



double Missile::getPosX() {
	return this->mPosX;
}

double Missile::getPosY() {
	return this->mPosY;
}

int Missile::getVarCollider() {
	return this->mCollider.r;
}

SDL_Texture* Missile::getTexture() {
	return m->texture;
}

double Missile::getVelX() {
	return this->mVelX;
}

void Missile::addVelX(double n) {
	this->mVelX += n;
}

void Missile::addVelY(double n) {
	this->mVelY += n;
}


void Missile::addAngle(double n) {
	this->angleRad += n;
	//std::cout<<"AAAA: "<<this->angleRad<<std::endl;
}

void Missile::setAngle(double n) {
	this->angleRad =  n;
}


double Missile::getAngle() {
	return this->angleRad;
}

void Missile::changeColor(Ball **ball) {
	
	if (color < 3) {
		delete m;
		m = new Ball(*ball[++color]);
	}
	else {
		delete m;
		m = new Ball(*ball[0]);
		color = 0;
	}
}

bool Missile::checkCollision( Circle& a, Circle& b )
{
	//Calculate total radius squared
	int totalRadiusSquared = a.r + b.r;
	totalRadiusSquared = totalRadiusSquared * totalRadiusSquared;

    //If the distance between the centers of the circles is less than the sum of their radii
    if( distanceSquared( a.x, a.y, b.x, b.y ) < ( totalRadiusSquared ) )
    {
        //The circles have collided
        return true;
    }

    //If not
    return false;
}

double Missile::distanceSquared( int x1, int y1, int x2, int y2 )
{
	int deltaX = x2 - x1;
	int deltaY = y2 - y1;
	return deltaX*deltaX + deltaY*deltaY;
}

void Missile::move() {
	
	setPosX(cos(getAngle()) + getPosX() + mVelX);
	shiftColliders();
	if( ( (int) mPosX - mCollider.r < 0 ) || ((int)  mPosX + mCollider.r > DISPLAY_WIDTH ) )
    {
        //Move back
        mPosX -= mVelX;
		shiftColliders();
		printf("Krawędz X\n");
		if (mPosX - mCollider.r < 0) 
		{
			mVelX = -mVelX;
			printf ("lewa krawedz\n");
		}
		if (mPosX + mCollider.r > DISPLAY_WIDTH) {
			mVelX = -mVelX;
			printf ("prawa krawedz\n");
		}
	}
	this->addPosY(mVelY);
	shiftColliders();

	if( ( (int) mPosY - mCollider.r < 0 ) || ( (int) mPosY + mCollider.r > DISPLAY_HEIGHT))
    {
        //Move back
        mPosY -= mVelY;
		shiftColliders();
		printf("Krawedz Y\n");
    }

}

Back* Missile::collisions( Circle& circle, Missile *missile)
{
	Back *back = NULL;
	
	/* gdy kolizja z innym kolorem */
	if ( active == ACTIVE && color != missile->color) {
		
		
		if (checkCollision( mCollider, circle ) )
		{
			printf ("mCollider.x: %d mCollider.y %d mCollider.r: %d\n", mCollider.x, mCollider.y, mCollider.r);
			printf ("circle.x %d  circle.y %d  circle.r %d\n", circle.x, circle.y, circle.r);
			back = new Back();
			//Move back
			missile->mPosX -= mVelX;
			shiftColliders();
			asm("nop");
			back->indexAdd = missile->index;
			back->indexDel = -1;
			back->color = missile->color;
			back->x = missile->mPosX;
			back->y = missile->mPosY;
		
		}

		// If the dot collided or went too far up or down
		if (checkCollision( mCollider, circle))
		{
			printf ("mCollider.x: %d mCollider.y %d mCollider.r: %d\n", mCollider.x, mCollider.y, mCollider.r);
			printf ("circle.x %d  circle.y %d  circle.r %d\n", circle.x, circle.y, circle.r);
			back = new Back();
			//Move back 
			missile->mPosY -= mVelY;
			shiftColliders();
		
			back->indexAdd = missile->index;
			back->indexDel = -1;
			back->color = missile->color;
			back->x = missile->mPosX;
			back->y = missile->mPosY;

		}
	}
	/* gsy odnaleziono taki zam kolor */
	else if ( active == ACTIVE && color == missile->color) {

		if (checkCollision( mCollider, circle ) )
		{
			back = new Back();
			//Move back
			missile->mPosX -= mVelX;
			shiftColliders();
			asm("nop");
			back->indexAdd = -2;
			back->indexDel = index;
			back->color = missile->color;
			back->x = missile->mPosX;
			back->y = missile->mPosY;
		}
	

		// If the dot collided or went too far up or down
		if (checkCollision( mCollider, circle))
		{
			back = new Back();

			//Move back 
			missile->mPosY -= mVelY;
			shiftColliders();
		
			back->indexAdd = -2;
			back->indexDel = index;
			back->color = missile->color;
			back->x = missile->mPosX;
			back->y = missile->mPosY;
		}
	}
	
		
	
	return back;
}

Circle& Missile::getCollider()
{
	return mCollider;
}

void Missile::shiftColliders()
{
	//Align collider to center of dot
	mCollider.x = (int) mPosX;
	mCollider.y = (int) mPosY;
}

void Missile::fixIndex(Missile *missile) {
	
	double cX, cY;
		
		if( mPosX < missile->mPosX )
    {
        cX = missile->mPosX;
    }
    else if( mPosX > missile->mPosX+BALL_SIZE )
    {
        cX = missile->mPosX+BALL_SIZE;
    }
    else
    {
        cX = mPosX;
    }

    //Find closest y offset
    if( mPosY < missile->mPosY  )
    {
        cY = missile->mPosY ;
    }
    else if( mPosY > missile->mPosY+BALL_SIZE )
    {
        cY = missile->mPosY+BALLSIZE;
    }
    else
    {
        cY = mPosY;
    }
		
	if (mPosX == cX && mPosY == cY) {
		missile->index = index;
		//printf("Index Corect: %d\n", index);
	}
}
